<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
?>
<style>
    #wlpr-launcher-preview-icon {
        position: fixed;
        bottom: 10px;
        width: 10%;
        background: <?php echo isset($launcher_icon_background_color) ? $launcher_icon_background_color: '#353d9f';?>;
        border-radius: 7px;
        text-align: center;
        height: 54px;
        cursor: pointer;
        box-shadow: 1px 1px 20px 2px rgba(0, 0, 0, 0.15);
        padding: 9px;
        z-index: 9999;
    <?php echo isset($launcher_position) ? $launcher_position: 'right';?>: 20px;
    }
    #wlpr-launcher-preview-content {
        <?php echo isset($launcher_position) ? $launcher_position: 'right';?>: 20px;
        position: fixed;
        bottom: 14px;
        margin-right: 26em;
        z-index: 99999;
    }
    #wlpr-launcher-preview-icon a{
        list-style: none;
        text-decoration: none;
    }
    #wlpr-launcher-preview-icon .lpr-close {
        /* display: inline-flex; */
        /* border-radius: 50%; */
        text-align: center;
        color: <?php echo isset($launcher_icon_text_color) ? $launcher_icon_text_color: '#f0f0f0';?>;
        cursor: pointer;
        -webkit-transition: all .1s ease-out;
        transition: all .1s ease-out;
        /* position: relative; */
        z-index: 998;
        overflow: hidden;
    }
    #wlpr-launcher-preview-icon .lpr-close img
    {
        width: 35px;
        height: auto;
        vertical-align: middle;
        max-width: 21px;
        display: inline-block;
    }
    #wlpr-launcher-preview-icon .my_rewards_launcher
    {
        font-size: 16px;
        font-weight: 500;
        line-height: 26px;
        position: relative;
        top: 2px;
        list-style: none;
        left: 5px;
    }
    #wlpr-launcher-preview-icon a:hover{
        color: #fff;
    }
    #wlpr-launcher-container .wlpr-launcher-above-close{
        float: right;
        color:#fff;
        cursor: pointer;
        font-size: 18px;
        position: relative;
        top: 12px;
    }

    @media screen and (min-width: 200px) and (max-width: 767px) {
        #wlpr-launcher-preview-icon {
        <?php echo (isset($launcher_display_device) && in_array($launcher_display_device,array('all','mobile'))) ? '': 'display:none!important;' ?>
        }
        #wlpr-launcher-preview-content {
            left: 0;
            position: fixed;
            bottom: 0;
            margin: 0 auto;
            z-index: 99999;
            right: 0;
            top: 0;
        <?php echo (isset($launcher_display_device) && in_array($launcher_display_device,array('all','mobile'))) ? '': 'display:none!important;' ?>
        }
        #wlpr-launcher-container .wlpr-launcher-above-close{
            position: absolute;
            top: 12px;
            right: 12px;
            background: rgba(0,0,0,0.5);
            width: 50px;
            height: 50px;
            line-height: 50px;
            text-align: center;
            border-radius: 4px;
            z-index: 99;
            cursor: pointer;
        }
    }
    @media screen and (min-width: 767px) {
        #wlpr-launcher-preview-icon {
        <?php echo (isset($launcher_display_device) && in_array($launcher_display_device,array('all','desktop'))) ? '': 'display:none!important;' ?>
        }
        #wlpr-launcher-preview-content {
        <?php echo (isset($launcher_display_device) && in_array($launcher_display_device,array('all','desktop'))) ? '': 'display:none!important;' ?>
        }
    }
</style>
<div id="wlpr-launcher-preview-content" style="display: none;">
    <?php echo isset($preview_content) ? $preview_content : ''; ?>
</div>
<div id="wlpr-launcher-preview-icon" onclick="wlpr.toggleLauncher();">
    <a class="lpr-close">
        <?php if (!empty($launcher_image)): ?>
            <img src="<?php echo $launcher_image; ?>" width="50px" height="50px">
        <?php endif; ?>
         <span class="my_rewards_launcher">
            <?php if (isset($launcher_text) && !empty($launcher_text)): ?>
            <?php echo $launcher_text; ?>
            <?php endif; ?>
         </span>
    </a>
</div>