<?php
$wlpr_launcher_header_background_color = Wlpr_Settings::get_custom_value('wlpr_launcher_header_background_color', Wlpr_Settings::get_default_value('wlpr_launcher_header_background_color'));
$wlpr_launcher_header_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_header_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_header_text_color'));
$launcher_body_background_color = Wlpr_Settings::get_custom_value('wlpr_launcher_body_background_color', Wlpr_Settings::get_default_value('wlpr_launcher_body_background_color'));
$launcher_font_family = Wlpr_Settings::get_custom_value('wlpr_launcher_font_family', Wlpr_Settings::get_default_value('wlpr_launcher_font_family'));
if (isset(Wlpr_Settings::$font_family_mapping[$launcher_font_family]) && !empty(Wlpr_Settings::$font_family_mapping[$launcher_font_family])) {
    $launcher_font_family = Wlpr_Settings::$font_family_mapping[$launcher_font_family];
}
$options = get_option('wlpr_settings', '');
$launcher_position = (isset($options['wlpr_launcher_icon_position']) && !empty($options['wlpr_launcher_icon_position'])) ? $options['wlpr_launcher_icon_position'] : 'left';
/* Sign up card */
$signup_button_color = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_button_color', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_button_color'));
$signup_button_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_button_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_button_text_color'));
$signup_card_background_color = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_background_color', Wlpr_Settings::get_default_value('wlpr_launcher_guest_card_background_color'));
$signup_card_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_guest_card_text_color'));
/* Guest review card */
$review_card_background_color = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_review_background_color', Wlpr_Settings::get_default_value('wlpr_launcher_guest_card_background_color'));
$review_card_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_review_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_review_text_color'));
/* Login review card */
$login_review_card_background_color = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_background_color', Wlpr_Settings::get_default_value('wlpr_launcher_login_card_background_color'));
$login_review_card_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_review_text_color'));
$login_review_link_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_link_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_login_review_link_text_color'));
/* login Birthday card*/
$login_birth_card_background_color = Wlpr_Settings::get_custom_value('wlpr_launcher_birthday_button_color', Wlpr_Settings::get_default_value('wlpr_launcher_birthday_button_color'));
$login_birth_card_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_birthday_button_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_birthday_button_text_color'));
/* Referral review card */
$login_referral_card_background_color = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referral_background_color', Wlpr_Settings::get_default_value('wlpr_launcher_login_card_background_color'));
$login_referral_card_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referral_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_referral_text_color'));
/* Referee review card */
$login_referee_card_background_color = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referee_background_color', Wlpr_Settings::get_default_value('wlpr_launcher_login_card_background_color'));
$login_referee_card_text_color = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referee_text_color', Wlpr_Settings::get_default_value('wlpr_launcher_referee_text_color'));
$wlpr_launcher_button_width = (isset($options['wlpr_launcher_button_width']) && !empty($options['wlpr_launcher_button_width'])) ? $options['wlpr_launcher_button_width'] : '15';
?>
    #wlpr-launcher-container {
        bottom: 0;
        position: <?php echo (isset($front_end) && $front_end) ? 'fixed': 'relative'?>;
        margin: 1em;
        z-index: 9999;
    }

    #wlpr-launcher-header {
        font-weight: 500;
        color: <?php echo isset($wlpr_launcher_header_text_color) ? $wlpr_launcher_header_text_color: '#f9f9f9';?>;
        height: 130px;
        background: <?php echo isset($wlpr_launcher_header_background_color) ? $wlpr_launcher_header_background_color: '#353d9f'?>;
        border-top-left-radius: 10px;
        border-top-right-radius: 10px;
        padding-top: 8px;
        padding: 20px;
    }

    #wlpr-launcher-body-container {
        background: <?php echo isset($launcher_body_background_color) ? $launcher_body_background_color: '#f9f9f9'?>;
        border-radius: 8px;
    }

    #wlpr-launcher-box {
        background: <?php echo isset($launcher_body_background_color) ? $launcher_body_background_color: '#f9f9f9'?>;
    }

    /* Sign up card */
    #wlpr-launcher-signup-card {
        background: <?php echo isset($signup_card_background_color) ? $signup_card_background_color: '#f9f9f9'?>;
    }

    #wlpr-launcher-signup-card #wlpr-launcher-signup-content h4 {
        color: <?php echo isset($signup_card_text_color) ? $signup_card_text_color: '#444'?>;
    }

    #wlpr-launcher-signup-card #wlpr-launcher-signup-content p {
        color: <?php echo isset($signup_card_text_color) ? $signup_card_text_color: '#444'?>;
    }

    #wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-signin-prefix-content {
        color: <?php echo isset($signup_card_text_color) ? $signup_card_text_color: '#444'?>;
        letter-spacing: 0.02em;
    }

    #wlpr-signup-btn {
        border: 0 solid #353d9f;
        background: <?php echo (isset($signup_button_color) && !empty($signup_button_color)) ? $signup_button_color: '#353d9f';?>;
        color: <?php echo isset($signup_button_text_color) && !empty($signup_button_text_color) ? $signup_button_text_color: '#f9f9f9';?>;
        padding: 10px 24px;
        font-size: 15px;
        line-height: 1.5;
        border-radius: 6px;
        min-height: 2.3rem;
        min-width: 3.6rem;
        box-shadow: 0 1px 7px 0 rgba(18, 52, 77, 0.18), 0 2px 8px 0 rgba(31, 36, 39, 0.04);
        bottom: 2px;
        margin-left: 15px;
        font-weight: 600;
    }

    /* Guest review card */
    #wlpr-launcher-guest-review-card {
        background: <?php echo (isset($review_card_background_color) && !empty($review_card_background_color)) ? $review_card_background_color: '#f9f9f9';?>;
    }

    #wlpr-launcher-guest-review-card #wlpr-launcher-guest-review-content h4 {
        color: <?php echo isset($review_card_text_color) ? $review_card_text_color: '#444'?>;
    }

    #wlpr-launcher-guest-review-card #wlpr-launcher-guest-review-content p {
        color: <?php echo isset($review_card_text_color) ? $review_card_text_color: '#444'?>;
    }

    /* Login review card */
    #wlpr-launcher-login-review-card {
        background: <?php echo (isset($login_review_card_background_color) && !empty($login_review_card_background_color)) ? $login_review_card_background_color: '#f9f9f9';?>;
    }

    #wlpr-launcher-login-review-card #wlpr-launcher-login-review-content h4 {
        color: <?php echo isset($login_review_card_text_color) ? $login_review_card_text_color: '#444'?>;
    }

    #wlpr-launcher-login-review-card #wlpr-launcher-login-review-content p {
        color: <?php echo isset($login_review_card_text_color) ? $login_review_card_text_color: '#444'?>;
    }
    #wlpr-launcher-login-review-card #wlpr-launcher-login-review-content .review-card{
        color: <?php echo isset($login_review_card_text_color) ? $login_review_card_text_color: '#444'?>;
    }

    #wlpr-launcher-login-review-card .review-link a{
        color: <?php echo isset($login_review_link_text_color) ? $login_review_link_text_color: '#353d9f'?>;
    }
    /* login birth card*/
    #wlpr-launcher-login-birth-card .wlpr-birth-save-button {
        background: <?php echo (isset($login_birth_card_background_color) && !empty($login_birth_card_background_color)) ? $login_birth_card_background_color: '#353d9f';?>;
        color: <?php echo isset($login_birth_card_text_color) ? $login_birth_card_text_color: '#f9f9f9'?>;
    }

    /* Referral card */
    #wlpr-launcher-login-referral-card {
        background: <?php echo (isset($login_referral_card_background_color) && !empty($login_referral_card_background_color)) ? $login_referral_card_background_color: '#f9f9f9';?>;
    }

    #wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content h4 {
        color: <?php echo isset($login_referral_card_text_color) ? $login_referral_card_text_color: '#444'?>;
    }

    #wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content p {
        color: <?php echo isset($login_referral_card_text_color) ? $login_referral_card_text_color: '#444'?>;
    }

    /* Referee card */
    #wlpr-launcher-login-referee-card {
        background: <?php echo (isset($login_referee_card_background_color) && !empty($login_referee_card_background_color)) ? $login_referee_card_background_color: '#f9f9f9';?>;
    }

    #wlpr-launcher-login-referee-card #wlpr-launcher-login-referee-content h4 {
        color: <?php echo isset($login_referee_card_text_color) ? $login_referee_card_text_color: '#444'?>;
    }

    #wlpr-launcher-login-referee-card #wlpr-launcher-login-referee-content p {
        color: <?php echo isset($login_referee_card_text_color) ? $login_referee_card_text_color: '#444'?>;
    }

    #wlpr-launcher-login-referee-card #wlpr_launcher_body_referee_content {
        color: <?php echo isset($login_referee_card_text_color) ? $login_referee_card_text_color: '#444'?>;
        line-height: 25px !important;
        margin-bottom: 10px !important;
        border-top: 1px solid #f3f3f3;
        padding-top: 12px !important;
    }

    #wlpr-launcher-login-referee-card .wlpr-icon-list {
        color: <?php echo isset($login_referee_card_text_color) ? $login_referee_card_text_color: '#444'?>;
    }

    /*Chatbox*/
    #wlpr-launcher-box {
        position: fixed;
    <?php echo isset($launcher_position) ? $launcher_position: 'left'?>: 22 px;
        bottom: 9%;
        width: 400px;
        font-size: 12px;
        line-height: 22px;
        border-radius: 10px;
        font-family: <?php echo isset($launcher_font_family) ? $launcher_font_family: 'inherit'?>;
        font-weight: 500;
        box-shadow: 1px 1px 20px 2px rgba(0, 0, 0, 0.15);
        border-radius: 10px;
        -webkit-transition: all .2s ease-out;
        -webkit-transition: all .2s ease-in-out;
        transition: all .2s ease-in-out;
    }

    #wlpr-launcher-box::-webkit-scrollbar {
      display: none;
    }
    /* Hide scrollbar for IE, Edge and Firefox */
    #wlpr-launcher-box {
      -ms-overflow-style: none; /* IE and Edge */
      scrollbar-width: none; /* Firefox */
    }

    #wlpr-launcher-container ul li {
        list-style: none;
    }

    #wlpr-launcher-container * {
        box-sizing: inherit;
    }

    #wlpr-launcher-container h4 {
        color: #333;
        font-size: 16px;
        font-weight: 600;
        padding: 0px;
        margin-top: 20px;
        margin-bottom: 0px;
    }


    #wlpr-launcher-container .wlpr-inline-content li {
        display: inline-block !important;
    }

    #wlpr-launcher-container #wlpr-sign-in {
        color: <?php echo isset($login_review_link_text_color) ? $login_review_link_text_color: '#353d9f'?>;
        text-decoration: underline;
    }

    #wlpr-launcher-container #wlpr-guest-header-content {
        float: left;
        font-size: 15px;
        list-style: none;
        position: relative;
        margin-right: 10px;
        font-weight: 400;
        margin-top: 0;
    }

    #wlpr-launcher-container #wlpr-login-header-content {
        float: left;
        font-size: 15px;
        list-style: none;
        position: relative;
        margin-right: 10px;
        letter-spacing: 0.5px;
        font-weight: 400;
        margin-top: 0;
    }

    #wlpr-launcher-container #wlpr-launcher-header img {
        border-radius: 50%;
        width: 60px;
        height: 60px;
        float: left;
        margin: 0px 20px 0px 0px;
    }

    #wlpr-launcher-container #wlpr-guest-header-content .agent {
        font-size: 22px;
        font-weight: 600;
        line-height: 34px;
    }

    #wlpr-launcher-container #wlpr-guest-header-content #wlpr-launcher-header-text {
        margin-top: 6px;
        display: inline-block;
    }

    #wlpr-launcher-container #wlpr-login-header-content #wlpr-launcher-login-text {
        margin-top: 6px;
        display: inline-block;
    }

    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card {
        margin: 20px auto 0;
        position: relative;
        bottom: 40px;
        border-radius: 8px;
        width: 90%;
        box-shadow: 0 0 13px 0 rgba(0,0,0,.09);
        padding: 10px 15px;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card table{
        margin-bottom: 0;
        background: transparent;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card table tr td{
        border-bottom: 1px solid #eee;
        background: transparent;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card table tr:last-child td{
        border-bottom: none;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card .review-card, #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card .review-link{
        padding: 10px;
        vertical-align: middle;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card .review-card{
        line-height: 30px;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card .review-link{
        text-align: center;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-launcher-body-card .review-link a{
        padding: 10px;
        margin-top: 0;
    }

    #wlpr-launcher-container #wlpr-launcher-body-container p {
        padding: 0px;
        font-weight: 400;
        font-size: 15px;
        margin: 0 0 10px;
        color: #637381;
    }

    #wlpr-launcher-container #wlpr-launcher-body-container h6 {
        font-weight: 300;
        font-size: 15px;
        line-height: 29px;
        margin-top: 8px;
        border-top: 1px solid #f3f3f3;
        padding-top: 17px;
        margin-bottom: 15px;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container input{
        border: 1px solid #ddd;
        border-radius: 4px;
        min-height: 40px;
        outline: none;
        padding: 5px 10px;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container input:focus{
        border-color: <?php echo isset($login_review_link_text_color) ? $login_review_link_text_color: '#353d9f'?>;
        outline: none;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container a {
        text-decoration: none;
        line-height: 24px;
        font-size: 14px;
        cursor: pointer;
        margin: 10px auto 0;
        display: inline-block;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container a:focus{
        outline: none;
    }
    #wlpr-launcher-container #wlpr-launcher-body-container .wlpr-birth-save-button {
        text-decoration: none;
        line-height: 24px;
        font-size: 14px;
        display: inline-block;
        font-weight: 600;
        padding: 7px 12px;
        border-radius: 4px;
        margin-top: 10px;
    }

    #wlpr-launcher-container .wlpr-m-15 {
        margin-top: 15px;
    }

    #wlpr-launcher-container .wlpr_list ul {
        font-size: 15px;
        list-style: none;
        position: relative;
        height: auto;
        width: 100%;
        margin-right: 10px;
        font-weight: 400;
        margin-top: 0px;
        text-align: left;
        display: inline-block;
        padding-bottom: 10px;
        margin-bottom: 10px;
        padding: 0px;
        margin-left: 0px;
    }

    #wlpr-launcher-container .wlpr_list ul li {
        border-bottom: 0 solid #f3f3f3;
    }

    #wlpr-launcher-container .wlpr_list img {
        border-radius: 50%;
        width: 60px;
        float: left;
        margin: 8px 12px 0px 0px;
    }

    #wlpr-launcher-container .wlpr_list .agent {
        font-size: 22px;
        font-weight: 600;
        line-height: 34px;
    }

    #wlpr-launcher-container .wlpr_list_content {
        margin-top: 16px;
        display: inline-block;
    }

    #wlpr-launcher-container .wlpr-member {
        text-align: center;
    }

    #wlpr-launcher-container #wlpr_referral_url_link {
        background: none 0% 0% repeat scroll rgb(255, 255, 255);
        border: 1px solid #e2e2e2;
        color: #525252;
        border-radius: 8px;
        padding: 6px 15px;
        margin-top: 10px;
        margin-bottom: 10px;
        font-size: 16px;
        height: 44px;
        width: 90%;
    }

    #wlpr-launcher-container .wlpr-icon-list {
        display: inline-block !important;
        padding: 7% !important;
        text-align: center;
        text-decoration: none !important;
        font-size: 16px !important;
        margin-top: 0px;
        margin-bottom: 0px;
    }

    #wlpr-launcher-container .lpr-text-center {
        text-align: center;
    }

    #wlpr-launcher-container .wlpr-icon-list span {
        display: block;
        font-size: 14px;
    }

    #wlpr-launcher-container .wlpr-icon-list i {
        font-size: 22px;
        margin-bottom: 4px;
    }

    #wlpr-launcher-container #wlpr_referral_url_link:focus {
        border: 1px solid #353d9f;
        outline: none;
    }

    #wlpr-launcher-container .wlpr-input-group-append {
        margin-left: -1px;
        display: flex;
        position: relative;
    }

    #wlpr-launcher-container .wlpr-input-group-text {
        display: flex;
        align-items: center;
        margin-bottom: 0;
        font-weight: 400;
        text-align: center;
        white-space: nowrap;
        cursor: pointer;
        background: #e2e2e2;
        border: 1px solid #e2e2e2;
        color: rgb(68, 68, 68);
        border-radius: 4px;
        position: absolute;
        bottom: 10px;
        right: 0;
        height: 44px;
        font-size: 18px;
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
        padding: 6px 14px;
        line-height: 20px;
    }

    #wlpr-launcher-container #wlpr-launcher-login-text .agent {
        font-size: 22px;
        font-weight: 600;
        line-height: 34px;
    }

    @media screen and (min-width: 1000px) {
        #wlpr-launcher-box {
            position: fixed;
<?php echo isset($launcher_position) ? $launcher_position: 'left'?>: 22px;
            bottom: 70px;
            overflow-x: auto;
            width: 400px;
            max-height: calc(100% - 105px);
        }

        #wlpr-launcher-preview-icon {
            position: fixed;
            bottom: 14px;
            width: <?php echo isset($wlpr_launcher_button_width) ? $wlpr_launcher_button_width: 15;?>%;
        }
    }

    @media screen and (min-width: 768px) and (max-width: 999px) {
        #wlpr-launcher-container #wlpr-launcher-box {
            width: 100%;
            max-width: 420px;
            position: relative;
            overflow: auto;
            position: fixed;
<?php echo isset($launcher_position) ? $launcher_position: 'left'?>: 22px;
            bottom: 70px;
            overflow-x: auto;
            max-height: calc(100% - 100px);
        }

        #wlpr-launcher-container {
            position: fixed;
            margin: -1em;
        <?php echo isset($launcher_position) ? $launcher_position: 'left'?>: 0;
            z-index: 99999;
            bottom: 12%;
        }

        #wlpr-launcher-preview-icon {
            position: fixed;
            bottom: 14px;
            width: 24%;
        }
    }

    @media screen and (min-width: 481px) and (max-width: 767px) {
        #wlpr-launcher-container #wlpr-launcher-box {
            width: 97%;
            position: absolute;
            max-height: 100%;
            left: auto;
            bottom: 0;
            overflow: auto;
            z-index: 999999;
            border-radius: 0;
        }

        #wlpr-launcher-container {
            position: fixed;
            margin: 0 auto;
<?php echo isset($launcher_position) ? $launcher_position: 'left'?>: 0;
            z-index: 99999;
            bottom: 0px;
            height: 100%;
            width: 100%;
            display: flex;
            justify-content: center;
        }

        #wlpr-launcher-preview-icon {
            position: fixed;
            bottom: 80px;
            width: 50px;
            border-radius: 50%;
            text-align: center;
            height: 50px;
            cursor: pointer;
            box-shadow: 1px 1px 20px 2px rgba(0, 0, 0, 0.15);
            padding: 10px;
            right: 18px;
            z-index: 9999;
        }
        #wlpr-launcher-preview-content{
            z-index: 999999;
        }
        #wlpr-launcher-preview-icon .my_rewards_launcher{
            display: none;
        }
    }

    @media screen and (min-width: 200px) and (max-width: 480px) {
        #wlpr-launcher-header{
            border-radius: 0;
        }
        #wlpr-launcher-container #wlpr-launcher-box {
            width: 100%;
            position: absolute;
            max-height: 100%;
            height: 100%;
            left: 0;
            bottom: 0;
            overflow: auto;
            z-index: 999999;
            border-radius: 0;
        }

        #wlpr-launcher-container {
            position: fixed;
            margin: 0 auto;
        <?php echo isset($launcher_position) ? $launcher_position: 'left'?>: 0;
            z-index: 99999;
            bottom: 0;
            height: 91%;
            width: 100%;
        }

        #wlpr-launcher-preview-icon {
            position: fixed;
            bottom: 80px;
            width: 50px;
            border-radius: 50%;
            text-align: center;
            height: 50px;
            cursor: pointer;
            box-shadow: 1px 1px 20px 2px rgba(0, 0, 0, 0.15);
            padding: 10px;
            right: 18px;
            z-index: 9999;
        }
        #wlpr-launcher-preview-icon .my_rewards_launcher{
            display: none;
        }
    }