<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
if (!defined('ABSPATH')) {
    exit;
}
?>
<!DOCTYPE html>
<!--[if IE 7]>
<html class="ie ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html class="ie ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 7) & !(IE 8)]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->

<head>

    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta name="viewport" content="width=device-width"/>

    <title><?php echo __('Email Designer', WLPR_TEXT_DOMAIN); ?></title>
    <style type="text/css">
        #wlpr_preview_wrapper #wlpr-launcher-container{
            width: 100%;
            margin: 0;
            position: relative !important;
        }
        #wlpr_preview_wrapper #wlpr-launcher-container #wlpr-launcher-box {
            position: relative !important;
            top: 0;
            left: auto !important;
            right: auto !important;
            margin: 0 auto;
        }
    </style>
    <style type="text/css" id="wlpr_designer_custom_css"></style>

</head>

<body>

<div id="wlpr_preview_wrapper" style="display: block;" dir="<?php echo is_rtl() ? 'rtl' : 'ltr'; ?>">

    <table border="0" cellpadding="0" cellspacing="0" height="100%" width="100%">
        <tr>
            <td align="center" valign="top">
                <?php Wlpr_Preview::print_preview_launcher(); ?>
            </td>
        </tr>
    </table>
</div>

<?php
do_action('wlpr_launcher_preview_footer');
wp_footer();
?>
</body>

</html>
