<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
$discount_types = array(
    'fixed' => esc_html__('Fixed', WLPR_TEXT_DOMAIN),
    'percentage' => esc_html__('Percentage', WLPR_TEXT_DOMAIN)
);
$discount_enabled_attr = array(
    'no' => __('No',WLPR_TEXT_DOMAIN),
    'yes' => __('Yes',WLPR_TEXT_DOMAIN),
);
$earn_point_actions_attr = array(
    'global' => __('Inherit from global settings',WLPR_TEXT_DOMAIN),
    'product' => __('Override points at product level',WLPR_TEXT_DOMAIN),
    'disable' => __('Disable',WLPR_TEXT_DOMAIN)
);
?>
    <h3 style="padding: 30px 0px 7px!important;  color: #212b36;font-size: 24px !important;border-top: 1px solid #d8dbe87a;"><?php esc_html_e('Loyalty point settings', WLPR_TEXT_DOMAIN) ?></h3>
    <p class="form-row form-row-last">
        <label style="display: block;margin-right: 13px; font-size: 15px;margin-bottom: 10px; font-weight: 500;color: #0F0F1A;"><?php _e('Enable product variant earn points ?', WLPR_TEXT_DOMAIN); ?></label>
        <?php
        $wlpr_variable_product_enable_earn_point = ((isset($wlpr_variable_product_enable_earn_point) && !empty($wlpr_variable_product_enable_earn_point)) ? $wlpr_variable_product_enable_earn_point : 'global'); ?>
        <select style="max-width: 40%; border: 1px solid #ced4da;font-size: 15px;color: #475867; padding: 5px 10px;margin-left: 12px;"
                id="wlpr-earn-point-action-settings-<?php echo $loop;?>"
                onchange="showEarnPointDiv('<?php echo $loop;?>');"
                name="_wlpr_variable_product_enable_earn_point[<?php echo esc_attr($loop); ?>]">
            <?php foreach ($earn_point_actions_attr as $d_key => $d_value): ?>
                <?php if ($d_key == $wlpr_variable_product_enable_earn_point): ?>
                    <option value="<?php echo $d_key; ?>"
                            selected="selected"><?php echo $d_value; ?></option>
                <?php else: ?>
                    <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>
    </p>

        <p class="form-row form-row-last wlpr-earn-point-disable-msg-<?php echo $loop;?>" style="<?php echo ($wlpr_variable_product_enable_earn_point == 'disable') ? "": "display:none;";?>">
            <?php echo __('Earn points will be disabled for this variant',WLPR_TEXT_DOMAIN);?>
        </p>

    <p class="form-row form-row-full wlpr-earn-point-settings-<?php echo $loop;?>" style="<?php echo ($wlpr_variable_product_enable_earn_point== 'product') ? "":"display:none;";?>">
        <label style="display: block;margin-right: 13px;font-size: 15px; margin-bottom: 10px; font-weight: 500; color: #0F0F1A;"><?php esc_html_e('How many points customer can earn when they purchase?(per variant quantity)', WLPR_TEXT_DOMAIN); ?></label>
        <input class="wlpr-earn-point"
               style="max-width: 20%; border: 1px solid #ced4da; font-size: 15px;  color: #475867; padding: 5px 10px; margin-right: 13px;"
               type="number" min="0"
               name="_wlpr_variable_product_points_earned[<?php echo esc_attr($loop); ?>][wlpr_earn_point]"
               value="<?php echo esc_attr((isset($earn_point_setting['wlpr_earn_point']) && !empty($earn_point_setting['wlpr_earn_point']) ? $earn_point_setting['wlpr_earn_point'] : 0)); ?>"/><?php esc_html_e('points can be earned for spending', WLPR_TEXT_DOMAIN); ?>
        &nbsp;&#61;&nbsp;<?php echo get_woocommerce_currency_symbol(); ?>

        <input class="wlpr-point-earn-price"
               style="max-width: 20%; border: 1px solid #ced4da;font-size: 15px;color: #475867; padding: 5px 10px;margin-left: 12px;"
               type="number" min="0"
               name="_wlpr_variable_product_points_earned[<?php echo esc_attr($loop); ?>][wlpr_point_earn_price]"
               value="<?php echo esc_attr((isset($earn_point_setting['wlpr_point_earn_price']) && !empty($earn_point_setting['wlpr_point_earn_price']) ? $earn_point_setting['wlpr_point_earn_price'] : 0)); ?>"/>
        <br/>
        <small style="font-size: 12px;position: relative;top: 15px;"><?php esc_html_e('Set the number of points awarded based on the product variant price.', WLPR_TEXT_DOMAIN); ?></small>
    </p>
    <p class="form-row form-row-last">
        <label style="display: block;margin-right: 13px; font-size: 15px;margin-bottom: 10px; font-weight: 500;color: #0F0F1A;"><?php _e('Enable maximum discount(per variant quantity) ?', WLPR_TEXT_DOMAIN); ?></label>
        <?php
        $max_variant_discount_enabled = ((isset($max_variant_discount_enabled) && !empty($max_variant_discount_enabled)) ? $max_variant_discount_enabled : 'no'); ?>
        <select style="max-width: 40%; border: 1px solid #ced4da;font-size: 15px;color: #475867; padding: 5px 10px;margin-left: 12px;"
                name="_wlpr_variable_product_max_discount_enabled[<?php echo esc_attr($loop); ?>]">
            <?php foreach ($discount_enabled_attr as $d_key => $d_value): ?>
                <?php if ($d_key == $max_variant_discount_enabled): ?>
                    <option value="<?php echo $d_key; ?>"
                            selected="selected"><?php echo $d_value; ?></option>
                <?php else: ?>
                    <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>
    </p>
    <p class="form-row form-row-last">
        <label style="display: block;margin-right: 13px; font-size: 15px;margin-bottom: 10px; font-weight: 500;color: #0F0F1A;"><?php _e('Maximum Points Discount(per variant quantity)', WLPR_TEXT_DOMAIN); ?></label>
        <input style="max-width: 40%; border: 1px solid #ced4da; font-size: 15px;  color: #475867; padding: 5px 10px; margin-right: 13px;"
               type="number" min="0"
               name="_wlpr_variable_product_points_max_discount[<?php echo esc_attr($loop); ?>]"
               value="<?php echo esc_attr($max_discount); ?>"
               placeholder="<?php _e('Variation Max Points Discount', WLPR_TEXT_DOMAIN); ?>"/>
        <?php $max_discount_type = esc_attr((isset($max_discount_type) && !empty($max_discount_type) ? $max_discount_type : 'fixed')); ?>
        <select style="max-width: 40%; border: 1px solid #ced4da;font-size: 15px;color: #475867; padding: 5px 10px;margin-left: 12px;"
                name="_wlpr_variable_product_points_max_discount_type[<?php echo esc_attr($loop); ?>]">
            <?php foreach ($discount_types as $d_key => $d_value): ?>
                <?php if ($d_key == $max_discount_type): ?>
                    <option value="<?php echo $d_key; ?>"
                            selected="selected"><?php echo $d_value; ?></option>
                <?php else: ?>
                    <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>
        <br/>
        <small style="font-size: 12px;position: relative;top: 15px;"><?php esc_html_e('Set the maximum product discount allowed when redeeming points per-variant. Use either a fixed monetary amount or a percentage based on the variant price. Leave blank to disable.', WLPR_TEXT_DOMAIN); ?></small>
    </p>
<?php if (isset($product_type) && !empty($product_type) && in_array($product_type,array("subscription","variable-subscription"))): ?>
    <p class="form-row form-row-full">
        <label style="display: block;margin-right: 13px;font-size: 15px; margin-bottom: 10px; font-weight: 500; color: #0F0F1A;"><?php esc_html_e('How many renewal points customer can earn when they purchase?(For subscription product)', WLPR_TEXT_DOMAIN); ?></label>
        <input class="wlpr-earn-point"
               style="max-width: 20%; border: 1px solid #ced4da; font-size: 15px;  color: #475867; padding: 5px 10px; margin-right: 13px;"
               type="number" min="0"
               name="_wlpr_variable_product_points_renewal_points[<?php echo esc_attr($loop); ?>][wlpr_earn_point]"
               value="<?php echo esc_attr((isset($renewal_earn_point_setting['wlpr_earn_point']) && !empty($renewal_earn_point_setting['wlpr_earn_point']) ? $renewal_earn_point_setting['wlpr_earn_point'] : 0)); ?>"/><?php esc_html_e('points can be earned for spending', WLPR_TEXT_DOMAIN); ?>
        &nbsp;&#61;&nbsp;<?php echo get_woocommerce_currency_symbol(); ?>

        <input class="wlpr-point-earn-price"
               style="max-width: 20%; border: 1px solid #ced4da; font-size: 15px;  color: #475867; padding: 5px 10px; margin-right: 13px;"
               type="number" min="0"
               name="_wlpr_variable_product_points_renewal_points[<?php echo esc_attr($loop); ?>][wlpr_point_earn_price]"
               value="<?php echo esc_attr((isset($renewal_earn_point_setting['wlpr_point_earn_price']) && !empty($renewal_earn_point_setting['wlpr_point_earn_price']) ? $renewal_earn_point_setting['wlpr_point_earn_price'] : 0)); ?>"/>
        <br/>
        <small><?php esc_html_e('Set the number of points awarded based on the renewal product variant price.', WLPR_TEXT_DOMAIN); ?></small>
    </p>
    <?php
endif;
?>
<script type="application/javascript">
    function showEarnPointDiv(loop){
        var current_value = jQuery('#wlpr-earn-point-action-settings-'+loop).val();
        if(current_value == 'global'){
            jQuery('.wlpr-earn-point-settings-'+loop).hide();
            jQuery('.wlpr-earn-point-disable-msg-'+loop).hide();
        }
        if(current_value == 'disable'){
            jQuery('.wlpr-earn-point-disable-msg-'+loop).show();
            jQuery('.wlpr-earn-point-settings-'+loop).hide();
        }
        if(current_value == 'product'){
            jQuery('.wlpr-earn-point-disable-msg-'+loop).hide();
            jQuery('.wlpr-earn-point-settings-'+loop).show();
        }
    }
</script>
