<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
$discount_types = array(
    'fixed' => esc_html(__('Fixed', WLPR_TEXT_DOMAIN)),
    'percentage' => esc_html(__('Percentage', WLPR_TEXT_DOMAIN))
);
$user_batch_list = array(5,10,15,20,25,30);
$order_status_list = \Wlpr\App\Helpers\Loyalty::woocommerce()->get_order_statuses();
?>

<div class="full-width lpr-setting">
    <div class="wlpr-settings-container lprwp-setting-nw-container">
        <ul class="lprwp-settings-nw-tab">
            <li class="wlpr-setting-tab-link active" onclick="wlpr.openCustomTab(this, 'wlpr-license-settings');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('License', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>

            <li class="wlpr-setting-tab-link" onclick="wlpr.openCustomTab(this, 'wlpr-launcher-settings');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('Launcher', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>

            <li class="wlpr-setting-tab-link" onclick="wlpr.openCustomTab(this, 'wlpr-earn-point-purchase-action');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('Earn Points for Purchase action', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>
            <li class="wlpr-setting-tab-link" onclick="wlpr.openCustomTab(this, 'wlpr-earn-point-other-action');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('Earn Points for Other Actions', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>
            <li class="wlpr-setting-tab-link" onclick="wlpr.openCustomTab(this, 'wlpr-redemption-settings');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('Redemption Settings', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>
            <li class="wlpr-setting-tab-link" onclick="wlpr.openCustomTab(this, 'wlpr-front-end-message-settings');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('Display Messages (Includes Product/cart and checkout pages)', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>
        </ul>
        <form id="wlpr-settings_form" method="post">
            <br>
            <div class="lpr-points-settings-save">
                <div class="form-row">
                    <input type="button" id="wlpr-setting-submit-button" class="lpr-button-btn btn btn-save lpr-btn-setting-save"
                           onclick="wlpr.saveSettings();"
                           value="<?php _e('Save', WLPR_TEXT_DOMAIN); ?>"/>
                </div>
            </div>
            <br>
            <br>
            <br>
            <div class="lpr-points-settings" id="wlpr-license-settings">
                <div class="lpr-point-help-text">
                    <?php echo __('You can get your license from <a target="_blank" href="https://www.flycart.org/my-downloads">your account at Flycart website</a>', WLPR_TEXT_DOMAIN); ?>
                </div>
                <div class="lpr-points-settings-second lpr-points-second-settings-nw">
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="license_key"><?php _e('License key', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <?php
                            $license_key = isset($license_key) ? $license_key : NULL;
                            ?>
                            <div class="form-wecp-input-group">
                                <input type="text" id="license_key" class="lpr-form-control-2" name="license_key"
                                       value="<?php echo $license_key ?>"
                                       placeholder="<?php _e('Enter license key here...', WLPR_TEXT_DOMAIN); ?>">
                                <button type="button" class="lpr-button-btn btn btn-validate lpr-btn-license"
                                        onclick="wlpr.saveSettings();"
                                        id="btn-validate"><?php _e('Validate', WLPR_TEXT_DOMAIN) ?></button>
                            </div>
                            <?php
                            if (!empty($license_key)) {
                                ?>
                                <p class="license_key_message"
                                   style="margin: 10px 0 0 0;color:<?php echo (isset($license_key_error) && !empty($license_key_error)) ? 'red' : 'green'; ?>;">
                                    <?php echo (isset($license_key_message) && !empty($license_key_message)) ? $license_key_message : ''; ?>
                                </p>
                                <?php
                            } else {
                                ?>
                                <p class="license_key_message" style="margin: 10px 0 0 0;"></p>
                                <?php
                            }
                            ?>

                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="wlpr_client_id"><?php _e('Client id / Consumer key', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $wlpr_client_id = (isset($options['wlpr_client_id']) && !empty($options['wlpr_client_id'])) ? $options['wlpr_client_id'] : ''; ?>
                                <input type="text" id="wlpr_client_id" name="wlpr_client_id" value="<?php echo $wlpr_client_id;?>" class="lpr-form-control-2" />
                                <div class="lpr-button-btn btn btn-validate lpr-btn-license" onclick="wlpr.copyLink('wlpr_client_id')"><span
                                            class="input-group-text"><?php echo __('Copy',WLPR_TEXT_DOMAIN)?></span></div>
                            </div>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="wlpr_client_secret"><?php _e('Client Secret / Consumer Secret', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $wlpr_client_secret = (isset($options['wlpr_client_secret']) && !empty($options['wlpr_client_secret'])) ? $options['wlpr_client_secret'] : ''; ?>
                                <input type="text" id="wlpr_client_secret" name="wlpr_client_secret" value="<?php echo $wlpr_client_secret;?>" class="lpr-form-control-2" />
                                <div class="lpr-button-btn btn btn-validate lpr-btn-license" onclick="wlpr.copyLink('wlpr_client_secret')"><span
                                            class="input-group-text"><?php echo __('Copy',WLPR_TEXT_DOMAIN)?></span></div>
                                <input type="hidden" id="generate_api_key" name="generate_api_key" value="0" />

                                <button type="button" class="lpr-button-btn btn btn-validate lpr-btn-license"
                                        onclick="wlpr_jquery('#generate_api_key').val(1);wlpr.saveSettings();"
                                        id="btn-validate">
                                    <?php if(empty($wlpr_client_id) || empty($wlpr_client_secret)):?>
                                        <?php _e('Generate REST Api key', WLPR_TEXT_DOMAIN) ?>
                                    <?php else: ?>
                                        <?php _e('Re-generate REST Api key', WLPR_TEXT_DOMAIN) ?>
                                    <?php endif; ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="lpr-points-settings" id="wlpr-launcher-settings" style="display: none;">
                <div class="lpr-point-help-text">
                    <?php echo __('Add a Launcher widget to your website so that your customers can easily learn about the rewards you offer', WLPR_TEXT_DOMAIN); ?>
                    &nbsp;<a class="button" href="https://docs.flycart.org/en/articles/3825697-launcher-widget" target="_blank"><?php _e('Read docs',WLPR_TEXT_DOMAIN);?></a>
                </div>
                <div class="lpr-points-settings-second lpr-points-second-settings-nw">
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="customize_icon"><?php _e('Enable Launcher ?', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $enable_launcher = (isset($options['wlpr_enable_launcher']) && !empty($options['wlpr_enable_launcher'])) ? $options['wlpr_enable_launcher'] : 'yes'; ?>
                                <select name="wlpr_enable_launcher" class="lpr-form-control">
                                    <option value="no" <?php echo ($enable_launcher == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                    <option value="yes" <?php echo ($enable_launcher == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                                </select>
                                <br/>
                            </div>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="customize_icon"><?php _e('Launcher Icon', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <div class="column three">
                                    <?php
                                    $default_launcher_icon_path = WLPR_PLUGIN_URL.'Assets/Images/launcher_icon.png';
                                    $launcher_icon = (isset($options['wlpr_launcher_icon']) && !empty($options['wlpr_launcher_icon'])) ? $options['wlpr_launcher_icon'] : $default_launcher_icon_path;
                                    echo \Wlpr\App\Helpers\Launcher::get_image_display('wlpr_launcher_icon', $launcher_icon, $default_launcher_icon_path) ?>
                                </div>
                                <div class="column nine">
                                    <?php $launcher_template_preview = WLPR_PLUGIN_URL.'Assets/Images/launcher.png';?>
                                    <img class="launcher-preview-img" src="<?php echo $launcher_template_preview;?>" width="400" height="200" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="customize_text"><?php _e('Launcher Text', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $launcher_text = (isset($options['wlpr_launcher_text']) && !empty($options['wlpr_launcher_text'])) ? $options['wlpr_launcher_text'] : 'My Rewards'; ?>
                                <input type="text" name="wlpr_launcher_text" class="lpr-form-control" value="<?php echo $launcher_text; ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="launcher_icon_width"><?php _e('Launcher Button Width', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $wlpr_launcher_button_width = (isset($options['wlpr_launcher_button_width']) && !empty($options['wlpr_launcher_button_width'])) ? $options['wlpr_launcher_button_width'] : '15'; ?>
                                <input type="number" min="0" oninput="validity.valid||(value='');" name="wlpr_launcher_button_width" class="lpr-form-control" value="<?php echo $wlpr_launcher_button_width; ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="customize_position"><?php _e('Launcher Icon Display Position', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php
                                $launcher_position_options = array(
                                    'right' => __('Right', WLPR_TEXT_DOMAIN),
                                    'left' => __('Left', WLPR_TEXT_DOMAIN)
                                );
                                $launcher_icon_position = (isset($options['wlpr_launcher_icon_position']) && !empty($options['wlpr_launcher_icon_position'])) ? $options['wlpr_launcher_icon_position'] : 'left'; ?>
                                <select name="wlpr_launcher_icon_position" style="width: 100%;">
                                    <?php foreach ($launcher_position_options as $position_key => $position_value): ?>
                                        <option value="<?php esc_attr_e($position_key); ?>" <?php echo ($position_key == $launcher_icon_position) ? 'selected="selected"' : ''; ?>><?php echo $position_value; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="wlpr_launcher_icon_background_color"><?php _e('Launcher Icon Background Color', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $launcher_icon_background_color = (isset($options['wlpr_launcher_icon_background_color']) && !empty($options['wlpr_launcher_icon_background_color'])) ? $options['wlpr_launcher_icon_background_color'] : '#353d9f'; ?>
                                <input type="text" value="<?php echo $launcher_icon_background_color;?>" name="wlpr_launcher_icon_background_color" class="wlpr-color-field" />
                            </div>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="wlpr_launcher_icon_text_color"><?php _e('Launcher Icon Text Color', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $wlpr_launcher_icon_text_color = (isset($options['wlpr_launcher_icon_text_color']) && !empty($options['wlpr_launcher_icon_text_color'])) ? $options['wlpr_launcher_icon_text_color'] : '#f0f0f0'; ?>
                                <input type="text" value="<?php echo $wlpr_launcher_icon_text_color;?>" name="wlpr_launcher_icon_text_color" class="wlpr-color-field" />
                            </div>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="customize_launcher_device"><?php _e('Show Launcher in', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php
                                $launcher_device_options = array(
                                    'all' => __('All Devices', WLPR_TEXT_DOMAIN),
                                    'desktop' => __('Desktop', WLPR_TEXT_DOMAIN),
                                    'mobile' => __('Mobile devices', WLPR_TEXT_DOMAIN)
                                );
                                $wlpr_launcher_display_device = (isset($options['wlpr_launcher_display_device']) && !empty($options['wlpr_launcher_display_device'])) ? $options['wlpr_launcher_display_device'] : 'all'; ?>
                                <select name="wlpr_launcher_display_device" style="width: 100%;">
                                    <?php foreach ($launcher_device_options as $device_key => $device_value): ?>
                                        <option value="<?php esc_attr_e($device_key); ?>" <?php echo ($device_key == $wlpr_launcher_display_device) ? 'selected="selected"' : ''; ?>><?php echo $device_value; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="form-row">
                            <div class="lpr-label-text">
                                <label for="customize_url"><?php _e('Customize Launcher', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <a href="<?php echo (isset($launcher_url) && $launcher_url) ? $launcher_url : ''; ?>"
                                   class="blpr-button-btn lpr-btn-license"><?php _e('Customize', WLPR_TEXT_DOMAIN); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="lpr-points-settings" id="wlpr-earn-point-purchase-action" style="display: none;">
                <div class="lpr-point-help-text">
                    <?php echo __(sprintf('Set points earned for each dollar customer spend in your store. These are global settings. You can also set points for specific products or categories which will override this settings for those products. <br/><br/><strong>Example:</strong> 1 points can be earned for spending %s1', get_woocommerce_currency_symbol()), WLPR_TEXT_DOMAIN); ?>
                </div>
                <div class="lpr-points-settings-second lpr-points-second-settings-nw">
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable earn point?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php $enable_earn_point = (isset($options['wlpr_enable_earn_point']) && !empty($options['wlpr_enable_earn_point'])) ? $options['wlpr_enable_earn_point'] : 'yes'; ?>
                            <select name="wlpr_enable_earn_point" class="lpr-form-control">
                                <option value="no" <?php echo ($enable_earn_point == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($enable_earn_point == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                            <br/>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('How many points customer can earn when they purchase?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <input class="lpr-form-control wlpr-earn-point lpr-form-control-width" type="number" min="0"
                                   oninput="validity.valid||(value='');"
                                   name="wlpr_earn_point"
                                   value="<?php echo (isset($options['wlpr_earn_point']) && (!empty($options['wlpr_earn_point']) || $options['wlpr_earn_point'] == 0)) ? $options['wlpr_earn_point'] : 1; ?>"/>
                            <span class="points-value">  <?php esc_html_e('points can be earned for spending', WLPR_TEXT_DOMAIN); ?>
                                &nbsp;<?php echo get_woocommerce_currency_symbol(); ?></span>
                            <input class="lpr-form-control wlpr-point-earn-price lpr-form-control-width" type="number"
                                   oninput="validity.valid||(value='');"
                                   min="0"
                                   name="wlpr_point_earn_price"
                                   value="<?php echo (isset($options['wlpr_point_earn_price']) && (!empty($options['wlpr_point_earn_price']) || $options['wlpr_point_earn_price'] == 0)) ? $options['wlpr_point_earn_price'] : 1; ?>"/>
                            <br/>
                            <small><?php esc_html_e('Example: If you want to award your customers 1 point for each 1$ spent on the product. Set it as 1 and 1.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Award points only for the following order statuses', WLPR_TEXT_DOMAIN); ?></label>
                            <?php $wlpr_point_earning_status = (isset($options['wlpr_point_earning_status']) && !empty($options['wlpr_point_earning_status']) ? $options['wlpr_point_earning_status'] : array('completed', 'processing')); ?>
                        </div>

                        <div class="lpr-label-input">
                            <select name="wlpr_point_earning_status[]" multiple="multiple" style="width: 100%;"
                                    class="lpr-form-multselect">
                                <?php foreach ($order_status_list as $earn_status_key => $earn_status_value): ?>
                                    <?php if (in_array($earn_status_key, $wlpr_point_earning_status)): ?>
                                        <option value="<?php esc_attr_e($earn_status_key); ?>"
                                                selected="selected"><?php echo $earn_status_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php esc_attr_e($earn_status_key); ?>"><?php echo $earn_status_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Points will be awarded to the customer when their order status matches the above values.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Exclude User Roles from earning points', WLPR_TEXT_DOMAIN); ?></label>
                            <?php $wlpr_exclude_point_earning_roles = (isset($options['wlpr_exclude_point_earning_roles']) && !empty($options['wlpr_exclude_point_earning_roles']) ? $options['wlpr_exclude_point_earning_roles'] : array()); ?>
                        </div>
                        <div class="lpr-label-input">
                            <select name="wlpr_exclude_point_earning_roles[]" multiple="multiple" style="width: 100%;"
                                    class="lpr-form-multselect">
                                <?php foreach ($exclude_earn_point_roles as $exclude_role_key => $exclude_role_value): ?>
                                    <?php if (in_array($exclude_role_key, $wlpr_exclude_point_earning_roles)): ?>
                                        <option value="<?php esc_attr_e($exclude_role_key); ?>"
                                                selected="selected"><?php echo $exclude_role_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php esc_attr_e($exclude_role_key); ?>"><?php echo $exclude_role_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Select user roles that are excluded from earning points. You can select multiple values as well.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Earn point calculation after discount?', WLPR_TEXT_DOMAIN); ?></label>
                            <?php $wlpr_is_earn_point_after_discount = (isset($options['wlpr_is_earn_point_after_discount']) && !empty($options['wlpr_is_earn_point_after_discount']) ? $options['wlpr_is_earn_point_after_discount'] : 'no'); ?>
                        </div>

                        <div class="lpr-label-input">
                            <select name="wlpr_is_earn_point_after_discount"
                                    class="wlpr-is-earn-point-after-discount lpr-form-select">
                                <option value="no" <?php echo ($wlpr_is_earn_point_after_discount == 'no') ? 'selected' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($wlpr_is_earn_point_after_discount == 'yes') ? 'selected' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                            <br/>
                            <small><?php esc_html_e('If any discount applied in cart, then point will calculate after discount amount.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Rounding Mode for points earned', WLPR_TEXT_DOMAIN); ?></label>
                            <?php $point_rounding_type = (isset($options['wlpr_point_rounding_type']) && !empty($options['wlpr_point_rounding_type']) ? $options['wlpr_point_rounding_type'] : 'round'); ?>
                        </div>

                        <div class="lpr-label-input">
                            <select name="wlpr_point_rounding_type" class="lpr-form-select">
                                <option value="round" <?php echo ($point_rounding_type == 'round') ? 'selected' : ''; ?>><?php esc_html_e('Round to nearest integer', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="floor" <?php echo ($point_rounding_type == 'floor') ? 'selected' : ''; ?>><?php esc_html_e('Always round down', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="ceil" <?php echo ($point_rounding_type == 'ceil') ? 'selected' : ''; ?>><?php esc_html_e('Always round up', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Example: If a user has spent 5.50 on a product, round up or to the nearest integer would make 6 points whereas round down will earn him 5 points.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>


                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Points text to be displayed as', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <input class="wlpr-point-label lpr-form-control" type="text"
                                   name="wlpr_point_label"
                                   value="<?php echo esc_attr((isset($options['wlpr_point_label']) && !empty($options['wlpr_point_label']) ? $options['wlpr_point_label'] : esc_html(__('points', WLPR_TEXT_DOMAIN)))); ?>"/>
                            <br/>
                            <small><?php esc_html_e('Give your desired text instead of points.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('My Account Label Icon Display Position', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php
                            $my_account_label_icon_position = (isset($options['wlpr_my_account_label_icon_position']) && !empty($options['wlpr_my_account_label_icon_position']) ? $options['wlpr_my_account_label_icon_position'] : 'no'); ?>
                            <select name="wlpr_my_account_label_icon_position"
                                    class="wlpr-my-account-label-icon-position lpr-form-select">
                                <option value="no" <?php echo ($my_account_label_icon_position == 'no') ? 'selected' : ''; ?>><?php esc_html_e('No icon.', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($my_account_label_icon_position == 'yes') ? 'selected' : ''; ?>><?php esc_html_e('Icon display before label.', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                            <br/>
                            <small><?php esc_html_e('In My Account Page, Point label icon display position.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>


                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Expiry of points (Set 0 for Never Expire)', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="row-field">
                            <div class="lpr-label-input">
                                <select name="wlpr_expired_after" class="wlpr-expired-after lpr-form-select">
                                    <?php
                                    $number = esc_attr((isset($options['wlpr_expired_after']) && !empty($options['wlpr_expired_after']) ? $options['wlpr_expired_after'] : 0));
                                    for ($num = 0; $num < 100; $num++) :
                                        $selected = '';
                                        if ($num == $number) {
                                            $selected = ' selected="selected" ';
                                        }
                                        ?>
                                        <option value="<?php echo esc_attr($num); ?>" <?php echo $selected; ?>><?php echo $num; ?></option>
                                    <?php endfor; ?>
                                </select>
                                <?php
                                $expired_period_list = array(
                                    'DAY' => esc_html__('Day(s)', WLPR_TEXT_DOMAIN),
                                    'WEEK' => esc_html__('Week(s)', WLPR_TEXT_DOMAIN),
                                    'MONTH' => esc_html__('Month(s)', WLPR_TEXT_DOMAIN),
                                    'YEAR' => esc_html__('Year(s)', WLPR_TEXT_DOMAIN),
                                );
                                $wlpr_expired_period = esc_attr((isset($options['wlpr_expired_period']) && !empty($options['wlpr_expired_period']) ? $options['wlpr_expired_period'] : 'DAY'));
                                ?>
                            </div>
                        </div>
                        <div class="row-field">
                            <div class="lpr-label-input">
                                <select name="wlpr_expired_period" class="wlpr-expired-period lpr-form-select">
                                    <?php foreach ($expired_period_list as $expired_key => $expired_value): ?>
                                        <?php if ($expired_key == $wlpr_expired_period): ?>
                                            <option value="<?php esc_attr_e($expired_key); ?>"
                                                    selected="selected"><?php echo $expired_value; ?></option>
                                        <?php else: ?>
                                            <option value="<?php esc_attr_e($expired_key); ?>"><?php echo $expired_value; ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <br/>
                        <small><?php esc_html_e('How many days after which the Earned points should Expire', WLPR_TEXT_DOMAIN); ?></small>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Notify customer about expiry of points', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="row-field">
                            <div class="lpr-label-input">
                                <select name="wlpr_expired_email_after" class="wlpr-expired-after lpr-form-select">
                                    <?php
                                    $number = esc_attr((isset($options['wlpr_expired_email_after']) && !empty($options['wlpr_expired_email_after']) ? $options['wlpr_expired_email_after'] : 5));
                                    for ($num = 1; $num < 100; $num++) :
                                        $selected = '';
                                        if ($num == $number) {
                                            $selected = ' selected="selected" ';
                                        }
                                        ?>
                                        <option value="<?php echo esc_attr($num); ?>" <?php echo $selected; ?>><?php echo $num; ?></option>
                                    <?php endfor; ?>
                                </select>
                                <?php
                                $expired_period_list = array(
                                    'DAY' => esc_html__('Day(s)', WLPR_TEXT_DOMAIN),
                                    'WEEK' => esc_html__('Week(s)', WLPR_TEXT_DOMAIN),
                                    'MONTH' => esc_html__('Month(s)', WLPR_TEXT_DOMAIN),
                                    'YEAR' => esc_html__('Year(s)', WLPR_TEXT_DOMAIN),
                                );
                                $wlpr_expired_email_period = esc_attr((isset($options['wlpr_expired_email_period']) && !empty($options['wlpr_expired_email_period']) ? $options['wlpr_expired_email_period'] : 'DAY'));
                                ?>
                            </div>
                        </div>
                        <div class="row-field">
                            <div class="lpr-label-input">
                                <select name="wlpr_expired_email_period" class="wlpr-expired-period lpr-form-select">
                                    <?php foreach ($expired_period_list as $expired_key => $expired_value): ?>
                                        <?php if ($expired_key == $wlpr_expired_email_period): ?>
                                            <option value="<?php esc_attr_e($expired_key); ?>"
                                                    selected="selected"><?php echo $expired_value; ?></option>
                                        <?php else: ?>
                                            <option value="<?php esc_attr_e($expired_key); ?>"><?php echo $expired_value; ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <br/>
                        <small><?php esc_html_e('How many days after the date of earning points to notify about the expiry of points? (Example: 30 days after. If a customer earned points on January 1st, he will be notified on January 30th.) Valid only if the Points Expiry is set.', WLPR_TEXT_DOMAIN); ?></small>
                    </div>
                </div>
            </div>
            <div class="lpr-points-settings" id="wlpr-earn-point-other-action" style="display: none;">
                <div class="lpr-point-help-text">
                    <?php esc_html_e('Award points for actions like signup, writing a review.', WLPR_TEXT_DOMAIN); ?>
                </div>
                <div class="lpr-points-settings-second lpr-points-second-settings-nw">
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable account signup reward?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php $enable_signup_reward = (isset($options['wlpr_enable_signup_reward']) && !empty($options['wlpr_enable_signup_reward'])) ? $options['wlpr_enable_signup_reward'] : 'yes'; ?>
                            <select name="wlpr_enable_signup_reward" class="lpr-form-control">
                                <option value="no" <?php echo ($enable_signup_reward == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($enable_signup_reward == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                            <br/>
                        </div>
                    </div>

                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Account signup', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <input class="wlpr-account-signup-points lpr-form-control" type="number" min="0" oninput="validity.valid||(value='');"
                                   name="wlpr_account_signup_points"
                                   value="<?php echo (isset($options['wlpr_account_signup_points']) && (!empty($options['wlpr_account_signup_points']) || $options['wlpr_account_signup_points'] == 0)) ? $options['wlpr_account_signup_points'] : 50; ?>"/>
                            <br/>
                            <small><?php esc_html_e('Set points for customer Sign up/Register for an account in your store.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>

                    </div>

                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Account signup message', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <textarea class="wlpr-account-signup-message lpr-form-control-text"
                                      name="wlpr_account_signup_message"><?php echo esc_textarea((isset($options['wlpr_account_signup_message']) && !empty($options['wlpr_account_signup_message']) ? $options['wlpr_account_signup_message'] : 'Signup and earn <strong>{wlpr_signup_point}</strong> {wlpr_points_label}!')); ?></textarea>
                            <br/>
                            <small><?php esc_html_e('Use {wlpr_signup_point}, {wlpr_points_label} short code to customize message.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>

                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable review reward?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php $enable_review_reward = (isset($options['wlpr_enable_review_reward']) && !empty($options['wlpr_enable_review_reward'])) ? $options['wlpr_enable_review_reward'] : 'yes'; ?>
                            <select name="wlpr_enable_review_reward" class="lpr-form-control">
                                <option value="no" <?php echo ($enable_review_reward == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($enable_review_reward == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                            <br/>
                        </div>
                    </div>

                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Writing a review', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="wlpr-write-review-points  lpr-form-control" type="number" min="0"
                                   oninput="validity.valid||(value='');"
                                   name="wlpr_write_review_points"
                                   value="<?php echo (isset($options['wlpr_write_review_points']) && (!empty($options['wlpr_write_review_points']) || $options['wlpr_write_review_points'] == 0)) ? $options['wlpr_write_review_points'] : 50; ?>"/>
                            <br/>
                            <small><?php esc_html_e('Set points for product reviews.(Only for Woocommerce Reviews)', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>

                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Review message', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <textarea class="wlpr-write-review-points-message lpr-form-control-text"
                                      name="wlpr_write_review_message"><?php echo esc_textarea((isset($options['wlpr_write_review_message']) && !empty($options['wlpr_write_review_message']) ? $options['wlpr_write_review_message'] : 'Review and earn <strong>{wlpr_review_points}</strong> {wlpr_points_label}!')); ?></textarea>
                            <br/>
                            <small><?php esc_html_e('Use {wlpr_review_points},{wlpr_points_label} short code to customize review message.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>

                    </div>
                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable Birthday Date Point', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php $enable_birthday_date_reward = (isset($options['wlpr_enable_birth_date_point']) && !empty($options['wlpr_enable_birth_date_point'])) ? $options['wlpr_enable_birth_date_point'] : 'yes'; ?>
                            <select name="wlpr_enable_birth_date_point" class="lpr-form-control">
                                <option value="no" <?php echo ($enable_birthday_date_reward == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($enable_birthday_date_reward == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                        </div>

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Add Birthday Date Point', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="wlpr-birth-date-point  lpr-form-control" type="number" min="0"
                                   name="wlpr_birth_date_point" oninput="validity.valid||(value='');"
                                   value="<?php echo esc_attr((isset($options['wlpr_birth_date_point']) && !empty($options['wlpr_birth_date_point'])) ? $options['wlpr_birth_date_point'] : 0); ?>"/>
                            <br/>
                            <small><?php esc_html_e('How many points to award when a customer update birthday date.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('On Birthday Date Point', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="wlpr-on-birth-date-point  lpr-form-control" type="number" min="0"
                                   name="wlpr_on_birth_date_point" oninput="validity.valid||(value='');"
                                   value="<?php echo esc_attr((isset($options['wlpr_on_birth_date_point']) && !empty($options['wlpr_on_birth_date_point'])) ? $options['wlpr_on_birth_date_point'] : 0); ?>"/>
                            <br/>
                            <small><?php esc_html_e('How many points to award on customer birthday date.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="lpr-points-settings" id="wlpr-redemption-settings" style="display: none;">
                <div class="lpr-point-help-text">
                    <?php esc_html_e('Set how customers can redeem their earned points. Example: Customers can redeem 500 points for $5', WLPR_TEXT_DOMAIN); ?>
                    &nbsp;&nbsp;&nbsp;<a class="button" href="https://docs.flycart.org/en/articles/4354246-redemption-settings" target="_blank"><?php _e('Read docs',WLPR_TEXT_DOMAIN);?></a>
                </div>
                <div class="lpr-points-settings-second lpr-points-second-settings-nw">
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Conversion Rate for redeeming points', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="wlpr-redeem-point lpr-form-control lpr-form-control-width" type="number"
                                   oninput="validity.valid||(value='');"
                                   min="0" name="wlpr_redeem_point"
                                   value="<?php echo (isset($options['wlpr_redeem_point']) && (!empty($options['wlpr_redeem_point']) || $options['wlpr_redeem_point'] == 0)) ? $options['wlpr_redeem_point'] : 500; ?>"/>
                            <span class="points-value">  <?php esc_html_e('points can be redeemed for', WLPR_TEXT_DOMAIN); ?>

                                <?php echo get_woocommerce_currency_symbol(); ?> </span>
                            <input class="wlpr-point-redeem-price lpr-form-control lpr-form-control-width" type="number"
                                   oninput="validity.valid||(value='');"
                                   min="0"
                                   name="wlpr_point_redeem_price"
                                   value="<?php echo (isset($options['wlpr_point_redeem_price']) && (!empty($options['wlpr_point_redeem_price']) || $options['wlpr_point_redeem_price'] == 0)) ? $options['wlpr_point_redeem_price'] : 5; ?>"/>
                            <br/>
                            <small><?php esc_html_e('Set how many points can be redeemed for a discount amount. Example: 500 points for $5.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd" >
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Tax Setting', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <?php
                            $tax_application = (isset($options['wlpr_points_tax_application']) && !empty($options['wlpr_points_tax_application']) ? $options['wlpr_points_tax_application'] : 'exclusive'); ?>
                            <select name="wlpr_points_tax_application"
                                    class="wlpr-points-tax-application lpr-form-select">
                                <option value="inclusive" <?php echo ($tax_application == 'inclusive') ? 'selected' : ''; ?>><?php esc_html_e('Apply points to price inclusive of taxes.', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="exclusive" <?php echo ($tax_application == 'exclusive') ? 'selected' : ''; ?>><?php esc_html_e('Apply points to price exclusive of taxes.', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                            <br/>
                            <small><?php esc_html_e('The redemption value should include or exclude tax. Works based on your woocommerce tax settings.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd" >
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Choose how redemption point should work when WooCommerce coupons (or third party) coupons are used? ', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <?php
                            $redeem_when_other_coupon_apply = (isset($options['wlpr_redeem_when_other_coupon_apply']) && !empty($options['wlpr_redeem_when_other_coupon_apply']) ? $options['wlpr_redeem_when_other_coupon_apply'] : 'both'); ?>
                            <select name="wlpr_redeem_when_other_coupon_apply"
                                    class="wlpr-redeem-when-other-coupon-apply lpr-form-select">
                                <option value="both" <?php echo ($redeem_when_other_coupon_apply == 'both') ? 'selected' : ''; ?>><?php esc_html_e('Let both coupons and loyalty redemption run together.', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="other" <?php echo ($redeem_when_other_coupon_apply == 'other') ? 'selected' : ''; ?>><?php esc_html_e('Disable the loyalty redemption (coupons will work)', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="loyal" <?php echo ($redeem_when_other_coupon_apply == 'loyal') ? 'selected' : ''; ?>><?php esc_html_e('Disable the coupons (loyalty redemption will work).', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="row row-brd" style="display: none;">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Discount display process as', WLPR_TEXT_DOMAIN); ?></label>
                            <?php
                            $display_discount_list = array(
                                'fee' => __('Fee'),
                                'coupon' => __('Coupon')
                            );

                            $wlpr_discount_method = (isset($options['wlpr_discount_method']) && !empty($options['wlpr_discount_method']) ? $options['wlpr_discount_method'] : 'fee'); ?>
                        </div>
                        <div class="lpr-label-input">
                            <select name="wlpr_discount_method" class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($display_discount_list as $d_key => $d_value): ?>
                                    <?php if ($d_key == $wlpr_discount_method): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Redeem price display method', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Let points be redeemed only for the following order statuses', WLPR_TEXT_DOMAIN); ?></label>
                            <?php $wlpr_point_redeem_status = (isset($options['wlpr_point_redeem_status']) && !empty($options['wlpr_point_redeem_status']) ? $options['wlpr_point_redeem_status'] : array()); ?>
                        </div>
                        <div class="lpr-label-input">
                            <select name="wlpr_point_redeem_status[]" multiple="multiple" class="lpr-form-multselect"
                                    style="width: 100%;">
                                <?php foreach ($order_status_list as $redeem_status_key => $redeem_status_value): ?>
                                    <?php if (in_array($redeem_status_key, $wlpr_point_redeem_status)): ?>
                                        <option value="<?php esc_attr_e($redeem_status_key); ?>"
                                                selected="selected"><?php echo $redeem_status_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php esc_attr_e($redeem_status_key); ?>"><?php echo $redeem_status_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Start tying the order statuses to see the list. A customer can redeem his points only if the status of his redemption order matches the above values', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Label for Redeemed Points', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <input class="wlpr-point-label lpr-form-control" type="text"
                                   name="wlpr_cart_point_name"
                                   value="<?php echo esc_attr((isset($options['wlpr_cart_point_name']) && !empty($options['wlpr_cart_point_name']) ? $options['wlpr_cart_point_name'] : 'Points discount')); ?>"/>
                            <br/>
                            <small><?php esc_html_e('Label will be used to display the discount amount in the cart totals.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Manual redemption', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="wlpr-partial-redemption-enabled lpr-form-control-check-box" type="checkbox"
                                   name="wlpr_partial_redemption_enabled"
                                <?php echo esc_attr((isset($options['wlpr_partial_redemption_enabled']) && !empty($options['wlpr_partial_redemption_enabled']) ? 'checked="checked"' : '')); ?>
                                   value="yes"/>
                            <span class="partial-redemption-enabled"><?php esc_html_e('Enable pop-up for Customers to enter the points that they wish to redeem for that order.', WLPR_TEXT_DOMAIN); ?></span>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Minimum discount amount for redemption', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <input class="wlpr-minimum-discount  lpr-form-control" type="number" min="0"
                                   oninput="validity.valid||(value='');"
                                   name="wlpr_min_cart_discount"
                                   value="<?php echo esc_attr((isset($options['wlpr_min_cart_discount']) && !empty($options['wlpr_min_cart_discount']) ? $options['wlpr_min_cart_discount'] : 0)); ?>"/>
                            <br/>
                            <small><?php esc_html_e('Minimum discount value to enable redemption in cart. Example: 10. The redeem option will be enabled only when the user has enough points to redeem atleast 10$ in the cart.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Maximum discount amount for redemption', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <input class="wlpr-cart-maximum-discount lpr-form-control lpr-form-control-width"
                                   type="number" min="0"
                                   oninput="validity.valid||(value='');"
                                   name="wlpr_max_cart_discount"
                                   value="<?php echo esc_attr((isset($options['wlpr_max_cart_discount']) && !empty($options['wlpr_max_cart_discount']) ? $options['wlpr_max_cart_discount'] : 0)); ?>"/>
                            <?php $wlpr_max_cart_discount_type = esc_attr((isset($options['wlpr_max_cart_discount_type']) && !empty($options['wlpr_max_cart_discount_type']) ? $options['wlpr_max_cart_discount_type'] : 'fixed')); ?>
                            <select name="wlpr_max_cart_discount_type" class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($discount_types as $d_key => $d_value): ?>
                                    <?php if ($d_key == $wlpr_max_cart_discount_type): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Maximum discount allowed for redemption per order.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable Maximum discount amount for per product quantity redemption ?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <?php
                            $discount_enabled_attr = array(
                                'no' => __('No',WLPR_TEXT_DOMAIN),
                                'yes' => __('Yes',WLPR_TEXT_DOMAIN),
                            );
                            $wlpr_max_discount_enabled = esc_attr((isset($options['wlpr_max_discount_enabled']) && !empty($options['wlpr_max_discount_enabled']) ? $options['wlpr_max_discount_enabled'] : 'no')); ?>
                            <select name="wlpr_max_discount_enabled"
                                    class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($discount_enabled_attr as $d_key => $d_value): ?>
                                    <?php if ($d_key == $wlpr_max_discount_enabled): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Maximum discount amount for per product quantity redemption', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="wlpr-product-maximum-discount lpr-form-control lpr-form-control-width"
                                   type="number" min="0"
                                   oninput="validity.valid||(value='');"
                                   name="wlpr_max_product_discount"
                                   value="<?php echo esc_attr((isset($options['wlpr_max_product_discount']) && !empty($options['wlpr_max_product_discount']) ? $options['wlpr_max_product_discount'] : 0)); ?>"/>
                            <?php $wlpr_max_product_discount_type = esc_attr((isset($options['wlpr_max_product_discount_type']) && !empty($options['wlpr_max_product_discount_type']) ? $options['wlpr_max_product_discount_type'] : 'fixed')); ?>
                            <select name="wlpr_max_product_discount_type"
                                    class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($discount_types as $d_key => $d_value): ?>
                                    <?php if ($d_key == $wlpr_max_product_discount_type): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Maximum discount allowed per-product quantity. This can be overridden at product and category level.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="lpr-points-settings" id="wlpr-front-end-message-settings" style="display: none;">
                <div class="lpr-point-help-text">
                    <?php esc_html_e('Set up the promo messages that can be shown at the product / cart / checkout pages for earning / redeeming points.', WLPR_TEXT_DOMAIN) ?>
                </div>
                <div class="lpr-points-settings-second lpr-points-second-settings-nw">
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Which place loyalty points product message display?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php
                            $event_list = array(
                                'before_price' => __('Before Product Price', WLPR_TEXT_DOMAIN),
                                'after_price' => __('After Product Price', WLPR_TEXT_DOMAIN),
                                'before_add_to_cart' => __('Before Add to Cart', WLPR_TEXT_DOMAIN),
                                'after_add_to_cart' => __('After Add to Cart', WLPR_TEXT_DOMAIN),
                                'before_title' => __('Before Product Title',WLPR_TEXT_DOMAIN),
                                'after_title' => __('After Product Title',WLPR_TEXT_DOMAIN),
                            );
                            $display_product_display_position = (isset($options['display_product_display_position']) && !empty($options['display_product_display_position']) ? $options['display_product_display_position'] : 'before_price'); ?>
                            <select name="display_product_display_position" class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($event_list as $d_key => $d_value): ?>
                                    <?php if ($d_key == $display_product_display_position): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Where should the loyalty points message be displayed', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php
                            $product_message_place = array(
                                'all' => __('Both list and single product pages', WLPR_TEXT_DOMAIN),
                                'single' => __('Single Product Pages only', WLPR_TEXT_DOMAIN),
                                'list' => __('Product List Pages only', WLPR_TEXT_DOMAIN),
                                'hide' => __('Hide the message', WLPR_TEXT_DOMAIN)
                            );
                            $display_product_message_page = (isset($options['display_product_message_page']) && !empty($options['display_product_message_page']) ? $options['display_product_message_page'] : 'all'); ?>
                            <select name="display_product_message_page" class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($product_message_place as $d_key => $d_value): ?>
                                    <?php if ($d_key == $display_product_message_page): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Simple product page', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                <textarea class="wlpr-single-product-message lpr-form-control-text" type="text"
                          name="wlpr_single_product_message"><?php echo esc_textarea((isset($options['wlpr_single_product_message']) && !empty($options['wlpr_single_product_message']) ? $options['wlpr_single_product_message'] : 'Purchase this product now and earn <strong>{wlpr_points}</strong> {wlpr_points_label}!')); ?></textarea>
                            <br/>
                            <small><?php esc_html_e('This text will be displayed in Simple product pages. Shortcodes that can be used:  {wlpr_points} and {wlpr_points_label}', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Variable product page', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                <textarea class="wlpr-variable-product-message  lpr-form-control-text" type="text"
                          name="wlpr_variable_product_message"><?php echo esc_textarea((isset($options['wlpr_variable_product_message']) && !empty($options['wlpr_variable_product_message']) ? $options['wlpr_variable_product_message'] : 'Earn up to <strong>{wlpr_points}</strong> {wlpr_points_label}.')); ?></textarea>
                            <br/>
                            <small><?php esc_html_e('This text will be displayed in Variable product pages. Shortcodes that can be used:  {wlpr_points} {wlpr_points_label}', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>

                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Cart/ Checkout Page message for Earn points', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                <textarea class="wlpr-cart-earn-points-message lpr-form-control-text" type="text"
                          name="wlpr_cart_earn_points_message"><?php echo esc_textarea((isset($options['wlpr_cart_earn_points_message']) && !empty($options['wlpr_cart_earn_points_message']) ? $options['wlpr_cart_earn_points_message'] : 'Complete your order and earn <strong>{wlpr_points}</strong> {wlpr_points_label} for a discount on a future purchase')); ?></textarea>
                            <br/>
                            <small><?php esc_html_e('This text will be displayed in Cart and checkout page when points are earned. Shortcodes: {wlpr_points} {wlpr_points_label}', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Display Position Of Earn Points Cart Page Message', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php $cart_earn_point_display_list = array(
                                'before' => __('Before Cart items', WLPR_TEXT_DOMAIN),
                                'after' => __('After Cart items', WLPR_TEXT_DOMAIN),
                                'content' => __('Before Update Cart', WLPR_TEXT_DOMAIN),
                                'summary' => __('Order Review', WLPR_TEXT_DOMAIN)
                            );
                            $cart_earn_point_display = (isset($options['wlpr_cart_earn_point_display']) && !empty($options['wlpr_cart_earn_point_display']) ? $options['wlpr_cart_earn_point_display'] : 'before');
                            ?>
                            <select name="wlpr_cart_earn_point_display"
                                    class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($cart_earn_point_display_list as $d_key => $d_value): ?>
                                    <?php if ($d_key == $cart_earn_point_display): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Choose where to show the earned points message on the cart page - before or after cart items', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd wlpr-earn-point-order-summary-text" style="<?php echo (isset($cart_earn_point_display) && $cart_earn_point_display != 'summary') ? 'display:none;':'';?>">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Order Review Earn Point Text', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php
                            $earn_point_summary_text = (isset($options['wlpr_earn_point_order_summary_text']) && !empty($options['wlpr_earn_point_order_summary_text']) ? $options['wlpr_earn_point_order_summary_text'] : 'Earn Points');
                            ?>
                            <input class="lpr-form-control lpr-form-control-width"
                                   type="text" name="wlpr_earn_point_order_summary_text"
                                   value="<?php echo esc_attr($earn_point_summary_text); ?>"/>
                        </div>
                    </div>
                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Cart/ Checkout page message for Redeem points', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                <textarea class="wlpr-cart-redeem-points-message lpr-form-control-text" type="text"
                          name="wlpr_cart_redeem_points_message"><?php echo esc_attr((isset($options['wlpr_cart_redeem_points_message']) && !empty($options['wlpr_cart_redeem_points_message']) ? $options['wlpr_cart_redeem_points_message'] : 'Use <strong>{wlpr_points}</strong> {wlpr_points_label} for a <strong>{wplr_points_balance}</strong> discount on this order!')); ?></textarea>
                            <br/>
                            <small><?php esc_html_e('This text will be displayed on the Cart and Checkout page when points are available for Redemption. Shortcodes: {wlpr_points}, {wplr_points_balance} {wlpr_points_label}', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Display Position Of Redeem Points Cart Page Message', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php $cart_redeem_point_display_list = array(
                                'before' => __('Before Cart items', WLPR_TEXT_DOMAIN),
                                'after' => __('After Cart items', WLPR_TEXT_DOMAIN),
                                'content' => __('Before Update Cart', WLPR_TEXT_DOMAIN)
                            );
                            $cart_redeem_point_display = (isset($options['wlpr_cart_redeem_point_display']) && !empty($options['wlpr_cart_redeem_point_display']) ? $options['wlpr_cart_redeem_point_display'] : 'before');
                            ?>
                            <select name="wlpr_cart_redeem_point_display"
                                    class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($cart_redeem_point_display_list as $d_key => $d_value): ?>
                                    <?php if ($d_key == $cart_redeem_point_display): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Choose where to show the redeem points message on the cart page - before/after cart items', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Message on Thank you page', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                <textarea class="wlpr-thank-you-message  lpr-form-control-text" type="text"
                          name="wlpr_thank_you_message"><?php echo esc_attr((isset($options['wlpr_thank_you_message']) && !empty($options['wlpr_thank_you_message']) ? $options['wlpr_thank_you_message'] : 'You have earned <strong>{wlpr_points}</strong> {wlpr_points_label} for this order. You have a total of <strong>{wlpr_total_points}</strong> {wlpr_total_points_label}.')); ?></textarea>
                            <br/>
                            <small><?php esc_html_e('This text will be displayed on the thank you / order received page when points were earned. Shortcodes: {wlpr_points}, {wlpr_total_points}, {wlpr_points_label}, {wlpr_total_points_label}.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>

                    <div class="row row-brd">

                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Thank you message display position', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <?php $thank_you_position = array(
                                'before' => esc_html(__('Top of the thank you message', WLPR_TEXT_DOMAIN)), 'after' => esc_html(__('Before order details', WLPR_TEXT_DOMAIN)));
                            $thank_you_msg_position = (isset($options['wlpr_thank_you_position']) && !empty($options['wlpr_thank_you_position']) ? $options['wlpr_thank_you_position'] : 'before');
                            ?>
                            <select name="wlpr_thank_you_position"
                                    class="lpr-form-control lpr-form-control-width">
                                <?php foreach ($thank_you_position as $d_key => $d_value): ?>
                                    <?php if ($d_key == $thank_you_msg_position): ?>
                                        <option value="<?php echo $d_key; ?>"
                                                selected="selected"><?php echo $d_value; ?></option>
                                    <?php else: ?>
                                        <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </select>
                            <br/>
                            <small><?php esc_html_e('Choose where to show the message on thank you page.', WLPR_TEXT_DOMAIN); ?></small>
                        </div>
                    </div>
                </div>
            </div>
            <div class="lpr-points-settings-save" style="float: right;width: 70%;">
                <div class="form-row">
                    <input type="button" id="wlpr-setting-submit-button" class="lpr-button-btn btn btn-save lpr-btn-setting-save"
                           onclick="wlpr.saveSettings();"
                           value="<?php _e('Save', WLPR_TEXT_DOMAIN); ?>"/>
                </div>
            </div>
            <div class="form-row">
                <input type="hidden" name="action" value="wlpr_save_settings">
                <input type="hidden" name="wlpr_none" value="<?php echo $wlpr_setting_none;?>">
                <input type="hidden" name="option_key"
                       value="<?php echo !empty($save_key) ? $save_key : 'wlpr_settings' ?>">
            </div>
        </form>
    </div>

</div>
