<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
$rule_types = array(
    'price' => esc_html(__('Cart subtotal', WLPR_TEXT_DOMAIN))
);
$referral_types = array(
    'referrer' => esc_html(__('Advocate/Referrer', WLPR_TEXT_DOMAIN)),
    'referee' => esc_html(__('Friend', WLPR_TEXT_DOMAIN))
);
$discount_types = array(
    'fixed' => esc_html(__('Fixed', WLPR_TEXT_DOMAIN)),
    'percentage' => esc_html(__('Percentage based on order subtotal', WLPR_TEXT_DOMAIN))
);
?>
<div class="full-width lpr-setting">
    <br>
    <div class="wlpr-settings-container lprwp-referral-container">
        <div class="lpr-recent-section lpr-point-history lpr-point-history-1">
            <div class="lpr-recent-points ">
                <div class="lpr-head-brd">
                    <h3><?php esc_html_e('Manage Referrals', WLPR_TEXT_DOMAIN); ?></h3>
                    <a class="button" href="https://docs.flycart.org/en/articles/3714156-referral-program" target="_blank"><?php _e('Read docs',WLPR_TEXT_DOMAIN);?></a>
                    <form action="<?php echo isset($base_url) ? $base_url: ''; ?>" method="get" id="referral_log_form" name="referral_log"
                          class="row-search">
                        <div class="row refer-row-search">
                            <div class="lpr-search-label-text">
                                <label><?php esc_html_e('Search', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-search-label-input">
                                <input type="text" class="lpr-form-control-search" name="search"
                                       value="<?php echo esc_html(isset($search) ? $search: ''); ?>"/>
                            </div>
                            <input type="submit" value="Submit" class="lpr-btn-submit">
                            <input type="hidden" name="page" value="<?php echo WLPR_PLUGIN_SLUG; ?>"/>
                            <input type="hidden" name="view" value="referral"/>
                            <input type="hidden" name="filter_order" id="referral_log_filter_order"
                                   value="<?php echo esc_attr(isset($filter_order) ? $filter_order: ''); ?>"/>
                            <input type="hidden" name="per_page" value="<?php echo esc_attr(isset($per_page) ? $per_page: 5); ?>"/>
                            <input type="hidden" name="page_number" value="<?php echo esc_attr(isset($page_number) ? $page_number: 1); ?>"/>
                            <input type="hidden" name="filter_order_dir" id="referral_log_filter_order_dir"
                                   value="<?php echo esc_attr(isset($filter_order_dir) ? $filter_order_dir: 'DESC'); ?>"/>
                        </div>
                    </form>
                </div>
                <table>

                    <tr>
                        <th><?php esc_html_e('Date', WLPR_TEXT_DOMAIN); ?></th>
                        <th><?php esc_html_e('Advocate', WLPR_TEXT_DOMAIN); ?></th>
                        <th><?php esc_html_e('Friend', WLPR_TEXT_DOMAIN); ?></th>
                        <th><?php esc_html_e('Status', WLPR_TEXT_DOMAIN); ?></th>
                        <th><?php esc_html_e('Order value', WLPR_TEXT_DOMAIN); ?></th>
                    </tr>

                    <?php if (isset($referral_users) && !empty($referral_users)): ?>
                        <?php foreach ($referral_users as $referral_user): ?>
                            <tr>
                                <td class="lpr-table-date"><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime(\Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($referral_user->created_date))); ?></td>
                                <td><?php echo $referral_user->referred_by; ?>
                                    <br/><?php
                                    echo sprintf(esc_html__('Points earned %s',WLPR_TEXT_DOMAIN),$referral_user->referred_by_earn_point);
                                    //esc_html_e(sprintf('Points earned %s', $referral_user->referred_by_earn_point), WLPR_TEXT_DOMAIN) ?>
                                </td>
                                <td><?php echo $referral_user->new_user; ?>
                                    <br/><?php
                                    echo sprintf(esc_html__('Points earned %s',WLPR_TEXT_DOMAIN),$referral_user->new_user_earn_point);
                                    //esc_html_e(sprintf('Points earned %s', $referral_user->new_user_earn_point), WLPR_TEXT_DOMAIN) ?>
                                </td>
                                <td><?php echo $referral_user->status;?></td>
                                <td><?php echo wc_price($referral_user->referred_order_price); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else:; ?>
                        <tr>
                            <td colspan="4"><?php esc_html_e('No referrals found', WLPR_TEXT_DOMAIN) ?></td>
                        </tr>
                    <?php endif; ?>
                    <?php if (isset($pagination)): ?>
                        <tr>
                            <td colspan="4"><?php echo $pagination->createLinks(); ?></td>
                        </tr>
                    <?php endif; ?>

                </table>

            </div>
        </div>
        <div class="lprwp-referral-settings">
            <div class="lpr-points-settings-save" style="display: grid;margin-right: 6px;">
                <div class="form-row">
                    <input type="button" id="wlpr-referral-submit-button" class="btn btn-save lpr-btn-setting-save"
                           onclick="wlpr.saveReferral();"
                           value="<?php _e('Save', WLPR_TEXT_DOMAIN); ?>"/>
                </div>
            </div>
        </div>
        <ul class="lprwp-referral-tab">
            <li class="wlpr-setting-tab-link active"
                onclick="wlpr.openCustomTab(this, 'wlpr-default-referral-settings');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('Bonus points for Referrals', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>
            <li class="wlpr-setting-tab-link" onclick="wlpr.openCustomTab(this, 'wlpr-dynamic-referral-settings');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('Dynamic Bonus Points based on Rules', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>
            <li class="wlpr-setting-tab-link" onclick="wlpr.openCustomTab(this, 'wlpr-referral-message-settings');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('My Account reward message', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>
            <li class="wlpr-setting-tab-link" onclick="wlpr.openCustomTab(this, 'wlpr-share-message-settings');">
                <div class="lpr-points-settings-first">
                    <h3><?php esc_html_e('Social Share Points', WLPR_TEXT_DOMAIN); ?></h3>
                    <span class="dashicons dashicons-arrow-right-alt2 lprwp-right"></span>
                </div>
            </li>
        </ul>

        <form id="wlpr-referring-form" method="post">

            <div class="lpr-points-settings" id="wlpr-default-referral-settings">
                <div class="lpr-point-help-text">
                    <?php echo __('Award your customers a fixed amount of points for referring new customers. Also the new customer (a friend referred by your existing customer) can get these additional bonus points on their first purchase', WLPR_TEXT_DOMAIN); ?>
                    <br/>
                    <br/>
                    <strong><?php echo __('Discount Reward For Friends'); ?></strong>
                    <br/>
                    <br/>
                    <?php echo __('Offer a discount to the receiver on thier first purchase. You can run something like: You get 250 Points and your friend gets 10% off on their first purchase with the referrer code.', WLPR_TEXT_DOMAIN); ?>
                </div>
                <div class="lpr-points-second-referral-1">
                    <div class="lpr-points-settings-box">
                        <div class="row">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Advocate Reward', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <div class="referral-edit">
                                    <input name="wlpr_referring_person" type="number" min="0"
                                           oninput="validity.valid||(value='');"
                                           class="lpr-form-control"
                                           value="<?php echo (isset($options['wlpr_referring_person']) && (!empty($options['wlpr_referring_person']) || $options['wlpr_referring_person'] == 0)) ? $options['wlpr_referring_person'] : 50; ?>">
                                    <br/>
                                </div>
                                <small><?php esc_html_e('This will be the number of bonus points earned by your customer for referring their friends / new customers', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>

                    </div>
                    <div class="lpr-points-settings-box lpr-right-box">
                        <div class="row">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Friend Reward', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <div class="referral-edit">
                                    <input name="wlpr_referred_person" type="number" min="0"
                                           oninput="validity.valid||(value='');"
                                           class="lpr-form-control"
                                           value="<?php echo (isset($options['wlpr_referred_person']) && (!empty($options['wlpr_referred_person']) || $options['wlpr_referred_person'] == 0)) ? $options['wlpr_referred_person'] : 50; ?>">
                                    <br/>
                                </div>
                                <small><?php esc_html_e('Set the bonus points that will be awarded when the new customers who were referred make a purchase. This will be the bonus in addition to earning regular loyalty points', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>
                    </div>

                    <div class="lpr-points-settings-box-bg">
                        <div class="row row-brd">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Enable Referral Program ?', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $enable_referral = (isset($options['wlpr_enable_referral']) && !empty($options['wlpr_enable_referral'])) ? $options['wlpr_enable_referral'] : 'yes'; ?>
                                <select name="wlpr_enable_referral" class="lpr-form-control">
                                    <option value="no" <?php echo ($enable_referral == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                    <option value="yes" <?php echo ($enable_referral == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                                </select>
                                <br/>
                                <small><?php esc_html_e('If you want increase your order and customer, then enable referral program.', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>

                        <div class="row row-brd">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Display friend reward message in cart ', WLPR_TEXT_DOMAIN); ?></label>
                            </div>

                            <div class="lpr-label-input">
                                <?php $cart_referee_reward_message_list = array(
                                    'before' => esc_html(__('Before cart items', WLPR_TEXT_DOMAIN)), 'after' => esc_html(__('After cart items', WLPR_TEXT_DOMAIN)));
                                $cart_referee_reward_message_type = (isset($options['wlpr_cart_referral_message_display']) && !empty($options['wlpr_cart_referral_message_display']) ? $options['wlpr_cart_referral_message_display'] : 'before');
                                ?>
                                <select name="wlpr_cart_referral_message_display"
                                        class="lpr-form-control">
                                    <?php foreach ($cart_referee_reward_message_list as $d_key => $d_value): ?>
                                        <?php if ($d_key == $cart_referee_reward_message_type): ?>
                                            <option value="<?php echo $d_key; ?>"
                                                    selected="selected"><?php echo $d_value; ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </select>
                                <br/>
                                <small><?php esc_html_e('Friend reward message in cart.', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>
                        <div class="row row-brd">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Friend reward message in cart and checkout', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <textarea class="lpr-form-control-text"
                                          name="wlpr_cart_referee_reward_message"><?php echo esc_textarea((isset($options['wlpr_cart_referee_reward_message']) && !empty($options['wlpr_cart_referee_reward_message']) ? $options['wlpr_cart_referee_reward_message'] : 'Complete the order to get {wlpr_referee_point} {wlpr_points_label} via referral program.')); ?></textarea>
                                <br/>
                                <small><?php esc_html_e('Cart reward message will display, when referee user came via referral program.', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>

                        <div class="row row-brd">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Referral code prefix', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <input name="wlpr_referral_prefix" type="text" class="lpr-form-control"
                                       value="<?php esc_html_e(isset($options['wlpr_referral_prefix']) && !empty($options['wlpr_referral_prefix']) ? $options['wlpr_referral_prefix'] : 'r_'); ?>">
                                <br/>
                                <small><?php esc_html_e('Set referral code prefix', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>
                        <div class="row row-brd">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Enable discount for friend / new customer / receiver?', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <?php $discount_referral = (isset($options['wlpr_referral_discount']) && !empty($options['wlpr_referral_discount'])) ? $options['wlpr_referral_discount'] : 'no'; ?>
                                <select name="wlpr_referral_discount" class="lpr-form-control">
                                    <option value="no" <?php echo ($discount_referral == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                    <option value="yes" <?php echo ($discount_referral == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                                </select>
                                <br/>
                                <small><?php esc_html_e('Enable this to offer a discount on the first purchase for the receiver / new customer who were referred to your store by an existing customer.', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>
                        <div class="row row-brd">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Referral discount name in cart', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <input name="wlpr_cart_referal_coupon_name" type="text"
                                       class="lpr-form-control lpr-form-control-width-1"
                                       value="<?php esc_html_e(isset($options['wlpr_cart_referal_coupon_name']) && !empty($options['wlpr_cart_referal_coupon_name']) ? $options['wlpr_cart_referal_coupon_name'] : esc_html(__('Referral discount', WLPR_TEXT_DOMAIN))); ?>">
                                <br/>
                                <small><?php esc_html_e('Display referral discount name in cart and checkout page', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>

                        <div class="row row-brd">
                            <div class="lpr-label-text">
                                <label><?php esc_html_e('Discount Value', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-label-input">
                                <input name="wlpr_referral_coupon_percent" type="number" min="0"
                                       oninput="validity.valid||(value='');"
                                       class="lpr-form-control lpr-form-control-width-1"
                                       value="<?php esc_html_e(isset($options['wlpr_referral_coupon_percent']) && !empty($options['wlpr_referral_coupon_percent']) ? $options['wlpr_referral_coupon_percent'] : 0); ?>">
                                <?php $discount_refferral_coupon_type = isset($options['wlpr_referral_coupon_percent_type']) && !empty($options['wlpr_referral_coupon_percent_type']) ? $options['wlpr_referral_coupon_percent_type'] : 'fixed'; ?>
                                <select name="wlpr_referral_coupon_percent_type"
                                        class="lpr-form-control lpr-form-control-width-1">
                                    <?php foreach ($discount_types as $d_key => $d_value): ?>
                                        <?php if ($d_key == $discount_refferral_coupon_type): ?>
                                            <option value="<?php echo $d_key; ?>"
                                                    selected="selected"><?php echo $d_value; ?></option>
                                        <?php else: ?>
                                            <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </select>
                                <br/>
                                <small><?php esc_html_e('It can be either a percentage based on the order total of the receiver or a fixed amount', WLPR_TEXT_DOMAIN); ?></small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="lpr-points-settings" id="wlpr-dynamic-referral-settings" style="display: none;">
                <div class="lpr-point-help-text">
                    <?php echo __('You can also award bonus points dynamically to both the sender (your existing customer) and their friends. ', WLPR_TEXT_DOMAIN); ?>
                </div>
                <div class="lpr-points-settings-second lpr-recent-section lpr-points-second-referral">
                    <table>
                        <tbody>
                        <tr class="refer-rule-0">
                            <td><?php esc_html_e('Condition', WLPR_TEXT_DOMAIN) ?></td>
                            <td><?php esc_html_e('Point for', WLPR_TEXT_DOMAIN) ?></td>
                            <td><?php esc_html_e('Range', WLPR_TEXT_DOMAIN) ?></td>
                            <td><?php esc_html_e('Earn Points', WLPR_TEXT_DOMAIN) ?></td>
                            <td><?php esc_html_e('Remove', WLPR_TEXT_DOMAIN) ?></td>
                        </tr>
                        <?php $i = 1; ?>
                        <?php if (isset($options['wlpr_rules']) && !empty($options['wlpr_rules'])):
                            ?>
                            <?php foreach ($options['wlpr_rules'] as $key => $rule): ?>
                            <tr class="refer-rule-<?php echo $i; ?>">
                                <td>
                                    <select name="wlpr_rules[<?php echo $i; ?>][rule_type]">
                                        <?php foreach ($rule_types as $rule_key => $rule_value): ?>
                                            <?php if (isset($rule['rule_type']) && !empty($rule['rule_type']) && $rule['rule_type'] == $rule_key): ?>
                                                <option value="<?php echo $rule_key; ?>"
                                                        selected="selected"><?php echo $rule_value ?></option>
                                            <?php else: ?>
                                                <option value="<?php echo $rule_key; ?>"><?php echo $rule_value ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <select name="wlpr_rules[<?php echo $i; ?>][referral_type]">
                                        <?php foreach ($referral_types as $refer_key => $refer_value): ?>
                                            <?php if (isset($rule['referral_type']) && !empty($rule['referral_type']) && $rule['referral_type'] == $refer_key): ?>
                                                <option value="<?php echo $refer_key; ?>"
                                                        selected="selected"><?php echo $refer_value ?></option>
                                            <?php else: ?>
                                                <option value="<?php echo $refer_key; ?>"><?php echo $refer_value ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td class="lpr-col-width">
                                    <?php esc_html_e('Min', WLPR_TEXT_DOMAIN) ?>
                                    <input class="wlpr_rules-contrler" name="wlpr_rules[<?php echo $i; ?>][rule_min]"
                                           type="number" min="0"
                                           oninput="validity.valid||(value='');"
                                           value="<?php echo (isset($rule['rule_min']) && !empty($rule['rule_min'])) ? $rule['rule_min'] : 0; ?>">
                                    <?php esc_html_e('Max', WLPR_TEXT_DOMAIN) ?>
                                    <input class="wlpr_rules-contrler" name="wlpr_rules[<?php echo $i; ?>][rule_max]"
                                           type="number" min="0"
                                           oninput="validity.valid||(value='');"
                                           value="<?php echo (isset($rule['rule_max']) && !empty($rule['rule_max'])) ? $rule['rule_max'] : 0; ?>">
                                </td>
                                <td>
                                    <input class="wlpr_rules-contrler" name="wlpr_rules[<?php echo $i; ?>][earn_point]"
                                           type="number" min="0"
                                           oninput="validity.valid||(value='');"
                                           value="<?php echo (isset($rule['earn_point']) && !empty($rule['earn_point'])) ? $rule['earn_point'] : 0; ?>">
                                    <?php $earn_point_type = esc_attr((isset($rule['earn_point_type']) && !empty($rule['earn_point_type']) ? $rule['earn_point_type'] : 'fixed')); ?>
                                    <select class="wlpr_rules-contrler-select"
                                            name="wlpr_rules[<?php echo $i; ?>][earn_point_type]">
                                        <?php foreach ($discount_types as $d_key => $d_value): ?>
                                            <?php if ($d_key == $earn_point_type): ?>
                                                <option value="<?php echo $d_key; ?>"
                                                        selected="selected"><?php echo $d_value; ?></option>
                                            <?php else: ?>
                                                <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                                <td>
                                    <a onclick="jQuery('.refer-rule-<?php echo $i; ?>').remove()"><span
                                                class="dashicons dashicons-trash rule-remove"></span></a>
                                </td>
                            </tr>
                            <?php $i = $i + 1; ?>
                        <?php endforeach; ?>
                        <?php else: ?>
                            <tr id="footer-referral-rule">
                                <td colspan="4"><?php esc_html_e('No referral rule found', WLPR_TEXT_DOMAIN) ?></td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="10">
                                <div id="next_key" style="display: none;"><?php echo $i; ?></div>
                                <a class="btn btn-primary lpr-add-rule"
                                   onclick="wlpr.addReferralRule()"><span
                                            class="dashicons dashicons-plus"></span> <?php esc_html_e('Add Rule', WLPR_TEXT_DOMAIN) ?>
                                </a>
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            <div class="lpr-points-settings" id="wlpr-referral-message-settings" style="display: none;">
                <div class="lpr-point-help-text">
                    <?php echo __('Reward message for My Account page', WLPR_TEXT_DOMAIN); ?>
                </div>
                <div class="lpr-points-settings-second lpr-points-second-referral">
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Before referral system active message', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <textarea class="lpr-form-control-text"
                                  name="wlpr_before_referral_message"><?php echo esc_textarea((isset($options['wlpr_before_referral_message']) && !empty($options['wlpr_before_referral_message']) ? $options['wlpr_before_referral_message'] : 'Great news, You can earn point via placing order and referring your friends. <br><strong>Note:</strong> You can refer your friends after your first order.')); ?></textarea>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('My Account referrer message', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <textarea class="lpr-form-control-text"
                                  name="wlpr_referrer_message"><?php echo esc_textarea((isset($options['wlpr_referrer_message']) && !empty($options['wlpr_referrer_message']) ? $options['wlpr_referrer_message'] : 'Refer your friend and earn rewards {wlpr_referrer_point} points')); ?></textarea>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('My Account referee message', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <textarea class="lpr-form-control-text"
                                  name="wlpr_referee_message"><?php echo esc_textarea((isset($options['wlpr_referee_message']) && !empty($options['wlpr_referee_message']) ? $options['wlpr_referee_message'] : 'Your friend will earn {wlpr_referee_point} points')); ?></textarea>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('My Account referee discount message', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <textarea class="lpr-form-control-text"
                                  name="wlpr_referee_discount_message"><?php echo esc_textarea((isset($options['wlpr_referee_discount_message']) && !empty($options['wlpr_referee_discount_message']) ? $options['wlpr_referee_discount_message'] : 'Send your friends a {wlpr_referee_discount} discount.')); ?></textarea>
                    </div>
                </div>
            </div>

            <div class="lpr-points-settings" id="wlpr-share-message-settings" style="display: none;">

                <div class="lpr-points-settings-second lpr-points-second-referral">

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable Facebook Share Point?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <?php $enable_facebook_share_point = (isset($options['wlpr_enable_facebook_share_point']) && !empty($options['wlpr_enable_facebook_share_point'])) ? $options['wlpr_enable_facebook_share_point'] : 'yes'; ?>
                            <select name="wlpr_enable_facebook_share_point" class="lpr-form-control">
                                <option value="no" <?php echo ($enable_facebook_share_point == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($enable_facebook_share_point == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Facebook Share Point', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="lpr-form-control-text" name="wlpr_facebook_share_point" min="0"
                                   type="number" oninput="validity.valid||(value='');"
                                   value="<?php echo (isset($options['wlpr_facebook_share_point']) && !empty($options['wlpr_facebook_share_point'])) ? $options['wlpr_facebook_share_point'] : 0; ?>">
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable Twitter Share Point?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <?php $enable_twitter_share_point = (isset($options['wlpr_enable_twitter_share_point']) && !empty($options['wlpr_enable_twitter_share_point'])) ? $options['wlpr_enable_twitter_share_point'] : 'yes'; ?>
                            <select name="wlpr_enable_twitter_share_point" class="lpr-form-control">
                                <option value="no" <?php echo ($enable_twitter_share_point == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($enable_twitter_share_point == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Twitter Share Point', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="lpr-form-control-text" name="wlpr_twitter_share_point" min="0"
                                   type="number" oninput="validity.valid||(value='');"
                                   value="<?php echo (isset($options['wlpr_twitter_share_point']) && !empty($options['wlpr_twitter_share_point'])) ? $options['wlpr_twitter_share_point'] : 0; ?>">
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable Email Share Point?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <?php $enable_email_share_point = (isset($options['wlpr_enable_email_share_point']) && !empty($options['wlpr_enable_email_share_point'])) ? $options['wlpr_enable_email_share_point'] : 'yes'; ?>
                            <select name="wlpr_enable_email_share_point" class="lpr-form-control">
                                <option value="no" <?php echo ($enable_email_share_point == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($enable_email_share_point == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Email Share Point', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="lpr-form-control-text" name="wlpr_email_share_point" min="0"
                                   type="number" oninput="validity.valid||(value='');"
                                   value="<?php echo (isset($options['wlpr_email_share_point']) && !empty($options['wlpr_email_share_point'])) ? $options['wlpr_email_share_point'] : 0; ?>">
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Mail Share Subject', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <input class="lpr-form-control-text" name="wlpr_share_subject" type="text"
                                   value="<?php echo (isset($options['wlpr_share_subject']) && !empty($options['wlpr_share_subject'])) ? $options['wlpr_share_subject'] : '{wlpr_referee_point} {wlpr_points_label} off your first purchase.'; ?>"/>
                        </div>
                    </div>
                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Share Content', WLPR_TEXT_DOMAIN); ?></label>
                        </div>

                        <div class="lpr-label-input">
                            <textarea class="lpr-form-control-text"
                                      name="wlpr_share_content"><?php echo (isset($options['wlpr_share_content']) && !empty($options['wlpr_share_content'])) ? $options['wlpr_share_content'] : '{wlpr_referee_point} {wlpr_points_label} off your first purchase.'; ?></textarea>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('Enable WhatsApp Share Point?', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <?php $enable_whatsapp_share_point = (isset($options['wlpr_enable_whatsapp_share_point']) && !empty($options['wlpr_enable_whatsapp_share_point'])) ? $options['wlpr_enable_whatsapp_share_point'] : 'yes'; ?>
                            <select name="wlpr_enable_whatsapp_share_point" class="lpr-form-control">
                                <option value="no" <?php echo ($enable_whatsapp_share_point == 'no') ? 'selected="selected"' : ''; ?>><?php esc_html_e('No', WLPR_TEXT_DOMAIN); ?></option>
                                <option value="yes" <?php echo ($enable_whatsapp_share_point == 'yes') ? 'selected="selected"' : ''; ?>><?php esc_html_e('Yes', WLPR_TEXT_DOMAIN); ?></option>
                            </select>
                        </div>
                    </div>

                    <div class="row row-brd">
                        <div class="lpr-label-text">
                            <label><?php esc_html_e('WhatsApp Share Point', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-label-input">
                            <input class="lpr-form-control-text" name="wlpr_whatsapp_share_point" min="0"
                                   type="number" oninput="validity.valid||(value='');"
                                   value="<?php echo (isset($options['wlpr_whatsapp_share_point']) && !empty($options['wlpr_whatsapp_share_point'])) ? $options['wlpr_whatsapp_share_point'] : 0; ?>">
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-row">
                <input type="hidden" name="action" value="wlpr_save_referral">
                <input type="hidden" name="wlpr_none" value="<?php echo $wlpr_referral_none;?>">
                <input type="hidden" name="option_key"
                       value="wlpr_referral">
            </div>

        </form>
        <div class="lpr-points-settings">
            <div class="lpr-points-settings-save" style="display: grid;margin-right: 6px;float: right;">
                <div class="form-row">
                    <input type="button" id="wlpr-referral-submit-button" class="btn btn-save lpr-btn-setting-save"
                           onclick="wlpr.saveReferral();"
                           value="<?php _e('Save', WLPR_TEXT_DOMAIN); ?>"/>
                </div>
            </div>
        </div>
    </div>
</div>