<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
?>
<div class="lpr-recent-section">
    <div class="side-elements lpr-recent-points">
        <h3><?php esc_html_e('Recent Activity', WLPR_TEXT_DOMAIN); ?></h3>
        <a class="button lpr-btn-view"
           href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'point_logs'))) ?>"><?php esc_html_e('View All Activities', WLPR_TEXT_DOMAIN); ?></a>
    </div>
    <br>
    <table>
        <tr>
            <th><?php esc_html_e('Date', WLPR_TEXT_DOMAIN); ?></th>
            <th><?php esc_html_e('Event', WLPR_TEXT_DOMAIN); ?></th>
            <th><?php esc_html_e('Email', WLPR_TEXT_DOMAIN); ?></th>
            <th><?php esc_html_e('Points', WLPR_TEXT_DOMAIN); ?></th>
        </tr>
        <?php if (isset($items) && !empty($items) && isset($point_helper)): ?>
            <?php foreach ($items as $item): ?>
                <tr>
                    <td class="lpr-table-date"><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime(\Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($item->created_date))); ?></td>
                    <td><?php echo $point_helper->eventTypeDescription($item->type); ?></td>
                    <td>
                        <a href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'customer_history', 'user_email' => $item->user_email))) ?>"><?php echo $item->user_email; ?></a>
                    </td>
                    <td class="lpr-points-green"><?php echo $item->points; ?></td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="4"><?php esc_html_e('Launch your loyalty program to see your customer activities here', WLPR_TEXT_DOMAIN); ?></td>
            </tr>
        <?php endif; ?>
    </table>
</div>