<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
$discount_types = array(
    'fixed' => esc_html(__('Fixed', WLPR_TEXT_DOMAIN)),
    'percentage' => esc_html(__('Percentage', WLPR_TEXT_DOMAIN))
);
$discount_enabled_attr = array(
    'no' => __('No',WLPR_TEXT_DOMAIN),
    'yes' => __('Yes',WLPR_TEXT_DOMAIN),
);
$earn_point_actions_attr = array(
    'global' => __('Inherit from global settings',WLPR_TEXT_DOMAIN),
    'product' => __('Override points at product level',WLPR_TEXT_DOMAIN),
    'disable' => __('Disable',WLPR_TEXT_DOMAIN)
);
?>
<h3 style="color: rgb(33, 43, 54);padding: 5px 0px 6px !important;font-size: 20px !important;display: block;margin-left: 14px;"
    class="show_if_simple show_if_booking show_if_accommodation-booking"><?php esc_html_e('Loyalty point settings', WLPR_TEXT_DOMAIN) ?></h3>
<p class="form-field show_if_simple show_if_booking show_if_accommodation-booking">
    <label style="display: block;margin-right: 13px;font-size: 14px; margin-bottom: 10px; font-weight: 500; color: #0F0F1A;"><?php esc_html_e('Enable product earn points ?', WLPR_TEXT_DOMAIN); ?></label>
    <?php
    $wlpr_product_enable_earn_point = ((isset($wlpr_product_enable_earn_point) && !empty($wlpr_product_enable_earn_point)) ? $wlpr_product_enable_earn_point : 'global'); ?>
    <select id="wlpr-earn-point-action-settings" style="max-width: 30%;border: 1px solid #ced4da;font-size: 15px;color: #475867;padding: 0 24px 0 8px;margin-right: 13px;float: none;"
            onchange="showEarnPointDiv();"
            name="_wlpr_product_enable_earn_point">
        <?php foreach ($earn_point_actions_attr as $d_key => $d_value): ?>
            <?php if ($d_key == $wlpr_product_enable_earn_point): ?>
                <option value="<?php echo $d_key; ?>"
                        selected="selected"><?php echo $d_value; ?></option>
            <?php else: ?>
                <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
            <?php endif; ?>
        <?php endforeach; ?>
    </select>
</p>

    <p class="form-row form-row-last wlpr-earn-point-disable-msg" style="<?php echo ($wlpr_product_enable_earn_point == 'disable') ? "": "display:none;";?>">
        <?php echo __('Earn points will be disabled for this product',WLPR_TEXT_DOMAIN);?>
    </p>

<p class="form-field show_if_simple show_if_booking show_if_accommodation-booking wlpr-earn-point-settings" style="<?php echo ($wlpr_product_enable_earn_point== 'product') ? "":"display:none;";?>">
    <label style="display: block;margin-right: 13px;font-size: 14px; margin-bottom: 10px; font-weight: 500; color: #0F0F1A;"><?php esc_html_e('How many points customer can earn when they purchase?(per product quantity)', WLPR_TEXT_DOMAIN); ?></label>
    <input class="wlpr-earn-point"
           style="max-width: 20%;border: 1px solid #ced4da;font-size: 15px;color: #475867;padding: 5px 10px;margin-right: 13px;float: none;"
           type="number" min="0"
           name="_wlpr_product_points_earned[wlpr_earn_point]"
           value="<?php echo esc_attr((isset($earn_point_setting['wlpr_earn_point']) && !empty($earn_point_setting['wlpr_earn_point']) ? $earn_point_setting['wlpr_earn_point'] : 0)); ?>"/><?php esc_html_e(' points can be earned for spending', WLPR_TEXT_DOMAIN); ?>
    &nbsp;&#61;&nbsp;<?php echo get_woocommerce_currency_symbol(); ?>

    <input class="wlpr-point-earn-price"
           style="max-width: 20%;border: 1px solid #ced4da;font-size: 15px;color: #475867;padding: 5px 10px;margin-right: 13px;float: none;"
           type="number" min="0"
           name="_wlpr_product_points_earned[wlpr_point_earn_price]"
           value="<?php echo esc_attr((isset($earn_point_setting['wlpr_point_earn_price']) && !empty($earn_point_setting['wlpr_point_earn_price']) ? $earn_point_setting['wlpr_point_earn_price'] : 0)); ?>"/>
    <br/>
    <small><?php esc_html_e('Set the number of points awarded based on the product price.', WLPR_TEXT_DOMAIN); ?></small>

</p>
<p class="form-field show_if_simple show_if_booking show_if_accommodation-booking">
    <label style="display: block;margin-right: 13px;font-size: 14px; margin-bottom: 10px; font-weight: 500; color: #0F0F1A;"><?php esc_html_e('Enable maximum product discount(per product quantity) ?', WLPR_TEXT_DOMAIN); ?></label>
    <?php
    $max_product_discount_enabled = ((isset($max_product_discount_enabled) && !empty($max_product_discount_enabled)) ? $max_product_discount_enabled : 'no'); ?>
    <select style="max-width: 20%;border: 1px solid #ced4da;font-size: 15px;color: #475867;padding: 0 24px 0 8px;margin-right: 13px;float: none;"
            name="_wlpr_product_max_discount_enabled">
        <?php foreach ($discount_enabled_attr as $d_key => $d_value): ?>
            <?php if ($d_key == $max_product_discount_enabled): ?>
                <option value="<?php echo $d_key; ?>"
                        selected="selected"><?php echo $d_value; ?></option>
            <?php else: ?>
                <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
            <?php endif; ?>
        <?php endforeach; ?>
    </select>
</p>
<p class="form-field show_if_simple show_if_booking show_if_accommodation-booking">
    <label style="display: block;margin-right: 13px;font-size: 14px; margin-bottom: 10px; font-weight: 500; color: #0F0F1A;"><?php esc_html_e('Maximum product points discount(per product quantity)', WLPR_TEXT_DOMAIN); ?></label>
    <input class="wlpr-product-maximum-discount"
           style="max-width: 20%;border: 1px solid #ced4da;font-size: 15px;color: #475867;padding: 5px 10px;margin-right: 13px;float: none;"
           type="number" min="0"
           name="_wlpr_product_points_max_discount"
           value="<?php echo esc_attr((isset($max_product_discount) && !empty($max_product_discount) ? $max_product_discount : 0)); ?>"/>
    <?php $max_product_discount_type = esc_attr((isset($max_product_discount_type) && !empty($max_product_discount_type) ? $max_product_discount_type : 'fixed')); ?>
    <select style="max-width: 20%;border: 1px solid #ced4da;font-size: 15px;color: #475867;padding: 5px 10px;margin-right: 13px;float: none;"
            name="_wlpr_product_points_max_discount_type">
        <?php foreach ($discount_types as $d_key => $d_value): ?>
            <?php if ($d_key == $max_product_discount_type): ?>
                <option value="<?php echo $d_key; ?>"
                        selected="selected"><?php echo $d_value; ?></option>
            <?php else: ?>
                <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
            <?php endif; ?>
        <?php endforeach; ?>
    </select>
    <br/>
    <small><?php esc_html_e('Set the maximum product discount allowed when redeeming points per-product. Use either a fixed monetary amount or a percentage based on the product price. Leave blank to disable.', WLPR_TEXT_DOMAIN); ?></small>
</p>
<?php if (isset($product_type) && !empty($product_type) && in_array($product_type,array("subscription","variable-subscription"))): ?>
    <p class="form-field show_if_simple show_if_booking show_if_accommodation-booking">
        <label style="display: block;margin-right: 13px;font-size: 14px; margin-bottom: 10px; font-weight: 500; color: #0F0F1A;"><?php esc_html_e('How many renewal points customer can earn when they purchase? (For subscription product)', WLPR_TEXT_DOMAIN); ?></label>
        <input class="wlpr-renewal-earn-point"
               style="max-width: 20%;border: 1px solid #ced4da;font-size: 15px;color: #475867;padding: 5px 10px;margin-right: 13px;float: none;"
               type="number" min="0"
               name="_wlpr_renewal_product_points_earned[wlpr_earn_point]"
               value="<?php echo esc_attr((isset($renewal_setting['wlpr_earn_point']) && !empty($renewal_setting['wlpr_earn_point']) ? $renewal_setting['wlpr_earn_point'] : 0)); ?>"/><?php esc_html_e('points can be earned for spending', WLPR_TEXT_DOMAIN); ?>
        &nbsp;&#61;&nbsp;<?php echo get_woocommerce_currency_symbol(); ?>

        <input class="wlpr-renewal-point-earn-price"
               style="max-width: 20%;border: 1px solid #ced4da;font-size: 15px;color: #475867;padding: 5px 10px;margin-right: 13px;float: none;"
               type="number" min="0"
               name="_wlpr_renewal_product_points_earned[wlpr_point_earn_price]"
               value="<?php echo esc_attr((isset($renewal_setting['wlpr_point_earn_price']) && !empty($renewal_setting['wlpr_point_earn_price']) ? $renewal_setting['wlpr_point_earn_price'] : 0)); ?>"/>
        <br/>
        <small><?php esc_html_e('Set the number of points awarded based on the renewal product price', WLPR_TEXT_DOMAIN); ?></small>
    </p>
<?php endif; ?>
<script type="application/javascript">
    function showEarnPointDiv(){
        var current_value = jQuery('#wlpr-earn-point-action-settings').val();
        if(current_value == 'global'){
            jQuery('.wlpr-earn-point-settings').hide();
            jQuery('.wlpr-earn-point-disable-msg').hide();
        }
        if(current_value == 'disable'){
            jQuery('.wlpr-earn-point-disable-msg').show();
            jQuery('.wlpr-earn-point-settings').hide();
        }
        if(current_value == 'product'){
            jQuery('.wlpr-earn-point-disable-msg').hide();
            jQuery('.wlpr-earn-point-settings').show();
        }
    }
</script>