<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
?>
<div id="wlpr-main">
    <section class="full-width">
        <div class="lpr-recent-section lpr-point-history mts-10">
            <div class="side-elements lpr-recent-points lpr-head-brd">
                <h3><?php esc_html_e('All Activities', WLPR_TEXT_DOMAIN); ?></h3>
                <a class="button lpr-btn-view-1"
                   href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'dashboard'))) ?>"><?php esc_html_e('Back', WLPR_TEXT_DOMAIN); ?></a>


                <form action="<?php echo $base_url; ?>" method="post" id="manage_user_activity_form" class="row-search"
                      name="manage_user_activity">
                    <div class="row row-brd">
                        <div class="lpr-search-label-text">
                            <label><?php esc_html_e('Search', WLPR_TEXT_DOMAIN); ?></label>
                        </div>
                        <div class="lpr-search-label-input">
                            <input type="text" class="lpr-form-control-search" name="search"
                                   value="<?php echo esc_html($search); ?>"/>
                        </div>
                        <input type="submit" value="Submit" class="lpr-btn-submit">
                        <input type="hidden" name="per_page" value="<?php echo esc_attr($per_page); ?>"/>
                        <input type="hidden" name="page_number" value="<?php echo esc_attr($page_number); ?>"/>
                        <input type="hidden" name="page" value="<?php echo WLPR_PLUGIN_SLUG; ?>"/>
                        <input type="hidden" name="view" value="point_logs"/>
                        <input type="hidden" name="filter_order" id="user_activity_filter_order"
                               value="<?php echo esc_attr($filter_order); ?>"/>
                        <input type="hidden" name="filter_order_dir" id="user_activity_filter_order_dir"
                               value="<?php echo esc_attr($filter_order_dir); ?>"/>
                    </div>
                </form>
            </div>
            <table>
                <tr>
                    <th>
                        <a onclick="wlpr.filterAction('user_activity_filter_order','user_email','user_activity_filter_order_dir','manage_user_activity_form');">
                            <?php esc_html_e('Email', WLPR_TEXT_DOMAIN); ?>
                            <?php if (isset($filter_order) && $filter_order == 'user_email'): ?>
                                <i class="<?php echo (isset($filter_order_dir) && $filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th>
                        <a onclick="wlpr.filterAction('user_activity_filter_order','points','user_activity_filter_order_dir','manage_user_activity_form');">
                            <?php esc_html_e('Points', WLPR_TEXT_DOMAIN); ?>
                            <?php if (isset($filter_order) && $filter_order == 'points'): ?>
                                <i class="<?php echo (isset($filter_order_dir) && $filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                    <th><?php esc_html_e('Event', WLPR_TEXT_DOMAIN); ?></th>
                    <th>
                        <a onclick="wlpr.filterAction('user_activity_filter_order','created_date','user_activity_filter_order_dir','manage_user_activity_form');">
                            <?php esc_html_e('Date', WLPR_TEXT_DOMAIN); ?>
                            <?php if (isset($filter_order) && $filter_order == 'created_date'): ?>
                                <i class="<?php echo (isset($filter_order_dir) && $filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                            <?php endif; ?>
                        </a>
                    </th>
                </tr>
                <?php if (isset($items) && !empty($items) && isset($point_helper)): ?>
                    <?php foreach ($items as $item): ?>
                        <tr>
                            <td>
                                <a href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'customer_history', 'user_email' => $item->user_email))) ?>"><?php echo $item->user_email; ?></a>
                            </td>
                            <td class="lpr-points-green"><?php echo $item->points; ?></td>
                            <td><?php echo $point_helper->eventTypeDescription($item->type); ?></td>
                            <td class="lpr-table-date"><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime(\Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($item->created_date))); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4"><?php esc_html_e('Launch your loyalty program to see your customer activities here', WLPR_TEXT_DOMAIN); ?></td>
                    </tr>
                <?php endif; ?>
                <?php if (isset($pagination)): ?>
                    <tr>
                        <td colspan="4"><?php echo $pagination->createLinks(); ?></td>
                    </tr>
                <?php endif; ?>
            </table>
        </div>
    </section>
</div>
