<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

use Wlpr\App\Helpers\Loyalty;

?>
<?php if (isset($analsis_data) && !empty($analsis_data)): ?>
    <form id="point-analysis"
          action="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'dashboard'))) ?>"
          method="post">
        <div class="twelve filter lpr-filter">
            <select name="filter_date" id="filter_date" class="lpr-filter-date"
                    onchange="wlpr.analysis_filter('point-analysis')">
                <?php foreach ($date_filter as $key => $value): ?>
                    <?php if ($key == $filter_date): ?>
                        <option value="<?php echo $key; ?>" selected="selected"><?php echo $value; ?></option>
                    <?php else: ?>
                        <option value="<?php echo $key; ?>"><?php echo $value; ?></option>
                    <?php endif; ?>
                <?php endforeach; ?>
            </select>
            <div id="filter_custom_date" class="lpr-main-custom"
                 style="<?php echo ($filter_date != 'custom') ? 'display: none;' : ''; ?>">
                <label>   <?php esc_html_e('From Date', WLPR_TEXT_DOMAIN); ?> </label>
                <input class="flatpickr flatpickr-input active lpr-custom_date" id="from_date_point" type="text"
                       name="from_date"
                       placeholder="<?php esc_html_e('Select Date..', WLPR_TEXT_DOMAIN); ?>" readonly="readonly">
                <label> <?php esc_html_e('To Date', WLPR_TEXT_DOMAIN); ?> </label>
                <input class="flatpickr flatpickr-input active lpr-custom_date" id="to_date_point" type="text"
                       name="to_date"
                       placeholder="<?php esc_html_e('Select Date..', WLPR_TEXT_DOMAIN); ?>" readonly="readonly">
                <a class="button lpr-btn-go"
                   onclick="wlpr_jquery('#point-analysis').submit();"><?php esc_html_e('Go', WLPR_TEXT_DOMAIN); ?></a>
                <script>
                    (function ($) {
                        flatpickr(wlpr_jquery("#wlpr-main #from_date_point"), {
                            enableTime: true,
                            dateFormat: "Y-m-d H:i",
                            defaultDate: ["<?php echo ($filter_date == 'custom') ? $woocommerce_helper->convert_utc_to_wp_time($start) : '';?>"]
                        });
                        flatpickr(wlpr_jquery("#wlpr-main #to_date_point"), {
                            enableTime: true,
                            dateFormat: "Y-m-d H:i",
                            defaultDate: ["<?php echo ($filter_date == 'custom') ? $woocommerce_helper->convert_utc_to_wp_time($end) : '';?>"]
                        });
                    })(wlpr_jquery);
                </script>
            </div>
            <p id="date_compare_text"><?php //esc_html_e('Compared to ', WLPR_TEXT_DOMAIN); ?>
                <?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($woocommerce_helper->convert_utc_to_wp_time($start))); ?>
                -
                <?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime($woocommerce_helper->convert_utc_to_wp_time($end))); ?></p>
        </div>
    </form>
    <br/>
    <div class="twelve side-elements  lpr-card-section">
        <div class="lpr-row">
            <div class="card lpr_card">
                <label><?php esc_html_e('Total points awarded', WLPR_TEXT_DOMAIN); ?></label>
                <div class="d-flex justify-content-between">
                    <?php
                    $analsis_earn_point = ((isset($analsis_data->total_positive_earn_point_rewards) && $analsis_data->total_positive_earn_point_rewards) ? $analsis_data->total_positive_earn_point_rewards : 0);
                    $analsis_earn_point += ((isset($analsis_data->total_negative_earn_point_rewards)) ? (float)$analsis_data->total_negative_earn_point_rewards : 0);
                    if($analsis_earn_point < 0){
                        $analsis_earn_point = 0;
                    }
                    ?>
                    <h3><?php echo $analsis_earn_point; ?></h3>
                    <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                        <span class="dashicons dashicons-awards"></span>
                    </div>
                </div>
            </div>

            <div class="card lpr_card">
                <label><?php esc_html_e('Total Points Redeemed', WLPR_TEXT_DOMAIN); ?></label>
                <div class="d-flex justify-content-between">
                    <?php
                    $analsis_redeem_point = (isset($analsis_data->total_point_redeemed)) ? $analsis_data->total_point_redeemed : 0;
                    $analsis_redeem_point += (isset($analsis_data->total_cancel_point_redeemed) && $analsis_data->total_cancel_point_redeemed) ? $analsis_data->total_cancel_point_redeemed : 0;
                    if($analsis_redeem_point < 0){
                        $analsis_redeem_point = -$analsis_redeem_point;
                    }else{
                        $analsis_redeem_point = 0;
                    }
                    ?>
                    <h3><?php echo $analsis_redeem_point; ?></h3>
                    <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                        <span class="dashicons dashicons-awards"></span>
                    </div>
                </div>
            </div>
            <div class="card lpr_card">
                <label><?php esc_html_e('Total Value of Redeemed Points ', WLPR_TEXT_DOMAIN); ?></label>
                <div class="d-flex justify-content-between">
                    <h3><?php echo wc_price($analsis_data->total_redeem_price-$analsis_data->total_cancel_redeem_price); ?></h3>
                    <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                        <span class="dashicons dashicons-awards"></span>
                    </div>
                </div>
            </div>
            <div class="card lpr_card">
                <label><?php esc_html_e('Customers', WLPR_TEXT_DOMAIN); ?></label>
                <div class="d-flex justify-content-between">
                    <h3><?php echo (isset($analsis_data->total_customer) && $analsis_data->total_customer) ? $analsis_data->total_customer : 0; ?></h3>
                    <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                        <span class="dashicons dashicons-awards"></span>
                    </div>
                </div>
            </div>
            <div class="card lpr_card">
                <label><?php esc_html_e('Referral Revenue', WLPR_TEXT_DOMAIN); ?></label>
                <div class="d-flex justify-content-between">
                    <h3><?php echo wc_price(((isset($referral_data->total_ref_price) && $referral_data->total_ref_price) ?  $referral_data->total_ref_price : 0));?></h3>
                    <div class="badge-circle badge-circle-lg badge-circle-light-danger mx-auto mb-50">
                        <span class="dashicons dashicons-awards"></span>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <?php if (!empty($point_chart_data)): ?>
        <?php
        function date_compare($a, $b)
        {
            $t1 = strtotime($a[0]);
            $t2 = strtotime($b[0]);
            return $t1 - $t2;
        }

        usort($point_chart_data, 'date_compare');
        ?>
        <div id="wlpr-chart-container">
            <h3><?php esc_html_e('Points awarded and redeemed', WLPR_TEXT_DOMAIN); ?></h3>
            <div id="wlpr-analysis-chart"></div>
        </div>
        <script>
            (function () {
                google.charts.load('current', {packages: ['corechart', 'line']});
                google.charts.setOnLoadCallback(handle_load_data);
            })(wlpr_jquery);

            function handle_load_data() {
                var data = google.visualization.arrayToDataTable(<?php echo json_encode($point_chart_data);?>);
                var options = {
                    title: '',
                    //curveType: 'function',
                    //legend: {position: 'bottom'},
                    hAxis: {
                        title: '<?php echo $point_x;?>'
                    },
                    vAxis: {
                        title: '<?php echo $point_y;?>'
                    },
                    fontSize: 15
                };

                var chart = new google.visualization.LineChart(document.getElementById('wlpr-analysis-chart'));

                chart.draw(data, options);

            }
        </script>
    <?php endif; ?>
<?php endif; ?>