<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
?>
<div id="wlpr-main">
    <section class="full-width">
        <div class="column twelve">
            <div class="sec-title centered">
                <h1><?php esc_html_e('Loyalty Points and Rewards', WLPR_TEXT_DOMAIN); ?> <i style="font-size: medium;">v<?php echo WLPR_PLUGIN_VERSION;?></i></h1>

            </div>
            <nav class="nav-tab-wrapper lpr-main-nav-tab">
                <a class="nav-tab <?php echo ($current_view == "dashboard") ? 'nav-tab-active' : ''; ?>"
                   href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'dashboard'))) ?>"><?php _e('Dashboard', WLPR_TEXT_DOMAIN) ?>
                </a>
                <a class="nav-tab <?php echo ($current_view == "customer") ? 'nav-tab-active' : ''; ?>"
                   href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'customer'))) ?>"><?php _e('Manage Points', WLPR_TEXT_DOMAIN) ?>
                </a>
                <a class="nav-tab <?php echo ($current_view == "referral") ? 'nav-tab-active' : ''; ?>"
                   href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'referral'))) ?>"><?php _e('Referrals', WLPR_TEXT_DOMAIN) ?>
                </a>
                <a class="nav-tab <?php echo ($current_view == "settings") ? 'nav-tab-active' : ''; ?>"
                   href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'settings'))) ?>"><?php _e('Settings', WLPR_TEXT_DOMAIN) ?>
                </a>
                <a class="nav-tab" href="https://docs.flycart.org/en/articles/3706632-points" target="_blank"><?php _e('Read docs',WLPR_TEXT_DOMAIN);?></a>
            </nav>
            <div class="full-content twelve">
                <?php echo apply_filters('wlpr_extra_content', (isset($extra) ? $extra : NULL)); ?>
                <?php if(isset($migrate_content) && !empty($migrate_content)):?>
                <div class="wlpr-migrate-display-content">
                    <?php
                echo $migrate_content;
                ?>
                </div>
                <?php endif;?>
                <?php echo isset($tab_content) ? $tab_content : NULL ?>
            </div>
        </div>
    </section>
</div>
