<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

use Wlpr\App\Helpers\Woocommerce;

?>
<div class="lpr-recent-section lpr-point-history lpr-point-history-1">
    <div class="lpr-recent-points ">
        <div class="lpr-head-brd">
            <h3 class="mr-10"><?php esc_html_e('Manage Points', WLPR_TEXT_DOMAIN); ?></h3>
            <?php if (Woocommerce::hasAdminPrivilege()):?>
            <button class="lpr-button-btn" onclick="wlpr.showpopup('wlpr_import_popup')"><?php echo __('Import',WLPR_TEXT_DOMAIN);?></button>
            <?php endif;?>
            <?php if (Woocommerce::hasAdminPrivilege()):?>
                <button class="lpr-button-btn" onclick="wlpr.showpopup('wlpr_export_popup')"><?php echo __('Export',WLPR_TEXT_DOMAIN);?></button>
            <?php endif;?>
            <?php if (Woocommerce::hasAdminPrivilege() && isset($files) && !empty($files)):?>
                <button class="lpr-button-btn" onclick="wlpr.showpopup('wlpr_export_file')"><?php echo __('Export File',WLPR_TEXT_DOMAIN);?></button>
            <?php endif;?>
            <?php if (Woocommerce::hasAdminPrivilege()):?>
                <button class="lpr-button-btn" onclick="wlpr.showNewCustomer('<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'new_customer'))); ?>')"><?php echo __('Add New Customer',WLPR_TEXT_DOMAIN);?></button>
            <?php endif;?>
            <?php if (Woocommerce::hasAdminPrivilege()):?>
                <a class="lpr-delete"
                   onclick="wlpr.bulk_delete_user();"><span class="rule-remove"><?php _e('Bulk delete',WLPR_TEXT_DOMAIN)?></span></a>
            <?php endif;?>
            <?php if (Woocommerce::hasAdminPrivilege()):?>
                <a class="button" href="https://docs.flycart.org/en/articles/4341866-how-to-import-customer-points" target="_blank"><?php _e('Read docs',WLPR_TEXT_DOMAIN);?></a>
            <?php endif;?>
            <form action="<?php echo $base_url; ?>" method="get" id="manage_user_point_form" name="manage_user_point"
                  class="row-search">
                <div class="row row-brd">
                    <div class="lpr-search-label-text">
                        <label><?php esc_html_e('Search', WLPR_TEXT_DOMAIN); ?></label>
                    </div>
                    <div class="lpr-search-label-input">
                        <input type="text" class="lpr-form-control-search" name="search"
                               value="<?php echo esc_html($search); ?>"/>
                    </div>
                    <input type="submit" value="Submit" class="lpr-btn-submit">
                    <input type="hidden" name="per_page" value="<?php echo esc_attr($per_page); ?>"/>
                    <input type="hidden" name="page_number" value="<?php echo esc_attr($page_number); ?>"/>
                    <input type="hidden" name="page" value="<?php echo WLPR_PLUGIN_SLUG; ?>"/>
                    <input type="hidden" name="view" value="customer"/>
                    <input type="hidden" name="filter_order" id="user_point_filter_order"
                           value="<?php echo esc_attr($filter_order); ?>"/>
                    <input type="hidden" name="filter_order_dir" id="user_point_filter_order_dir"
                           value="<?php echo esc_attr($filter_order_dir); ?>"/>
                </div>
            </form>
        </div>

        <table>
            <tr>
                <th><input type="checkbox" onclick="wlpr.selectCb()" id="cb-all"></th>
                <th>
                    <a onclick="wlpr.filterAction('user_point_filter_order','user_email','user_point_filter_order_dir','manage_user_point_form');">
                        <?php esc_html_e('Customers', WLPR_TEXT_DOMAIN); ?>
                        <?php if (isset($filter_order) && $filter_order == 'user_email'): ?>
                            <i class="<?php echo (isset($filter_order_dir) && $filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                        <?php endif; ?>
                    </a>
                </th>
                <th>
                    <a onclick="wlpr.filterAction('user_point_filter_order','points','user_point_filter_order_dir','manage_user_point_form');">
                        <?php esc_html_e('Points', WLPR_TEXT_DOMAIN); ?>
                        <?php if (isset($filter_order) && $filter_order == 'points'): ?>
                            <i class="<?php echo (isset($filter_order_dir) && $filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                        <?php endif; ?>
                    </a>

                </th>
                <th><?php esc_html_e('Referral Code', WLPR_TEXT_DOMAIN); ?></th>
                <th><?php esc_html_e('Referral Url', WLPR_TEXT_DOMAIN); ?></th>
            </tr>
            <?php if (isset($items) && !empty($items) && isset($point_helper)): ?>
                <?php foreach ($items as $item): ?>
                    <tr>
                        <td><input type="checkbox" onclick="wlpr.changeAllCb('<?php echo $item->id;?>')" class="cb cb-<?php echo $item->id;?>" name="cb[]" value="<?php echo $item->id;?>"></td>
                        <td>
                            <a href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'customer_history', 'user_email' => $item->user_email))) ?>"><?php echo $item->user_email; ?></a>
                        </td>
                        <?php $user_customer_point_id = str_replace(array('@', ' ', '.','+'), "", $item->user_email); ?>
                        <td><input class="lpr-form-control m-r-0" type="number" min="0" oninput="validity.valid||(value='');"
                                   value="<?php echo $item->points; ?>"
                                   id="customer_point_<?php echo $user_customer_point_id; ?>"
                                   name="point[<?php echo $user_customer_point_id; ?>]">
                            <a class="lpr-update"
                               onclick="wlpr.apply_point('<?php echo $item->user_email; ?>','<?php echo $user_customer_point_id; ?>',false);"><?php esc_html_e('Update', WLPR_TEXT_DOMAIN); ?></a>
                            <a class="lpr-delete"
                               onclick="wlpr.delete_user('<?php echo $item->user_email; ?>',true);"><span class="dashicons dashicons-trash rule-remove"></span></a>
                        </td>
                        <td><?php echo $item->refer_code; ?></td>
                        <td><?php echo site_url() . '?wlpr_ref=' . $item->refer_code; ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4"><?php esc_html_e('Once your customers start earning points, you can manage them here', WLPR_TEXT_DOMAIN); ?></td>
                </tr>
            <?php endif; ?>
            <?php if (isset($pagination)): ?>
                <tr>
                    <td colspan="4"><?php echo $pagination->createLinks(); ?></td>
                </tr>
            <?php endif; ?>
        </table>
    </div>
</div>