<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
?>
<div id="wlpr-main">
    <section class="full-width">
        <div class="row full-width">
            <div class="columns twelve mtb-2">
                <div class="lpr-row side-elements">
                    <a class="button lpr-btn-back"
                       href="<?php echo admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'dashboard'))) ?>"><?php esc_html_e('Back', WLPR_TEXT_DOMAIN); ?></a>
                </div>
            </div>
            <div class="lpr-row lpr-card-customer-main">
                <div class="lpr-card-customer">
                    <div class="lpr_card">
                        <div class="lpr_card-header">
                            <h4><?php esc_html_e('Customer Point Details', WLPR_TEXT_DOMAIN); ?></h4>
                        </div>
                        <div class="lpr-cpd-box lpr-cpd-brd">
                            <div class="badge-circle-points">
                                <span class="dashicons dashicons-awards"></span>
                            </div>
                            <h6><?php esc_html_e('Points :', WLPR_TEXT_DOMAIN); ?> </h6>
                            <h5 id="wplr_customer_point"><?php echo isset($user_details->points) ? $user_details->points : 0; ?> </h5>
                            <a onclick="jQuery('#wlpr_apply_point_setting').toggle();jQuery('#wplr_customer_point').hide();jQuery(this).hide();"><span
                                        class="dashicons dashicons-edit"></span><?php esc_html_e('Adjust balance', WLPR_TEXT_DOMAIN); ?>
                            </a>
                            <div id="wlpr_apply_point_setting" style="display: none;">
                                <?php $user_point_id = str_replace(array('@', ' ', '.'), "", isset($user_details->user_email) ? $user_details->user_email : ''); ?>
                                <input class="lpr-form-adjust-balance" type="number" min="0"
                                       value="<?php echo isset($user_details->points) ? $user_details->points : 0; ?>"
                                       id="customer_point_<?php echo $user_point_id; ?>">
                                <a class=""
                                   onclick="wlpr.apply_point('<?php echo isset($user_details->user_email) ? $user_details->user_email : ""; ?>','<?php echo $user_point_id; ?>',true);"><?php esc_html_e('Update', WLPR_TEXT_DOMAIN); ?></a>

                            </div>
                        </div>
                        <div class="lpr-cpd-box">
                            <div class="badge-circle-points">
                                <span class="dashicons dashicons-award">₹</span>
                            </div>
                            <h6>  <?php esc_html_e('Value', WLPR_TEXT_DOMAIN); ?> </h6>
                            <h5> <?php echo wc_price($point_helper->getRedeemPointAmount(isset($user_details->points) ? $user_details->points : 0)); ?></h5>
                        </div>
                    </div>
                </div>

                <?php if (isset($user_details->user_email)): ?>
                    <div class="lpr-card-customer lpr-card-customer-1">
                        <div class="lpr_card lpr-card-bg">
                            <div class="lpr_card-header">
                                <h4><?php esc_html_e('Customer Details', WLPR_TEXT_DOMAIN); ?></h4>
                            </div>
                            <?php
                            $user_data = get_user_by('email', $user_details->user_email);
                            ?>

                            <?php
                            if (isset($user_data->ID) && !empty($user_data->ID)):
                                $user_meta_data = get_metadata('user', $user_data->ID, '', true);
                                $address_data = array(
                                    'first_name',
                                    'last_name',
                                    'address_1',
                                    'city',
                                    'phone',
                                    'postcode',
                                    'country'
                                );
                                ?>
                                <div class="lpr-cpd-box lpr-cpd-user">
                                    <h3><?php echo isset($user_data->data) ? $user_data->data->display_name : ''; ?> </h3>
                                    <h6><?php echo !isset($user_data->data) ? __('Guest user', WLPR_TEXT_DOMAIN) : ''; ?></h6>
                                    <?php foreach ($address_data as $address): ?>
                                        <h3><?php echo isset($user_meta_data['billing_' . $address]) ? maybe_unserialize($user_meta_data['billing_' . $address][0]) : ''; ?> </h3>
                                    <?php endforeach; ?>

                                </div>
                                <div class="lpr-cpd-box lpr-cpd-user">
                                    <h3><?php echo $user_details->user_email; ?></h3>
                                    <?php foreach ($address_data as $address): ?>
                                        <h3><?php echo isset($user_meta_data['shipping_' . $address]) ? maybe_unserialize($user_meta_data['shipping_' . $address][0]) : ''; ?> </h3>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <section class="full-width">
        <div class="lpr-recent-section lpr-point-history">
            <div class="side-elements lpr-recent-points">
                <div class="lpr-head-brd">
                    <h3 class="lpr-mb-15"><?php esc_html_e('Transactions', WLPR_TEXT_DOMAIN); ?></h3>
                    <form action="<?php echo $filter_base_url; ?>" method="post" id="transaction_form_id"
                          class="row-search"
                          name="transaction_form">
                        <div class="row row-brd ">
                            <div class="lpr-search-label-text">
                                <label><?php esc_html_e('Search', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-search-label-input">
                                <input type="text" class="lpr-form-control-search" name="t_search"
                                       value="<?php echo esc_html($t_search); ?>"/>
                            </div>
                            <input type="submit" value="Submit" class="lpr-btn-submit">

                            <input type="hidden" name="per_page" value="<?php echo esc_attr($per_page); ?>"/>
                            <input type="hidden" name="transaction_page_number"
                                   value="<?php echo esc_attr($transaction_page_number); ?>"/>
                            <input type="hidden" name="action_page_number"
                                   value="<?php echo esc_attr($action_page_number); ?>"/>
                            <input type="hidden" name="activity_page_number"
                                   value="<?php echo esc_attr($activity_page_number); ?>"/>

                            <input type="hidden" name="page" value="<?php echo WLPR_PLUGIN_SLUG; ?>"/>
                            <input type="hidden" name="view" value="customer_history"/>
                            <input type="hidden" name="user_email" value="<?php echo $user_email; ?>"/>
                            <input type="hidden" name="t_filter_order" id="transaction_filter_order_id"
                                   value="<?php echo esc_attr($t_filter_order); ?>"/>
                            <input type="hidden" name="t_filter_order_dir" id="transaction_filter_order_dir_id"
                                   value="<?php echo esc_attr($t_filter_order_dir); ?>"/>
                        </div>
                    </form>
                </div>
                <table>
                    <tr>
                        <th>
                            <a onclick="wlpr.filterAction('transaction_filter_order_id','created_date','transaction_filter_order_dir_id','transaction_form_id');">
                                <?php esc_html_e('Date', WLPR_TEXT_DOMAIN); ?>
                                <?php if (isset($t_filter_order) && $t_filter_order == 'created_date'): ?>
                                    <i class="<?php echo (isset($t_filter_order_dir) && $t_filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th><?php esc_html_e('Type', WLPR_TEXT_DOMAIN); ?></th>
                        <th><?php esc_html_e('Event', WLPR_TEXT_DOMAIN); ?></th>
                        <th>
                            <a onclick="wlpr.filterAction('transaction_filter_order_id','user_email','transaction_filter_order_dir_id','transaction_form_id');">
                                <?php esc_html_e('Email', WLPR_TEXT_DOMAIN); ?>
                                <?php if (isset($t_filter_order) && $t_filter_order == 'user_email'): ?>
                                    <i class="<?php echo (isset($t_filter_order_dir) && $t_filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a onclick="wlpr.filterAction('transaction_filter_order_id','points','transaction_filter_order_dir_id','transaction_form_id');">
                                <?php esc_html_e('Points', WLPR_TEXT_DOMAIN); ?>
                                <?php if (isset($t_filter_order) && $t_filter_order == 'points'): ?>
                                    <i class="<?php echo (isset($t_filter_order_dir) && $t_filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>

                    </tr>
                    <?php if (isset($transaction) && !empty($transaction) && isset($point_helper)): ?>
                        <?php foreach ($transaction as $item): ?>
                            <tr>
                                <td class="lpr-table-date"><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime(\Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($item->created_date))); ?></td>
                                <td><?php
                                    if (in_array($item->type, array('order-placed', 'order-cancelled', 'order-refunded', 'order-redeem'))): ?>
                                        <a href="<?php echo admin_url('post.php?' . http_build_query(array('post' => $item->order_id, 'action' => 'edit'))); ?>"><?php esc_html_e('Order #', WLPR_TEXT_DOMAIN); ?><?php echo \Wlpr\App\Helpers\Loyalty::woocommerce()->getDisplayOrderId($item->order_id); ?></a>
                                    <?php elseif ($item->type == 'admin-adjustment'): ?>
                                        <?php esc_html_e('Admin adjusted', WLPR_TEXT_DOMAIN); ?>
                                    <?php elseif ($item->type == 'rest-api'): ?>
                                        <?php esc_html_e('REST API adjusted', WLPR_TEXT_DOMAIN); ?>
                                    <?php elseif ($item->type == 'expire'): ?>
                                        <?php esc_html_e('Expired', WLPR_TEXT_DOMAIN); ?>
                                    <?php elseif ($item->type == 'product-review'): ?>
                                        <?php esc_html_e('Review', WLPR_TEXT_DOMAIN); ?>
                                    <?php elseif ($item->type == 'account-signup'): ?>
                                        <?php esc_html_e('Signup', WLPR_TEXT_DOMAIN); ?>
                                    <?php elseif ($item->type == 'referring_user'): ?>
                                        <?php esc_html_e('Points earned through referral', WLPR_TEXT_DOMAIN); ?>
                                    <?php elseif ($item->type == 'referral_point'): ?>
                                        <?php esc_html_e('Referred some one', WLPR_TEXT_DOMAIN); ?>
                                    <?php endif; ?></td>
                                <td><?php echo $point_helper->eventTypeDescription($item->type); ?></td>
                                <td><?php echo $item->user_email; ?></td>
                                <td class="lpr-points-green"><?php echo $item->points; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3"><?php esc_html_e('No transaction found', WLPR_TEXT_DOMAIN); ?></td>
                        </tr>
                    <?php endif; ?>
                    <?php if (isset($transaction_pagination)): ?>
                        <tr>
                            <td colspan="5"><?php echo $transaction_pagination->createLinks(array('page_number_name' => 'transaction_page_number')); ?></td>
                        </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </section>
    <section class="full-width">
        <div class="lpr-recent-section lpr-point-history">
            <div class="side-elements lpr-recent-points">
                <div class="lpr-head-brd">
                    <h3 class="lpr-mb-15"><?php esc_html_e('Points About to Expire', WLPR_TEXT_DOMAIN); ?></h3>
                    <form action="<?php echo $filter_base_url; ?>" method="post" id="e_form_id" name="e_form"
                          class="row-search">
                        <div class="row row-brd">
                            <div class="lpr-search-label-text">
                                <label><?php esc_html_e('Search', WLPR_TEXT_DOMAIN); ?></label>
                            </div>
                            <div class="lpr-search-label-input">
                                <input type="text" class="lpr-form-control-search" name="e_search"
                                       value="<?php echo esc_html($e_search); ?>"/>
                            </div>
                            <input type="submit" class="lpr-btn-submit"
                                   value="<?php esc_html_e('Submit', WLPR_TEXT_DOMAIN) ?>"/>

                            <input type="hidden" name="per_page" value="<?php echo esc_attr($per_page); ?>"/>
                            <input type="hidden" name="transaction_page_number"
                                   value="<?php echo esc_attr($transaction_page_number); ?>"/>
                            <input type="hidden" name="action_page_number"
                                   value="<?php echo esc_attr($action_page_number); ?>"/>
                            <input type="hidden" name="activity_page_number"
                                   value="<?php echo esc_attr($activity_page_number); ?>"/>

                            <input type="hidden" name="page" value="<?php echo WLPR_PLUGIN_SLUG; ?>"/>
                            <input type="hidden" name="view" value="customer_history"/>
                            <input type="hidden" name="user_email" value="<?php echo $user_email; ?>"/>
                            <input type="hidden" name="e_filter_order" id="e_filter_order_id"
                                   value="<?php echo esc_attr($e_filter_order); ?>"/>
                            <input type="hidden" name="e_filter_order_dir" id="e_filter_order_dir_id"
                                   value="<?php echo esc_attr($e_filter_order_dir); ?>"/>
                        </div>
                    </form>
                </div>
                <table>
                    <tr>
                        <th>
                            <a onclick="wlpr.filterAction('e_filter_order_id','created_date','e_filter_order_dir_id','e_form_id');">
                                <?php esc_html_e('Expiry Date', WLPR_TEXT_DOMAIN); ?>
                                <?php if (isset($e_filter_order) && $e_filter_order == 'created_date'): ?>
                                    <i class="<?php echo (isset($e_filter_order_dir) && $e_filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a onclick="wlpr.filterAction('e_filter_order_id','points','e_filter_order_dir_id','e_form_id');">
                                <?php esc_html_e('Total Earned Points', WLPR_TEXT_DOMAIN); ?>
                                <?php if (isset($e_filter_order) && $e_filter_order == 'points'): ?>
                                    <i class="<?php echo (isset($e_filter_order_dir) && $e_filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a onclick="wlpr.filterAction('e_filter_order_id','remaining_point','e_filter_order_dir_id','e_form_id');">
                                <?php esc_html_e('Remaining Points', WLPR_TEXT_DOMAIN); ?>
                                <?php if (isset($e_filter_order) && $e_filter_order == 'remaining_point'): ?>
                                    <i class="<?php echo (isset($e_filter_order_dir) && $e_filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                        <th>
                            <a onclick="wlpr.filterAction('e_filter_order_id','user_email','e_filter_order_dir_id','e_form_id');">
                                <?php esc_html_e('Customer', WLPR_TEXT_DOMAIN); ?>
                                <?php if (isset($e_filter_order) && $e_filter_order == 'user_email'): ?>
                                    <i class="<?php echo (isset($e_filter_order_dir) && $e_filter_order_dir == 'DESC') ? 'dashicons dashicons-arrow-down' : 'dashicons dashicons-arrow-up'; ?>"></i>
                                <?php endif; ?>
                            </a>
                        </th>
                    </tr>
                    <?php if (isset($point_action) && !empty($point_action) && isset($point_helper)): ?>
                        <?php foreach ($point_action as $item): ?>
                            <tr>
                                <td class="lpr-table-date">
                                    <span id="expire-date-display-<?php echo $item->id;?>"><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime(\Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($item->expire_date, 'Y-m-d H:i:s'))); ?></span>
                                    <span id="expire-date-edit-<?php echo $item->id;?>" style="display: none;">
                                        <input class="flatpickr flatpickr-input active lpr-custom_date" id="expire_date_id_<?php echo $item->id;?>" type="text"
                                               name="expire_date[<?php echo $item->id;?>]"
                                               placeholder="<?php esc_html_e('Select Date..', WLPR_TEXT_DOMAIN); ?>" readonly="readonly">
                                    </span>
                                    <a class="lpr-update" onclick="wlpr_jquery('#expire-date-display-<?php echo $item->id;?>').hide();wlpr_jquery('#expire-date-edit-<?php echo $item->id;?>').show();wlpr_jquery(this).hide();wlpr_jquery('#expire-date-update-button-<?php echo $item->id;?>').show();"><?php echo __('Edit', WLPR_TEXT_DOMAIN);?></a>
                                    <a class="lpr-update" id="expire-date-update-button-<?php echo $item->id;?>" style="display: none;" onclick="wlpr.update_expire_date('<?php echo $item->id;?>','<?php echo WLPR_PLUGIN_SLUG; ?>')"><?php echo __('Update', WLPR_TEXT_DOMAIN);?></a>
                                    <script>
                                        flatpickr(wlpr_jquery("#expire-date-edit-<?php echo $item->id;?> #expire_date_id_<?php echo $item->id;?>"), {
                                            enableTime: true,
                                            dateFormat: "Y-m-d H:i",
                                            defaultDate: ["<?php echo \Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($item->expire_date, 'Y-m-d H:i:s'); ?>"]
                                        });
                                    </script>
                                    </td>
                                <td class="lpr-points-green"><?php echo $item->points; ?></td>
                                <td class="lpr-points-green"><?php echo $item->remaining_point; ?></td>
                                <td><?php echo $item->user_email; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3"><?php esc_html_e('No points that expire soon found', WLPR_TEXT_DOMAIN); ?></td>
                        </tr>
                    <?php endif; ?>
                    <?php if (isset($action_pagination)): ?>
                        <tr>
                            <td colspan="3"><?php echo $action_pagination->createLinks(array('page_number_name' => 'action_page_number')); ?></td>
                        </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>
    </section>
    <section class="full-width">
        <div class="lpr-recent-section lpr-point-history">
            <div class="side-elements lpr-recent-points">
                <h3><?php esc_html_e('Activity', WLPR_TEXT_DOMAIN); ?></h3>
                <ul class="widget-timeline">
                    <?php if (isset($activity) && !empty($activity) && isset($point_helper)): ?>
                        <?php foreach ($activity as $item): ?>
                            <li class="timeline-items <?php echo ($item->points > 0) ? 'timeline-icon-success' : 'border-danger'; ?> active">

                                <div class="timeline-time"><?php echo date_i18n(get_option('date_format') . ' ' . get_option('time_format'), strtotime(\Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($item->created_date))); ?></div>
                                <div class=""><h6 class="timeline-title"><?php echo $item->user_email; ?></h6>
                                    <div class="timeline-content"><?php echo $point_helper->activityTypeDescription($item); ?></div>
                            </li>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3"><?php esc_html_e('No activity found', WLPR_TEXT_DOMAIN); ?></td>
                        </tr>
                    <?php endif; ?>
                </ul>
                <?php if (isset($activity_pagination)): ?>
                    <?php echo $activity_pagination->createLinks(array('page_number_name' => 'activity_page_number')); ?>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section class="full-width">
        <div class="lpr-recent-section lpr-point-history">
            <div class="lpr-add-private">
                <label><?php esc_html_e('Add private note: ', WLPR_TEXT_DOMAIN); ?></label>
                <input type="text" name="point_note" class="lpr-form-control" id="point-private-note">
                <a class="button lpr-add-btn"
                   onclick="wlpr.save_private_note('point-private-note','<?php echo $user_email; ?>')"><?php esc_html_e('Add', WLPR_TEXT_DOMAIN); ?></a>
            </div>
        </div>
    </section>
</div>
