<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
$discount_types = array(
    'fixed' => esc_html__('Fixed', WLPR_TEXT_DOMAIN),
    'percentage' => esc_html__('Percentage', WLPR_TEXT_DOMAIN)
);
$discount_enabled_attr = array(
    'no' => __('No',WLPR_TEXT_DOMAIN),
    'yes' => __('Yes',WLPR_TEXT_DOMAIN),
);
$earn_point_actions_attr = array(
    'global' => __('Inherit from global settings',WLPR_TEXT_DOMAIN),
    'product' => __('Override points at category level',WLPR_TEXT_DOMAIN),
    'disable' => __('Disable',WLPR_TEXT_DOMAIN)
);
?>
<tr>
    <td colspan="2">
        <hr/>
    </td>
</tr>
<tr>
    <td colspan="2"><h3><?php esc_html_e('Loyalty point settings', WLPR_TEXT_DOMAIN) ?></h3></td>
</tr>
<tr class="form-field">
    <th scope="row">
        <label><?php esc_html_e('Enable category earn points ?', WLPR_TEXT_DOMAIN); ?></label>
    </th>
    <td>
        <?php
        $wlpr_category_enable_earn_point = (isset($wlpr_category_enable_earn_point) && !empty($wlpr_category_enable_earn_point)) ? $wlpr_category_enable_earn_point : 'global'; ?>
        <select name="_wlpr_category_enable_earn_point"
                id="wlpr-earn-point-action-settings"
                onchange="showEarnPointDiv();"
        >
            <?php foreach ($earn_point_actions_attr as $d_key => $d_value): ?>
                <?php if ($d_key == $wlpr_category_enable_earn_point): ?>
                    <option value="<?php echo $d_key; ?>"
                            selected="selected"><?php echo $d_value; ?></option>
                <?php else: ?>
                    <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>
    </td>
</tr>
<tr class="form-field wlpr-earn-point-disable-msg" style="<?php echo ($wlpr_category_enable_earn_point == 'disable') ? "": "display:none;";?>">
    <th colspan="2" scope="row" >
        <?php echo __('Earn points will be disabled for this category',WLPR_TEXT_DOMAIN);?>
    </th>
</tr>
<tr class="form-field wlpr-earn-point-settings" style="<?php echo ($wlpr_category_enable_earn_point== 'product') ? "":"display:none;";?>">
    <th scope="row">
        <label><?php esc_html_e('How many points customer can earn when they purchase?(per product quantity)', WLPR_TEXT_DOMAIN); ?></label>
    </th>
    <td>
        <input class="wlpr-earn-point" style="max-width: 50px;" type="number" min="0"
               name="_wlpr_category_points_earned[wlpr_earn_point]"
               value="<?php echo esc_attr((isset($earn_point_setting['wlpr_earn_point']) && !empty($earn_point_setting['wlpr_earn_point']) ? $earn_point_setting['wlpr_earn_point'] : 0)); ?>"/><?php esc_html_e('points can be earned for spending', WLPR_TEXT_DOMAIN); ?>
        <span>&nbsp;&#61;&nbsp;</span>&nbsp;<?php echo get_woocommerce_currency_symbol(); ?>
        <input class="wlpr-point-earn-price" style="max-width: 50px;" type="number" min="0"
               name="_wlpr_category_points_earned[wlpr_point_earn_price]"
               value="<?php echo esc_attr((isset($earn_point_setting['wlpr_point_earn_price']) && !empty($earn_point_setting['wlpr_point_earn_price']) ? $earn_point_setting['wlpr_point_earn_price'] : 0)); ?>"/>
        <p class="description"><?php esc_html_e('Set the number of points awarded based on the product price.', WLPR_TEXT_DOMAIN); ?></p>
    </td>
</tr>
<tr class="form-field">
    <th scope="row">
        <label><?php esc_html_e('Enable maximum product points discount ?', WLPR_TEXT_DOMAIN); ?></label>
    </th>
    <td>
        <?php
        $discount_enabled_attr = array(
                'no' => __('No',WLPR_TEXT_DOMAIN),
            'yes' => __('Yes',WLPR_TEXT_DOMAIN),
        );
        $max_product_discount_enabled = (isset($max_product_discount_enabled) && !empty($max_product_discount_enabled)) ? $max_product_discount_enabled : 'no'; ?>
        <select name="_wlpr_category_max_discount_enabled">
            <?php foreach ($discount_enabled_attr as $d_key => $d_value): ?>
                <?php if ($d_key == $max_product_discount_enabled): ?>
                    <option value="<?php echo $d_key; ?>"
                            selected="selected"><?php echo $d_value; ?></option>
                <?php else: ?>
                    <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>
    </td>
</tr>
<tr class="form-field">
    <th scope="row">
        <label><?php esc_html_e('Maximum product points discount(per product quantity)', WLPR_TEXT_DOMAIN); ?></label></th>
    <td>
        <input class="wlpr-product-maximum-discount" style="max-width: 50px;" type="number" min="0"
               name="_wlpr_category_points_max_discount"
               value="<?php echo esc_attr((isset($max_product_discount) && !empty($max_product_discount) ? $max_product_discount : 0)); ?>"/>
        <?php
        $max_product_discount_type = esc_attr((isset($max_product_discount_type) && !empty($max_product_discount_type) ? $max_product_discount_type : 'fixed')); ?>
        <select name="_wlpr_category_points_max_discount_type">
            <?php foreach ($discount_types as $d_key => $d_value): ?>
                <?php if ($d_key == $max_product_discount_type): ?>
                    <option value="<?php echo $d_key; ?>"
                            selected="selected"><?php echo $d_value; ?></option>
                <?php else: ?>
                    <option value="<?php echo $d_key; ?>"><?php echo $d_value; ?></option>
                <?php endif; ?>
            <?php endforeach; ?>
        </select>
        <p class="description"><?php esc_html_e('Set the maximum product discount allowed when redeeming points per-product. Use either a fixed monetary amount or a percentage based on the product price. Leave blank to disable.', WLPR_TEXT_DOMAIN); ?></p>
    </td>
</tr>
<?php if (class_exists('WC_Subscriptions')): ?>
    <tr class="form-field">
        <th scope="row">
            <label><?php esc_html_e('How many renewal points customer can earn when they purchase?(For subscription product)', WLPR_TEXT_DOMAIN); ?></label>
        </th>
        <td>
            <input class="wlpr-renewal-earn-point" style="max-width: 50px;" type="number" min="0"
                   name="_wlpr_category_points_renewal_points[wlpr_earn_point]"
                   value="<?php echo esc_attr((isset($renewal_setting['wlpr_earn_point']) && !empty($renewal_setting['wlpr_earn_point']) ? $renewal_setting['wlpr_earn_point'] : 0)); ?>"/><?php esc_html_e('points can be earned for spending', WLPR_TEXT_DOMAIN); ?>
            &nbsp;&#61;&nbsp;<?php echo get_woocommerce_currency_symbol(); ?>

            <input class="wlpr-renewal-point-earn-price"
                   style="max-width: 50px;" type="number" min="0"
                   name="_wlpr_category_points_renewal_points[wlpr_point_earn_price]"
                   value="<?php echo esc_attr((isset($renewal_setting['wlpr_point_earn_price']) && !empty($renewal_setting['wlpr_point_earn_price']) ? $renewal_setting['wlpr_point_earn_price'] : 0)); ?>"/>
            <p class="description"><?php esc_html_e('Set the number of points awarded based on the product price.', WLPR_TEXT_DOMAIN); ?></p>
        </td>
    </tr>
<?php endif; ?>
<tr>
    <td colspan="2">
        <hr/>
    </td>
</tr>
<script type="application/javascript">
    function showEarnPointDiv(){
        var current_value = jQuery('#wlpr-earn-point-action-settings').val();
        if(current_value == 'global'){
            jQuery('.wlpr-earn-point-settings').hide();
            jQuery('.wlpr-earn-point-disable-msg').hide();
        }
        if(current_value == 'disable'){
            jQuery('.wlpr-earn-point-disable-msg').show();
            jQuery('.wlpr-earn-point-settings').hide();
        }
        if(current_value == 'product'){
            jQuery('.wlpr-earn-point-disable-msg').hide();
            jQuery('.wlpr-earn-point-settings').show();
        }
    }
</script>