<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Models;
class Referral extends Base
{

    function __construct()
    {
        parent::__construct();
        $this->table = self::$db->prefix . 'wlpr_referral';
        $this->primary_key = 'id';
        $this->fields = array(
            'referred_by' => '%s',
            'new_user' => '%s',
            'referred_by_earn_point' => '%d',
            'new_user_earn_point' => '%d',
            'referred_order_price' => '%s',
            'new_user_discount' => '%s',
            'order_id' => '%s',
            'created_date' => '%s',
            'status' => '%s'
        );
    }

    function beforeTableCreation() {}

    function runTableCreation()
    {
        $create_table_query = "CREATE TABLE IF NOT EXISTS {$this->table} (
				 `{$this->getPrimaryKey()}` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
                 `referred_by` varchar(180) DEFAULT NULL,
                 `new_user` varchar(180) DEFAULT NULL,
                 `referred_by_earn_point` int (11) DEFAULT 0,
                 `new_user_earn_point` int(11) DEFAULT 0,
                 `referred_order_price` decimal (15,6) DEFAULT 0.0,
                 `new_user_discount` decimal (15,6) DEFAULT 0.0,
                 `order_id` varchar(180) DEFAULT NULL,
                 `created_date` datetime DEFAULT NULL,
                 PRIMARY KEY (`{$this->getPrimaryKey()}`)
			)";
        $this->createTable($create_table_query);
    }

    function afterTableCreation() {
        global $wpdb;
        if ( self::$db->get_var( "SHOW TABLES LIKE '{$this->table}'" ) ) {
            $existing_columns = $wpdb->get_col("DESC {$this->table}", 0);
            if(!in_array('status',$existing_columns)){
                self::$db->query(
                    "ALTER TABLE `{$this->table}` ADD COLUMN status varchar(180) DEFAULT 'completed'"
                );
            }
        }
        if ( self::$db->get_var( "SHOW TABLES LIKE '{$this->table}'" ) ) {
			if ( self::$db->get_var( "SHOW KEYS FROM {$this->table} WHERE Key_name = 'x_referred_by'" ) ) {
				self::$db->query(
					"ALTER TABLE `{$this->table}` DROP INDEX x_referred_by"
				);
			}
        }
    }
}