<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Models;
class Points extends Base
{

    function __construct()
    {
        parent::__construct();
        $this->table = self::$db->prefix . 'wlpr_points';
        $this->primary_key = 'id';
        $this->fields = array(
            'user_email' => '%s',
            'points' => '%s',
            'created_date' => '%s',
            'refer_code' => '%s'
        );
    }

    function beforeTableCreation() {}

    function runTableCreation()
    {
        $create_table_query = "CREATE TABLE IF NOT EXISTS {$this->table} (
				 `{$this->getPrimaryKey()}` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
                 `user_email` varchar(180) DEFAULT NULL,
                 `refer_code` varchar(180) DEFAULT NULL,
                 `points` BIGINT DEFAULT 0,
                 `created_date` datetime DEFAULT NULL,
                 PRIMARY KEY (`{$this->getPrimaryKey()}`)
			)";
        $this->createTable($create_table_query);
    }

    function afterTableCreation() {
        global $wpdb;
        if ( self::$db->get_var( "SHOW TABLES LIKE '{$this->table}'" ) ) {
			if ( ! self::$db->get_var( "SHOW KEYS FROM {$this->table} WHERE Key_name = 'user_email'" ) ) {
				self::$db->query(
					"ALTER TABLE `{$this->table}` ADD UNIQUE (user_email(150))"
				);
			}
        }

        if ( self::$db->get_var( "SHOW TABLES LIKE '{$this->table}'" ) ) {
            $existing_columns = $wpdb->get_col("DESC {$this->table}", 0);
            if (!in_array('birth_date', $existing_columns)) {
                self::$db->query("ALTER TABLE `{$this->table}` ADD birth_date datetime DEFAULT NULL");
            }
        }
    }

}