<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Models;
use function GuzzleHttp\Psr7\str;

class PointLog extends Base
{

    function __construct()
    {
        parent::__construct();
        $this->table = self::$db->prefix . 'wlpr_point_logs';
        $this->primary_key = 'id';
        $this->fields = array(
            'user_email' => '%s',
            'points' => '%s',
            'type' => '%s',
            'order_id' => '%s',
            'product_id' => '%s',
            'admin_user_id' => '%s',
            'log_data' => '%s',
            'created_date' => '%s',
            'redeem_price' => '%f',
            'earn_price' => '%f'
        );
    }

    function beforeTableCreation() {}

    function runTableCreation()
    {
        $create_table_query = "CREATE TABLE IF NOT EXISTS {$this->table} (
				 `{$this->getPrimaryKey()}` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
                 `user_email` varchar(180) DEFAULT NULL,
                 `points` BIGINT SIGNED DEFAULT 0,
                 `type` varchar(180) DEFAULT NULL,
                 `order_id` varchar(180) DEFAULT NULL,
                 `product_id` varchar(180) DEFAULT NULL,
                 `admin_user_id` BIGINT UNSIGNED DEFAULT NULL,
                 `log_data` longtext DEFAULT NULL,
                 `created_date` datetime DEFAULT NULL,
                 `redeem_price` DECIMAL(12,4) NOT NULL DEFAULT '0.0',
                 `earn_price` DECIMAL(12,4) NOT NULL DEFAULT '0.0',
                PRIMARY KEY (`{$this->getPrimaryKey()}`)
			)";
        $this->createTable($create_table_query);
    }

    function afterTableCreation() {
        global $wpdb;
        if ( self::$db->get_var( "SHOW TABLES LIKE '{$this->table}'" ) ) {
            $existing_columns = $wpdb->get_col("DESC {$this->table}", 0);
            if(!in_array('product_id',$existing_columns)){
                self::$db->query(
                    "ALTER TABLE `{$this->table}` ADD COLUMN product_id varchar(180) DEFAULT NULL"
                );
            }
            if(!in_array('redeem_price',$existing_columns)){
                self::$db->query(
                    "ALTER TABLE `{$this->table}` ADD COLUMN redeem_price DECIMAL(12,4) NOT NULL DEFAULT '0.0'"
                );
            }
            if(!in_array('earn_price',$existing_columns)){
                self::$db->query(
                    "ALTER TABLE `{$this->table}` ADD COLUMN earn_price DECIMAL(12,4) NOT NULL DEFAULT '0.0'"
                );
            }
            $query = $wpdb->prepare("SELECT COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = %s AND COLUMN_NAME = %s",$this->table,'points');
            $existing_column = $wpdb->get_row($query,OBJECT);
            if(isset($existing_column->COLUMN_TYPE) && in_array($existing_column->COLUMN_TYPE,array('bigint unsigned','bigint'))){
                self::$db->query(
                    "ALTER TABLE `{$this->table}` MODIFY COLUMN points BIGINT SIGNED DEFAULT 0"
                );
            }
        }
    }

    function add_log_entry($args)
    {
        $data = array(
            'user_email' => sanitize_email($args['user_email']),
            'points' => (int)$args['points'],
            'type' => (string)$args['event_type'],
            'created_date' => isset($args['created_date']) && $args['created_date'] ? $args['created_date'] : date("Y-m-d h:i:s"),
            'redeem_price' => (float)isset($args['redeem_price']) && $args['redeem_price'] ? $args['redeem_price'] : 0.0,
            'earn_price' => (float)isset($args['earn_price']) && $args['earn_price'] ? $args['earn_price'] : 0.0,
        );
        if (isset($args['order_id']) && $args['order_id']) {
            $data['order_id'] = (string)$args['order_id'];
        }
        if(isset($args['product_id']) && $args['product_id']){
            $data['product_id'] = (int)$args['product_id'];
        }
        if (isset($args['log_data']) && $args['log_data']) {
            $data['log_data'] = json_encode($args['log_data']);
        }
        if(isset($data['type']) && $data['type'] == 'admin-adjustment'){
            $data['admin_user_id'] = isset($args['admin_user_id']) && !empty($args['admin_user_id']) ? $args['admin_user_id']: 0;
        }
        if (is_admin() && !defined('DOING_AJAX')) {
            $admin_user = wp_get_current_user();
            $data['admin_user_id'] = (int)$admin_user->ID;
        }
        $this->insertRow($data);
    }
}