<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
defined('ABSPATH') or exit;
if (!class_exists('WlprRefereeEmail')) {
    class WlprRefereeEmail extends WC_Email
    {
        protected static $replace_place_array = array();
        function __construct()
        {
            $this->id = WLPR_PLUGIN_PREFIX . '_referee_email';
            $this->customer_email = true;
            $this->title = __('Referral Points Earned by Friend', WLPR_TEXT_DOMAIN);
            $this->description = __('This email is sent to the friend who have made his first purchase through a referral and earned a reward.', WLPR_TEXT_DOMAIN);
            $this->default_subject =  __('You have unlocked a reward!', WLPR_TEXT_DOMAIN);
            $this->default_heading = __('You have unlocked a reward!', WLPR_TEXT_DOMAIN);
            $this->template_html = 'emails/wlpr-referee-point.php';
            $this->template_plain = 'emails/plain/wlpr-referee-point.php';
            add_action('wlpr_after_add_referral_points',array($this,'sendReferralPointEmail'),10,5);
            parent::__construct();
            $this->recipient = $this->get_option('recipient', get_option('admin_email'));
            $this->template_base = WLPR_PLUGIN_PATH . 'Templates/';

        }

        function sendReferralPointEmail($data, $order_id){
            if(!empty($data) && !empty($order_id)){
                $this->trigger($data,$order_id);
            }
        }

        function trigger($data,$order_id){
            if(empty($order_id)){
                return;
            }
            $order = \Wlpr\App\Helpers\Loyalty::woocommerce()->getOrder($order_id);
            if(empty($order)){
                return;
            }
            $user_email = $order->get_billing_email();
            if(empty($user_email)){
                return;
            }
            /*$data = array(
                        'referred_by' => $referred_user->user_email,
                        'new_user' => $order_email,
                        'referred_by_earn_point' => $referred_by_earn_point,
                        'new_user_earn_point' => $new_user_earn_point,
                        'referred_order_price' => $sub_total,
                        'new_user_discount' => $discount_amount,
                        'created_date' => date('Y-m-d H:s:i')
                    );*/
            // send new customer referral mail
            if(isset($data['new_user']) && !empty($data['new_user']) && isset($data['new_user_earn_point']) && !empty($data['new_user_earn_point'])){
                $this->recipient = $data['new_user'];
                $ref_url = \Wlpr\App\Helpers\Loyalty::referral()->getReferralUrl('',$data['new_user']);
                $discount_amount = (isset($data['new_user_discount']) && !empty($data['new_user_discount'])) ? $data['new_user_discount']: 0;
                $short_codes = array(
                    '{wlpr_referee_point}' => $data['new_user_earn_point'],
                    '{wlpr_referral_url}' => $ref_url,
                    '{wlpr_order_id}' => \Wlpr\App\Helpers\Loyalty::woocommerce()->getDisplayOrderId($order_id),
                    '{wlpr_discounted_amount}' => $discount_amount
                );
                $short_codes = apply_filters( 'wlpr_referee_point_mail_short_code', $short_codes );
                foreach ($short_codes as $short_code => $short_code_value){
                    $this->add_placeholder($short_code, $short_code_value);
                }
                $subject = $this->get_subject();//__('Referral point earned for order #', WLPR_TEXT_DOMAIN) . $order->get_order_number();
                $attachments = $this->get_attachments();
                if (empty($attachments)) {
                    $attachments = array();
                }
                if ($this->is_enabled()) {
                    $this->send($this->get_recipient(), $subject, $this->get_content(), $this->get_headers(), $attachments);
                }
            }
        }

        /**
         * Add placeholder
         * @param $find
         * @param $replace
         */
        function add_placeholder($find, $replace)
        {
            $index = array_search($find, $this->find, true);
            if ($index === false) {
                $this->find[] = $find;
                $this->replace[] = $replace;
            } else {
                $this->find[$index] = $find;
                $this->replace[$index] = $replace;
            }
            self::$replace_place_array[$find] = $replace;
        }

        /**
         * get_content_html function.
         *
         * @access public
         * @return string
         */
        function get_content_html() {
            self::$replace_place_array['email'] = $this;
            ob_start();
            wc_get_template($this->template_html,self::$replace_place_array,'',
                $this->template_base );
            $html = ob_get_clean();
            return $this->format_string($html);
        }

        /**
         * get_content_plain function.
         *
         * @access public
         * @return string
         */
        function get_content_plain() {
            self::$replace_place_array['email'] = $this;
            ob_start();
            wc_get_template( $this->template_plain,self::$replace_place_array,'',
                $this->template_base );
            $html = ob_get_clean();
            return $this->format_string($html);
        }

        function init_form_fields()
        {
            $this->form_fields = array(
                'enabled' => array(
                    'title' => __('Enable/Disable', WLPR_TEXT_DOMAIN),
                    'type' => 'checkbox',
                    'label' => __('Enable this email notification', WLPR_TEXT_DOMAIN),
                    'default' => 'yes',
                ),
                'subject' => array(
                    'title' => __('Subject', WLPR_TEXT_DOMAIN),
                    'type' => 'text',
                    'description' => sprintf(__('This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', WLPR_TEXT_DOMAIN), $this->subject),
                    'placeholder' => '',
                    'default' => $this->default_subject
                ),
                'heading' => array(
                    'title' => __('Email Heading', WLPR_TEXT_DOMAIN),
                    'type' => 'text',
                    'description' => sprintf(__('This controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', WLPR_TEXT_DOMAIN), $this->heading),
                    'placeholder' => '',
                    'default' => $this->default_heading
                ),
                'email_type' => array(
                    'title' => __('Email type', WLPR_TEXT_DOMAIN),
                    'type' => 'select',
                    'description' => __('Choose which format of email to send.', WLPR_TEXT_DOMAIN),
                    'default' => 'html',
                    'class' => 'email_type',
                    'options' => array(
                        'plain' => __('Plain text', WLPR_TEXT_DOMAIN),
                        'html' => __('HTML', WLPR_TEXT_DOMAIN),
                        'multipart' => __('Multipart', WLPR_TEXT_DOMAIN),
                    )
                )
            );
        }
    }
}
