<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

use Wlpr\App\Models\PointLog;

defined('ABSPATH') or exit;
if (!class_exists('WlprPointExpireEmail')) {
    class WlprPointExpireEmail extends WC_Email
    {
        protected static $replace_place_array = array();
        function __construct()
        {
            $this->id = WLPR_PLUGIN_PREFIX . '_point_expire_email';
            $this->customer_email = true;
            $this->title = __('Points Expiry Email', WLPR_TEXT_DOMAIN);
            $this->description = __('This email is sent to the customer when their points are about to expire', WLPR_TEXT_DOMAIN);
            $this->default_subject = __('Your reward points are about to expire. Redeem now!', WLPR_TEXT_DOMAIN);
            $this->default_heading = __('Your reward points are about to expire. Redeem now!', WLPR_TEXT_DOMAIN);
            $this->template_html = 'emails/wlpr-expire-point.php';
            $this->template_plain = 'emails/plain/wlpr-expire-point.php';
            add_action('wlpr_email_expire_point_event', array($this, 'sendExpirePointEmail'));
            parent::__construct();
            $this->recipient = $this->get_option('recipient', get_option('admin_email'));
            $this->template_base = WLPR_PLUGIN_PATH . 'Templates/';
        }


        function sendExpirePointEmail(){
            $point_setting = get_option('wlpr_settings');
            //case 1: order placed 1 , mail send 5, expired date 10
            //case 2: order placed 2 , mail send 1, expired date 2
            $point_action_model = new \Wlpr\App\Models\PointAction();
            $email_expired_points = $point_action_model->get_expire_email_list();
            $final_email_list = array();
            foreach ($email_expired_points as $email_expired_point){
                $email_date = date('Y-m-d', strtotime($email_expired_point->created_date));
                if(!isset($final_email_list[$email_expired_point->user_email])){
                    $final_email_list[$email_expired_point->user_email] = array();
                }

                if(isset($final_email_list[$email_expired_point->user_email][$email_date]) && array_key_exists($email_date,$final_email_list[$email_expired_point->user_email])){
                    $final_email_list[$email_expired_point->user_email][$email_date]->points += $email_expired_point->points;
                    $final_email_list[$email_expired_point->user_email][$email_date]->email_status[]= $email_expired_point->id;
                }
                if(!isset($final_email_list[$email_expired_point->user_email][$email_date])){
                    $final_email_list[$email_expired_point->user_email][$email_date] = $email_expired_point;
                    $final_email_list[$email_expired_point->user_email][$email_date]->email_status = array();
                    $final_email_list[$email_expired_point->user_email][$email_date]->email_status[]= $email_expired_point->id;
                }
            }
            if(!empty($final_email_list)){
                foreach ($final_email_list as $point_user_email => $final_user_list){
                    foreach ($final_user_list as $point_email_date => $point_data){
                        $this->trigger($point_data);
                    }
                }
            }
        }
        function trigger($expired_point){
            if(!isset($expired_point->user_email) || empty($expired_point->user_email)){
                return;
            }
            $user_email = sanitize_email($expired_point->user_email);
            $this->recipient = $expired_point->user_email;
            $shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
            $expire_date_format = 'Y-m-d';
            $expire_date_format = apply_filters( 'wlpr_expire_mail_date_format', $expire_date_format );
            $ref_url = \Wlpr\App\Helpers\Loyalty::referral()->getReferralUrl('',$user_email);
            $short_codes = array(
                '{wlpr_expire_point}' => $expired_point->points,
                '{wlpr_point_expiry_redeem_url}' => $shop_page_url,
                '{wlpr_referral_url}' => $ref_url,
                '{wlpr_total_earn_point}' => \Wlpr\App\Helpers\Loyalty::point()->getUsersPoints($user_email),
                '{wlpr_point_expiry_date}' => \Wlpr\App\Helpers\Loyalty::woocommerce()->convert_utc_to_wp_time($expired_point->expire_date,$expire_date_format)
            );
            $short_codes = apply_filters( 'wlpr_expire_point_mail_short_code', $short_codes );
            foreach ($short_codes as $short_code => $short_code_value){
                $this->add_placeholder($short_code, $short_code_value);
            }
            $subject = $this->get_subject();//__('Your points will expire soon', WLPR_TEXT_DOMAIN);
            $attachments = $this->get_attachments();
            if (empty($attachments)) {
                $attachments = array();
            }
            if ($this->is_enabled()) {
                $this->send($this->get_recipient(), $subject, $this->get_content(), $this->get_headers(), $attachments);
                foreach ($expired_point->email_status as $update_id){
                    $point_action_model = new \Wlpr\App\Models\PointAction();
                    $point_action_model->updateRow(array(
                        'is_expire_mail_send' => 1,
                        'expire_mail_date' => date("Y-m-d h:i:s")
                    ), array(
                        'id' => (int)$update_id
                    ));
                }
                // required log parameters
                $args = array(
                    'user_email' => sanitize_email($expired_point->user_email),
                    'points' => (int)$expired_point->points,
                    'event_type' => 'expire_email',
                    'created_date' => date('Y-m-d H:i:s'),
                    'log_data' => array('note' => sanitize_email($expired_point->user_email))
                );
                // log the event
                $point_log = new PointLog();
                $point_log->add_log_entry($args);
            }
        }

        /**
         * Add placeholder
         * @param $find
         * @param $replace
         */
        function add_placeholder($find, $replace)
        {
            $index = array_search($find, $this->find, true);
            if ($index === false) {
                $this->find[] = $find;
                $this->replace[] = $replace;
            } else {
                $this->find[$index] = $find;
                $this->replace[$index] = $replace;
            }
            self::$replace_place_array[$find] = $replace;
        }

        /**
         * get_content_html function.
         *
         * @access public
         * @return string
         */
        function get_content_html() {
            self::$replace_place_array['email'] = $this;
            ob_start();
            wc_get_template($this->template_html,self::$replace_place_array,'',
                $this->template_base );
            $html = ob_get_clean();
            return $this->format_string($html);
        }

        /**
         * get_content_plain function.
         *
         * @access public
         * @return string
         */
        function get_content_plain() {
            self::$replace_place_array['email'] = $this;
            ob_start();
            wc_get_template( $this->template_plain,self::$replace_place_array,'',
                $this->template_base );
            $html = ob_get_clean();
            return $this->format_string($html);
        }

        function init_form_fields()
        {
            $this->form_fields = array(
                'enabled' => array(
                    'title' => __('Enable/Disable', WLPR_TEXT_DOMAIN),
                    'type' => 'checkbox',
                    'label' => __('Enable this email notification', WLPR_TEXT_DOMAIN),
                    'default' => 'yes',
                ),
                'subject' => array(
                    'title' => __('Subject', WLPR_TEXT_DOMAIN),
                    'type' => 'text',
                    'description' => sprintf(__('This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', WLPR_TEXT_DOMAIN), $this->subject),
                    'placeholder' => '',
                    'default' => $this->default_subject
                ),
                'heading' => array(
                    'title' => __('Email Heading', WLPR_TEXT_DOMAIN),
                    'type' => 'text',
                    'description' => sprintf(__('This controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', WLPR_TEXT_DOMAIN), $this->heading),
                    'placeholder' => '',
                    'default' => $this->default_heading
                ),
                'email_type' => array(
                    'title' => __('Email type', WLPR_TEXT_DOMAIN),
                    'type' => 'select',
                    'description' => __('Choose which format of email to send.', WLPR_TEXT_DOMAIN),
                    'default' => 'html',
                    'class' => 'email_type',
                    'options' => array(
                        'plain' => __('Plain text', WLPR_TEXT_DOMAIN),
                        'html' => __('HTML', WLPR_TEXT_DOMAIN),
                        'multipart' => __('Multipart', WLPR_TEXT_DOMAIN),
                    )
                )
            );
        }
    }


}