<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
defined('ABSPATH') or exit;
if (!class_exists('WlprOnBirthDayGiftEmail')) {
    class WlprOnBirthDayGiftEmail extends WC_Email
    {
        protected static $replace_place_array = array();
        function __construct()
        {
            $this->id = WLPR_PLUGIN_PREFIX . '_on_birth_gift_email';
            $this->customer_email = true;
            $this->title = __('Birthday Point Gift earned', WLPR_TEXT_DOMAIN);
            $this->description = __('This email is sent to the customer when they have birthday points', WLPR_TEXT_DOMAIN);
            $this->default_subject = __('You have earned birthday gift points.', WLPR_TEXT_DOMAIN);
            $this->default_heading = __('You have earned birthday gift points', WLPR_TEXT_DOMAIN);
            $this->template_html = 'emails/wlpr-birthday-gift-point.php';
            $this->template_plain = 'emails/plain/wlpr-birthday-gift-point.php';
            add_action('wlpr_after_add_earn_point',array($this,'sendBirthGiftEmail'),10,5);
            parent::__construct();
            $this->recipient = $this->get_option('recipient', get_option('admin_email'));
            $this->template_base = WLPR_PLUGIN_PATH . 'Templates/';

        }

        function sendBirthGiftEmail($user_email, $points, $event_type, $data, $order_id){
            if($event_type == 'on_birth_date' && !empty($user_email)){
                $user_email = sanitize_email($user_email);
                $this->recipient = $user_email;
                $ref_url = \Wlpr\App\Helpers\Loyalty::referral()->getReferralUrl('',$user_email);
                $short_codes = array(
                    '{wlpr_earn_point}' => $points,
                    '{wlpr_referral_url}' => $ref_url,
                    '{wlpr_total_earn_point}' => \Wlpr\App\Helpers\Loyalty::point()->getUsersPoints($user_email)
                );
                $short_codes = apply_filters( 'wlpr_birthday_point_mail_short_code', $short_codes );
                foreach ($short_codes as $short_code => $short_code_value){
                    $this->add_placeholder($short_code, $short_code_value);
                }
                $subject = $this->get_subject();//__('Reward point earned for order #', WLPR_TEXT_DOMAIN) . $order->get_order_number();
                $attachments = $this->get_attachments();
                if (empty($attachments)) {
                    $attachments = array();
                }
                if ($this->is_enabled()) {
                    $this->send($this->get_recipient(), $subject, $this->get_content(), $this->get_headers(), $attachments);
                }
            }
        }

        /**
         * Add placeholder
         * @param $find
         * @param $replace
         */
        function add_placeholder($find, $replace)
        {
            $index = array_search($find, $this->find, true);
            if ($index === false) {
                $this->find[] = $find;
                $this->replace[] = $replace;
            } else {
                $this->find[$index] = $find;
                $this->replace[$index] = $replace;
            }
            self::$replace_place_array[$find] = $replace;

        }

        /**
         * get_content_html function.
         *
         * @access public
         * @return string
         */
        function get_content_html() {
            self::$replace_place_array['email'] = $this;
            ob_start();
            wc_get_template($this->template_html,self::$replace_place_array,'',
                $this->template_base );
            $html = ob_get_clean();
            return $this->format_string($html);
        }

        /**
         * get_content_plain function.
         *
         * @access public
         * @return string
         */
        function get_content_plain() {
            self::$replace_place_array['email'] = $this;
            ob_start();
            wc_get_template( $this->template_plain,self::$replace_place_array,'',
                $this->template_base );
            $html = ob_get_clean();
            return $this->format_string($html);
        }

        function init_form_fields()
        {
            $this->form_fields = array(
                'enabled' => array(
                    'title' => __('Enable/Disable', WLPR_TEXT_DOMAIN),
                    'type' => 'checkbox',
                    'label' => __('Enable this email notification', WLPR_TEXT_DOMAIN),
                    'default' => 'yes',
                ),
                'subject' => array(
                    'title' => __('Subject', WLPR_TEXT_DOMAIN),
                    'type' => 'text',
                    'description' => sprintf(__('This controls the email subject line. Leave blank to use the default subject: <code>%s</code>.', WLPR_TEXT_DOMAIN), $this->subject),
                    'placeholder' => '',
                    'default' => $this->default_subject
                ),
                'heading' => array(
                    'title' => __('Email Heading', WLPR_TEXT_DOMAIN),
                    'type' => 'text',
                    'description' => sprintf(__('This controls the main heading contained within the email notification. Leave blank to use the default heading: <code>%s</code>.', WLPR_TEXT_DOMAIN), $this->heading),
                    'placeholder' => '',
                    'default' => $this->default_heading
                ),
                'email_type' => array(
                    'title' => __('Email type', WLPR_TEXT_DOMAIN),
                    'type' => 'select',
                    'description' => __('Choose which format of email to send.', WLPR_TEXT_DOMAIN),
                    'default' => 'html',
                    'class' => 'email_type',
                    'options' => array(
                        'plain' => __('Plain text', WLPR_TEXT_DOMAIN),
                        'html' => __('HTML', WLPR_TEXT_DOMAIN),
                        'multipart' => __('Multipart', WLPR_TEXT_DOMAIN),
                    )
                )
            );
        }
    }
}
