<?php
/**
 * Customizer Setup
 *  Heavily borrowed from rightpress Decorator
 */

use Wlpr\App\Helpers\Woocommerce;
use Wlpr\App\Models\Points;

if (!class_exists('WlprFull')) {
    class WlprFull
    {
        /**
         * @var null
         */
        private static $instance = null;
        private $short_code = array();

        /**
         * Instance Control
         */
        public static function get_instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        function set_short_code($shortcode)
        {
            $this->short_code = $shortcode;
        }

        function render($front_end = false)
        {

            $css = wc_get_template_html('wlpr_full_styles.php', array('front_end' => $front_end), '',
                WLPR_PLUGIN_PATH . 'App/Views/Launcher/');
            $css = apply_filters('wlpr_launcher_styles', $css, $this);

            $html = '<style type="text/css">' . $css . '</style>';
            $html .= $this->get_header_content($front_end);
            $html .= $this->get_body_content($front_end);
            $html .= $this->get_footer_content($front_end);
            $html = $this->process_short_code($html);
            return $html;
        }

        function process_short_code($html)
        {
            if (!empty($this->short_code) && !empty($this->short_code)) {
                foreach ($this->short_code as $code => $value) {
                    $html = str_replace($code, $value, $html);
                }
            }
            return $html;
        }

        function get_short_code_value($code){
            $short_code_value = '';
            if(isset($this->short_code[$code]) && !empty($this->short_code[$code])){
                $short_code_value = $this->short_code[$code];
            }
            return $short_code_value;
        }

        function get_body_content($front_end = false)
        {
            global $wpdb;
            /* Guest launcher */
            //signup card

            $enable_signup_card = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_card_enable', Wlpr_Settings::get_default_value('wlpr_launcher_card_enable'));
            $signup_heading = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_heading', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_heading'));
            $signup_content = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_content', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_content'));
            $signup_content = Woocommerce::getCleanHtml($signup_content);
            $signup_button_text = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_button_text', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_button_text'));
            $signup_button_url = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_button_url', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_button_url'));
            $signin_prefix_text = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_signin_prefix_text', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_signin_prefix_text'));
            $signin_link_text = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_signin_link_text', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_signin_link_text'));
            $signin_link_url = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_signup_signin_url', Wlpr_Settings::get_default_value('wlpr_launcher_guest_signup_signin_url'));
            //review card
            $enable_guest_review_card = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_review_card_enable', Wlpr_Settings::get_default_value('wlpr_launcher_card_enable'));
            $enable_product_review_display = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_product_display', Wlpr_Settings::get_default_value('wlpr_launcher_card_enable'));

            $review_heading = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_review_heading', Wlpr_Settings::get_default_value('wlpr_launcher_guest_review_heading'));
            $review_content = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_review_content', Wlpr_Settings::get_default_value('wlpr_launcher_guest_review_content'));
            $review_content = Woocommerce::getCleanHtml($review_content);
            $review_img = $this->full_image_url(Wlpr_Settings::get_custom_value('wlpr_launcher_guest_review_img', Wlpr_Settings::get_default_value('wlpr_launcher_review_img')));

            /* login launcher */
            //review card
            $point_setting = get_option('wlpr_settings');
            $enable_review_reward = (isset($point_setting['wlpr_enable_review_reward']) && !empty($point_setting['wlpr_enable_review_reward'])) ? $point_setting['wlpr_enable_review_reward'] : 'yes';

            $enable_login_review_card = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_card_enable', Wlpr_Settings::get_default_value('wlpr_launcher_card_enable'));
            $review_login_heading = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_heading', Wlpr_Settings::get_default_value('wlpr_launcher_login_review_heading'));
            $review_login_content = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_content', Wlpr_Settings::get_default_value('wlpr_launcher_login_review_content'));
            $review_login_content = Woocommerce::getCleanHtml($review_login_content);
            $login_review_link_text = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_link_text', Wlpr_Settings::get_default_value('wlpr_launcher_login_review_link_text'));

            $review_login_img = $this->full_image_url(Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_img', Wlpr_Settings::get_default_value('wlpr_launcher_review_img')));
            //birthday card
            $enable_login_birth_card = Wlpr_Settings::get_custom_value('wlpr_launcher_birth_date_enable', Wlpr_Settings::get_default_value('wlpr_launcher_card_enable'));
            $birth_login_heading = Wlpr_Settings::get_custom_value('wlpr_launcher_birth_date_heading', Wlpr_Settings::get_default_value('wlpr_launcher_birth_date_heading'));
            $birth_login_label = Wlpr_Settings::get_custom_value('wlpr_launcher_birth_date_label', Wlpr_Settings::get_default_value('wlpr_launcher_birth_date_label'));
            $birth_login_img = $this->full_image_url(Wlpr_Settings::get_custom_value('wlpr_launcher_birth_img', Wlpr_Settings::get_default_value('wlpr_launcher_birth_img')));
            $birth_date_save_text = Wlpr_Settings::get_custom_value('wlpr_launcher_birth_date_button_text', Wlpr_Settings::get_default_value('wlpr_launcher_birth_date_button_text'));
            $user = get_user_by('id', get_current_user_id());
            $user_email = '';
            if($front_end){
                if(isset($user->user_email)){
                    $user_email = sanitize_email($user->user_email);
                }
            }else{
                $user_email =  Wlpr_Customizer::opt( 'preview_customer' );
            }

            $review_product = array();
            if(!empty($user_email) && $enable_product_review_display == 'yes'){
                // Get last product
                $order = \Wlpr\App\Helpers\Loyalty::woocommerce()->get_order_by_bill_email($user_email);
                if(isset($order) && $order){
                    $items = $order->get_items('line_item');
                    foreach ($items as $item){
                        $product_id = 0;
                        if(isset($item['product_id']) && !empty($item['product_id'])){
                            $product_id = $item['product_id'];
                        }
                        $product = $item->get_product();
                        if(empty($product_id) && isset($product) && !empty($product)){
                            $product_id = $product->get_id();
                        }
                        $review_product[] = array(
                            'product_link' =>  apply_filters( 'woocommerce_loop_product_link', get_the_permalink($product_id), $product ),
                            'product_name' =>  get_the_title($product_id)
                        );
                    }
                }
            }
            $point_table = new Points();
            $point_where = $wpdb->prepare("user_email = %s", array($user_email));
            $user_point = $point_table->getWhere($point_where, '*', true);
            $birthday = (isset($user_point->birth_date) && !empty($user_point->birth_date)) ? $user_point->birth_date: '';

            //point card
            $point_login_heading = Wlpr_Settings::get_custom_value('wlpr_launcher_login_point_heading', Wlpr_Settings::get_default_value('wlpr_launcher_login_point_heading'));
            $point_login_content = Wlpr_Settings::get_custom_value('wlpr_launcher_login_point_content', Wlpr_Settings::get_default_value('wlpr_launcher_login_point_content'));
            //referral card
            $enable_login_referral_card = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referral_card_enable', Wlpr_Settings::get_default_value('wlpr_launcher_card_enable'));
            $referral_login_heading = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referral_heading', Wlpr_Settings::get_default_value('wlpr_launcher_login_referral_heading'));
            $referral_login_content = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referral_content', Wlpr_Settings::get_default_value('wlpr_launcher_login_referral_content'));
            $referral_login_content = Woocommerce::getCleanHtml($referral_login_content);
            $referral_login_img = $this->full_image_url(Wlpr_Settings::get_custom_value('wlpr_launcher_login_referral_img', Wlpr_Settings::get_default_value('wlpr_launcher_referral_img')));
            //referee card
            $enable_login_referee_card = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referee_card_enable', Wlpr_Settings::get_default_value('wlpr_launcher_card_enable'));
            $referee_login_heading = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referee_heading', Wlpr_Settings::get_default_value('wlpr_launcher_login_referee_heading'));
            $referee_login_content = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referee_content', Wlpr_Settings::get_default_value('wlpr_launcher_login_referee_content'));
            $referee_login_content = Woocommerce::getCleanHtml($referee_login_content);
            $referee_body_login_content = Wlpr_Settings::get_custom_value('wlpr_launcher_body_login_referee_content', Wlpr_Settings::get_default_value('wlpr_launcher_body_login_referee_content'));
            $referee_body_login_content = Woocommerce::getCleanHtml($referee_body_login_content);
            $referee_login_img = $this->full_image_url(Wlpr_Settings::get_custom_value('wlpr_launcher_login_referee_img', Wlpr_Settings::get_default_value('wlpr_launcher_referee_img')));
            $no_referral_code_message = Wlpr_Settings::get_custom_value('wlpr_launcher_login_no_referral_content', Wlpr_Settings::get_default_value('wlpr_launcher_login_no_referral_content'));
            $no_referral_code_message = Woocommerce::getCleanHtml($no_referral_code_message);
            //ordering
            $review_ordering = Wlpr_Settings::get_custom_value('wlpr_launcher_login_review_ordering', Wlpr_Settings::get_default_value('wlpr_launcher_login_review_ordering'));
            $birth_ordering = Wlpr_Settings::get_custom_value('wlpr_launcher_birth_date_ordering', Wlpr_Settings::get_default_value('wlpr_launcher_birth_date_ordering'));
            $referral_ordering = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referral_ordering', Wlpr_Settings::get_default_value('wlpr_launcher_login_referral_ordering'));
            $referee_ordering = Wlpr_Settings::get_custom_value('wlpr_launcher_login_referee_ordering', Wlpr_Settings::get_default_value('wlpr_launcher_login_referee_ordering'));
            $sort_card = array(
                'review' => $review_ordering,
                'birth' => $birth_ordering,
                'referral' => $referral_ordering,
                'referee' =>$referee_ordering
            );
            array_multisort ( $sort_card);
            $current_user = get_current_user_id();
            $referral_options = get_option('wlpr_referral', array());
            $facebook_app_id = (isset($referral_options['wlpr_fb_app_id']) && !empty($referral_options['wlpr_fb_app_id'])) ? $referral_options['wlpr_fb_app_id'] : '';
            $enable_referral = (isset($referral_options['wlpr_enable_referral']) && !empty($referral_options['wlpr_enable_referral'])) ? $referral_options['wlpr_enable_referral'] : 'yes';
            $referral_code = $this->get_short_code_value('{wlpr_referral_code}');

            $url = '{wlpr_referral_url}';
            $share_content = '{wlpr_share_content} ' . $url;
            $share_subject = '{wlpr_share_subject}';
            if (!empty($this->short_code) && !empty($this->short_code)) {
                foreach ($this->short_code as $code => $value) {
                    $url = str_replace($code, $value, $url);
                    $share_content = str_replace($code, $value, $share_content);
                    $share_subject = str_replace($code, $value, $share_subject);
                }
            }

            return wc_get_template_html(
                'wlpr_full.php',
                array(
                    'id' => 'wlpr_full',
                    'front_end' => $front_end,
                    'current_user' => $current_user,
                    'sort_card' => $sort_card,
                    /* Guest launcher */
                    'enable_signup_card' => $enable_signup_card,
                    'signup_heading' => $signup_heading,
                    'signup_content' => $signup_content,
                    'signup_button_text' => $signup_button_text,
                    'signup_button_url' => $signup_button_url,
                    'signin_prefix_text' => $signin_prefix_text,
                    'signin_link_text' => $signin_link_text,
                    'signin_link_url' => $signin_link_url,
                    'enable_guest_review_card' => $enable_guest_review_card,
                    'review_heading' => $review_heading,
                    'review_content' => $review_content,
                    'review_img' => $review_img,
                    /* Login launcher*/
                    'enable_login_review_card' => $enable_login_review_card,
                    'review_login_heading' => $review_login_heading,
                    'review_login_content' => $review_login_content,
                    'review_login_img' => $review_login_img,
                    'enable_review_reward' => $enable_review_reward,
                    'enable_product_review_display' => $enable_product_review_display,
                    'need_review_product' => $review_product,
                    'login_review_link_text' => $login_review_link_text,

                    'enable_login_birth_card' => $enable_login_birth_card,
                    'birth_login_heading' => $birth_login_heading,
                    'birth_login_label' => $birth_login_label,
                    'birth_login_img' => $birth_login_img,
                    'birthday' => $birthday,
                    'birth_date_save_text' => $birth_date_save_text,

                    'enable_login_referral_card' => $enable_login_referral_card,
                    'referral_login_heading' => $referral_login_heading,
                    'referral_login_content' => $referral_login_content,
                    'referral_login_img' => $referral_login_img,

                    'enable_login_referee_card' => $enable_login_referee_card,
                    'referee_login_img' => $referee_login_img,
                    'referee_login_heading' => $referee_login_heading,
                    'referee_login_content' => $referee_login_content,
                    'referee_body_login_content' => $referee_body_login_content,
                    /* Other */
                    'short_codes' => $this->short_code,
                    'referral_code' => $referral_code,
                    'no_referral_code_message' => $no_referral_code_message,
                    'enable_referral' => $enable_referral,
                    /* share */
                    'facebook_app_id' => $facebook_app_id,
                    'enable_facebook_share' => (isset($referral_options['wlpr_enable_facebook_share_point']) && !empty($referral_options['wlpr_enable_facebook_share_point'])) ? $referral_options['wlpr_enable_facebook_share_point']: 'yes',
                    'enable_twitter_share' => (isset($referral_options['wlpr_enable_twitter_share_point']) && !empty($referral_options['wlpr_enable_twitter_share_point'])) ? $referral_options['wlpr_enable_twitter_share_point']: 'yes',
                    'enable_email_share' => (isset($referral_options['wlpr_enable_email_share_point']) && !empty($referral_options['wlpr_enable_email_share_point'])) ? $referral_options['wlpr_enable_email_share_point']: 'yes',
                    'enable_whatsapp_share' => (isset($referral_options['wlpr_enable_whatsapp_share_point']) && !empty($referral_options['wlpr_enable_whatsapp_share_point'])) ? $referral_options['wlpr_enable_whatsapp_share_point']: 'yes',
                    'share_subject' => $share_subject,
                    'url' => $url,
                    'share_content' => $share_content
                ),
                '',
                WLPR_PLUGIN_PATH . 'App/Views/Launcher/'
            );
        }

        function get_footer_content($front_end = false)
        {
            return wc_get_template_html(
                'launcher_footer.php',
                array(
                    'id' => 'wlpr_full'
                ),
                '',
                WLPR_PLUGIN_PATH . 'App/Views/Launcher/'
            );
        }

        function full_image_url($header_img){
            if( (substr($header_img,0,7) == 'http://') || (substr($header_img,0,8) == 'https://') ) {
                return $header_img;
            }
            if(!empty($header_img)){
                if(!file_exists($header_img)){
                    $header_img = WLPR_PLUGIN_URL.$header_img;
                }
            }
            return $header_img;
        }

        function get_header_content($front_end = false)
        {
            //Guest
            $guest_header_content = Wlpr_Settings::get_custom_value('wlpr_launcher_guest_header_content',Wlpr_Customizer::opt('wlpr_launcher_guest_header_content'));
            $guest_header_content = Woocommerce::getCleanHtml($guest_header_content);
            $header_img = $this->full_image_url(Wlpr_Settings::get_custom_value('wlpr_launcher_header_image',Wlpr_Customizer::opt('wlpr_launcher_header_image')));
            if (empty($header_img)) {
                $header_img = WLPR_PLUGIN_URL . 'Assets/Images/wlpr_full/sign-up.png';
            }
            // Login
            $login_header_content = Wlpr_Settings::get_custom_value('wlpr_launcher_login_header_content',Wlpr_Customizer::opt('wlpr_launcher_login_header_content'));
            $login_header_content = Woocommerce::getCleanHtml($login_header_content);
            $current_user = get_current_user_id();
            return wc_get_template_html(
                'launcher_header.php',
                array(
                    'id' => 'wlpr_full',
                    'front_end' => $front_end,
                    'current_user' => $current_user,
                    'header_img' => $header_img,
                    //guest
                    'guest_header_content' => $guest_header_content,

                    // login
                    'login_header_content' => $login_header_content,
                ),
                '',
                WLPR_PLUGIN_PATH . 'App/Views/Launcher/'
            );
        }
    }
}