<?php
/**
 * Exit if accessed directly.
 */
if (!defined('ABSPATH')) {
    exit;
}
require_once WLPR_PLUGIN_PATH . 'App/Includes/Launcher/Settings.php';
require_once WLPR_PLUGIN_PATH . 'App/Includes/Launcher/Customizer.php';
require_once WLPR_PLUGIN_PATH . 'App/Includes/Launcher/Preview.php';
require_once WLPR_PLUGIN_PATH . 'App/Includes/Launcher/Designer.php';
if (!class_exists('Wlpr_Settings')) {
    /**
     * Customizer Settings
     */
    class Wlpr_Settings
    {
        /**
         * The panels for customizer.
         *
         * @var null
         */
        private static $panels = null;

        /**
         * The sections for customizer.
         *
         * @var null
         */
        private static $sections = null;

        /**
         * The settings for customizer.
         *
         * @var null
         */
        private static $settings = null;

        /**
         * The woo settings copy for customizer.
         *
         * @var null
         */
        private static $woo_copy_settings = null;

        /**
         * The woo settings for customizer.
         *
         * @var null
         */
        private static $woo_settings = null;

        /**
         * The default values for customizer.
         *
         * @var null
         */
        private static $default_values = null;

        /**
         * The order ids.
         *
         * @var null
         */
        private static $point_customers = null;
        /**
         * The available font options.
         *
         * @var array
         */
        public static $font_family_mapping = array(
            'helvetica' => '"Helvetica Neue", Helvetica, Roboto, Arial, sans-serif',
            'arial' => 'Arial, Helvetica, sans-serif',
            'arial_black' => '"Arial Black", Gadget, sans-serif',
            'courier' => '"Courier New", Courier, monospace',
            'impact' => 'Impact, Charcoal, sans-serif',
            'lucida' => '"Lucida Sans Unicode", "Lucida Grande", sans-serif',
            'palatino' => '"Palatino Linotype", "Book Antiqua", Palatino, serif',
            'georgia' => 'Georgia, serif',
        );

        /**
         * Get our prebuilt tempaltes.
         *
         * @var array
         */
        public static $prebuilt_templates_mapping = array(
            'wlpr_full' => array(
                'image' => 'Assets/Images/wlpr_full_template.png',
                'name' => 'Default Template'
            )
        );

        /**
         * Get our customizer panels
         *
         * @access public
         * @return array
         */
        public static function get_panels()
        {
            // Define panels.
            if (is_null(self::$panels)) {
                self::$panels = array(
                    // Guest card
                    'guest_card' => array(
                        'title' => __('Apperance for Guest User', WLPR_TEXT_DOMAIN),
                        'priority' => 10,
                    ),
                    // Guest card
                    'login_card' => array(
                        'title' => __('Appearance for Logged in User', WLPR_TEXT_DOMAIN),
                        'priority' => 10,
                    ),
                );
            }
            // Return panels.
            return self::$panels;
        }

        /**
         * Get our Customizer sections
         *
         * @access public
         * @return array
         */
        public static function get_sections()
        {
            // Define sections.
            if (is_null(self::$sections)) {
                self::$sections = array(
                    'template' => array(
                        'title' => __('Prebuilt Templates', WLPR_TEXT_DOMAIN),
                        'priority' => 8,
                    ),
                    'launcher_header' => array(
                        'title' => __('Launcher', WLPR_TEXT_DOMAIN),
                        'priority' => 9,
                    ),
                    // Header Image.
                    'guest_header' => array(
                        'title' => __('Header', WLPR_TEXT_DOMAIN),
                        'panel' => 'guest_card',
                        'priority' => 20,
                    ),
                    'guest_signup' => array(
                        'title' => __('Signup Card', WLPR_TEXT_DOMAIN),
                        'panel' => 'guest_card',
                        'priority' => 20,
                    ),
                    'guest_review' => array(
                        'title' => __('Review Card', WLPR_TEXT_DOMAIN),
                        'panel' => 'guest_card',
                        'priority' => 20,
                    ),
                    'login_sample' => array(
                        'title' => __('Sample Data', WLPR_TEXT_DOMAIN),
                        'panel' => 'login_card',
                        'priority' => 20,
                    ),
                    'login_header' => array(
                        'title' => __('Header', WLPR_TEXT_DOMAIN),
                        'panel' => 'login_card',
                        'priority' => 20,
                    ),
                    'login_review' => array(
                        'title' => __('Review Card', WLPR_TEXT_DOMAIN),
                        'panel' => 'login_card',
                        'priority' => 22,
                    ),
                    'login_referral' => array(
                        'title' => __('Referral Points Earning Card', WLPR_TEXT_DOMAIN),
                        'panel' => 'login_card',
                        'priority' => 21,
                    ),
                    'login_referee' => array(
                        'title' => __('Refer-a-friend card', WLPR_TEXT_DOMAIN),
                        'panel' => 'login_card',
                        'priority' => 20,
                    ),
                    'login_birth' => array(
                        'title' => __('Birthday card', WLPR_TEXT_DOMAIN),
                        'panel' => 'login_card',
                        'priority' => 20,
                    ),
                    // Custom Styles.
                    'custom_styles' => array(
                        'title' => __('Custom Styles', WLPR_TEXT_DOMAIN),
                        'priority' => 80,
                    ),
                    // Import_export.
                    'import_export' => array(
                        'title' => __('Import Export', WLPR_TEXT_DOMAIN),
                        'priority' => 90,
                    )
                );
            }
            // Return sections.
            return self::$sections;
        }

        /**
         * Get woocommerce settings that the plugin will allow editing of
         *
         * @access public
         * @return array
         */
        public static function get_woo_settings()
        {
            if (is_null(self::$woo_settings)) {
                $base_options = array();
                //header
                $base_options['wlpr_launcher_font_family'] = array(
                    'title'         => __( 'Launcher Font Family', WLPR_TEXT_DOMAIN ),
                    'section'       => 'launcher_header',
                    'default'       => Wlpr_Customizer::opt('wlpr_launcher_font_family'),
                    'live_method'   => 'css',
                    'type'          => 'select',
                    'choices'       => self::get_font_families(),
                    'selectors'     => array(
                        '#wlpr-launcher-box' => array( 'font-family' )
                    ),
                );
                // header background color
                $base_options['wlpr_launcher_header_background_color'] = array(
                    'title' => __('Header Background color', WLPR_TEXT_DOMAIN),
                    'section' => 'launcher_header',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_header_background_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-header' => array('background-color'),
                    ),
                );
                // header text color
                $base_options['wlpr_launcher_header_text_color'] = array(
                    'title' => __('Header Text color', WLPR_TEXT_DOMAIN),
                    'section' => 'launcher_header',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_header_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-header' => array('color'),
                        '.text' => array('color'),
                    ),
                );
                // Guest header img
                $base_options['wlpr_launcher_header_image'] = array(
                    'title' => __('Header Image', WLPR_TEXT_DOMAIN),
                    'control_type' => 'image',
                    'section' => 'launcher_header',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_header_image'),
                    'original' => '',
                    'transport' => 'postMessage',
                    'selectors' => array(
                        '#wlpr-guest-header-content img',
                        '#wlpr-login-header-content img',
                    ),
                );
                $base_options['wlpr_launcher_body_background_color'] = array(
                    'title' => __('Body Background Color', WLPR_TEXT_DOMAIN),
                    'section' => 'launcher_header',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_body_background_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-body-container' => array('background-color'),
                        '#wlpr-launcher-box' => array('background-color'),
                    ),
                );
                // Guest header content
                $base_options['wlpr_launcher_guest_header_content'] = array(
                    'title' => __('Header Content', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_header',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_header_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-guest-header-content #wlpr-launcher-header-text',
                    )
                );
                // Placeholder Info.
                $base_options['wlpr_launcher_guest_header_short_code'] = array(
                    'title'         => __( 'Available Short codes', WLPR_TEXT_DOMAIN ),
                    'section'       => 'guest_header',
                    'control_type'  => 'wlprinfoblock',
                    'priority'      => 50,
                    'description'   => '<code>{wlpr_points_label} - Point labels <br>{wlpr_site_title} - Site title <br>{wlpr_review_points} - Earn point when review product <br>{wlpr_signup_point} - Earn point when sign up <br>{wlpr_signin_url} - Login url <br>{wlpr_signup_url} - Signup url <br>{wlpr_customer_total_points} - Customer total point <br>{wlpr_customer_available_points_balance} - Customer total point balance <br>{wlpr_referral_earn_points} - Earn point when refer new friend <br>{wlpr_total_referral_point} - total earn point via referral <br>{wlpr_friend_earn_points} - Friend earn point <br>{wlpr_referral_code} - Referral code <br>{wlpr_referral_url} - refer your friend via referral url <br>{wlpr_logged_in_username} - Logged in username <br>{wlpr_birthday_point} - Birthday date update earn point <br>{wlpr_facebook_point} - facebook share point <br>{wlpr_twitter_point} - Twitter share point <br>{wlpr_email_point} - Email share point<br>{wlpr_whatsapp_point} - WhatsApp share point<br></code>',
                );
                // Signup card enable
                $base_options['wlpr_launcher_guest_signup_card_enable'] = array(
                    'title'         => __( 'Enable Signup Card', WLPR_TEXT_DOMAIN ),
                    'section'       => 'guest_signup',
                    'type'  => 'select',
                    'choices'       => array(
                        'yes' => __('Yes',WLPR_TEXT_DOMAIN),
                        'no' => __('No',WLPR_TEXT_DOMAIN)
                    ),
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_card_enable'),
                );
                // Placeholder Info.
                $base_options['wlpr_launcher_guest_signup_short_codes'] = array(
                    'title'         => __( 'Available Short codes', WLPR_TEXT_DOMAIN ),
                    'section'       => 'guest_signup',
                    'control_type'  => 'wlprinfoblock',
                    'priority'      => 50,
                    'description'   => '<code>{wlpr_points_label} - Point labels <br>{wlpr_site_title} - Site title <br>{wlpr_review_points} - Earn point when review product <br>{wlpr_signup_point} - Earn point when sign up <br>{wlpr_signin_url} - Login url <br>{wlpr_signup_url} - Signup url <br>{wlpr_customer_total_points} - Customer total point <br>{wlpr_customer_available_points_balance} - Customer total point balance <br>{wlpr_referral_earn_points} - Earn point when refer new friend <br>{wlpr_total_referral_point} - total earn point via referral <br>{wlpr_friend_earn_points} - Friend earn point <br>{wlpr_referral_code} - Referral code <br>{wlpr_referral_url} - refer your friend via referral url <br>{wlpr_logged_in_username} - Logged in username <br>{wlpr_birthday_point} - Birthday date update earn point <br>{wlpr_facebook_point} - facebook share point <br>{wlpr_twitter_point} - Twitter share point <br>{wlpr_email_point} - Email share point<br>{wlpr_whatsapp_point} - WhatsApp share point<br></code>',
                );
                //Guest signup heading
                $base_options['wlpr_launcher_guest_signup_heading'] = array(
                    'title' => __('Signup Heading', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_heading'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content h4',
                    )
                );
                //Guest signup content
                $base_options['wlpr_launcher_guest_signup_content'] = array(
                    'title' => __('Signup Content', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content p',
                    )
                );
                //Guest signup button text
                $base_options['wlpr_launcher_guest_signup_button_text'] = array(
                    'title' => __('Signup Button Text', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_button_text'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-signup-btn',
                    )
                );
                //Guest signup button url
                $base_options['wlpr_launcher_guest_signup_button_url'] = array(
                    'title' => __('Signup Button URL', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_button_url'),
                    'original' => '',
                    'live_method' => 'property',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-signup-btn' => array('href'),
                    )
                );
                //Guest signup button color
                $base_options['wlpr_launcher_guest_signup_button_color'] = array(
                    'title' => __('Signup Button Color', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_button_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-signup-btn' => array('background-color'),
                    ),
                );
                //Guest signup button text color
                $base_options['wlpr_launcher_guest_signup_button_text_color'] = array(
                    'title' => __('Signup Button Text Color', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_button_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-signup-btn' => array('color'),
                        '.text' => array('color'),
                    ),
                );
                //guest signup card text color
                $base_options['wlpr_launcher_guest_signup_text_color'] = array(
                    'title' => __('Signup Text Color', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_card_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content h4' => array('color'),
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content p' => array('color'),
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-signin-prefix-content' => array('color'),
                        '.text' => array('color'),
                    ),
                );

                //Guest signin prefix text
                $base_options['wlpr_launcher_guest_signup_signin_prefix_text'] = array(
                    'title' => __('Signin Prefix Text', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_signin_prefix_text'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-signin-prefix-content',
                    )
                );
                //Guest signin link text
                $base_options['wlpr_launcher_guest_signup_signin_link_text'] = array(
                    'title' => __('Signin Link Text', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_signin_link_text'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-sign-in',
                    )
                );
                //Guest signin link url
                $base_options['wlpr_launcher_guest_signup_signin_url'] = array(
                    'title' => __('Signin Url', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_signup_signin_url'),
                    'original' => '',
                    'live_method' => 'property',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card #wlpr-launcher-signup-content #wlpr-sign-in' => array('href'),
                    )
                );
                //Guest signup background color
                $base_options['wlpr_launcher_guest_signup_background_color'] = array(
                    'title' => __('Signup Background Color', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_signup',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_card_background_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-signup-card' => array('background-color'),
                    ),
                );
                //Guest review card enable
                $base_options['wlpr_launcher_guest_review_card_enable'] = array(
                    'title'         => __( 'Enable Review Card', WLPR_TEXT_DOMAIN ),
                    'section'       => 'guest_review',
                    'type'  => 'select',
                    'choices'       => array(
                        'yes' => __('Yes',WLPR_TEXT_DOMAIN),
                        'no' => __('No',WLPR_TEXT_DOMAIN)
                    ),
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_card_enable'),
                );
                // Placeholder Info.
                $base_options['wlpr_launcher_guest_review_short_codes'] = array(
                    'title'         => __( 'Available Short codes', WLPR_TEXT_DOMAIN ),
                    'section'       => 'guest_review',
                    'control_type'  => 'wlprinfoblock',
                    'priority'      => 50,
                    'description'   => '<code>{wlpr_points_label} - Point labels <br>{wlpr_site_title} - Site title <br>{wlpr_review_points} - Earn point when review product <br>{wlpr_signup_point} - Earn point when sign up <br>{wlpr_signin_url} - Login url <br>{wlpr_signup_url} - Signup url <br>{wlpr_customer_total_points} - Customer total point <br>{wlpr_customer_available_points_balance} - Customer total point balance <br>{wlpr_referral_earn_points} - Earn point when refer new friend <br>{wlpr_total_referral_point} - total earn point via referral <br>{wlpr_friend_earn_points} - Friend earn point <br>{wlpr_referral_code} - Referral code <br>{wlpr_referral_url} - refer your friend via referral url <br>{wlpr_logged_in_username} - Logged in username <br>{wlpr_birthday_point} - Birthday date update earn point <br>{wlpr_facebook_point} - facebook share point <br>{wlpr_twitter_point} - Twitter share point <br>{wlpr_email_point} - Email share point<br>{wlpr_whatsapp_point} - WhatsApp share point<br></code>',
                );
                //Guest review heading
                $base_options['wlpr_launcher_guest_review_heading'] = array(
                    'title' => __('Review Heading', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_review',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_review_heading'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-guest-review-card #wlpr-launcher-guest-review-content h4',
                    )
                );
                //Guest review content
                $base_options['wlpr_launcher_guest_review_content'] = array(
                    'title' => __('Review Content', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_review',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_review_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-guest-review-card #wlpr-launcher-guest-review-content p',
                    )
                );
                //Guest review img
                $base_options['wlpr_launcher_guest_review_img'] = array(
                    'title' => __('Review Image', WLPR_TEXT_DOMAIN),
                    'control_type' => 'image',
                    'section' => 'guest_review',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_review_img'),
                    'original' => '',
                    'transport' => 'postMessage',
                    'selectors' => array(
                        '#wlpr-launcher-guest-review-card #wlpr-launcher-guest-review-content img',
                    ),
                );
                //guest review card background
                $base_options['wlpr_launcher_guest_review_background_color'] = array(
                    'title' => __('Review Background Color', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_review',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_guest_card_background_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-guest-review-card' => array('background-color'),
                    ),
                );
                // guest review text color
                $base_options['wlpr_launcher_guest_review_text_color'] = array(
                    'title' => __('Review Text Color', WLPR_TEXT_DOMAIN),
                    'section' => 'guest_review',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_review_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-guest-review-card #wlpr-launcher-guest-review-content h4' => array('color'),
                        '#wlpr-launcher-guest-review-card #wlpr-launcher-guest-review-content p' => array('color'),
                        '.text' => array('color'),
                    ),
                );

                /* Login user */
                // Placeholder Info.
                $base_options['wlpr_launcher_login_header_short_codes'] = array(
                    'title'         => __( 'Available Short codes', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_header',
                    'control_type'  => 'wlprinfoblock',
                    'priority'      => 50,
                    'description'   => '<code>{wlpr_points_label} - Point labels <br>{wlpr_site_title} - Site title <br>{wlpr_review_points} - Earn point when review product <br>{wlpr_signup_point} - Earn point when sign up <br>{wlpr_signin_url} - Login url <br>{wlpr_signup_url} - Signup url <br>{wlpr_customer_total_points} - Customer total point <br>{wlpr_customer_available_points_balance} - Customer total point balance <br>{wlpr_referral_earn_points} - Earn point when refer new friend <br>{wlpr_total_referral_point} - total earn point via referral <br>{wlpr_friend_earn_points} - Friend earn point <br>{wlpr_referral_code} - Referral code <br>{wlpr_referral_url} - refer your friend via referral url <br>{wlpr_logged_in_username} - Logged in username <br>{wlpr_birthday_point} - Birthday date update earn point <br>{wlpr_facebook_point} - facebook share point <br>{wlpr_twitter_point} - Twitter share point <br>{wlpr_email_point} - Email share point<br>{wlpr_whatsapp_point} - WhatsApp share point<br></code>',
                );
                // login header content
                $base_options['wlpr_launcher_login_header_content'] = array(
                    'title' => __('Header Content', WLPR_TEXT_DOMAIN),
                    'section' => 'login_header',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_header_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-login-header-content #wlpr-launcher-login-text',
                    )
                );
                //login review card enable
                $base_options['wlpr_launcher_login_review_card_enable'] = array(
                    'title'         => __( 'Enable Review Card', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_review',
                    'type'  => 'select',
                    'choices'       => array(
                        'yes' => __('Yes',WLPR_TEXT_DOMAIN),
                        'no' => __('No',WLPR_TEXT_DOMAIN)
                    ),
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_card_enable'),
                );
                //login review card enable
                $base_options['wlpr_launcher_login_review_product_display'] = array(
                    'title'         => __( 'Purchased product display for review(Only display last purchase product)', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_review',
                    'type'  => 'select',
                    'choices'       => array(
                        'yes' => __('Yes',WLPR_TEXT_DOMAIN),
                        'no' => __('No',WLPR_TEXT_DOMAIN)
                    ),
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_card_enable'),
                );
                // Placeholder Info.
                $base_options['wlpr_launcher_login_review_short_codes'] = array(
                    'title'         => __( 'Available Short codes', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_review',
                    'control_type'  => 'wlprinfoblock',
                    'priority'      => 50,
                    'description'   => '<code>{wlpr_points_label} - Point labels <br>{wlpr_site_title} - Site title <br>{wlpr_review_points} - Earn point when review product <br>{wlpr_signup_point} - Earn point when sign up <br>{wlpr_signin_url} - Login url <br>{wlpr_signup_url} - Signup url <br>{wlpr_customer_total_points} - Customer total point <br>{wlpr_customer_available_points_balance} - Customer total point balance <br>{wlpr_referral_earn_points} - Earn point when refer new friend <br>{wlpr_total_referral_point} - total earn point via referral <br>{wlpr_friend_earn_points} - Friend earn point <br>{wlpr_referral_code} - Referral code <br>{wlpr_referral_url} - refer your friend via referral url <br>{wlpr_logged_in_username} - Logged in username <br>{wlpr_birthday_point} - Birthday date update earn point <br>{wlpr_facebook_point} - facebook share point <br>{wlpr_twitter_point} - Twitter share point <br>{wlpr_email_point} - Email share point<br>{wlpr_whatsapp_point} - WhatsApp share point<br></code>',
                );
                //review ordering
                $base_options['wlpr_launcher_login_review_ordering'] = array(
                    'title' => __('Review Card Ordering', WLPR_TEXT_DOMAIN),
                    'section' => 'login_review',
                    'type' => 'select',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_review_ordering'),
                    'original' => '',
                    'choices'       => array(
                        '1'        => __( 'First', WLPR_TEXT_DOMAIN ),
                        '2'        => __( 'Second', WLPR_TEXT_DOMAIN ),
                        '3'        => __( 'Third', WLPR_TEXT_DOMAIN ),
                    ),
                );
                //review  heading
                $base_options['wlpr_launcher_login_review_heading'] = array(
                    'title' => __('Review Heading', WLPR_TEXT_DOMAIN),
                    'section' => 'login_review',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_review_heading'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-review-card #wlpr-launcher-login-review-content h4',
                    )
                );
                // content
                $base_options['wlpr_launcher_login_review_content'] = array(
                    'title' => __('Review Content', WLPR_TEXT_DOMAIN),
                    'section' => 'login_review',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_review_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-review-card #wlpr-launcher-login-review-content p',
                    )
                );
                //review image
                $base_options['wlpr_launcher_login_review_img'] = array(
                    'title' => __('Review Image', WLPR_TEXT_DOMAIN),
                    'control_type' => 'image',
                    'section' => 'login_review',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_review_img'),
                    'original' => '',
                    'transport' => 'postMessage', //refresh
                    'selectors' => array(
                        '#wlpr-launcher-login-review-card #wlpr-launcher-login-review-content img',
                    ),
                );
                // review background color
                $base_options['wlpr_launcher_login_review_background_color'] = array(
                    'title' => __('Review Background Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_review',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_card_background_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-review-card' => array('background-color'),
                    ),
                );
                // review text color
                $base_options['wlpr_launcher_login_review_text_color'] = array(
                    'title' => __('Review Text Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_review',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_review_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-review-card #wlpr-launcher-login-review-content h4' => array('color'),
                        '#wlpr-launcher-login-review-card #wlpr-launcher-login-review-content p' => array('color'),
                        '#wlpr-launcher-login-review-card #wlpr-launcher-login-review-content .review-card' => array('color'),
                        '.text' => array('color'),
                    ),
                );

                $base_options['wlpr_launcher_login_review_link_text'] = array(
                    'title' => __('Review Link Text', WLPR_TEXT_DOMAIN),
                    'section' => 'login_review',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_review_link_text'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-review-card .review-link a',
                    )
                );

                $base_options['wlpr_launcher_login_review_link_text_color'] = array(
                    'title' => __('Review Link Text Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_review',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_review_link_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-review-card .review-link a' => array('color'),
                        '.text' => array('color'),
                    ),
                );

                //birthday card
                // Birthday date enable
                $base_options['wlpr_launcher_birth_date_enable'] = array(
                    'title' => __('Enable/Disable Birthday Date Card', WLPR_TEXT_DOMAIN),
                    'section' => 'login_birth',
                    'type'  => 'select',
                    'choices'       => array(
                        'yes' => __('Yes',WLPR_TEXT_DOMAIN),
                        'no' => __('No',WLPR_TEXT_DOMAIN)
                    ),
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_card_enable'),
                );
                //birthday ordering
                $base_options['wlpr_launcher_birth_date_ordering'] = array(
                    'title' => __('Birthday Card Ordering', WLPR_TEXT_DOMAIN),
                    'section' => 'login_birth',
                    'type' => 'select',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_birth_date_ordering'),
                    'original' => '',
                    'choices'       => array(
                        '1'        => __( 'First', WLPR_TEXT_DOMAIN ),
                        '2'        => __( 'Second', WLPR_TEXT_DOMAIN ),
                        '3'        => __( 'Third', WLPR_TEXT_DOMAIN ),
                        '4'        => __( 'Four', WLPR_TEXT_DOMAIN ),
                    ),
                );
                //birthday  heading
                $base_options['wlpr_launcher_birth_date_heading'] = array(
                    'title' => __('Birthday card Heading', WLPR_TEXT_DOMAIN),
                    'section' => 'login_birth',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_birth_date_heading'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-birth-card #wlpr-launcher-login-birth-content h4',
                    )
                );
                //birthday  content
                $base_options['wlpr_launcher_birth_date_label'] = array(
                    'title' => __('Birthday Card Label', WLPR_TEXT_DOMAIN),
                    'section' => 'login_birth',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_birth_date_label'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-birth-card #wlpr-launcher-login-birth-content p',
                    )
                );
                //birthday  button text
                $base_options['wlpr_launcher_birth_date_button_text'] = array(
                    'title' => __('Birthday Button Text', WLPR_TEXT_DOMAIN),
                    'section' => 'login_birth',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_birth_date_button_text'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-birth-card #wlpr-birthday-save-button',
                    )
                );
                //birthday button color
                $base_options['wlpr_launcher_birthday_button_color'] = array(
                    'title' => __('Birthday Button Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_birth',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_birthday_button_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-birth-card .wlpr-birth-save-button' => array('background-color'),
                    ),
                );
                //birthday button text color
                $base_options['wlpr_launcher_birthday_button_text_color'] = array(
                    'title' => __('Birthday Button Text Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_birth',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_birthday_button_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-birth-card .wlpr-birth-save-button' => array('color'),
                        '.text' => array('color'),
                    ),
                );
                //birthday image
                $base_options['wlpr_launcher_birth_img'] = array(
                    'title' => __('Birthday Image', WLPR_TEXT_DOMAIN),
                    'control_type' => 'image',
                    'section' => 'login_birth',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_birth_img'),
                    'original' => '',
                    'transport' => 'postMessage',
                    'selectors' => array(
                        '#wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content img',
                    ),
                );
                // Placeholder Info.
                $base_options['wlpr_launcher_login_birth_short_codes'] = array(
                    'title'         => __( 'Available Short codes', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_birth',
                    'control_type'  => 'wlprinfoblock',
                    'priority'      => 50,
                    'description'   => '<code>{wlpr_points_label} - Point labels <br>{wlpr_site_title} - Site title <br>{wlpr_review_points} - Earn point when review product <br>{wlpr_signup_point} - Earn point when sign up <br>{wlpr_signin_url} - Login url <br>{wlpr_signup_url} - Signup url <br>{wlpr_customer_total_points} - Customer total point <br>{wlpr_customer_available_points_balance} - Customer total point balance <br>{wlpr_referral_earn_points} - Earn point when refer new friend <br>{wlpr_total_referral_point} - total earn point via referral <br>{wlpr_friend_earn_points} - Friend earn point <br>{wlpr_referral_code} - Referral code <br>{wlpr_referral_url} - refer your friend via referral url <br>{wlpr_logged_in_username} - Logged in username <br>{wlpr_birthday_point} - Birthday date update earn point <br>{wlpr_facebook_point} - facebook share point <br>{wlpr_twitter_point} - Twitter share point <br>{wlpr_email_point} - Email share point<br>{wlpr_whatsapp_point} - WhatsApp share point<br></code>',
                );
                // referral card
                //login referral card enable
                $base_options['wlpr_launcher_login_referral_card_enable'] = array(
                    'title'         => __( 'Enable Referral Card', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_referral',
                    'type'  => 'select',
                    'choices'       => array(
                        'yes' => __('Yes',WLPR_TEXT_DOMAIN),
                        'no' => __('No',WLPR_TEXT_DOMAIN)
                    ),
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_card_enable'),
                );
                // Placeholder Info.
                $base_options['wlpr_launcher_login_referral_short_codes'] = array(
                    'title'         => __( 'Available Short codes', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_referral',
                    'control_type'  => 'wlprinfoblock',
                    'priority'      => 50,
                    'description'   => '<code>{wlpr_points_label} - Point labels <br>{wlpr_site_title} - Site title <br>{wlpr_review_points} - Earn point when review product <br>{wlpr_signup_point} - Earn point when sign up <br>{wlpr_signin_url} - Login url <br>{wlpr_signup_url} - Signup url <br>{wlpr_customer_total_points} - Customer total point <br>{wlpr_customer_available_points_balance} - Customer total point balance <br>{wlpr_referral_earn_points} - Earn point when refer new friend <br>{wlpr_total_referral_point} - total earn point via referral <br>{wlpr_friend_earn_points} - Friend earn point <br>{wlpr_referral_code} - Referral code <br>{wlpr_referral_url} - refer your friend via referral url <br>{wlpr_logged_in_username} - Logged in username <br>{wlpr_birthday_point} - Birthday date update earn point <br>{wlpr_facebook_point} - facebook share point <br>{wlpr_twitter_point} - Twitter share point <br>{wlpr_email_point} - Email share point<br>{wlpr_whatsapp_point} - WhatsApp share point<br></code>',
                );
                //referral ordering
                $base_options['wlpr_launcher_login_referral_ordering'] = array(
                    'title' => __('Referral Card Ordering', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referral',
                    'type' => 'select',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_referral_ordering'),
                    'original' => '',
                    'choices'       => array(
                        '1'        => __( 'First', WLPR_TEXT_DOMAIN ),
                        '2'        => __( 'Second', WLPR_TEXT_DOMAIN ),
                        '3'        => __( 'Third', WLPR_TEXT_DOMAIN ),
                    ),
                );
                //referral  heading
                $base_options['wlpr_launcher_login_referral_heading'] = array(
                    'title' => __('Referral Heading', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referral',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_referral_heading'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content h4',
                    )
                );
                //referral content
                $base_options['wlpr_launcher_login_referral_content'] = array(
                    'title' => __('Referral Content', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referral',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_referral_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content p',
                    )
                );
                //referral image
                $base_options['wlpr_launcher_login_referral_img'] = array(
                    'title' => __('Referral Image', WLPR_TEXT_DOMAIN),
                    'control_type' => 'image',
                    'section' => 'login_referral',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_referral_img'),
                    'original' => '',
                    'transport' => 'postMessage',
                    'selectors' => array(
                        '#wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content img',
                    ),
                );
                // referral background color
                $base_options['wlpr_launcher_login_referral_background_color'] = array(
                    'title' => __('Referral Background Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referral',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_card_background_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-referral-card' => array('background-color'),
                    ),
                );
                // referral text color
                $base_options['wlpr_launcher_login_referral_text_color'] = array(
                    'title' => __('Referral Text Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referral',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_referral_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content h4' => array('color'),
                        '#wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content p' => array('color'),
                        '.text' => array('color'),
                    ),
                );

                //login_referee
                //login referee card enable
                $base_options['wlpr_launcher_login_referee_card_enable'] = array(
                    'title'         => __( 'Enable Card', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_referee',
                    'type'  => 'select',
                    'choices'       => array(
                        'yes' => __('Yes',WLPR_TEXT_DOMAIN),
                        'no' => __('No',WLPR_TEXT_DOMAIN)
                    ),
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_card_enable'),
                );
                // Placeholder Info.
                $base_options['wlpr_launcher_login_referee_short_codes'] = array(
                    'title'         => __( 'Available Short codes', WLPR_TEXT_DOMAIN ),
                    'section'       => 'login_referee',
                    'control_type'  => 'wlprinfoblock',
                    'priority'      => 50,
                    'description'   => '<code>{wlpr_points_label} - Point labels <br>{wlpr_site_title} - Site title <br>{wlpr_review_points} - Earn point when review product <br>{wlpr_signup_point} - Earn point when sign up <br>{wlpr_signin_url} - Login url <br>{wlpr_signup_url} - Signup url <br>{wlpr_customer_total_points} - Customer total point <br>{wlpr_customer_available_points_balance} - Customer total point balance <br>{wlpr_referral_earn_points} - Earn point when refer new friend<br>{wlpr_referee_discount} - Friend earn discount <br>{wlpr_total_referral_point} - total earn point via referral <br>{wlpr_friend_earn_points} - Friend earn point <br>{wlpr_referral_code} - Referral code <br>{wlpr_referral_url} - refer your friend via referral url <br>{wlpr_logged_in_username} - Logged in username <br>{wlpr_birthday_point} - Birthday date update earn point <br>{wlpr_facebook_point} - facebook share point <br>{wlpr_twitter_point} - Twitter share point <br>{wlpr_email_point} - Email share point<br>{wlpr_whatsapp_point} - WhatsApp share point<br></code>',
                );
                //referee ordering
                $base_options['wlpr_launcher_login_referee_ordering'] = array(
                    'title' => __('Card Ordering', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referee',
                    'type' => 'select',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_referee_ordering'),
                    'original' => '',
                    'choices'       => array(
                        '1'        => __( 'First', WLPR_TEXT_DOMAIN ),
                        '2'        => __( 'Second', WLPR_TEXT_DOMAIN ),
                        '3'        => __( 'Third', WLPR_TEXT_DOMAIN ),
                    ),
                );
                //referee  heading
                $base_options['wlpr_launcher_login_referee_heading'] = array(
                    'title' => __('Heading', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referee',
                    'type' => 'text',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_referee_heading'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-referee-card #wlpr-launcher-login-referee-content h4',
                    )
                );
                //referee content
                $base_options['wlpr_launcher_login_referee_content'] = array(
                    'title' => __('Content', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referee',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_referee_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-referee-card #wlpr-launcher-login-referee-content p',
                    )
                );
                //referee
                $base_options['wlpr_launcher_body_login_referee_content'] = array(
                    'title' => __('Body Content', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referee',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_body_login_referee_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-referee-card #wlpr_launcher_body_referee_content',
                    )
                );
                // no referral url content
                $base_options['wlpr_launcher_login_no_referral_content'] = array(
                    'title' => __('Content for When Customer don\'t have referral url', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referee',
                    'type' => 'textarea',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_no_referral_content'),
                    'original' => '',
                    'live_method' => 'replace',
                    'selectors' => array(
                        '#wlpr-launcher-login-referee-card #wlpr_launcher_body_no_referral_content',
                    )
                );
                //referee img
                $base_options['wlpr_launcher_login_referee_img'] = array(
                    'title' => __('Image', WLPR_TEXT_DOMAIN),
                    'control_type' => 'image',
                    'section' => 'login_referee',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_referee_img'),
                    'original' => '',
                    'transport' => 'postMessage',
                    'selectors' => array(
                        '#wlpr-launcher-login-referee-card #wlpr-launcher-login-referee-content img',
                    ),
                );
                // referee background color
                $base_options['wlpr_launcher_login_referee_background_color'] = array(
                    'title' => __('Background Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referee',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_login_card_background_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-referee-card' => array('background-color'),
                    ),
                );
                // referral text color
                $base_options['wlpr_launcher_login_referee_text_color'] = array(
                    'title' => __('Text Color', WLPR_TEXT_DOMAIN),
                    'section' => 'login_referee',
                    'control_type' => 'color',
                    'default' => Wlpr_Customizer::opt('wlpr_launcher_referee_text_color'),
                    'live_method' => 'css',
                    'selectors' => array(
                        '#wlpr-launcher-login-referee-card #wlpr-launcher-login-referee-content h4' => array('color'),
                        '#wlpr-launcher-login-referee-card #wlpr-launcher-login-referee-content p' => array('color'),
                        '#wlpr-launcher-login-referee-card h6' => array('color'),
                        '#wlpr-launcher-login-referee-card .wlpr-icon-list' => array('color'),
                        '.text' => array('color'),
                    ),
                );
                $email_text = array();
                self::$woo_settings = array_merge($base_options, $email_text);
            }
            return self::$woo_settings;
        }

        /**
         * Get our extra settings
         *
         * @access public
         * @return array
         */
        public static function get_settings()
        {
            // Define settings
            if (is_null(self::$settings)) {
                // Main Base options.
                //wlpr_launcher_launcher_load_template wlpr_full image-radio-select-item wlpr-active
                $mainoptions = array(
                    // Email template
                    'launcher_load_template' => array(
                        'title' => __('Template_load', WLPR_TEXT_DOMAIN),
                        'section' => 'template',
                        'control_type' => 'wlprtemplateload',
                        'choices' => self::get_template_options(),
                        'default' => get_option('wlpr_active_template','wlpr_full'),
                        'transport' => 'refresh',
                    ),
                    // Preview Order Id.
                    'preview_customer' => array(
                        'title' => __('Preview Point User', WLPR_TEXT_DOMAIN),
                        'section' => 'login_sample',
                        'type' => 'select',
                        'priority' => 1,
                        'choices' => self::get_point_customers(),
                        'default' => self::get_default_value('preview_point_user_id'),
                    ),
                    'preview_customer_button' => array(
                        'title' => __('Preview Point User', WLPR_TEXT_DOMAIN),
                        'section' => 'login_sample',
                        'type' => 'button',
                        'priority' => 1,
                        'default' => 'Load Sample'

                    )
                );
                $extra_email_text = array();
                $main = array(
                    'custom_css' => array(
                        'title' => __('Custom CSS', WLPR_TEXT_DOMAIN),
                        'section' => 'custom_styles',
                        'default' => '',
                        'type' => 'textarea',
                        'live_method' => 'replace',
                        'original' => '',
                        'selectors' => array(
                            'style#wlpr_designer_custom_css',
                        ),
                    ),
                    'import_export' => array(
                        'title' => __('Import Export', WLPR_TEXT_DOMAIN),
                        'section' => 'import_export',
                        'default' => '',
                        'control_type' => 'wlprimportexport',
                    )
                );
                $mainoptions = array_merge($mainoptions, $main);
                self::$settings = array_merge($extra_email_text, $mainoptions);
            }
            // Return settings
            return self::$settings;
        }

        /**
         * Get default values
         *
         * @access public
         * @return array
         */
        public static function get_default_values()
        {
            // Define default values
            if (is_null(self::$default_values)) {
                $default_values = array(
                    'wlpr_launcher_guest_header_content' => 'Welcome to <br> <span class="agent"> My Rewards</span>',
                    'wlpr_launcher_guest_signup_heading' => 'Become a Member',
                    'wlpr_launcher_guest_signup_content' => 'Join our loyalty program to unlock exclusive perks and rewards.',
                    'wlpr_launcher_guest_signup_button_text' => 'Join Now',
                    'wlpr_launcher_guest_signup_button_url' => '{wlpr_signup_url}',
                    'wlpr_launcher_guest_signup_button_color' => '#353d9f',
                    'wlpr_launcher_guest_signup_button_text_color' => '#f9f9f9',
                    'wlpr_launcher_guest_card_text_color' => '#444',
                    'wlpr_launcher_guest_signup_signin_prefix_text' => 'Already have an account?',
                    'wlpr_launcher_guest_signup_signin_link_text' => 'Sign in',
                    'wlpr_launcher_guest_signup_signin_url' => '{wlpr_signin_url}',
                    'wlpr_launcher_guest_card_background_color' => '#f9f9f9',
                    'wlpr_launcher_guest_review_heading' => 'Review Product',
                    'wlpr_launcher_guest_review_content' => 'Review and earn <strong>{wlpr_review_points}</strong> {wlpr_points_label}!',
                    /* login launcher */
                    'wlpr_launcher_login_header_content' => '<span>Your Points</span> <br> <span class="agent">{wlpr_customer_total_points}</span>',
                    'wlpr_launcher_login_review_heading' => 'Review Product',
                    'wlpr_launcher_login_review_content' => 'Review and earn <strong>{wlpr_review_points}</strong> {wlpr_points_label}!',
                    'wlpr_launcher_login_referral_heading' => 'Your Referral Rewards',
                    'wlpr_launcher_login_referral_content' => '{wlpr_total_referral_point} points earned',
                    'wlpr_launcher_login_referee_heading' => 'Refer your friends',
                    'wlpr_launcher_login_referee_content' => 'You can earn {wlpr_referral_earn_points} points.',
                    'wlpr_launcher_body_login_referee_content' => 'Share this URL to your friends. Your friends get {wlpr_friend_earn_points} bonus points on their first purchase and you will get {wlpr_referral_earn_points} points.',
                    'wlpr_launcher_login_no_referral_content' => 'Make an order to get the Referral link and about how to earn Referral points.',
                    'wlpr_launcher_login_review_ordering' => 1,
                    'wlpr_launcher_login_referral_ordering' => 2,
                    'wlpr_launcher_login_referee_ordering' => 3,
                    /* common */
                    'wlpr_launcher_review_img' => WLPR_PLUGIN_URL.'Assets/Images/wlpr_full/actions.png',
                    'wlpr_launcher_referral_img' => WLPR_PLUGIN_URL.'Assets/Images/wlpr_full/referrals.png',
                    'wlpr_launcher_referee_img' => WLPR_PLUGIN_URL.'Assets/Images/wlpr_full/actions.png',
                    'wlpr_launcher_header_image' => WLPR_PLUGIN_URL.'Assets/Images/wlpr_full/sign-up.png',
                    'wlpr_launcher_review_text_color' => '#444',
                    'wlpr_launcher_login_review_link_text' => 'Review',
                    'wlpr_launcher_login_review_link_text_color' => '#353d9f',

                    'wlpr_launcher_login_card_background_color' => '#f9f9f9',
                    'wlpr_launcher_header_background_color' => '#353d9f',
                    'wlpr_launcher_header_text_color' => '#f9f9f9',
                    'wlpr_launcher_referral_text_color' => '#444',
                    'wlpr_launcher_referee_text_color' => '#444',
                    'wlpr_launcher_body_background_color' => '#f9f9f9',

                    'wlpr_launcher_font_family' => 'helvetica',

                    'launcher_text' => 'My Rewards',
                    'launcher_position' => 'right',
                    'wlpr_launcher_card_enable' => 'yes',

                    'wlpr_launcher_birth_date_ordering' => 2,
                    'wlpr_launcher_birth_date_heading' => 'Birthday Rewards',
                    'wlpr_launcher_birth_date_label' => 'Enter Birthday Date',
                    'wlpr_launcher_birth_img' => WLPR_PLUGIN_URL.'Assets/Images/wlpr_full/sign-up.png',
                    'wlpr_launcher_birth_date_button_text' => 'Save',
                    'wlpr_launcher_birthday_button_color' => '#353d9f',
                    'wlpr_launcher_birthday_button_text_color' => '#f9f9f9',


                );
                self::$default_values = apply_filters('wlpr_launcher_email_settings_default_values', $default_values);
            }
            // Return default values.
            return self::$default_values;
        }

        /**
         * Get default values
         *
         * @access public
         * @param string $key the setting key.
         * @return string
         */
        public static function get_default_value($key)
        {
            // Get default values.
            $default_values = self::get_default_values();
            // Check if such key exists and return default value.
            return isset($default_values[$key]) ? $default_values[$key] : '';
        }

        public static function get_custom_value($key,$default = ''){
            $value = get_option($key,$default);
            if(empty($value)){
                $value = $default;
            }
            return __($value,WLPR_TEXT_DOMAIN);
        }

        /**
         * Get border styles
         *
         * @access public
         * @return array
         */
        public static function get_border_styles()
        {
            return array(
                'none' => __('none', WLPR_TEXT_DOMAIN),
                'hidden' => __('hidden', WLPR_TEXT_DOMAIN),
                'dotted' => __('dotted', WLPR_TEXT_DOMAIN),
                'dashed' => __('dashed', WLPR_TEXT_DOMAIN),
                'solid' => __('solid', WLPR_TEXT_DOMAIN),
                'double' => __('double', WLPR_TEXT_DOMAIN),
                'groove' => __('groove', WLPR_TEXT_DOMAIN),
                'ridge' => __('ridge', WLPR_TEXT_DOMAIN),
                'inset' => __('inset', WLPR_TEXT_DOMAIN),
                'outset' => __('outset', WLPR_TEXT_DOMAIN),
            );
        }

        /**
         * Get text align options
         *
         * @access public
         * @return array
         */
        public static function get_text_aligns()
        {
            return array(
                'left' => __('Left', WLPR_TEXT_DOMAIN),
                'center' => __('Center', WLPR_TEXT_DOMAIN),
                'right' => __('Right', WLPR_TEXT_DOMAIN),
                'justify' => __('Justify', WLPR_TEXT_DOMAIN),
            );
        }

        /**
         * Get image align options
         *
         * @access public
         * @return array
         */
        public static function get_image_aligns()
        {
            return array(
                'left' => __('Left', WLPR_TEXT_DOMAIN),
                'center' => __('Center', WLPR_TEXT_DOMAIN),
                'right' => __('Right', WLPR_TEXT_DOMAIN),
            );
        }

        /**
         * Get Customer list
         *
         * @access public
         * @return array
         */
        public static function get_point_customers()
        {
            if (is_null(self::$point_customers)) {
                $user_array = array();
                $user_array['0'] = __('Loyalty Customer', WLPR_TEXT_DOMAIN);
                $point_model = new \Wlpr\App\Models\Points();
                $where = 'id > 0 LIMIT 10';
                $point_users = $point_model->getWhere($where, '*', false);
                if (!empty($point_users)) {
                    foreach ($point_users as $point_user) {
                        $user_array[$point_user->user_email] = $point_user->user_email;
                    }
                }
                self::$point_customers = $user_array;
            }
            return self::$point_customers;
        }

        /**
         * Get font families
         *
         * @access public
         * @return array
         */
        public static function get_font_families()
        {
            return apply_filters('wlpr_launcher_font_families', self::$font_family_mapping);
        }

        /**
         * Get Email Templates
         *
         * @access public
         * @return array
         */
        public static function get_launcher_templates()
        {
            return apply_filters('wlpr_launcher_prebuilt_templates_settings', self::$prebuilt_templates_mapping);
        }

        public static function get_template_options()
        {
            $templates = self::get_launcher_templates();
            $templates_option = array();
            foreach ($templates as $template_key => $template_value) {
                $templates_option[$template_key] = $template_value['image'];
            }
            return $templates_option;
        }

    }
}
