<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
/**
 * Customizer Setup
 * Heavily borrowed from rightpress Decorator
 */
if ( ! class_exists( 'Wlpr_Preview' ) ) {
    /**
     * Customizer Preview Setup
     */
    class Wlpr_Preview {
        public static $launcher_class_name  = array(
            'wlpr_full' => array(
                'class' => 'WlprFull',
                'file_path' => 'App/Includes/Launcher/Template/WlprFull'
            )
        );
        /**
         * @var null
         */
        private static $instance = null;

        /**
         * Instance Control
         */
        public static function get_instance() {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self();
            }
            return self::$instance;
        }

        /**
         * Class constructor
         *
         * @access public
         */
        public function __construct() {
            $input_helper = new \Wlpr\App\Helpers\Input();
            $wlpr_launcher_preview_input = (string)$input_helper->post_get('wlpr-launcher-preview','');
            if(isset($wlpr_launcher_preview_input) && !empty($wlpr_launcher_preview_input)){
                // Set up preview.
                add_action( 'parse_request', array( $this, 'set_up_preview' ) );
                add_filter( 'customize_previewable_devices', array($this,'preview_device'));
                add_action( 'customize_preview_init', array( $this, 'init_preview' ) );
            }
        }
        function init_preview(){
            $partials = array();
            $exports = array(
                'partials'       => $partials
            );

            // Export data to JS.
            echo sprintf( '<script>var _customizePartialRefreshExports = %s;</script>', wp_json_encode( $exports ) );
        }
        public function preview_device($devices){
            $devices = array();
            return $devices;
        }
        public static function front_end_view(){
            $content = self::get_preview_launcher(true);
            $html = '';
            if ( ! empty( $content ) ) {
                $html = $content;
            }
            return $html;
        }

        /**
         * Set up preview
         *
         * @access public
         * @return void
         */
        public function set_up_preview() {
            // Make sure this is own preview request.
            if ( ! Wlpr_Designer::is_own_preview_request() ) {
                return;
            }
            // Load main view.
            include WLPR_PLUGIN_PATH . 'App/Views/Launcher/preview.php';

            // Do not load any further elements.
            exit;
        }

        /**
         * Get the email class name
         *
         * @param string $email_template the email template slug.
         */
        public static function get_launcher_class_name( $launcher_template ) {
            $class_names = apply_filters( 'wlpr_launcher_type_class_name_array', self::$launcher_class_name );
            if ( isset( $class_names[ $launcher_template ] ) ) {
                return $class_names[ $launcher_template ];
            } else {
                return false;
            }
        }
        /**
         * Get the email content
         *
         */
        public static function get_preview_launcher( $front_end = false ) {
            $id = get_current_user_id();
            $preview_point_email = '';
            if($front_end){
                $launcher_template = get_option('wlpr_active_template','wlpr_full');
                if(!empty($id)){
                    $email = get_user_by('id',get_current_user_id())->user_email;
                    if(!empty($email)){
                        $preview_point_email =  $email;
                    }
                }

            }else{
                $launcher_template = Wlpr_Customizer::opt( 'launcher_load_template' );
                $preview_point_email =  Wlpr_Customizer::opt( 'preview_customer' );
            }

            $launcher_class_data = self::get_launcher_class_name($launcher_template);

            if ( empty($launcher_class_data) ) {
                return false;
            }
            if(empty($preview_point_email)){
                $point_data = self::get_point_preview_data();
            }else{
                $point_data = self::get_point_preview_data($preview_point_email);
            }
            $content = false;
            if(!empty($launcher_class_data) && !empty($point_data)){
                require_once WLPR_PLUGIN_PATH.$launcher_class_data['file_path'].'.php';
                $launcher_class_name = $launcher_class_data['class'];
                //process short code
                try{
                    $launcher = new $launcher_class_name();
                    $launcher->set_short_code($point_data);
                    $content = $launcher->render($front_end);
                }catch (Exception $e){
                }
            }

            return $content;
        }

        /**
         * Print preview launcher
         *
         * @access public
         * @return void
         */
        public static function print_preview_launcher() {
            // Make sure this is own preview request.
            if ( ! Wlpr_Designer::is_own_preview_request() ) {
                return;
            }
            $content = self::get_preview_launcher();
            if ( ! empty( $content ) ) {
                wp_register_style(WLPR_PLUGIN_SLUG . '-font-wlpr', WLPR_PLUGIN_URL . 'Assets/Site/Css/wlpr-front.css', array(), WLPR_PLUGIN_VERSION);
                wp_enqueue_style(WLPR_PLUGIN_SLUG . '-font-wlpr');
                // Print email content
                echo $content;
                // Print live preview scripts in footer
                add_action( 'wp_footer', array( 'Wlpr_Preview', 'print_live_preview_scripts' ), 99 );
            }/*elseif ( false == $content ) {
                echo __( 'An error occurred trying to load this email type. Make sure this email type is enabled or please try another type.', WLPR_TEXT_DOMAIN );
            }*/
        }

        public static function get_point_preview_data($email = ''){
            global $wpdb;
            $point_helper = \Wlpr\App\Helpers\Loyalty::point();
            $point_label = $point_helper->getPointLabel();
            $site_title =  get_bloginfo( 'name', 'display' );
            $point_setting = get_option('wlpr_settings');
            $referral_settings = get_option('wlpr_referral');
            $review_point = (isset($point_setting['wlpr_write_review_points']) && (!empty($point_setting['wlpr_write_review_points'])||$point_setting['wlpr_write_review_points']==0)) ? $point_setting['wlpr_write_review_points'] : 50;
            $enable_review_reward = (isset($point_setting['wlpr_enable_review_reward']) && !empty($point_setting['wlpr_enable_review_reward'])) ? $point_setting['wlpr_enable_review_reward'] : 'yes';
            if($enable_review_reward == 'no'){
                $review_point = 0;
            }
            $enable_signup_reward = (isset($point_setting['wlpr_enable_signup_reward']) && !empty($point_setting['wlpr_enable_signup_reward'])) ? $point_setting['wlpr_enable_signup_reward'] : 'yes';
            $signup_point = (isset($point_setting['wlpr_account_signup_points']) && (!empty($point_setting['wlpr_account_signup_points'])|| $point_setting['wlpr_account_signup_points'] == 0)) ? $point_setting['wlpr_account_signup_points'] : 50;
            if($enable_signup_reward == 'no'){
                $signup_point = 0;
            }
            $referee_point = (isset($referral_settings['wlpr_referred_person']) && (!empty($referral_settings['wlpr_referred_person'])||$referral_settings['wlpr_referred_person'] ==0)) ? $referral_settings['wlpr_referred_person'] : 50;
            $referral_earn_person = (isset($referral_settings['wlpr_referring_person']) && (!empty($referral_settings['wlpr_referring_person'])|| $referral_settings['wlpr_referring_person']== 0)) ? $referral_settings['wlpr_referring_person'] : 50;
            $referee_discount = (isset($referral_settings['wlpr_referral_coupon_percent']) && !empty($referral_settings['wlpr_referral_coupon_percent'])) ? $referral_settings['wlpr_referral_coupon_percent']: 0;
            $referee_discount_type = (isset($referral_settings['wlpr_referral_coupon_percent_type']) && !empty($referral_settings['wlpr_referral_coupon_percent_type'])) ? $referral_settings['wlpr_referral_coupon_percent_type']: 'fixed';
            $referee_discount_enabled = (isset($referral_settings['wlpr_referral_discount']) && !empty($referral_settings['wlpr_referral_discount'])) ? $referral_settings['wlpr_referral_discount']: 'no';
            if($referee_discount_enabled === 'no'){
                $referee_discount = 0;
            }elseif($referee_discount_type === 'percentage'){
                $referee_discount = $referee_discount.'%';
            }elseif($referee_discount_type === 'fixed'){
                $referee_discount = wc_price($referee_discount);
            }
            $enable_birth_date_point = (isset($point_setting['wlpr_enable_birth_date_point']) && !empty($point_setting['wlpr_enable_birth_date_point'])) ? $point_setting['wlpr_enable_birth_date_point']: 'yes';
            $birth_date_point = 0;
            if($enable_birth_date_point === 'yes'){
                $birth_date_point = (isset($point_setting['wlpr_birth_date_point']) && !empty($point_setting['wlpr_birth_date_point'])) ? $point_setting['wlpr_birth_date_point']: 0;
            }

            $enable_facebook_share_point = (isset($referral_settings['wlpr_enable_facebook_share_point']) && !empty($referral_settings['wlpr_enable_facebook_share_point'])) ? $referral_settings['wlpr_enable_facebook_share_point']: 'yes';
            $wlpr_facebook_share_point = 0;
            if($enable_facebook_share_point === 'yes'){
                $wlpr_facebook_share_point = (isset($referral_settings['wlpr_facebook_share_point']) && !empty($referral_settings['wlpr_facebook_share_point'])) ? $referral_settings['wlpr_facebook_share_point']: 0;
            }

            $enable_twitter_share_point = (isset($referral_settings['wlpr_enable_twitter_share_point']) && !empty($referral_settings['wlpr_enable_twitter_share_point'])) ? $referral_settings['wlpr_enable_twitter_share_point']: 'yes';
            $wlpr_twitter_share_point = 0;
            if($enable_twitter_share_point === 'yes'){
                $wlpr_twitter_share_point = (isset($referral_settings['wlpr_twitter_share_point']) && !empty($referral_settings['wlpr_twitter_share_point'])) ? $referral_settings['wlpr_twitter_share_point']: 0;
            }

            $enable_email_share_point = (isset($referral_settings['wlpr_enable_email_share_point']) && !empty($referral_settings['wlpr_enable_email_share_point'])) ? $referral_settings['wlpr_enable_email_share_point']: 'yes';
            $wlpr_email_share_point = 0;
            if($enable_email_share_point === 'yes'){
                $wlpr_email_share_point = (isset($referral_settings['wlpr_email_share_point']) && !empty($referral_settings['wlpr_email_share_point'])) ? $referral_settings['wlpr_email_share_point']: 0;
            }
            $enable_whatsapp_share_point = (isset($referral_settings['wlpr_enable_whatsapp_share_point']) && !empty($referral_settings['wlpr_enable_whatsapp_share_point'])) ? $referral_settings['wlpr_enable_whatsapp_share_point']: 'yes';
            $wlpr_whatsapp_share_point = 0;
            if($enable_whatsapp_share_point === 'yes'){
                $wlpr_whatsapp_share_point = (isset($referral_settings['wlpr_whatsapp_share_point']) && !empty($referral_settings['wlpr_whatsapp_share_point'])) ? $referral_settings['wlpr_whatsapp_share_point']: 0;
            }
            if(empty($email)){
                $default_value = array(
                    /* common*/
                    '{wlpr_points_label}' => $point_label,
                    '{wlpr_review_points}' => $review_point,
                    '{wlpr_site_title}' => $site_title,
                    /*Guest */
                    '{wlpr_signin_url}' => get_permalink( get_option('woocommerce_myaccount_page_id') ),
                    '{wlpr_signup_url}' => get_permalink( get_option('woocommerce_myaccount_page_id') ),
                    '{wlpr_signup_point}' => $signup_point,

                    /*Login*/
                    '{wlpr_referral_earn_points}' => $referral_earn_person,
                    '{wlpr_total_referral_point}' => 0,
                    '{wlpr_friend_earn_points}' => $referee_point,
                    '{wlpr_logged_in_username}' => '',
                    '{wlpr_birthday_point}' => 0,
                    '{wlpr_facebook_point}' => 0,
                    '{wlpr_twitter_point}' => 0,
                    '{wlpr_email_point}' => 0,
                    '{wlpr_whatsapp_point}' => 0,
                    '{wlpr_referee_discount}' => $referee_discount,
                    //'{wlpr_friend_discount}',
                    '{wlpr_customer_total_points}' => 0,
                    '{wlpr_referral_code}' => '',
                    '{wlpr_referral_url}' => '',
                    '{wlpr_customer_available_points_balance}' => wc_price(0),
                    '{wlpr_share_content}' => '',
                    '{wlpr_share_subject}' => '',

                );
            }else{
                $point_model = new \Wlpr\App\Models\Points();
                $email = sanitize_email($email);
                $where = $wpdb->prepare("user_email = %s", array($email));
                $point_data = $point_model->getWhere($where, '*', true);
                $referral_model = new \Wlpr\App\Models\Referral();
                $ref_where = $wpdb->prepare("referred_by = %s AND (status = %s OR status = %s)", array($email,'completed',''));
                $referral_data = $referral_model->getWhere($ref_where, 'SUM(referred_by_earn_point) as total_referred_point', true);
                $user = wp_get_current_user();
                $default_value = array(
                    /* common*/
                    '{wlpr_points_label}' => $point_label,
                    '{wlpr_review_points}' => $review_point,
                    '{wlpr_site_title}' => $site_title,
                    /*Guest */
                    '{wlpr_signin_url}' => get_permalink( get_option('woocommerce_myaccount_page_id') ),
                    '{wlpr_signup_url}' => get_permalink( get_option('woocommerce_myaccount_page_id') ),
                    '{wlpr_signup_point}' => $signup_point,

                    /*Login*/
                    '{wlpr_referral_earn_points}' => $referral_earn_person,
                    '{wlpr_total_referral_point}' => (isset($referral_data->total_referred_point) && !empty($referral_data->total_referred_point)) ? $referral_data->total_referred_point: 0,
                    '{wlpr_friend_earn_points}' => $referee_point,
                    '{wlpr_logged_in_username}' => (isset($user->display_name) && !empty($user->display_name)) ? $user->display_name: '',
                    '{wlpr_birthday_point}' => $birth_date_point,
                    '{wlpr_facebook_point}' => $wlpr_facebook_share_point,
                    '{wlpr_twitter_point}' => $wlpr_twitter_share_point,
                    '{wlpr_email_point}' => $wlpr_email_share_point,
                    '{wlpr_whatsapp_point}' => $wlpr_whatsapp_share_point,
                    '{wlpr_referee_discount}' => $referee_discount,
                    //'{wlpr_friend_discount}',
                    '{wlpr_customer_total_points}' => (isset($point_data->points) && !empty($point_data->points)) ? $point_data->points: 0,
                    '{wlpr_referral_code}' => !empty($point_data->refer_code) ? $point_data->refer_code: '',
                    '{wlpr_referral_url}' => !empty($point_data->refer_code) ? site_url() . '?wlpr_ref=' . $point_data->refer_code: '',
                    '{wlpr_customer_available_points_balance}' => wc_price(((isset($point_data->points) && !empty($point_data->points)) ? $point_data->points: 0)),
                    '{wlpr_share_content}' => self::get_share_content(),
                    '{wlpr_share_subject}' => self::get_share_subject()
                );
            }

            return apply_filters('wlpr_preview_short_codes',$default_value);
        }

        public static function get_share_content(){
            $referral_settings = get_option('wlpr_referral');
            $points_label = \Wlpr\App\Helpers\Loyalty::point()->getPointLabel();
            $wlpr_referred_person = (isset($referral_settings['wlpr_referred_person']) && (!empty($referral_settings['wlpr_referred_person']) || $referral_settings['wlpr_referred_person']==0)) ? $referral_settings['wlpr_referred_person'] : 50;

            $share_content = (isset($referral_settings['wlpr_share_content']) && !empty($referral_settings['wlpr_share_content'])) ? __($referral_settings['wlpr_share_content'],WLPR_TEXT_DOMAIN) : __('{wlpr_referee_point} {wlpr_points_label} off your first purchase.',WLPR_TEXT_DOMAIN);
            $share_content = str_replace('{wlpr_points_label}', $points_label, $share_content);
            $share_content = str_replace('{wlpr_referee_point}', $wlpr_referred_person, $share_content);


            $enable_refer_discount = (isset($referral_settings['wlpr_referral_discount']) && !empty($referral_settings['wlpr_referral_discount'])) ? $referral_settings['wlpr_referral_discount'] : 'no';
            $referral_coupon_amount = (isset($referral_settings['wlpr_referral_coupon_percent']) && !empty($referral_settings['wlpr_referral_coupon_percent'])) ? $referral_settings['wlpr_referral_coupon_percent'] : 0;
            $referral_coupon_type = (isset($referral_settings['wlpr_referral_coupon_percent_type']) && !empty($referral_settings['wlpr_referral_coupon_percent_type'])) ? $referral_settings['wlpr_referral_coupon_percent_type'] : 'fixed';
            if ($enable_refer_discount == 'yes' && $referral_coupon_amount > 0) {
                if ($referral_coupon_type == 'fixed') {
                    $share_content = str_replace('{wlpr_referee_discount}', get_woocommerce_currency_symbol() . $referral_coupon_amount, $share_content);
                } else {
                    $share_content = str_replace('{wlpr_referee_discount}', $referral_coupon_amount . '%', $share_content);
                }
            } else {
                $share_content = str_replace('{wlpr_referee_discount}', 0, $share_content);
            }
            return $share_content;
        }

        public static function get_share_subject(){
            $referral_settings = get_option('wlpr_referral');
            $points_label = \Wlpr\App\Helpers\Loyalty::point()->getPointLabel();
            $wlpr_referred_person = (isset($referral_settings['wlpr_referred_person']) && (!empty($referral_settings['wlpr_referred_person']) || $referral_settings['wlpr_referred_person'] ==0)) ? $referral_settings['wlpr_referred_person'] : 50;
            $share_subject = (isset($referral_settings['wlpr_share_subject']) && !empty($referral_settings['wlpr_share_subject'])) ? __($referral_settings['wlpr_share_subject'],WLPR_TEXT_DOMAIN) : __('{wlpr_referee_point} {wlpr_points_label} off your first purchase.',WLPR_TEXT_DOMAIN);
            $share_subject = str_replace('{wlpr_points_label}', $points_label, $share_subject);
            $share_subject = str_replace('{wlpr_referee_point}', $wlpr_referred_person, $share_subject);
            return $share_subject;
        }

        /**
         * Print live preview scripts
         *
         * @access public
         * @return void
         */
        public static function print_live_preview_scripts() {

            $responsive_check = Wlpr_Customizer::opt( 'responsive_mode' );
            // Open container
            $scripts = '<script type="text/javascript">jQuery(document).ready(function() {';

            // Font family mapping
            $scripts .= 'var font_family_mapping = ' . json_encode( Wlpr_Settings::$font_family_mapping ) . ';';

            // Get information from email to use in placeholders.
            $scripts .= 'var pl_site_title = "' . get_bloginfo( 'name', 'display' ) . '";';
            $scripts .= 'var pl_year = "' . date( 'Y' ) . '";';
            // Function to handle special cases.
            $scripts .= "function prepare(value, key, selector) {
					if (key === 'border_radius' && selector === '#template_header') {
						value = value.replace('!important', '').trim();
						value = value + ' ' + value + ' 0 0 !important';
					} else if (key === 'footer_padding' && selector === '#template_footer #credit') {
						value = '0 ' + value + ' ' + value + ' ' + value;
					}  else if (key === 'footer_content_text' && value !== '') {
						value = '<p>' + value + '</p>';
					} else if (key === 'shadow') {
						value = '0 ' + (value > 0 ? 1 : 0) + 'px ' + (value * 4) + 'px ' + value + 'px rgba(0,0,0,0.1) !important';
					} else if (key.match(/font_family$/)) {
						value = typeof font_family_mapping[value] !== 'undefined' ? font_family_mapping[value] : value;
					} else if (key === 'wlpr_launcher_header_image') {
						value = '<p style=\"margin-top:0; margin-bottom:0;\"><img src=\"' + value + '\" style=\"border: none; display: inline; font-weight: bold; height: auto; line-height: 100%; outline: none; text-decoration: none; text-transform: capitalize;\" /></p>';
					} else if (value && value.includes('{site_title}') ) {
						value = value.replace('{site_title}', pl_site_title);
						if (value && value.includes('{year}') ) {
							value = value.replace('{year}', pl_year);
						}
					} else if (value && value.includes('{year}') ) {
						value = value.replace('{year}', pl_year);
					} 

					return value;
				}";
            // Get CSS suffixes
            $scripts .= 'var suffixes = ' . json_encode( Wlpr_Customizer::get_css_suffix() ) . ';';
            // Guest card active
            $scripts .= "jQuery(window.parent.document).on('click','#accordion-panel-wlpr_launcher_guest_card',function(){
                jQuery('#wlpr_preview_wrapper .wlpr-login-card').hide();
                jQuery('#wlpr_preview_wrapper .wlpr-guest-card').show();
            });";
            $scripts .= "jQuery(window.parent.document).on('click','#accordion-panel-wlpr_launcher_guest_card',function(){
                jQuery('#wlpr_preview_wrapper .wlpr-login-card').hide();
                jQuery('#wlpr_preview_wrapper .wlpr-guest-card').show();
            });
            ";
            // login card active
            $scripts .= "jQuery(window.parent.document).on('click','#accordion-panel-wlpr_launcher_login_card',function(){
                jQuery('#wlpr_preview_wrapper .wlpr-guest-card').hide();
                jQuery('#wlpr_preview_wrapper .wlpr-login-card').show();
            });";
            $scripts .= "wp.customize( 'wlpr_launcher_login_review_img', function( value ) {
                value.bind( function( to ) {
                    jQuery('#wlpr-launcher-login-review-content img').attr('src',to);
                } );
            } );
            /*customize-control-wlpr_launcher_login_referral_img*/
            wp.customize( 'wlpr_launcher_login_referral_img', function( value ) {
                value.bind( function( to ) {
                    jQuery('#wlpr-launcher-login-referral-card #wlpr-launcher-login-referral-content img').attr('src',to);
                } );
            } );
            wp.customize( 'wlpr_launcher_login_referee_img', function( value ) {
                value.bind( function( to ) {
                    jQuery('#wlpr-launcher-login-referee-card #wlpr-launcher-login-referee-content img').attr('src',to);
                } );
            } );
            /*Guest */
            wp.customize( 'wlpr_launcher_guest_review_img', function( value ) {
                value.bind( function( to ) {
                    jQuery('#wlpr-launcher-guest-review-card #wlpr-launcher-guest-review-content img').attr('src',to);
                } );
            } );
            wp.customize( 'wlpr_launcher_header_image', function( value ) {
                value.bind( function( to ) {
                    jQuery('#wlpr-guest-header-content img').attr('src',to);
                    jQuery('#wlpr-login-header-content img').attr('src',to);
                } );
            } );
            ";
            // Go through  settings
            foreach ( Wlpr_Settings::get_settings() as $setting_key => $setting ) {

                // No live method
                if ( ! isset( $setting['live_method'] ) ) {
                    continue;
                }

                // Iterate over selectors
                if ( in_array( $setting['live_method'], array( 'css', 'property' ) ) && ! empty( $setting['selectors'] ) ) {
                    foreach ( $setting['selectors'] as $selector => $properties ) {

                        // Iterate over properties
                        foreach ( $properties as $property ) {

                            // CSS value change
                            if ( ! isset( $setting['live_method'] ) || $setting['live_method'] === 'css' ) {
                                if ( $responsive_check && 'content_width'== $setting_key ) {
                                    $property = 'max-width';
                                    if ( '#template_container' !== $selector && '#template_footer' !== $selector ) {
                                        continue;
                                    }
                                }
                                if ( ! $responsive_check && 'content_inner_width' == $setting_key ) {
                                    continue;
                                }
                                $scripts .= "wp.customize('wlpr_launcher[$setting_key]', function(value) {
								value.bind(function(newval) {
								newval = newval + (typeof suffixes['$setting_key'] !== 'undefined' ? suffixes['$setting_key'] : '');
								newval = prepare(newval, '$setting_key', '$selector');
								jQuery('$selector').css('$property', '').attr('style', function(i, s) { return (s||'') + '$property: ' + newval + ';' });
								});
								});";
                            }

                            // DOM object property
                            if ( $setting['live_method'] === 'property' ) {
                                $scripts .= "wp.customize('wlpr_launcher[$setting_key]', function(value) {
								value.bind(function(newval) {
								newval = newval + (typeof suffixes['$setting_key'] !== 'undefined' ? suffixes['$setting_key'] : '');
								newval = prepare(newval, '$setting_key', '$selector');
								jQuery('$selector').prop('$property', newval);
								});
								});";
                            }
                        }
                    }
                }

                // HTML Replace
                if ( $setting['live_method'] === 'replace' && ! empty( $setting[ 'selectors' ] ) ) {
                    foreach ( $setting['selectors'] as $selector ) {
                        $original = json_encode( $setting['original'] );
                        $scripts .= "wp.customize('wlpr_launcher[$setting_key]', function(value) {
						value.bind(function(newval) {
						newval = (newval !== '' ? newval : $original);
						newval = prepare(newval, '$setting_key', '$selector');
						jQuery('$selector').html(newval);
						});
						});";
                    }
                }
            }
            // Go through woo settings
            foreach ( Wlpr_Settings::get_woo_settings() as $setting_key => $setting ) {

                // No live method
                if ( ! isset( $setting['live_method'] ) ) {
                    continue;
                }

                // Iterate over selectors
                if ( in_array( $setting['live_method'], array( 'css', 'property' ) ) && ! empty( $setting['selectors'] ) ) {
                    
                    foreach ( $setting['selectors'] as $selector => $properties ) {

                        // Iterate over properties
                        foreach ( $properties as $property ) {
                            
                            // CSS value change.
                            if ( ! isset( $setting['live_method'] ) || $setting['live_method'] === 'css' ) {
                                $scripts .= "wp.customize('$setting_key', function(value) {
								value.bind(function(newval) {
								newval = newval + (typeof suffixes['$setting_key'] !== 'undefined' ? suffixes['$setting_key'] : '');
								newval = prepare(newval, '$setting_key', '$selector');
								jQuery('$selector').css('$property', '').attr('style', function(i, s) { return (s||'') + '$property: ' + newval + ';' });
								});
								
								});";
                            }

                            // DOM object property.
                            if ( 'property' === $setting['live_method'] ) {
                                $scripts .= "wp.customize('$setting_key', function(value) {
								value.bind(function(newval) {
								newval = newval + (typeof suffixes['$setting_key'] !== 'undefined' ? suffixes['$setting_key'] : '');
								newval = prepare(newval, '$setting_key', '$selector');
								jQuery('$selector').prop('$property', newval);
								});
								});";
                            }
                        }
                    }
                }
                // HTML Replace.
                if ( 'replace' === $setting['live_method'] && ! empty( $setting['selectors'] ) ) {
                    foreach ( $setting['selectors'] as $selector ) {
                        $original = ( isset( $setting['input_attrs'] ) && isset( $setting['input_attrs']['placeholder'] ) && ! empty( $setting['input_attrs']['placeholder'] ) ? json_encode( $setting['input_attrs']['placeholder'] ) : '"Placeholder Text"' );
                        $scripts .= "wp.customize('$setting_key', function(value) {
						value.bind(function(newval) {
						newval = (newval !== '' ? newval : $original);

						newval = prepare(newval, '$setting_key', '$selector');
						jQuery('$selector').html(newval);
						});
						});";
                    }
                }
            }

            // Close container and return.
            echo $scripts . '});</script>';
        }

    }

    Wlpr_Preview::get_instance();

}
