<?php
/**
 * Main Class
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
if ( ! class_exists( 'Wlpr_Designer' ) ) {
    class Wlpr_Designer {
        /**
         * Instance Control
         *
         * @var null
         */
        private static $instance = null;
        /**
         * User Role
         *
         * @var null
         */
        private static $admin_capability = null;
        /**
         * Overide Var
         *
         * @var null
         */
        private static $overwrite_options = null;

        /**
         * Instance Control
         */
        public static function get_instance() {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self();
            }
            return self::$instance;
        }
        /**
         * Construct
         */
        public function __construct() {

            add_action( 'plugins_loaded', array( $this, 'on_plugins_loaded' ) );
        }
        /**
         * Function on plugins loaded
         */
        public function on_plugins_loaded() {
            add_action( 'init', array( $this, 'on_init' ), 80 );
        }
        /**
         * Trigger Load on init.
         */
        public function on_init() {

            // Hook in footer container.
            //add_action( 'wlpr_launcher_designer_footer', array( $this, 'email_footer_content' ), 10 );

            // Hook for replacing {year} in email-footer.
            //add_filter( 'wlpr_launcher_footer_text', array( $this, 'email_footer_replace_year' ) );

        }

        /**
         * Check if WooCommerce settings need to be overwritten and custom styles applied
         * This is true when plugin is active and at least one custom option is stored in the database
         *
         * @access public
         * @return bool
         */
        public static function overwrite_options() {

            // Check if any settings were saved.
            if ( null === self::$overwrite_options ) {
                $option = get_option( 'wlpr_launcher', array() );
                self::$overwrite_options = ! empty( $option );
            }

            // Return result.
            return self::$overwrite_options;
        }

        /**
         * Checks to see if we are opening our custom customizer preview
         *
         * @access public
         * @return bool
         */
        public static function is_own_preview_request() {
            $input_helper = new \Wlpr\App\Helpers\Input();
            $wp_customize_preview_input = $input_helper->post_get('wlpr-launcher-preview','');
            return isset( $wp_customize_preview_input ) && '1' === $wp_customize_preview_input;
        }

        /**
         * Checks to see if we are opening our custom customizer controls
         *
         * @access public
         * @return bool
         */
        public static function is_own_customizer_request() {
            $input_helper = new \Wlpr\App\Helpers\Input();
            $wp_customize_launcher_input = $input_helper->post_get('wlpr-launcher-customize','');
            return isset( $wp_customize_launcher_input ) && '1' === $wp_customize_launcher_input;
        }

        /**
         * Gets the capability setting needed to edit in the email customizer
         *
         * @access public
         * @return string
         */
        public static function get_admin_capability() {
            // Get capability.
            if ( is_null( self::$admin_capability ) ) {
                self::$admin_capability = apply_filters( 'wlpr_launcher_capability', 'manage_woocommerce' );
            }

            // Return capability.
            return self::$admin_capability;
        }

        /**
         * Check if user is authorized to use the email customizer
         *
         * @access public
         * @return bool
         */
        public static function is_admin() {
            return current_user_can( self::get_admin_capability() );
        }
    }
}

