<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
if ( ! defined('ABSPATH') ) {
    exit;
}
require_once ABSPATH.'/wp-includes/class-wp-customize-control.php';
if ( class_exists( 'WP_Customize_Control' ) && ! class_exists( 'WP_Customize_Wlprtemplateload_Control' ) ) {
    class WP_Customize_Wlprtemplateload_Control extends \WP_Customize_Control {
        public $type = 'wlprtemplateload';

        public function render_content() {
            ?>
            <span class="customize-control-title">
				<?php _e( 'Load Template', WLPR_TEXT_DOMAIN ); ?>
			</span>
            <div class="wlpr-template-launcher-load-controls">
                <div id="input_<?php echo $this->id; ?>" class="image-radio-select">
                    <?php foreach ( $this->choices as $value => $label ) : ?>
                        <label class="<?php echo $this->id . $value; ?> image-radio-select-item" data-image-value="<?php echo esc_attr( $value ); ?>">
                            <img src="<?php echo esc_url( WLPR_PLUGIN_URL .  $label ); ?>" alt="<?php echo esc_attr( $value ); ?>" title="<?php echo esc_attr( $value ); ?>">
                        </label>
                    <?php endforeach; ?>
                </div>
                <input type="hidden" value="<?php echo esc_attr( $this->value() ); ?>" id="wlpr-launcher-prebuilt-template" name="wlpr-launcher-prebuilt-template">
                <?php wp_nonce_field( 'wlpr-launcher-importing-template', 'wlpr-launcher-import-template' ); ?>
            </div>
            <div class="wlpr-launcher-loading"><?php _e( 'Loading and Saving...', WLPR_TEXT_DOMAIN ); ?></div>
            <input type="button" class="button button-primary wlpr-launcher-template-button" name="wlpr-launcher-template-button" value="<?php esc_attr_e( 'Load Template', WLPR_TEXT_DOMAIN ); ?>" />
            <?php
        }
    }
}
