<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
if ( ! defined('ABSPATH') ) {
    exit;
}
require_once ABSPATH.'/wp-includes/class-wp-customize-control.php';
/**
 * This is a customized version of https://wordpress.org/plugins/customizer-export-import/
 */
if ( class_exists( 'WP_Customize_Control' ) && ! class_exists( 'WP_Customize_Wlprimportexport_Control' ) ) {
    class WP_Customize_Wlprimportexport_Control extends WP_Customize_Control {
        public $type = 'wlprimportexport';

        public function render_content() {
            ?>
            <span class="customize-control-title">
				<?php _e( 'Export', WLPR_TEXT_DOMAIN ); ?>
			</span>
            <span class="description customize-control-description">
				<?php _e( 'Click the button below to export the customization settings for this plugin.', WLPR_TEXT_DOMAIN ); ?>
			</span>
            <input type="button" class="button button-primary wlpr-launcher-export wlpr-launcher-button" name="wlpr-launcher-export-button" value="<?php esc_attr_e( 'Export', WLPR_TEXT_DOMAIN ); ?>" />

            <hr class="wlpr-launcher-hr" />

            <span class="customize-control-title">
				<?php _e( 'Import', WLPR_TEXT_DOMAIN ); ?>
			</span>
            <span class="description customize-control-description">
				<?php _e( 'Upload a file to import customization settings for this plugin.', WLPR_TEXT_DOMAIN ); ?>
			</span>
            <div class="wlpr-launcher-import-controls">
                <input type="file" name="wlpr-launcher-import-file" class="wlpr-launcher-import-file" />
                <?php wp_nonce_field( 'wlpr-launcher-importing', 'wlpr-launcher-import' ); ?>
            </div>
            <div class="wlpr-launcher-uploading"><?php _e( 'Uploading...', WLPR_TEXT_DOMAIN ); ?></div>
            <input type="button" class="button button-primary wlpr-launcher-import wlpr-launcher-button" name="wlpr-launcher-import-button" value="<?php esc_attr_e( 'Import', WLPR_TEXT_DOMAIN ); ?>" />
            <?php
        }
    }
}