<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
namespace Wlpr\App\Helpers;

use Wlpr\App\Models\PointAction;

class SocialShare extends Point
{
    public static $instance = null;

    /**
     * Point constructor.
     * @param array $config
     * @since 1.0.0
     */
    public function __construct($config = array())
    {
        parent::__construct($config);
    }

    /**
     * class instance
     * @param array $config
     * @return Point|null
     * @since 1.0.0
     */
    public static function getInstance(array $config = array())
    {
        if (!self::$instance) {
            self::$instance = new self($config);
        }
        return self::$instance;
    }

    /**
     * Social share
     * @param $sharePoint
     * @param string $type
     */
    function socialShareReward($sharePoint,$type = ''){
        global $wpdb;
        if(empty(get_current_user_id())){
            wp_send_json_error();
        }
        $userEmail = get_user_by('id', get_current_user_id())->user_email;
        if($sharePoint > 0 && !empty($type)){
            $pointAction = new PointAction();
            $userEmail = sanitize_email($userEmail);
            $pointActionWhere = $wpdb->prepare('user_email = %s AND action = %s', array($userEmail,$type));
            $pointActionData = $pointAction->getWhere($pointActionWhere, '*', true);
            if(empty($pointActionData)){
                $this->addEarnPoint($userEmail, $sharePoint, $type, null, null);
            }
        }
        wp_send_json_success();
    }
}