<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Helpers;


class Product
{
    public static $instance = null;

    public static function getInstance(array $config = array())
    {
        if (!self::$instance) {
            self::$instance = new self($config);
        }
        return self::$instance;
    }

    function getProductEarnPoint($product, $order = null)
    {
        if (!is_object($product)) {
            $product = wc_get_product($product);
        }
        if (!is_object($product)) {
            return 0;
        }
        list($points,$isPointEnabled) = $this->getProductLevelEarnPoints($product, $order);
        if($isPointEnabled == 'disable'){
            return 0;
        }

        if ($isPointEnabled == 'product') {
            return $points;
        }
        list($points, $isPointEnabled) = $this->getCategoryLevelEarnPoints($product, $order);
        if($isPointEnabled == 'disable'){
            return 0;
        }
        if ($isPointEnabled == 'product') {
            return $points;
        }
        $product_price = $this->getProductPrice($product,null);
        $points = Loyalty::point()->globalPoints($product_price);
        if (!empty($points)) {
            return $points;
        }
        return 0;
    }

    function productLevelEarn($product, $order)
    {
        $points = 0;
        $pointSetting = json_decode(get_post_meta($product->get_id(), '_wlpr_product_points_earned', true), true);
        if (isset($pointSetting['wlpr_earn_point']) && isset($pointSetting['wlpr_point_earn_price']) &&
            $pointSetting['wlpr_earn_point'] && $pointSetting['wlpr_point_earn_price']) {
            $productPrice = $this->getProductPrice($product);
            $points = $productPrice * ((int)$pointSetting['wlpr_earn_point'] / (int)$pointSetting['wlpr_point_earn_price']);
        }
        return $points;
    }

    function renewalOrderEarn($product, $order)
    {
        $wooHelper = Loyalty::woocommerce();
        $points = 0;
        if ($wooHelper->is_order_renewal($order)) {
            $renewalPoints = 0;
            $renewalSetting = json_decode(get_post_meta($product->get_id(), '_wlpr_renewal_product_points_earned', true), true);
            if (isset($renewalSetting['wlpr_earn_point']) && isset($renewalSetting['wlpr_point_earn_price']) &&
                $renewalSetting['wlpr_earn_point'] && $renewalSetting['wlpr_point_earn_price']) {
                $productPrice = $this->getProductPrice($product);
                $renewalPoints = $productPrice * ((int)$renewalSetting['wlpr_earn_point'] / (int)$renewalSetting['wlpr_point_earn_price']);
            }
            $points = $renewalPoints;
        }
        return $points;
    }

    function getProductLevelEarnPoints($product, $order)
    {
        $variationId = 0;
        if (in_array(get_class($product), array('WC_Product_Variation', 'WC_Product_Subscription_Variation'))) {
            $variationId = (int)(version_compare(WC_VERSION, '3.0', '<') && isset($product->variation_id)) ? $product->variation_id : $product->get_id();
        }
        $wooHelper = Loyalty::woocommerce();
        $points = 0;
        if (empty($variationId)) {
            $enableEarnPoint = get_post_meta($product->get_id(), '_wlpr_product_enable_earn_point', true);
            if(!in_array($enableEarnPoint,array('global','product','disable'))){
                $enableEarnPoint = 'global';
            }
            if($enableEarnPoint == 'product'){
                $points = $this->productLevelEarn($product, $order);
                if (!method_exists($product, 'get_variation_price')) {
                    if ($wooHelper->is_order_renewal($order)) {
                        $points = $this->renewalOrderEarn($product, $order);
                    }
                }
            }
        } else {
            $enableEarnPoint = get_post_meta($variationId, '_wlpr_variable_product_enable_earn_point', true);
            if(!in_array($enableEarnPoint,array('global','product','disable'))){
                $enableEarnPoint = 'global';
            }
            if($enableEarnPoint == 'product'){
                $productPrice = $this->getProductPrice($product);
                $pointSetting = json_decode(get_post_meta($variationId, '_wlpr_variable_product_points_earned', true), true);
                if (isset($pointSetting['wlpr_earn_point']) && isset($pointSetting['wlpr_point_earn_price']) &&
                    $pointSetting['wlpr_earn_point'] && $pointSetting['wlpr_point_earn_price']) {
                    $points = $productPrice * ((int)$pointSetting['wlpr_earn_point'] / (int)$pointSetting['wlpr_point_earn_price']);
                }
                if ($wooHelper->is_order_renewal($order)) {
                    $renewalPoints = 0;
                    $renewalSetting = json_decode(get_post_meta($variationId, '_wlpr_variable_product_points_renewal_points', true), true);
                    if (isset($renewalSetting['wlpr_earn_point']) && isset($renewalSetting['wlpr_point_earn_price']) &&
                        $renewalSetting['wlpr_earn_point'] && $renewalSetting['wlpr_point_earn_price']) {
                        $renewalPoints = $productPrice * ((int)$renewalSetting['wlpr_earn_point'] / (int)$renewalSetting['wlpr_point_earn_price']);
                    }
                    $points = $renewalPoints;
                }
                if (0 == $points) {
                    $points = $this->productLevelEarn($product, $order);
                    if ($wooHelper->is_order_renewal($order)) {
                        $points = $this->renewalOrderEarn($product, $order);
                    }
                }
            }
        }
        return array($points,$enableEarnPoint);
    }

    public function getCategoryLevelEarnPoints($product, $order = null)
    {
        $productId = $this->getProductId($product);
        $categoryIds = $this->getCatIdFromMeta($productId);
        if (!$categoryIds) {
            return array(0,'global');
        }
        $categoryPoints = 0;
        $categoryPointData = $this->getCategoryPointData($categoryIds);
        $wooHelper = Loyalty::woocommerce();
        $productPrice = $this->getProductPrice($product);
        $isEnableCategoryList = array();
        if ($categoryPointData && count($categoryPointData) > 0) {
            foreach ($categoryPointData as $category) {
                $categoryEnableEarnPoint = $wooHelper->get_term_meta($category->category_id, '_wlpr_category_enable_earn_point', true);
                if(!in_array($categoryEnableEarnPoint,array('global','product','disable'))){
                    $categoryEnableEarnPoint = 'global';
                }
                $isEnableCategoryList[] = $categoryEnableEarnPoint;
                if($categoryEnableEarnPoint == 'product'){
                    $categorySetting = json_decode($category->points, true);
                    if (isset($categorySetting['wlpr_earn_point']) && isset($categorySetting['wlpr_point_earn_price']) &&
                        !empty($categorySetting['wlpr_earn_point']) && !empty($categorySetting['wlpr_point_earn_price'])) {
                        $points = $productPrice * ((int)$categorySetting['wlpr_earn_point'] / (int)$categorySetting['wlpr_point_earn_price']);
                        if ($wooHelper->is_order_renewal($order)) {
                            $renewalPoints = 0;
                            $renewalSetting = json_decode(version_compare(WC_VERSION, '3.6', 'ge') ? get_term_meta($category->category_id, '_wlpr_category_points_renewal_points', true) : get_woocommerce_term_meta($category->category_id, '_wlpr_category_points_renewal_points', true), true);
                            if (isset($renewalSetting['wlpr_earn_point']) && isset($renewalSetting['wlpr_point_earn_price']) &&
                                $renewalSetting['wlpr_earn_point'] && $renewalSetting['wlpr_point_earn_price']) {
                                $renewalPoints = $productPrice * ((int)$renewalSetting['wlpr_earn_point'] / (int)$renewalSetting['wlpr_point_earn_price']);
                            }
                            $points = $renewalPoints;
                        }
                        if (!is_numeric($points)) {
                            continue;
                        }
                        if ($points >= (int)$categoryPoints) {
                            $categoryPoints = $points;
                        }
                    }
                }
            }
        }
        $isEnablePointCategory = 'global';
        if(!empty($isEnableCategoryList) && in_array('product',$isEnableCategoryList)){
            $isEnablePointCategory = 'product';
        }else if( in_array('global',$isEnableCategoryList)){
            $isEnablePointCategory = 'global';
        }else if(in_array('disable',$isEnableCategoryList)){
            $isEnablePointCategory = 'disable';
        }
        return array($categoryPoints,$isEnablePointCategory);
    }

    public function getProductId($product){
        if ($product->is_type('variation')) {
            $productId = (int)version_compare(WC_VERSION, '3.0.0', '<') ? $product->parent_id : $product->get_parent_id();
        } else {
            $productId = (int)$product->get_id();
        }
        return $productId;
    }

    public function getCatIdFromMeta($product_id){
        return wc_get_product_terms($product_id, 'product_cat', array('fields' => 'ids'));
    }

    protected function getCategoryPointData($categoryIds){
        global $wpdb;
        $categoryIdString = implode(',', array_map('intval', $categoryIds));
        static $sets;
        if ( !is_array( $sets) )
        {
            $sets= array( );
        }
        if(!isset($sets[$categoryIdString])) {
            if (version_compare(WC()->version, '2.6.0', '>=')) {
                $categoryPointQuery = "SELECT term_id AS category_id, meta_value AS points FROM {$wpdb->termmeta} WHERE meta_key = '_wlpr_category_points_earned' AND term_id IN ( $categoryIdString );";
            } else {
                $categoryPointQuery = "SELECT woocommerce_term_id AS category_id, meta_value AS points FROM {$wpdb->woocommerce_termmeta} WHERE meta_key = '_wlpr_category_points_earned' AND woocommerce_term_id IN ( $categoryIdString );";
            }
            $sets[$categoryIdString] = $wpdb->get_results($categoryPointQuery);
        }
        return $sets[$categoryIdString];
    }

    protected function getProductPricePercentage($percentage, $product)
    {
        $percentage = str_replace('%', '', $percentage) / 100;
        $productPrice = $this->getProductPrice($product);
        return $percentage * $productPrice;
    }

    public function getMaximumPointDiscountForProduct($product)
    {
        /*
         * Rule :
         * product level
         * category level
         * Global level
         * */
        if (empty($product)) {
            return array(0,false);
        }
        if (!is_object($product)) {
            $product = wc_get_product($product);
        }

        list($maxDiscount,$isEnabledProductMaxDiscount)  = $this->getProductMaxDiscount($product);
        if (is_numeric($maxDiscount) && $isEnabledProductMaxDiscount) {
            return array($maxDiscount,$isEnabledProductMaxDiscount);
        }
        list($maxDiscount,$isEnabledCategoryMaxDiscount) = $this->getCategoryMaxDiscount($product);
        if (is_numeric($maxDiscount) &&  $isEnabledCategoryMaxDiscount) {
            return array($maxDiscount,$isEnabledCategoryMaxDiscount);
        }
        $settingOption = get_option('wlpr_settings', '');
        $maxDiscountEnabled = (isset($settingOption['wlpr_max_discount_enabled']) && !empty($settingOption['wlpr_max_discount_enabled'])) ? $settingOption['wlpr_max_discount_enabled'] : 'no';
        if($maxDiscountEnabled == 'yes'){
            $maxDiscount = (isset($settingOption['wlpr_max_product_discount']) && !empty($settingOption['wlpr_max_product_discount'])) ? $settingOption['wlpr_max_product_discount'] : 0;
            $maxDiscountType = (isset($settingOption['wlpr_max_product_discount_type']) && !empty($settingOption['wlpr_max_product_discount_type'])) ? $settingOption['wlpr_max_product_discount_type'] : 'fixed';
            if ($maxDiscountType != 'fixed') {
                $maxDiscount = $this->getProductPricePercentage($maxDiscount, $product);
            }
            return array($maxDiscount,true);
        }
        return array(0,false);
    }

    private function getProductMaxDiscount($product)
    {
        $variationId = 0;
        if (in_array(get_class($product), array('WC_Product_Variation', 'WC_Product_Subscription_Variation'))) {
            $variationId = (int)(version_compare(WC_VERSION, '3.0', '<') && isset($product->variation_id)) ? $product->variation_id : $product->get_id();
        }
        $maxDiscount = 0;
        $isEnabledMaxDiscount = false;
        if (empty($variationId)) {
            $pointMaxDiscountEnabled = get_post_meta($product->get_id(), '_wlpr_product_max_discount_enabled', true);
            if($pointMaxDiscountEnabled == 'yes'){
                $isEnabledMaxDiscount = true;
                $pointMaxDiscount = get_post_meta($product->get_id(), '_wlpr_product_points_max_discount', true);
                $maxDiscount = (isset($pointMaxDiscount) && !empty($pointMaxDiscount) ? $pointMaxDiscount : 0);
                $pointMaxDiscountType = get_post_meta($product->get_id(), '_wlpr_product_points_max_discount_type', true);
                if ($pointMaxDiscountType != 'fixed') {
                    $maxDiscount = $this->getProductPricePercentage($maxDiscount, $product);
                }
            }
        } else {
            $pointMaxDiscountEnabled = get_post_meta($variationId, '_wlpr_variable_product_max_discount_enabled', true);
            if($pointMaxDiscountEnabled == 'yes'){
                $isEnabledMaxDiscount = true;
                $pointMaxDiscount = get_post_meta($variationId, '_wlpr_variable_product_points_max_discount', true);
                $maxDiscount = (isset($pointMaxDiscount) && !empty($pointMaxDiscount) ? $pointMaxDiscount : 0);
                $pointMaxDiscountType = get_post_meta($variationId, '_wlpr_variable_product_points_max_discount_type', true);
                if ($pointMaxDiscountType != 'fixed') {
                    $maxDiscount = $this->getProductPricePercentage($maxDiscount, $product);
                }
            }
        }
        return array($maxDiscount,$isEnabledMaxDiscount);
    }

    private function getCategoryMaxDiscount($product)
    {
        global $wpdb;
        if ($product->is_type('variation')) {
            $productId = (int)version_compare(WC_VERSION, '3.0.0', '<') ? $product->parent_id : $product->get_parent_id();
        } else {
            $productId = (int)$product->get_id();
        }
        $categoryIds = wc_get_product_terms($productId, 'product_cat', array('fields' => 'ids'));
        if (!$categoryIds) {
            return '';
        }
        $categoryMaxDiscount = 0;
        $categoryIdString = implode(',', array_map('intval', $categoryIds));
        if (version_compare(WC()->version, '2.6.0', '>=')) {
            $categoryDiscountQuery = "SELECT term_id AS category_id, meta_value AS max_discount FROM {$wpdb->termmeta} WHERE meta_key = '_wlpr_category_points_max_discount' AND term_id IN ( $categoryIdString );";
        } else {
            $categoryDiscountQuery = "SELECT woocommerce_term_id AS category_id, meta_value AS max_discount FROM {$wpdb->woocommerce_termmeta} WHERE meta_key = '_wlpr_category_points_max_discount' AND woocommerce_term_id IN ( $categoryIdString );";
        }
        $categoryDiscountData = $wpdb->get_results($categoryDiscountQuery);
        $categoryDiscountArray = array();
        if ($categoryDiscountData && count($categoryDiscountData) > 0) {
            foreach ($categoryDiscountData as $category) {
                $categoryDiscountArray[$category->category_id] = $category->max_discount;
            }
        }
        $wooHelper = Loyalty::woocommerce();
        $isEnabledMaxDiscount = false;
        foreach ($categoryDiscountArray as $category_id => $maxDiscount) {
            $categoryMaxDiscountEnabled = $wooHelper->get_term_meta($category_id, '_wlpr_category_max_discount_enabled', true);
            if($categoryMaxDiscountEnabled == 'yes'){
                $categoryPointMaxDiscountType = $wooHelper->get_term_meta($category_id, '_wlpr_category_points_max_discount_type', true);
                if ($categoryPointMaxDiscountType != 'fixed') {
                    $maxDiscount = $this->getProductPricePercentage($maxDiscount, $product);
                }
                $isEnabledMaxDiscount = true;
            }else{
                $maxDiscount = 0;
            }
            if ($maxDiscount > $categoryMaxDiscount) {
                $categoryMaxDiscount = $maxDiscount;
            }
        }
        return array($categoryMaxDiscount,$isEnabledMaxDiscount);
    }

    function getProductPrice($product,$item = null,$is_redeem = false,$orderCurrency = ''){
        if(is_null($item)){
            $productPrice =  $product->get_price('edit');
            $productPrice = apply_filters('wlpr_default_product_price', $productPrice, $product, $is_redeem,$orderCurrency);
        }else{
            $itemData = $item->get_data();
            $quantity = $item->get_quantity();
            if ('no' === get_option('woocommerce_prices_include_tax')) {
                $productPrice = ($itemData['subtotal']) / $quantity;
            }else{
                $productPrice = ($itemData['subtotal'] + $itemData['subtotal_tax']) / $quantity;
            }

            $productPrice = apply_filters('wlpr_product_price', $productPrice, $product, $is_redeem,$orderCurrency);
        }
        return $productPrice;
    }
}