<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
namespace Wlpr\App\Helpers;

use Wlpr\App\Models\PointAction;
use Wlpr\App\Models\Points;

class Point extends Base
{
    public static $instance = null;

    public function __construct($config = array())
    {
        parent::__construct($config);
    }

    public static function getInstance(array $config = array())
    {
        if (!self::$instance) {
            self::$instance = new self($config);
        }
        return self::$instance;
    }

    function getUsersDiscountValue($userEmail)
    {
        $discountPrice = 0;
        $userPoint = $this->getUsersPoints($userEmail);
        if ($userPoint) {
            $settingOption = get_option('wlpr_settings', '');
            $redeemPoint = (isset($settingOption['wlpr_redeem_point']) && !empty($settingOption['wlpr_redeem_point'])) ? $settingOption['wlpr_redeem_point'] : 500;
            $redeemPrice = (isset($settingOption['wlpr_point_redeem_price']) && !empty($settingOption['wlpr_point_redeem_price'])) ? $settingOption['wlpr_point_redeem_price'] : 5;
            if (!empty($redeemPoint)) {
                $discountPrice = ($userPoint / $redeemPoint) * $redeemPrice;
            }
        }
        return apply_filters('wlpr_discount_price_change', $discountPrice);
    }

    function getDiscountForRedeemingPoints($applying = false, $existingDiscountAmounts = null, $forDisplay = false)
    {
        if (empty(get_current_user_id())) {
            return 0;
        }
        $userEmail = get_user_by('id', get_current_user_id())->user_email;
        $availableUserDiscount = $this->getUsersDiscountValue($userEmail);
        if ($availableUserDiscount <= 0) {
            return 0;
        }
        $settingOption = get_option('wlpr_settings', '');
        $partialRedemption = (isset($settingOption['wlpr_partial_redemption_enabled']) && !empty($settingOption['wlpr_partial_redemption_enabled'])) ? $settingOption['wlpr_partial_redemption_enabled'] : 'no';
        $partDiscountAmount = Loyalty::woocommerce()->get_discount_amount();
        if ($applying && 'yes' === $partialRedemption && $partDiscountAmount) {
            $requestedUserDiscount = $this->getRedeemPointAmount($partDiscountAmount);
            if ($requestedUserDiscount > 0 && $requestedUserDiscount < $availableUserDiscount) {
                $availableUserDiscount = $requestedUserDiscount;
            }
        }
        $minimumDiscount = (isset($settingOption['wlpr_min_cart_discount']) && !empty($settingOption['wlpr_min_cart_discount'])) ? $settingOption['wlpr_min_cart_discount'] : 0;
        if ($minimumDiscount > $availableUserDiscount) {
            return 0;
        }
        $discountApplied = 0;
        if (!did_action('woocommerce_before_calculate_totals')) {
            WC()->cart->calculate_totals();
        }
        $productHelper = Loyalty::product();
        $taxInclusive = (isset($settingOption['wlpr_points_tax_application']) && !empty($settingOption['wlpr_points_tax_application'])) ? $settingOption['wlpr_points_tax_application'] : 'exclusive';
        $taxInclusive = apply_filters( 'wlpr_redeem_point_tax_type', $taxInclusive );
        foreach (WC()->cart->get_cart() as $item_key => $item) {
            list($maxDiscount,$isMaxDiscountEnabled) = $productHelper->getMaximumPointDiscountForProduct($item['data']);
            $productPrice = $productHelper->getProductPrice($item['data']);
            if (is_numeric($maxDiscount) && $isMaxDiscountEnabled) {
                $maxDiscount *= $item['quantity'];
                if($maxDiscount > ($productPrice * $item['quantity'])){
                    $maxDiscount = $productPrice * $item['quantity'];
                }
            } else {
                if ('exclusive' === $taxInclusive && $forDisplay) {
                    if (function_exists('wc_get_price_excluding_tax')) {
                        $maxDiscount = wc_get_price_excluding_tax($item['data'], array('qty' => $item['quantity'], 'price' => $productPrice));
                    } elseif (method_exists($item['data'], 'get_price_excluding_tax')) {
                        $maxDiscount = $item['data']->get_price_excluding_tax($item['quantity'],$productPrice);
                    } else {
                        $maxDiscount = $productPrice * $item['quantity'];
                    }
                } else {
                    if (function_exists('wc_get_price_including_tax')) {
                        $maxDiscount = wc_get_price_including_tax($item['data'], array('qty' => $item['quantity'], 'price' => $productPrice));
                    } elseif (method_exists($item['data'], 'get_price_including_tax')) {
                        $maxDiscount = $item['data']->get_price_including_tax($item['quantity'], $productPrice);
                    } else {
                        $maxDiscount = $productPrice * $item['quantity'];
                    }
                }
            }
            $maxDiscount = apply_filters('wlpr_discount_price_change', $maxDiscount);
            $discount = ($availableUserDiscount <= $maxDiscount) ? $availableUserDiscount : $maxDiscount;
            $discountApplied += $discount;
            $availableUserDiscount -= $discount;
            if ($availableUserDiscount == 0) {
                break;
            }
        }

        if (is_null($existingDiscountAmounts)) {
            $existingDiscountAmounts = version_compare(WC_VERSION, '3.0.0', '<')
                ? WC()->cart->discount_total
                : WC()->cart->get_cart_discount_total();
        }
        $discountApplied = apply_filters('wlpr_convert_to_current_currency', $discountApplied);
        if (version_compare(WC_VERSION, '3.0.0', '<')) {
            if ('no' === get_option('woocommerce_prices_include_tax')) {
                $discountApplied = max(0, min($discountApplied, WC()->cart->subtotal_ex_tax - $existingDiscountAmounts));
            } else {
                $discountApplied = max(0, min($discountApplied, WC()->cart->subtotal - $existingDiscountAmounts));
            }
        } else {
            if ('no' === get_option('woocommerce_prices_include_tax')) {
                $discountApplied = max(0, min($discountApplied, WC()->cart->subtotal_ex_tax - $existingDiscountAmounts));
            } else {
                $discountApplied = max(0, min($discountApplied, WC()->cart->subtotal - $existingDiscountAmounts));
            }
        }
        $original_discount_apply = apply_filters('wlpr_discount_price_change_to_original', $discountApplied);
        if ($original_discount_apply < $minimumDiscount) {
            return 0;
        }
        $maxDiscount = (isset($settingOption['wlpr_max_cart_discount']) && !empty($settingOption['wlpr_max_cart_discount'])) ? $settingOption['wlpr_max_cart_discount'] : 0;
        $maxDiscountType = (isset($settingOption['wlpr_max_cart_discount_type']) && !empty($settingOption['wlpr_max_cart_discount_type'])) ? $settingOption['wlpr_max_cart_discount_type'] : 'fixed';
        if ($maxDiscountType != 'fixed') {
            $maxDiscount = $this->getCartMaxDiscountPercentage($maxDiscount);
        }
        if ($maxDiscount && $maxDiscount < $discountApplied) {
            $discountApplied = $maxDiscount;
        }
        return filter_var($discountApplied, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
    }

    function deductRedeemedPoints($orderId, $order = '')
    {
        $woocommerce = new Woocommerce();
        if (empty($order)) {
            $order = $woocommerce->getOrder($orderId);
        }
        if (empty($orderId) || empty($order)) {
            return;
        }
        $alreadyRedeemed = get_post_meta($orderId, '_wlpr_points_redeemed', true);
        $discountCode = get_post_meta($orderId, '_wlpr_points_order_discount_code', true);
        $loggedRedemption = get_post_meta($orderId, '_wlpr_points_logged_redemption', true);
        if (!empty($alreadyRedeemed)) {
            return;
        }
        $orderUserEmail = $order->get_billing_email();
        if (!$orderUserEmail) {
            return;
        }
        if(empty($discountCode)){
            $discountCode = $woocommerce->get_discount_code();
        }

        $options = get_option('wlpr_settings', '');
        $orderStatuses = (isset($options['wlpr_point_redeem_status']) && !empty($options['wlpr_point_redeem_status']) ? $options['wlpr_point_redeem_status'] : array('completed','processing'));
        $discountType = $this->getDiscountMethod();
        $couponCodes = version_compare(WC_VERSION, '3.7', 'ge') ? $order->get_coupon_codes() : $order->get_used_coupons();
        if($discountType == 'fee'){
            $lineItemsFee      = $order->get_items( 'fee' );

            $couponCodes = array();
            $discountCode = '';
            $discountAmount = 0;
            $pointsRedeemed = 0;
            foreach ($lineItemsFee as $fee){

                $discountCode = $fee->get_meta('fee_code');
                if(!empty($discountCode)){
                    $couponCodes[] = $discountCode;
                    $discountData  = $fee->get_data();
                    $discountAmount  = isset($discountData['amount']) ? -($discountData['amount']): 0;
                    $pointsRedeemed = $this->getPointForDiscount($discountAmount);
                }
            }

        }elseif (!empty($loggedRedemption)) {
            $pointsRedeemed = $loggedRedemption['points'];
            $discountAmount = $loggedRedemption['amount'];
            $discountCode = $loggedRedemption['discount_code'];
        } else {
            $discountAmount = $woocommerce->get_discount_from_code($discountCode,$order);
            $pointsRedeemed = $this->getPointForDiscount($discountAmount);
        }

        if (!in_array($discountCode, $couponCodes) || !in_array($order->get_status(), $orderStatuses)) {
            return;
        }
        $this->reducePoints($orderUserEmail, $pointsRedeemed, 'order-redeem', array('discount_code' => $discountCode, 'discount_amount' => $discountAmount), $orderId);
        update_post_meta($orderId, '_wlpr_points_redeemed', $pointsRedeemed);
        $order->add_order_note(sprintf(__('%1$d %2$s redeemed for a %3$s discount.', WLPR_TEXT_DOMAIN), $pointsRedeemed, $this->getPointLabel(), wc_price($discountAmount)));
    }

    function addPointEarned($orderId, $order = '')
    {
        $woocommerce = new Woocommerce();
        if (empty($order)) {
            $order = $woocommerce->getOrder($orderId);
        }
        $orderId = $order->get_id();
        $orderEmail = $order->get_billing_email();
        if (!$orderEmail) {
            return;
        }
        // case: 1. ref_code in session and already in referral table
        // 2. ref_code not in session and already in referral table
        // 3. ref_code in session and not in referral table
        // 4. ref_code not in session and not in referral table
        if (!empty($orderId)) {
            $referralCode = get_post_meta($orderId, '_wlpr_referral_code', true);

            $referralHelper = Loyalty::referral();
            if(empty($referralCode)){
                $referralCode = $referralHelper->check_referral_code($orderEmail);
            }
            if (!empty($referralCode)) {
                $referralHelper->add_referral_points($referralCode, $orderEmail, $orderId);
            }
        }

        $points = get_post_meta($orderId, '_wlpr_points_earned', true);
        if ('' !== $points) {
            return;
        }
        $points = $this->getPointsEarnedForPurchase($order);
        update_post_meta($orderId, '_wlpr_points_earned', $points);
        if (!$points) {
            return;
        }
        if(!$this->checkExcludeUserRole($orderEmail)){
            $this->addEarnPoint($orderEmail, $points, 'order-placed', null, $orderId);
        }else{
            $points = 0;
        }

        if (!$points) {
            return;
        }
        $order->add_order_note(sprintf(__('Customer earned %1$d %2$s for purchase.', WLPR_TEXT_DOMAIN), $points, $this->getPointLabel()));
    }

    function getPointsEarnedForPurchase($order)
    {
        $pointsEarned = 0;
        $productHelper = Loyalty::product();
        $point_setting = get_option('wlpr_settings');
        $is_earn_point_after_discount = (isset($point_setting['wlpr_is_earn_point_after_discount']) && !empty($point_setting['wlpr_is_earn_point_after_discount'])) ? $point_setting['wlpr_is_earn_point_after_discount'] : 'no';
        $bundleArray = array();
        foreach ($order->get_items() as $itemKey => $item) {
            $product = version_compare(WC_VERSION, '4.4.0', '<')
                ? $order->get_product_from_item($item)
                : $item->get_product();
            if (!is_object($product) || empty($product)) {
                continue;
            }
            $itemMetaData = $item->get_meta_data();
            if(isset($product) && $product->get_type() == 'bundle'){
                $bundleCartKey = '';

                foreach ($product->get_bundled_data_items() as $bundledDataItem){
                    $singleMetaData = $bundledDataItem->get_data();
                    $bundleMeta = (isset($singleMetaData['meta_data']) && !empty($singleMetaData['meta_data'])) ? $singleMetaData['meta_data']: array();
                    $productBundleId = 0;
                    if(isset($singleMetaData['product_id']) && !empty($singleMetaData['product_id'])){
                        $productBundleId = $singleMetaData['product_id'];
                    }
                    $bundleItemAllowed[$productBundleId] = false;
                    if(isset($bundleMeta['priced_individually']) && $bundleMeta['priced_individually'] === 'yes'){
                        $bundleItemAllowed[$productBundleId] = true;
                    }
                }

                $enableEarnPoint = get_post_meta($product->get_id(), '_wlpr_product_enable_earn_point', true);
                if(!in_array($enableEarnPoint,array('global','product','disable'))){
                    $enableEarnPoint = 'global';
                }
                if($enableEarnPoint == 'global'){
                    list($cate_points, $enableEarnPoint) = $productHelper->getCategoryLevelEarnPoints($product, $order);
                }
                foreach ($itemMetaData as $singleMeta){
                    $singleMetaData =  $singleMeta->get_data();
                    if(isset($singleMetaData['key']) && $singleMetaData['key'] == '_bundle_cart_key'){
                        $bundleCartKey = $singleMetaData['value'];
                        break;
                    }
                }
                $bundleArray[$bundleCartKey] = array(
                    'enabled' => ($enableEarnPoint == 'disable') ? false: true,
                    'bundled_items' => $bundleItemAllowed
                );

            }else{
                $bundledBy = '';
                foreach ($itemMetaData as $singleMeta){
                    $singleMetaData = $singleMeta->get_data();
                    if(isset($singleMetaData['key']) && $singleMetaData['key'] == '_bundled_by'){
                        $bundledBy = $singleMetaData['value'];
                        break;
                    }
                }
                if(!empty($bundledBy) && isset($bundleArray[$bundledBy]) && !empty($bundleArray[$bundledBy])){
                    $bundledItems = $bundleArray[$bundledBy];
                    $orderItem = $item->get_data();
                    if(isset($orderItem['product_id']) && !empty($orderItem['product_id'])){
                        $currentProductId = $orderItem['product_id'];
                    }else{
                        $currentProductId = $product->get_id();
                    }
                    $currentProductAllow = false;
                    $currentBundle = array();
                    if(isset($bundledItems['bundled_items']) && !empty($bundledItems['bundled_items'])){
                        $currentBundle = $bundledItems['bundled_items'];
                    }
                    if(isset($currentBundle[$currentProductId]) && $currentBundle[$currentProductId]){
                        $currentProductAllow = true;
                    }

                    if(!$bundledItems['enabled']  || !$currentProductAllow){
                        continue;
                    }
                }
            }
            $line_original_price = $item_price = $productHelper->getProductPrice($product,$item,false,$order->get_currency());
            /* Earn point calculation after Discount Price */
            $item_line_subtotal = $item->get_subtotal();
            $item_line_total = $item->get_total();
            $item_line_quantity = $item->get_quantity();
            $line_item_discount_price = 0;
            if($item_line_subtotal != $item_line_total && $is_earn_point_after_discount == 'yes'){
                $line_item_discount_price = ($item_line_subtotal - $item_line_total) / $item_line_quantity;
                $line_item_discount_price = apply_filters('wlpr_product_price', $line_item_discount_price, $item,false,$order->get_currency());
                $item_price = $item_price - $line_item_discount_price;
            }

            $product->set_price($item_price);
            $pointsEarned += apply_filters('wlpr_points_earned_for_order_item', $productHelper->getProductEarnPoint($product, $order), $product, $itemKey, $item, $order) * $item['qty'];

            if($line_item_discount_price > 0){
                /* Need to reset price for Cart display and other plugin */
                $product->set_price($line_original_price);
            }
        }
        $pointsEarned = $this->roundPoints($pointsEarned);
        return apply_filters('wlpr_points_earned_for_purchase', $pointsEarned, $order);
    }

    function checkSignUpPoint($email){
        global $wpdb;
        if(empty($email)){
            return false;
        }
        $pointAction = new PointAction();
        $email = sanitize_email($email);
        $where = $wpdb->prepare('user_email=%s AND action=%s',array($email,'account-signup'));
        $signUpDetails = $pointAction->getWhere($where,'*',true);
        if(!empty($signUpDetails)){
            return true;
        }
        return false;
    }



    public function getDiscountMethod(){
        $wlpr_discount_method = 'coupon';//'fee';//
        $wlpr_discount_method = apply_filters( 'wlpr_redeem_discount_method_type', $wlpr_discount_method );
        return $wlpr_discount_method;
    }

    public function getCouponApplyMethod(){
        $options = get_option('wlpr_settings');
        return (isset($options['wlpr_redeem_when_other_coupon_apply']) && !empty($options['wlpr_redeem_when_other_coupon_apply']) ? $options['wlpr_redeem_when_other_coupon_apply'] : 'both');
    }

    public function isLoyalDiscountApplied(){
        global $woocommerce;
        $loyalCoupon = Loyalty::woocommerce()->get_discount_code();
        if(isset($woocommerce->cart) && !empty($woocommerce->cart) && isset($woocommerce->cart->applied_coupons) && !empty($woocommerce->cart->applied_coupons)){
            if(in_array($loyalCoupon,$woocommerce->cart->applied_coupons)){
                return true;
            }
        }
        return false;
    }

    public function isValidEmailForRedeem($email){
        if(empty($email)){
            return false;
        }
        global $wpdb;
        $userPoint = new Points();
        $email = sanitize_email($email);
        $where = $wpdb->prepare('user_email=%s',array($email));
        $userDetails = $userPoint->getWhere($where,'*',true);
        if(!empty($userDetails)){
            return true;
        }
        return false;
    }
}