<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Helpers;
class Loyalty
{
    /**
     * point instance
     * @param array $config
     * @return Point|null
     * @since 1.0.0
     */
    public static function point($config = array())
    {
        return Point::getInstance($config);
    }

    /**
     * checkout instance
     * @param array $config
     * @return Checkout|null
     * @since 1.0.0
     */
    public static function checkout($config = array())
    {
        return Checkout::getInstance($config);
    }

    /**
     * product instance
     * @param array $config
     * @return Product|null
     * @since 1.0.0
     */
    public static function product($config = array())
    {
        return Product::getInstance($config);
    }

    /**
     * woocommerce instance
     * @param array $config
     * @return Woocommerce|null
     * @since 1.0.0
     */
    public static function woocommerce($config = array())
    {
        return Woocommerce::getInstance($config);
    }

    /**
     * referral instance
     * @param array $config
     * @return Referral|null
     * @since 1.0.0
     */
    public static function referral($config = array())
    {
        return Referral::getInstance($config);
    }

    /**
     * licence instance
     * @param array $config
     * @return License|null
     * @since 1.0.0
     */
    public static function licence($config = array())
    {
        return License::getInstance($config);
    }

    /**
     * licence instance
     * @param array $config
     * @return CsvHelper|null
     * @since 1.0.0
     */
    public static function csv($config = array())
    {
        return CsvHelper::getInstance($config);
    }

    /**
     * licence instance
     * @param array $config
     * @return SocialShare|null
     * @since 1.0.0
     */
    public static function social($config = array())
    {
        return SocialShare::getInstance($config);
    }
}