<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Helpers;

use Wlpr\App\Helpers\Launcher\Settings;

class Launcher
{
    /**
     * Get customizer url
     * @param $template
     * @return string
     */
    public static function get_customizer_url($template)
    {
        $customizer_url = add_query_arg(
            array(
                'wlpr-launcher-customize' => '1',
                'url' => urlencode(add_query_arg(array('wlpr-launcher-preview' => '1', 'wlpr_template' => $template), home_url('/'))),
                'return' => urlencode(admin_url('admin.php?' . http_build_query(array('page' => WLPR_PLUGIN_SLUG, 'view' => 'settings')))),
            ),
            admin_url('customize.php')
        );
        return $customizer_url;
    }

    /**
     * image display
     * @param $name
     * @param $src
     * @param $default_image
     * @param int $width
     * @param int $height
     * @return string
     */
    public static function get_image_display($name,$src,$default_image,$width = 100,$height = 100){
        $id = $name.'_id';
        $image_id = $name.'_image_id';
        $src = !empty($src) ? $src : $default_image;
        return '<div class="wlpr-upload">
            <img id="'.$image_id.'" class="wlpr-image-preview" data-src="' . $src . '" src="' . $src . '" width="' . $width . 'px" height="' . $height . 'px" />
            <div>
                <input type="hidden" name="'.$name.'" id="'.$id.'" value="' . $src . '" />
                <input type="button" onclick="wlpr.selectImage(\''.$id.'\',\''.$image_id.'\')" class="wlpr-upload-image-button button" value="'.__('Upload',WLPR_TEXT_DOMAIN).'"/>
                <input type="button" onclick="wlpr.removeImage(\''.$id.'\',\''.$image_id.'\',\''.$default_image.'\');" class="wlpr-remove-image-button button" value="'.__('Reset',WLPR_TEXT_DOMAIN).'"/>
            </div>
        </div>';
    }
}