<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Helpers;

use ParseCsv\Csv;
use Wlpr\App\Models\PointAction;
use Wlpr\App\Models\PointLog;
use Wlpr\App\Models\Points;

class CsvHelper extends Point
{
    public static $instance = null;
    protected $reader_csv = null;

    /**
     * Checkout constructor.
     * @param array $config
     * @since 1.0.0
     */
    public function __construct($config = array())
    {
    }

    /**
     * instance of class
     * @param array $config
     * @return CsvHelper|null
     * @since 1.0.0
     */
    public static function getInstance(array $config = array())
    {
        if (!self::$instance) {
            self::$instance = new self($config);
        }
        return self::$instance;
    }

    /**
     * Get total record of csv
     * @param $file_path
     * @param bool $with_header
     * @return int
     */
    function getTotalRecord($file_path, $with_header = false)
    {
        $fp = file($file_path);
        $total = count($fp);
        if (!$with_header) {
            $total = $total - 1;
        }
        return $total;
    }

    /**
     * Get header of csv
     * @return string[]
     */
    function getHeader()
    {
        //$header = $this->reader_csv->getHeader();
        $orginal_header = array(
            'user_email',
            'points',
            'refer_code',
            'birth_date'
        );
        return $orginal_header;
    }

    /**
     * Get first record in csv
     * @return array
     */
    function getFirstValue($file_path)
    {
        $first_value = $this->getCsvData($file_path,1,1);
        return !empty($first_value) && is_array($first_value) ? $first_value[0]: array();
    }

    function setCsvData($file_path,$data){
        try {
            $csv = new Csv();
            $csv->loadFile($file_path);
            $count = $csv->getTotalDataRowCount();
            if($count <= 0){
                $hearder = array();
                $hearder[] = $this->getHeader();
                $csv->save($file_path,$hearder,true);
            }
            $csv_hel = new Csv();
            $csv_hel->titles = $this->getHeader();
            $csv_hel->save( $file_path,$data,  true);
        }catch (\Exception $e){

        }
    }

    function getCsvData($file_path,$limit_start = 0,$limit = 5){
        $pair_data = array();
        try {
            $reader_csv = new Csv();
            $reader_csv->offset = $limit_start;
            $reader_csv->limit = $limit;
            $reader_csv->delimiter = ',';
            $reader_csv->titles = $this->getHeader();
            $reader_csv->parseFile($file_path);
            foreach ($reader_csv->data as $data){
                if(isset($data['user_email']) && $data['user_email'] == 'email'){
                    continue;
                }
                if(empty($data)){
                    continue;
                }
                $pair_data[] = $data;
            }

        }catch (\Exception $e){

        }
        return $pair_data;
    }

    /**
     * File delete
     * @param $filepath
     * @return bool
     */
    function file_delete($filepath)
    {
        @chmod($filepath, 0777);
        $status = false;
        // as long as the owner is either the webserver or the ftp
        if (@unlink($filepath)) {
            $status = true;
        }
        return $status;
    }

    /**
     * File upload
     * @param $src
     * @param $dest
     * @return bool
     */
    function file_upload($src, $dest)
    {
        // Create the destination directory if it does not exist
        $baseDir = \dirname($dest);
        if (is_writable($baseDir) && move_uploaded_file($src, $dest)) {
            // Short circuit to prevent file permission errors
            if (self::setPermissions($dest)) {
                $ret = true;
            } else {
                $ret = false;
            }
        } else {
            $ret = false;
        }
        return $ret;
    }

    /**
     * Set permission for file path
     * @param $path
     * @param string $filemode
     * @param string $foldermode
     * @return bool
     */
    public static function setPermissions($path, $filemode = '0644', $foldermode = '0755')
    {
        // Initialise return value
        $ret = true;

        if (is_dir($path)) {
            $dh = opendir($path);

            while ($file = readdir($dh)) {
                if ($file != '.' && $file != '..') {
                    $fullpath = $path . '/' . $file;

                    if (is_dir($fullpath)) {
                        if (!self::setPermissions($fullpath, $filemode, $foldermode)) {
                            $ret = false;
                        }
                    } else {
                        if (isset($filemode)) {
                            if (!@ chmod($fullpath, octdec($filemode))) {
                                $ret = false;
                            }
                        }
                    }
                }
            }

            closedir($dh);

            if (isset($foldermode)) {
                if (!@ chmod($path, octdec($foldermode))) {
                    $ret = false;
                }
            }
        } else {
            if (isset($filemode)) {
                $ret = @ chmod($path, octdec($filemode));
            }
        }

        return $ret;
    }

    /**
     * Save user data in database
     * @param $file_data
     * @param string $need_update
     */
    function save_user($file_data, $need_update = 'no')
    {
        global $wpdb;
        if (!empty($file_data)) {
            foreach ($file_data as $user_data) {

                if(isset($user_data['email']) && !empty($user_data['email']) && $user_data['email'] != 'email'){
                    $user_data['user_email'] = $user_data['email'];
                }

                if (isset($user_data['user_email']) && !empty($user_data['user_email']) && filter_var($user_data['user_email'], \FILTER_VALIDATE_EMAIL)) {
                    $email = sanitize_email($user_data['user_email']);
                    $point_table = new Points();
                    $where = $wpdb->prepare("user_email = %s", $email);
                    $user_points = $point_table->getWhere($where, '*', true);
                    $file_points = (int)(isset($user_data['points']) && !empty($user_data['points'])) ? $user_data['points'] : 0;
                    $old_point = 0;
                    $log_update_action = true;
                    if (isset($user_points->points) && !empty($user_points->points)) {
                        $old_point = $user_points->points;
                    }
                    if (empty($user_points)) {
                        $refer_code = (string)(isset($user_data['refer_code']) && !empty($user_data['refer_code'])) ? $user_data['refer_code'] : '';
                        $unique_refer_code = Loyalty::referral()->get_unique_refer_code($refer_code);
                        $_data = array(
                            'user_email' => $email,
                            'points' => $file_points,
                            'created_date' => date("Y-m-d h:i:s"),
                            'refer_code' => $unique_refer_code
                        );
                        $point_table->insertRow($_data);
                    } elseif (isset($user_points->points)) {
                        if ($need_update == 'yes') {
                            if (!empty($file_points)) {
                                $user_points->points = $file_points;
                            }
                            $update_data = array(
                                'points' => $user_points->points,
                                'created_date' => date('Y-m-d H:i:s')
                            );
                            $where = array('user_email' => $email);
                            $point_table->updateRow($update_data, $where);
                        } else {
                            $log_update_action = false;
                        }
                    }
                    $file_points = $file_points - $old_point;

                    $earn_price = 0.0;
                    $redeem_price = 0.0;
                    if($file_points > 0){
                        $earn_price = $this->getEarnPointAmount($file_points);
                    }else{
                        $redeem_price = $this->getRedeemPointAmount(-$file_points);
                    }
                    // required log parameters
                    $args = array(
                        'user_email' => $email,
                        'points' => $file_points,
                        'event_type' => 'import',
                        'created_date' => (isset($point_table->created_date) && !empty($point_table->created_date)) ? $point_table->created_date : date('Y-m-d H:i:s'),
                        'redeem_price' => $redeem_price,
                        'earn_price' => $earn_price
                    );
                    if (is_admin()) {
                        $admin_user = wp_get_current_user();
                        $args['admin_user_id'] = $admin_user->ID;
                    }
                    // log the event
                    if ($log_update_action) {
                        $point_log = new PointLog();
                        $point_log->add_log_entry($args);
                        $point_action = new PointAction();
                        if($file_points > 0){
                            $point_action->earn_point_action($email, 'import', $args);
                        }else{
                            $point_action->redeem_point_action($email, 'import', $args);
                        }
                    }
                }
            }
        }

    }
}