<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Helpers;
class Checkout
{
    public static $instance = null;

    /**
     * Checkout constructor.
     * @param array $config
     * @since 1.0.0
     */
    public function __construct($config = array())
    {
    }

    /**
     * instance of class
     * @param array $config
     * @return Checkout|null
     * @since 1.0.0
     */
    public static function getInstance(array $config = array())
    {
        if (!self::$instance) {
            self::$instance = new self($config);
        }
        return self::$instance;
    }

    /**
     * Get current cart points
     * @return float|int
     * @since 1.0.0
     */
    function getEarnedCartPoint()
    {
        $product_helper = Loyalty::product();
        $points_earned = 0;
        $bundle_array = array();
        $point_setting = get_option('wlpr_settings');
        $is_earn_point_after_discount = (isset($point_setting['wlpr_is_earn_point_after_discount']) && !empty($point_setting['wlpr_is_earn_point_after_discount'])) ? $point_setting['wlpr_is_earn_point_after_discount'] : 'no';

        foreach (WC()->cart->get_cart() as $item_key => $item) {
            /*if(isset($item['bundled_item_id']) && !empty($item['bundled_item_id'])){
                //$points_earned += apply_filters('wlpr_points_earned_for_cart_item', $product_helper->getProductEarnPoint($item['data']), $item_key, $item) * $item['quantity'];
            }else{
                $points_earned += apply_filters('wlpr_points_earned_for_cart_item', $product_helper->getProductEarnPoint($item['data']), $item_key, $item) * $item['quantity'];
            }*/
            if(isset($item['data']) && $item['data']->get_type() == 'bundle'){
                $enable_earn_point = get_post_meta($item['data']->get_id(), '_wlpr_product_enable_earn_point', true);
                if(!in_array($enable_earn_point,array('global','product','disable'))){
                    $enable_earn_point = 'global';
                }
                if($enable_earn_point == 'global'){
                    list($cate_points, $enable_earn_point) = $product_helper->getCategoryLevelEarnPoints($item['data'], WC()->order_factory);
                }
                $bundle_item_allowed = array();
                foreach ($item['data']->get_bundled_data_items() as $bundled_data_item){
                    $bundle_meta = $bundled_data_item->get_meta_data();
                    $single_bundle_data = $bundled_data_item->get_data();
                    $product_bundle_id = 0;
                    if(isset($single_bundle_data['product_id']) && !empty($single_bundle_data['product_id'])){
                        $product_bundle_id = $single_bundle_data['product_id'];
                    }
                    $bundle_item_allowed[$product_bundle_id] = false;
                    if(isset($bundle_meta['priced_individually']) && $bundle_meta['priced_individually'] === 'yes'){
                        $bundle_item_allowed[$product_bundle_id] = true;
                    }


                }
                $bundle_array[$item['key']] = array(
                    'enabled' => ($enable_earn_point == 'disable') ? false: true,
                    'bundled_items' => $bundle_item_allowed
                );

            }

            if(isset($item['bundled_by']) && !empty($item['bundled_by'])){
                if(isset($bundle_array[$item['bundled_by']]) && !empty($bundle_array[$item['bundled_by']])){
                    $bundled_items = $bundle_array[$item['bundled_by']];
                    $current_product_id = (isset($item['product_id']) && !empty($item['product_id'])) ? $item['product_id']: 0;
                    $current_product_allow = false;
                    $current_bundle = array();
                    if(isset($bundled_items['bundled_items']) && !empty($bundled_items['bundled_items'])){
                        $current_bundle = $bundled_items['bundled_items'];
                    }
                    if(isset($current_bundle[$current_product_id]) && $current_bundle[$current_product_id]){
                        $current_product_allow = true;
                    }
                    if(!$bundled_items['enabled'] || !$current_product_allow){
                        continue;
                    }
                }
            }

            /* Earn point calculation after Discount Price */
            $discount_price = 0;
            $original_price = 0;
            if(isset($item['line_subtotal']) && isset($item['line_total']) && $item['line_subtotal'] != $item['line_total'] && $is_earn_point_after_discount == 'yes'){
                $original_price = $product_price = $product_helper->getProductPrice($item['data']);
                $discount_price = ($item['line_subtotal'] - $item['line_total']) / $item['quantity'];
                $discount_price = apply_filters('wlpr_product_price', $discount_price, null,false,'');
                $product_price = $product_price - $discount_price;
                $item['data']->set_price($product_price);
            }
            $points_earned += apply_filters('wlpr_points_earned_for_cart_item', $product_helper->getProductEarnPoint($item['data']), null) * $item['quantity'];
            if($discount_price > 0){
                /* Need to reset price for Cart display and other plugin */
                $item['data']->set_price($original_price);
            }
        }
        $point_helper = Loyalty::point();
        /*$discount_amount = ( wc_prices_include_tax() ) ? WC()->cart->discount_cart + WC()->cart->discount_cart_tax : WC()->cart->discount_cart;
        $discount_point = min( $point_helper->globalPoints($discount_amount), $points_earned );
        // Apply a filter that will allow users to manipulate the way discounts affect points earned.
        $points_earned = apply_filters( 'wlpr_discount_points_modifier', $points_earned - $discount_point, $points_earned, $discount_amount, $discount_point );*/
        $points_earned = $point_helper->roundPoints($points_earned);
        return apply_filters('wlpr_points_earned_for_purchase', $points_earned, WC()->cart);
    }

    /**
     * Get cart price
     * @return float
     * @since 1.0.0
     */
    public function get_cart_price()
    {
        return wc_prices_include_tax() ? WC()->cart->get_cart_contents_total() + WC()->cart->get_cart_contents_tax() : WC()->cart->get_cart_contents_total();
    }

    /**
     * Check if order is renewal in case Subscriptions is enabled.
     *
     * @param \WC_Order $order
     *
     * @return bool
     * @since 1.0.0
     */
    protected function is_order_renewal($order)
    {
        if (!function_exists('wcs_order_contains_resubscribe') || !function_exists('wcs_order_contains_renewal')) {
            return false;
        }
        if (!wcs_order_contains_resubscribe($order) && !wcs_order_contains_renewal($order)) {
            return false;
        }
        return true;
    }
}