<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
namespace Wlpr\App\Helpers;

use Wlpr\App\Models\PointAction;
use Wlpr\App\Models\PointLog;
use Wlpr\App\Models\Points;

class Base
{

    public function __construct($config = array())
    {
    }

    public function globalPoints($amount)
    {
        $settingOption = get_option('wlpr_settings', '');
        $enableEarnPoint = (isset($settingOption['wlpr_enable_earn_point']) && !empty($settingOption['wlpr_enable_earn_point'])) ? $settingOption['wlpr_enable_earn_point'] : 'yes';
        if($enableEarnPoint == 'yes'){
            $points = (isset($settingOption['wlpr_earn_point']) && (!empty($settingOption['wlpr_earn_point']) || $settingOption['wlpr_earn_point'] == 0)) ? $settingOption['wlpr_earn_point'] : 1;
            $monetaryValue = (isset($settingOption['wlpr_point_earn_price']) && (!empty($settingOption['wlpr_point_earn_price']) || $settingOption['wlpr_point_earn_price'] == 0)) ? $settingOption['wlpr_point_earn_price'] : 1;
            if (!$points || !$monetaryValue || !$amount) {
                return 0;
            }
            return $amount * ($points / $monetaryValue);
        }
        return 0;
    }

    function getRedeemPointAmount($point)
    {
        $settingOption = get_option('wlpr_settings', '');
        $redeemPoint = (isset($settingOption['wlpr_redeem_point']) && !empty($settingOption['wlpr_redeem_point'])) ? $settingOption['wlpr_redeem_point'] : 500;
        $redeemPrice = (isset($settingOption['wlpr_point_redeem_price']) && !empty($settingOption['wlpr_point_redeem_price'])) ? $settingOption['wlpr_point_redeem_price'] : 5;
        $discountPrice = 0;
        if (!empty($redeemPrice) && !empty($redeemPoint) && !empty($point)) {
            $discountPrice = ($point / $redeemPoint) * $redeemPrice;
        }
        return apply_filters('wlpr_discount_price_change', $discountPrice);
    }

    function getRedeemPointDisplayPrice($point){
        $settingOption = get_option('wlpr_settings', '');
        $redeemPoint = (isset($settingOption['wlpr_redeem_point']) && !empty($settingOption['wlpr_redeem_point'])) ? $settingOption['wlpr_redeem_point'] : 500;
        $redeemPrice = (isset($settingOption['wlpr_point_redeem_price']) && !empty($settingOption['wlpr_point_redeem_price'])) ? $settingOption['wlpr_point_redeem_price'] : 5;
        $discountPrice = 0;
        if (!empty($redeemPrice) && !empty($redeemPoint) && !empty($point)) {
            $discountPrice = ($point / $redeemPrice) * $redeemPoint;
        }
        return apply_filters('wlpr_discount_price_change', $discountPrice);
    }

    function getEarnPointAmount($point){
        $settingOption = get_option('wlpr_settings', '');
        $earnPoint = (isset($settingOption['wlpr_earn_point']) && !empty($settingOption['wlpr_earn_point'])) ? $settingOption['wlpr_earn_point'] : 1;
        $earnPrice = (isset($settingOption['wlpr_point_earn_price']) && !empty($settingOption['wlpr_point_earn_price'])) ? $settingOption['wlpr_point_earn_price'] : 1;
        $earnFromPrice = 0;
        if (!empty($earnPrice) && !empty($earnPoint) && !empty($point)) {
            $earnFromPrice = ($point / $earnPoint) * $earnPrice;
        }
        return $earnFromPrice;
    }

    public function getCartMaxDiscountPercentage($maxDiscount)
    {
        $percentage = str_replace('%', '', $maxDiscount) / 100;
        if ('no' === get_option('woocommerce_prices_include_tax')) {
            $discount = WC()->cart->subtotal_ex_tax;
        } else {
            $discount = WC()->cart->subtotal;
        }
        return $percentage * $discount;
    }

    function getPointForDiscount($discountPrice)
    {
        if (empty($discountPrice)) {
            return 0;
        }
        $discountPrice = apply_filters('wlpr_discount_price_change_to_original', $discountPrice);
        $settingOption = get_option('wlpr_settings', '');
        $redeemPoint = (isset($settingOption['wlpr_redeem_point']) && (!empty($settingOption['wlpr_redeem_point']) || $settingOption['wlpr_redeem_point']== 0)) ? $settingOption['wlpr_redeem_point'] : 500;
        $redeemPrice = (isset($settingOption['wlpr_point_redeem_price']) && (!empty($settingOption['wlpr_point_redeem_price']) || $settingOption['wlpr_point_redeem_price'] == 0)) ? $settingOption['wlpr_point_redeem_price'] : 5;
        $requiredPoints = 0;
        if (!empty($redeemPrice)) {
            $requiredPoints = $discountPrice * ($redeemPoint / $redeemPrice);
            $requiredPoints = floor($requiredPoints * 100);
            $requiredPoints = $requiredPoints / 100;
        }
        return ceil($requiredPoints);
    }

    public function getUsersPoints($userEmail)
    {
        global $wpdb;
        $point = 0;
        $pointTable = new Points();
        $userEmail = sanitize_email($userEmail);
        $where = $wpdb->prepare("user_email = %s", array($userEmail));
        $pointList = $pointTable->getWhere($where, '*', false);
        foreach ($pointList as $_points) {
            $point += $_points->points;
        }
        return apply_filters('wlpr_user_points', $point, $userEmail);
    }

    public function getPointLabel()
    {
        $settingOption = get_option('wlpr_settings', '');
        return  (isset($settingOption['wlpr_point_label']) && !empty($settingOption['wlpr_point_label'])) ? __($settingOption['wlpr_point_label'],WLPR_TEXT_DOMAIN) : __('points', WLPR_TEXT_DOMAIN);
    }

    public function roundPoints($points)
    {
        $settingOption = get_option('wlpr_settings', '');
        $roundingOption = (isset($settingOption['wlpr_point_rounding_type']) && !empty($settingOption['wlpr_point_rounding_type'])) ? $settingOption['wlpr_point_rounding_type'] : 'round';
        switch ($roundingOption) {
            case 'ceil':
                $pointEarned = ceil($points);
                break;
            case 'floor':
                $pointEarned = floor($points);
                break;
            default:
                $pointEarned = round($points);
                break;
        }
        return $pointEarned;
    }

    public function addEarnPoint($email, $points, $eventType, $data = null, $orderId = null)
    {
        global $wpdb;
        if (empty($email)) {
            return false;
        }
        if($this->checkExcludeUserRole($email)){
            return false;
        }
        $referralHelper = Loyalty::referral();
        $points = apply_filters('wlpr_before_add_earn_point', $points, $email, $eventType, $data, $orderId);
        $pointTable = new Points();
        $email = sanitize_email($email);
        $where = $wpdb->prepare("user_email = %s", $email);
        $userPoints = $pointTable->getWhere($where, '*', true);
        if (empty($userPoints)) {
            $uniqueReferCode = $referralHelper->get_unique_refer_code();
            $_data = array(
                'user_email' => $email,
                'points' => $points,
                'created_date' => date("Y-m-d h:i:s"),
                'refer_code' => $uniqueReferCode
            );
            if ($orderId) {
                $_data['order_id'] = $orderId;
            }
            $pointTable->insertRow($_data);
        } elseif (isset($userPoints->points)) {
            $userPoints->points += $points;
            $updateData = array(
                'points' => $userPoints->points,
                'created_date' => date('Y-m-d H:i:s')
            );
            $where = array('user_email' => $email);
            $pointTable->updateRow($updateData, $where);
        }
        $earnPrice = 0.0;
        $redeemPrice = 0.0;
        if($points > 0){
            $earnPrice = $this->getEarnPointAmount($points);
        }
        if(in_array($eventType,array('order-cancelled','order-refunded'))){
            $earnPrice = 0.0;
            $redeemPrice = $this->getRedeemPointAmount($points);
        }
        $args = array(
            'user_email' => $email,
            'points' => $points,
            'event_type' => $eventType,
            'created_date' => (isset($pointTable->created_date) && !empty($pointTable->created_date)) ? $pointTable->created_date : date('Y-m-d H:i:s'),
            'redeem_price' => $redeemPrice,
            'earn_price' => $earnPrice
        );

        if ($orderId){
            $args['order_id'] = $orderId;
        }

        if ($data) {
            $args['data'] = $data;
        }
        if(isset($data['product_id'])){
            $args['product_id'] = $data['product_id'];
        }
        $pointAction = new PointAction();
        $statusOfTable = $pointAction->earn_point_action($email, $eventType, $args);
        if($statusOfTable){
            $point_log = new PointLog();
            $point_log->add_log_entry($args);
        }
        if (in_array($eventType, array('account-signup'))){
            $referralHelper->other_action_referral($eventType,$email);
        }
        \WC_Emails::instance();
        do_action('wlpr_after_add_earn_point', $email, $points, $eventType, $data, $orderId);
        return true;
    }

    function reducePoints($userEmail, $points, $eventType, $data = array(), $orderId = null)
    {
        global $wpdb;
        if (empty($userEmail)) return false;
        $points = apply_filters('wlpr_before_reduce_points', $points, $userEmail, $eventType, $data, $orderId);
        $pointTable = new Points();
        $userEmail = sanitize_email($userEmail);
        $where = $wpdb->prepare("user_email = %s", $userEmail);
        $userPoints = $pointTable->getWhere($where, '*', true);
        $createdDate = date("Y-m-d h:i:s");
        if (empty($userPoints)) {
            $uniqueReferCode = Loyalty::referral()->get_unique_refer_code();
            $insertData = array(
                'user_email' => $userEmail,
                'points' => 0,
                'created_date' => $createdDate,
                'refer_code' => $uniqueReferCode
            );
            $pointTable->insertRow($insertData);
        } elseif (isset($userPoints->points) && $userPoints->points > 0) {
            $userPoints->points = $userPoints->points - $points;
            if($userPoints->points <= 0){
                //eg: point 60 , Now user point -10... so must reduce point 50
                $points = $points + $userPoints->points;
                $userPoints->points = 0;
            }
            $update_data = array(
                'points' => $userPoints->points,
                'created_date' => $createdDate
            );
            $where = array('user_email' => $userEmail);
            $pointTable->updateRow($update_data, $where);
        }elseif(isset($userPoints->points) && $userPoints->points <= 0){
            return false;
        }
        $redeemPrice = 0.0;
        if($points > 0){
            $redeemPrice = $this->getRedeemPointAmount($points);
        }
        $args = array(
            'user_email' => $userEmail,
            'points' => -$points,
            'event_type' => $eventType,
            'created_date' => $createdDate,
            'redeem_price' => $redeemPrice,
            'earn_price' => 0.0
        );
        if ($orderId)
            $args['order_id'] = $orderId;
        if ($data) {
            $args['log_data'] = $data;
        }
        $pointLog = new PointLog();
        $pointLog->add_log_entry($args);
        $pointAction = new PointAction();
        $pointAction->redeem_point_action($userEmail, $eventType, $args);
        do_action('wlpr_after_reduce_points', $userEmail, $userPoints->points);
        return true;
    }

    public function getPointEarnedForOrderReceived($orderId)
    {
        global $wpdb;
        $points = 0;
        $pointLogTable = new PointLog();
        $where = $wpdb->prepare('order_id = %d and type = %s', array($orderId, 'order-placed'));
        $pointLog = $pointLogTable->getWhere($where, 'points', true);
        if (isset($pointLog->points) && !empty($pointLog->points)) {
            $points = $pointLog->points;
        }
        return $points;
    }

    function checkExcludeUserRole($email = ''){
        if(empty($email)){
            $user = wp_get_current_user();
        }else{
            $user = get_user_by('email', $email);
        }
        $status = false;
        if(!empty($user)){
            $options = get_option('wlpr_settings');
            $exclude_user_roles = (isset($options['wlpr_exclude_point_earning_roles']) && !empty($options['wlpr_exclude_point_earning_roles']) ? $options['wlpr_exclude_point_earning_roles'] : array());
            foreach ($user->roles as $role){
                if(in_array($role,$exclude_user_roles)){
                    $status = true;
                    break;
                }
            }
        }
        $status = apply_filters('wlpr_exclude_user_role',$status, $email);
        return $status;
    }

    public function eventTypeDescription($eventType, $event = null)
    {
        $eventDescription = '';
        $pointLabel = $this->getPointLabel();
        switch ($eventType) {
            case 'admin-adjustment':
                $eventDescription = sprintf(__('%s adjusted by "admin"', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'order-placed':
                $eventDescription = sprintf(__('%s earned for purchase', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'order-cancelled':
                $eventDescription = sprintf(__('%s adjusted for cancelled order', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'order-refunded':
                $eventDescription = sprintf(__('%s adjusted for an order refund', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'order-redeem':
                $eventDescription = sprintf(__('%s redeemed towards purchase', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'expire':
                $eventDescription = sprintf(__('%s expired', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'product-review':
                $eventDescription = sprintf(__('%s earned for product review', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'account-signup':
                $eventDescription = sprintf(__('%s earned for account signup', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'referring_user':
                $eventDescription = sprintf(__('%s earned via referral code', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'referral_point':
                $eventDescription = sprintf(__('%s earned referred some one', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'import':
                $eventDescription = __('User data imported by Admin', WLPR_TEXT_DOMAIN);
                break;
            case 'birth_date':
                $eventDescription = sprintf(__('%s earned Birthday date update', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'facebook_share':
                $eventDescription = sprintf(__('%s earned for Facebook share', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'twitter_share':
                $eventDescription = sprintf(__('%s earned for twitter share', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'email_share':
                $eventDescription = sprintf(__('%s earned for email share', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'rest-api':
                $eventDescription = sprintf(__('%s adjusted via "REST API"', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'on_birth_date':
                $eventDescription = sprintf(__('%s earned for birthday gift', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
            case 'whatsapp_share':
                $eventDescription = sprintf(__('%s earned for WhatsApp share', WLPR_TEXT_DOMAIN), $pointLabel);
                break;
        }
        return apply_filters('wlpr_point_event_description', $eventDescription, $eventType, $event);
    }

    function activityTypeDescription($item)
    {
        $eventDescription = '';
        $pointLabel = $this->getPointLabel();
        switch ($item->type) {
            case 'admin-adjustment':
                $eventDescription = sprintf(__('%s %s adjusted by "admin"', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'order-placed':
                $eventDescription = sprintf(__('%s %s earned for purchase', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'order-cancelled':
                $eventDescription = sprintf(__('%s %s adjusted for cancelled order', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'order-refunded':
                $eventDescription = sprintf(__('%s %s adjusted for an order refund', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'order-redeem':
                $eventDescription = sprintf(__('%s %s redeemed towards purchase', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'expire':
                $eventDescription = sprintf(__('%s %s expired', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'product-review':
                $eventDescription = sprintf(__('%s %s earned for product review', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'account-signup':
                $eventDescription = sprintf(__('%s %s earned for account signup', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'referring_user':
                $eventDescription = sprintf(__('%s %s earned via referral code', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'referral_point':
                $eventDescription = sprintf(__('%s %s earned referred some one', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'private_note':
                $log_data = json_decode($item->log_data);
                $eventDescription = sprintf(__('Private note: %s', WLPR_TEXT_DOMAIN), esc_attr((isset($log_data->note) && !empty($log_data->note) ? $log_data->note : '')));
                break;
            case 'import':
                $eventDescription = __('User data imported by Admin', WLPR_TEXT_DOMAIN);
                break;
            case 'expire_email':
                $eventDescription = sprintf(__('%s %s about to expire. Notified %s on %s', WLPR_TEXT_DOMAIN),$item->points,$pointLabel,$item->user_email,$item->created_date);
                break;
            case 'birth_date':
                $eventDescription = sprintf(__('%s %s earned Birthday date update', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'facebook_share':
                $eventDescription = sprintf(__('%s %s earned for facebook share', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'twitter_share':
                $eventDescription = sprintf(__('%s %s earned for twitter share', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'email_share':
                $eventDescription = sprintf(__('%s %s earned for email share', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'rest-api':
                $eventDescription = sprintf(__('%s %s adjusted via "REST API"', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'on_birth_date':
                $eventDescription = sprintf(__('%s %s earned for birthday gift', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
            case 'whatsapp_share':
                $eventDescription = sprintf(__('%s %s earned for WhatsApp share', WLPR_TEXT_DOMAIN), $item->points, $pointLabel);
                break;
        }
        return apply_filters('wlpr_point_activity_description', $eventDescription, $item);
    }
}