<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Controllers\Site;

use Wlpr\App\Controllers\Base;
use WC_Coupon;
use WC_Order_Refund;
use Wlpr\App\Helpers\Loyalty;
use Wlpr\App\Helpers\Pagination;
use Wlpr\App\Helpers\Validation;
use Wlpr\App\Helpers\Woocommerce;
use Wlpr\App\Models\PointAction;
use Wlpr\App\Models\PointLog;
use Wlpr\App\Models\Points;

class Main extends Base
{
    protected $endpoint = 'loyalty';

    function add_frontend_scripts()
    {
        $suffix = '.min';
        if(defined('SCRIPT_DEBUG')){
            $suffix  = SCRIPT_DEBUG ? '' : '.min';
        }
        /*$load_fb_sdk = true;
        $load_fb_sdk = apply_filters('wlpr_facebook_sdk_js', $load_fb_sdk);*/
        wp_register_script(WLPR_PLUGIN_SLUG . '-alertify', WLPR_PLUGIN_URL . 'Assets/Admin/Js/alertify'.$suffix.'.js', array('jquery'), WLPR_PLUGIN_VERSION);
        /*if($load_fb_sdk){
            wp_register_script(WLPR_PLUGIN_SLUG . '-fb-sdk', 'https://connect.facebook.net/en_US/sdk.js', array('jquery'), WLPR_PLUGIN_VERSION);
        }*/
        $main_js = array('jquery');
        if (is_checkout()) {
            $main_js[] = 'wc-checkout';
        }else{
            $main_js[] = 'wc-cart-fragments';
        }
        $main_js = apply_filters('wlpr_main_js_require_js',$main_js);
        //$main_js[] = WLPR_PLUGIN_SLUG . '-fb-sdk';
        wp_register_script(WLPR_PLUGIN_SLUG . '-main', WLPR_PLUGIN_URL . 'Assets/Site/Js/wlpr-main'.$suffix.'.js', $main_js, WLPR_PLUGIN_VERSION);

        wp_enqueue_script(WLPR_PLUGIN_SLUG . '-alertify');
        /*if($load_fb_sdk){
            wp_enqueue_script(WLPR_PLUGIN_SLUG . '-fb-sdk');
        }*/
        wp_enqueue_script('wc-cart-fragments');
        wp_enqueue_script(WLPR_PLUGIN_SLUG . '-main');

        wp_register_style(WLPR_PLUGIN_SLUG . '-alertify', WLPR_PLUGIN_URL . 'Assets/Admin/Css/alertify'.$suffix.'.css', array(), WLPR_PLUGIN_VERSION);
        wp_register_style(WLPR_PLUGIN_SLUG . '-font-wlpr', WLPR_PLUGIN_URL . 'Assets/Site/Css/wlpr-front'.$suffix.'.css', array(), WLPR_PLUGIN_VERSION);
        wp_register_style(WLPR_PLUGIN_SLUG . '-wlpr-site', WLPR_PLUGIN_URL . 'Assets/Site/Css/wlpr-site'.$suffix.'.css', array(), WLPR_PLUGIN_VERSION);

        wp_enqueue_style(WLPR_PLUGIN_SLUG . '-alertify');
        wp_enqueue_style(WLPR_PLUGIN_SLUG . '-font-wlpr');
        wp_enqueue_style(WLPR_PLUGIN_SLUG . '-wlpr-site');
        $referral_settings = get_option('wlpr_referral');
        $message = '';
        $referee_point = (isset($referral_settings['wlpr_referred_person']) && (!empty($referral_settings['wlpr_referred_person']) || $referral_settings['wlpr_referred_person'] ==0 )) ? $referral_settings['wlpr_referred_person'] : 50;
        if (!empty($referee_point)) {
            $message = (isset($referral_settings['wlpr_share_content']) && !empty($referral_settings['wlpr_share_content'])) ? __($referral_settings['wlpr_share_content'],WLPR_TEXT_DOMAIN) : __('{wlpr_referee_point} {wlpr_points_label} off your first purchase.',WLPR_TEXT_DOMAIN);
            $point_label = self::$point->getPointLabel();
            $message = str_replace('{wlpr_referee_point}', $referee_point, $message);
            $enable_refer_discount = (isset($referral_settings['wlpr_referral_discount']) && !empty($referral_settings['wlpr_referral_discount'])) ? $referral_settings['wlpr_referral_discount'] : 'no';
            $referral_coupon_amount = (isset($referral_settings['wlpr_referral_coupon_percent']) && !empty($referral_settings['wlpr_referral_coupon_percent'])) ? $referral_settings['wlpr_referral_coupon_percent'] : 0;
            $referral_coupon_type = (isset($referral_settings['wlpr_referral_coupon_percent_type']) && !empty($referral_settings['wlpr_referral_coupon_percent_type'])) ? $referral_settings['wlpr_referral_coupon_percent_type'] : 'fixed';
            if ($enable_refer_discount == 'yes') {
                if ($referral_coupon_type == 'fixed') {
                    $message = str_replace('{wlpr_referee_discount}', $referral_coupon_amount, $message);
                } else {
                    $message = str_replace('{wlpr_referee_discount}', $referral_coupon_amount, $message);
                }
            } else {
                $message = str_replace('{wlpr_referee_discount}', 0, $message);
            }
            $message = str_replace('{wlpr_points_label}', $point_label, $message);
        }
        $setting_option = get_option('wlpr_settings', '');
        $earn_message_position = (isset($setting_option['wlpr_cart_earn_point_display']) && !empty($setting_option['wlpr_cart_earn_point_display']) ? $setting_option['wlpr_cart_earn_point_display'] : 'before');
        $cart_redeem_point_display = (isset($setting_option['wlpr_cart_redeem_point_display']) && !empty($setting_option['wlpr_cart_redeem_point_display']) ? $setting_option['wlpr_cart_redeem_point_display'] : 'before');

        $localize = array(
            'home_url' => get_home_url(),
            'ajax_url' => admin_url('admin-ajax.php'),
            'apply_coupon_nonce' => wp_create_nonce( 'wlpr-coupon-none' ),
            'admin_url' => admin_url(),
            'plugin_url' => WLPR_PLUGIN_URL,
            'user_email' => wp_get_current_user()->user_email,
            'customizer_content_width' => '',
            'wlpr_ajax_none' => wp_create_nonce('apply-coupon'),
            'fb_app_id' => (isset($referral_settings['wlpr_fb_app_id']) && !empty($referral_settings['wlpr_fb_app_id'])) ? $referral_settings['wlpr_fb_app_id'] : '',
            'fb_content' => $message,
            'earn_message_position' => $earn_message_position,
            'redeem_message_position' => $cart_redeem_point_display,
            'wlpr_discount_none' => wp_create_nonce( 'wlpr-discount-none' ),
            'apply_share_nonce' => wp_create_nonce( 'wlpr-share-none' ),
            'checkout_partial_discount_message' => esc_js(__('How many points would you like to apply?', WLPR_TEXT_DOMAIN))
        );
        wp_localize_script(WLPR_PLUGIN_SLUG . '-main', 'wlpr_localize_data', $localize);
    }
    function displayCartMessageFragment($fragment)
    {
        $setting_option = get_option('wlpr_settings', '');
        $cart_earn_point_display = (isset($setting_option['wlpr_cart_earn_point_display']) && !empty($setting_option['wlpr_cart_earn_point_display']) ? $setting_option['wlpr_cart_earn_point_display'] : 'before');
        if (!in_array($cart_earn_point_display, array('summary', 'content'))) {
            $fragment['.wlpr_points_rewards_earn_message'] = $this->getCartEarnMessage();
        }
        $cart_redeem_point_display = (isset($setting_option['wlpr_cart_redeem_point_display']) && !empty($setting_option['wlpr_cart_redeem_point_display']) ? $setting_option['wlpr_cart_redeem_point_display'] : 'before');
        if ($cart_redeem_point_display != 'content') {
            $fragment['.wlpr_point_redeem_earn_points'] = $this->getCartRedeemMessage();
        }
        return $fragment;
    }

    function getCartEarnMessage(){
        if (self::$point->checkExcludeUserRole()) {
            return '<div class="wlpr_points_rewards_earn_message"></div>';
        }
        $setting_option = get_option('wlpr_settings', '');
        $point_earned = self::$checkout->getEarnedCartPoint();
        $point_earned = self::$point->roundPoints($point_earned);
        $message = (isset($setting_option['wlpr_cart_earn_points_message']) && !empty($setting_option['wlpr_cart_earn_points_message'])) ? __($setting_option['wlpr_cart_earn_points_message'],WLPR_TEXT_DOMAIN) : __('Complete your order and earn <strong>{wlpr_points}</strong> {wlpr_points_label} for a discount on a future purchase',WLPR_TEXT_DOMAIN);
        $point_label = self::$point->getPointLabel();
        $message = str_replace('{wlpr_points}', $point_earned, $message);
        $message = str_replace('{wlpr_points_label}', $point_label, $message);
        $message = Woocommerce::getCleanHtml($message);
        $message = apply_filters('wlpr_points_rewards_earn_points_message', $message, $point_earned);
        $message = '<div class="wlpr_points_rewards_earn_message"><div class="wlpr-message-info">' . $message . '</div></div>';
        if (empty($point_earned)) {
            $message = '<div class="wlpr_points_rewards_earn_message"></div>';
        }
        return $message;
    }

    function displayEarnPointsMessage()
    {
        $setting_option = get_option('wlpr_settings', '');
        $cart_earn_point_display = (isset($setting_option['wlpr_cart_earn_point_display']) && !empty($setting_option['wlpr_cart_earn_point_display']) ? $setting_option['wlpr_cart_earn_point_display'] : 'before');
        if (self::$point->checkExcludeUserRole()) {
            if($cart_earn_point_display == 'content'){
                return;
            }
            return '<div class="wlpr_points_rewards_earn_message"></div>';
        }
        if(wp_doing_ajax()){
            $wlpr_nonce = (string)self::$input->post_get('security','');
            if(!Woocommerce::verify_nonce($wlpr_nonce,'wlpr-coupon-none')){
                if($cart_earn_point_display == 'content'){
                    return;
                }
                return '<div class="wlpr_points_rewards_earn_message"></div>';
            }
        }
        $point_earned = self::$checkout->getEarnedCartPoint();
        $point_earned = self::$point->roundPoints($point_earned);
        $message = (isset($setting_option['wlpr_cart_earn_points_message']) && !empty($setting_option['wlpr_cart_earn_points_message'])) ? __($setting_option['wlpr_cart_earn_points_message'],WLPR_TEXT_DOMAIN) : __('Complete your order and earn <strong>{wlpr_points}</strong> {wlpr_points_label} for a discount on a future purchase',WLPR_TEXT_DOMAIN);
        $point_label = self::$point->getPointLabel();
        $message = str_replace('{wlpr_points}', $point_earned, $message);
        $message = str_replace('{wlpr_points_label}', $point_label, $message);
        $message = Woocommerce::getCleanHtml($message);
        $message = apply_filters('wlpr_points_rewards_earn_points_message', $message, $point_earned);
        if (!wp_doing_ajax()) {
            if($cart_earn_point_display == 'content' && !is_checkout()){
                $message = '<tr><td colspan="6" class="wlpr-message-info wlpr_points_rewards_earn_message" >'.$message.'</td></tr>';
            }else {
                $message = '<div class="wlpr_points_rewards_earn_message"><div class="wlpr-message-info">' . $message . '</div></div>';
            }
        }
        if (wp_doing_ajax()) {
            if (empty($point_earned)) {
                $message = '';
            }
            wp_send_json_success($message);
        } else {
            if (empty($point_earned)) {
                if($cart_earn_point_display == 'content'){
                    $message = '<tr><td colspan="6" class="wlpr-message-info wlpr_points_rewards_earn_message">'.$message.'</td></tr>';
                }else{
                    $message = '<div class="wlpr_points_rewards_earn_message"></div>';
                }
            }
            echo $message;
        }
    }

    function checkoutEarnPoints(){
        $point_earned = self::$checkout->getEarnedCartPoint();
        $point_label = self::$point->getPointLabel();
        $point_earned = self::$point->roundPoints($point_earned);
        $setting_option = get_option('wlpr_settings', '');
        $earn_point_summary_text = (isset($setting_option['wlpr_earn_point_order_summary_text']) && !empty($setting_option['wlpr_earn_point_order_summary_text']) ? $setting_option['wlpr_earn_point_order_summary_text'] : 'Earn Points');
        echo "<tr class=\"wlpr-checkout-point\">
   <th>".__($earn_point_summary_text,WLPR_TEXT_DOMAIN)."</th>
   <td>".$point_earned.$point_label."</td>
</tr>";
    }

    function getCartRedeemMessage(){
        $existing_point_discount = self::$woocommerce->get_discount_code();
        $setting_option = get_option('wlpr_settings', '');
        $wlpr_discount_method = self::$point->getDiscountMethod();
        if($wlpr_discount_method == 'fee'){
            if($this->is_fully_discounted() || -(float)WC()->cart->get_fee_total() > 0){
                return '<div class="wlpr_point_redeem_earn_points"></div>';
            }
        }elseif ($this->is_fully_discounted() || !wc_coupons_enabled() || (!empty($existing_point_discount) && WC()->cart->has_discount($existing_point_discount))) {
            return '<div class="wlpr_point_redeem_earn_points"></div>';
        }
        $discount_available = self::$point->getDiscountForRedeemingPoints(false, null, true);

        $message = (isset($setting_option['wlpr_cart_redeem_points_message']) && !empty($setting_option['wlpr_cart_redeem_points_message'])) ? __($setting_option['wlpr_cart_redeem_points_message'],WLPR_TEXT_DOMAIN) : __('Use <strong>{wlpr_points}</strong> {wlpr_points_label} for a <strong>{wplr_points_balance}</strong> discount on this order!',WLPR_TEXT_DOMAIN);
        if (!$message || !$discount_available) {
            return '<div class="wlpr_point_redeem_earn_points"></div>';
        }
        $point_label = self::$point->getPointLabel();
        $points = self::$point->getPointForDiscount($discount_available);
        if (empty($points)) {
            return '<div class="wlpr_point_redeem_earn_points"></div>';
        }
        $message = str_replace('{wlpr_points}', number_format_i18n($points), $message);
        $message = str_replace('{wplr_points_balance}', wc_price($discount_available), $message);
        $message = str_replace('{wlpr_points_label}', $point_label, $message);
        $message = Woocommerce::getCleanHtml($message);
        $message .= '<form class="wlpr_point_apply_discount" id="wlpr_point_apply_discount_form" action="' . esc_url(wc_get_cart_url()) . '" method="post" style="display:inline">';
        $message .= '<input type="hidden" name="wlpr_point_apply_discount_amount" id="wlpr_point_apply_discount_amount" class="wlpr_point_discount_amount" />';
        $message .= '<input type="button" class="button wlpr_point_apply_discount" id="wlpr_point_apply_discount_button" name="wlpr_point_apply_discount" value="' . __('Redeem points', WLPR_TEXT_DOMAIN) . '" /></form>';
        if (is_checkout()) {
            $message .= '<input type="hidden" name="wlpr_is_checkout" id="wlpr_is_checkout" value="1" />';
        } else {
            $message .= '<input type="hidden" name="wlpr_is_checkout" id="wlpr_is_checkout" value="0" />';
        }
        $partial_redemption = (isset($setting_option['wlpr_partial_redemption_enabled']) && !empty($setting_option['wlpr_partial_redemption_enabled'])) ? $setting_option['wlpr_partial_redemption_enabled'] : 'no';
        if ($partial_redemption == 'no') {
            $message .= '<input type="hidden" name="wlpr_is_partial" id="wlpr_is_partial" value="0" />';
        } else {
            $message .= '<input type="hidden" name="wlpr_is_partial" id="wlpr_is_partial" value="1" />';
        }
        $cart_redeem_point_display = (isset($setting_option['wlpr_cart_redeem_point_display']) && !empty($setting_option['wlpr_cart_redeem_point_display']) ? $setting_option['wlpr_cart_redeem_point_display'] : 'before');

        if($cart_redeem_point_display =='content' && !is_checkout()){
            $message = '<tr><td colspan="6" class="wlpr-message-info wlpr_point_redeem_earn_points">'.$message.'</td></tr>';
        }else{
            $message = '<div class="wlpr_point_redeem_earn_points"><div class="wlpr-message-info">' . $message . '</div></div>';
        }
        return apply_filters('wlpr_point_redeem_points_message', $message, $discount_available);
    }
    function displayRedeemPointsMessage()
    {
        /*
         * Rules:
         * Don't display redeem message to user if,
         * cart total fully discounted.
         * coupons are disabled
         * points discount already applied
         *
         * */
        $existing_point_discount = self::$woocommerce->get_discount_code();
        $setting_option = get_option('wlpr_settings', '');
        $wlpr_discount_method = self::$point->getDiscountMethod();
        if($wlpr_discount_method == 'fee'){
            if($this->is_fully_discounted() || -(float)WC()->cart->get_fee_total() > 0){
                return '<div class="wlpr_point_redeem_earn_points"></div>';
            }
        }elseif ($this->is_fully_discounted() || !wc_coupons_enabled() || (!empty($existing_point_discount) && WC()->cart->has_discount($existing_point_discount))) {
            return '<div class="wlpr_point_redeem_earn_points"></div>';
        }
        $discount_available = self::$point->getDiscountForRedeemingPoints(false, null, true);

        $message = (isset($setting_option['wlpr_cart_redeem_points_message']) && !empty($setting_option['wlpr_cart_redeem_points_message'])) ? __($setting_option['wlpr_cart_redeem_points_message'],WLPR_TEXT_DOMAIN) : __('Use <strong>{wlpr_points}</strong> {wlpr_points_label} for a <strong>{wplr_points_balance}</strong> discount on this order!',WLPR_TEXT_DOMAIN);
        if (!$message || !$discount_available) {
            return '<div class="wlpr_point_redeem_earn_points"></div>';
        }
        $point_label = self::$point->getPointLabel();
        $points = self::$point->getPointForDiscount($discount_available);
        if (empty($points)) {
            return '<div class="wlpr_point_redeem_earn_points"></div>';
        }
        $message = str_replace('{wlpr_points}', number_format_i18n($points), $message);
        $message = str_replace('{wplr_points_balance}', wc_price($discount_available), $message);
        $message = str_replace('{wlpr_points_label}', $point_label, $message);
        $message = Woocommerce::getCleanHtml($message);
        $message .= '<form class="wlpr_point_apply_discount" id="wlpr_point_apply_discount_form" action="' . esc_url(wc_get_cart_url()) . '" method="post" style="display:inline">';
        $message .= '<input type="hidden" name="wlpr_point_apply_discount_amount" id="wlpr_point_apply_discount_amount" class="wlpr_point_discount_amount" />';
        $message .= '<input type="button" class="button wlpr_point_apply_discount" id="wlpr_point_apply_discount_button" name="wlpr_point_apply_discount" value="' . __('Redeem points', WLPR_TEXT_DOMAIN) . '" /></form>';
        if (is_checkout()) {
            $message .= '<input type="hidden" name="wlpr_is_checkout" id="wlpr_is_checkout" value="1" />';
        } else {
            $message .= '<input type="hidden" name="wlpr_is_checkout" id="wlpr_is_checkout" value="0" />';
        }
        $partial_redemption = (isset($setting_option['wlpr_partial_redemption_enabled']) && !empty($setting_option['wlpr_partial_redemption_enabled'])) ? $setting_option['wlpr_partial_redemption_enabled'] : 'no';
        if ($partial_redemption == 'no') {
            $message .= '<input type="hidden" name="wlpr_is_partial" id="wlpr_is_partial" value="0" />';
        } else {
            $message .= '<input type="hidden" name="wlpr_is_partial" id="wlpr_is_partial" value="1" />';
        }
        $cart_redeem_point_display = (isset($setting_option['wlpr_cart_redeem_point_display']) && !empty($setting_option['wlpr_cart_redeem_point_display']) ? $setting_option['wlpr_cart_redeem_point_display'] : 'before');

        if($cart_redeem_point_display =='content' && !is_checkout()){
            $message = '<tr><td colspan="6" class="wlpr-message-info wlpr_point_redeem_earn_points">'.$message.'</td></tr>';
        }else{
            $message = '<div class="wlpr_point_redeem_earn_points"><div class="wlpr-message-info">' . $message . '</div></div>';
        }
        echo apply_filters('wlpr_point_redeem_points_message', $message, $discount_available);
    }

    public function renderDiscountJavascript()
    {
        $setting_option = get_option('wlpr_settings', '');
        $partial_redemption = (isset($setting_option['wlpr_partial_redemption_enabled']) && !empty($setting_option['wlpr_partial_redemption_enabled'])) ? $setting_option['wlpr_partial_redemption_enabled'] : 'no';
        if ('yes' === $partial_redemption) {
            $points = 0;
            wc_enqueue_js('
				$( "body" ).on( "click", "#wlpr_point_apply_discount_button", function( e ) {
				e.preventDefault();
					alertify.prompt( "' . esc_js(__('How many points would you like to apply?', WLPR_TEXT_DOMAIN)) . '", "' . $points . '",function(evt, value) {
					
					    $( "#wlpr_point_apply_discount_amount" ).val( value );
					    var $section = $( "div.wlpr_point_redeem_earn_points" );
					    var is_checkout = $("#wlpr_is_checkout").val();
						var data = {
							action: "wlpr_loyal_point_apply_discount",
							discount_amount: value,
							security: ( wlpr_localize_data.apply_coupon_nonce ? wlpr_localize_data.apply_coupon_nonce : wlpr_localize_data.wlpr_ajax_none )
						};
						$.ajax({
							type:     "POST",
							url:      wlpr_localize_data.ajax_url,
							data:     data,
							success:  function( json ) {
							    if(is_checkout == 1){
							        $section.hide();
							        if(json.success){
							        $( "body" ).trigger( "update_checkout" );
							        }
							    }else{
							        window.location.reload();
							    }
							},
							dataType: "json"
						});
					} ).setHeader(""); ;
				});
			');
        }
    }

    function displayReferralMessage()
    {
        if (self::$point->checkExcludeUserRole()) {
            return false;
        }
        $referral_code = self::$woocommerce->get_refer_discount_code();
        $options = get_option('wlpr_referral');
        $message = (isset($options['wlpr_cart_referee_reward_message']) && !empty($options['wlpr_cart_referee_reward_message']) ? __($options['wlpr_cart_referee_reward_message'],WLPR_TEXT_DOMAIN) : __('Complete the order to get {wlpr_referee_point} {wlpr_points_label} via referral program.', WLPR_TEXT_DOMAIN));
        $referral_helper = Loyalty::referral();
        if (!empty($referral_code) && get_current_user_id() <= 0 && !empty($message) ) {
            $points = $referral_helper->get_fixed_point();
            $sub_total = 0;
            foreach (WC()->cart->cart_contents as $item){
                $sub_total += self::$product->getProductPrice($item['data']) * $item['quantity'];
            }

            $points += $referral_helper->get_rule_point($sub_total);
            $message = str_replace('{wlpr_referee_point}', $points, $message);
            $message = str_replace('{wlpr_points_label}', self::$point->getPointLabel(), $message);
            $message = Woocommerce::getCleanHtml($message);
            echo '<div class="wlpr-message-info wlpr_cart_referee_reward_message">' . $message . '</div>';
        }
    }

    public function ajaxApplyDiscount()
    {
        $wlpr_nonce = (string)self::$input->post_get('wlpr_none','');
        if(!Woocommerce::verify_nonce($wlpr_nonce,'wlpr-discount-none')){
            $data = array(
                'message' => __('Invalid none', WLPR_TEXT_DOMAIN),
            );
            wp_send_json_error($data);
        }
        self::$woocommerce->set_discount_code('');
        $existing_discount = self::$woocommerce->get_discount_code();
        $wlpr_discount_method = self::$point->getDiscountMethod();
        $discount_amount = (int)self::$input->post_get('discount_amount',0);
        $setting_option = get_option('wlpr_settings', '');
        $partial_redemption = (isset($setting_option['wlpr_partial_redemption_enabled']) && !empty($setting_option['wlpr_partial_redemption_enabled'])) ? $setting_option['wlpr_partial_redemption_enabled'] : 'no';
        if(empty($discount_amount) && $partial_redemption == 'yes'){
            $data = array(
                'message' => __('Please enter discount amount', WLPR_TEXT_DOMAIN),
            );
            wp_send_json_error($data);
        }

        if (!empty($existing_discount) && WC()->cart->has_discount($existing_discount)) {
            $data = array(
                'message' => __('Already discount applied', WLPR_TEXT_DOMAIN),
            );
            wp_send_json_error($data);
        }
        $discount_amount = empty($discount_amount) ? self::$point->getDiscountForRedeemingPoints(false, null, false): $discount_amount;
        if($wlpr_discount_method == 'fee'){
            self::$woocommerce->set_discount_amount($discount_amount);
            $discount_code = self::$woocommerce->generate_discount_code();
        }else{
            self::$woocommerce->set_discount_amount($discount_amount);
            $discount_code = self::$woocommerce->generate_discount_code();
            WC()->cart->add_discount($discount_code);
        }

        $data = array(
            'message' => wc_get_notices(),
            'code' => $discount_code
        );
        wp_send_json_success($data);
    }

    public function cartApplyDiscount()
    {
        $wlpr_discount_method = self::$point->getDiscountMethod();
        if($wlpr_discount_method != 'fee') {
            if (!is_cart() || !isset($_POST['wlpr_point_apply_discount'])) {
                return;
            }
            $existing_discount = self::$woocommerce->get_discount_code();
            if (!empty($existing_discount) && WC()->cart->has_discount($existing_discount)) {
                return;
            }
            $discount_amount = self::$input->post_get('wlpr_point_apply_discount_amount',0);
            self::$woocommerce->set_discount_amount($discount_amount);
            $discount_code = self::$woocommerce->generate_discount_code();
            WC()->cart->add_discount($discount_code);
        }
    }

    function is_fully_discounted()
    {

        if (WC()->cart->prices_include_tax && 0 >= (WC()->cart->cart_contents_total + WC()->cart->tax_total)) {
            return true;
        }
        if (!WC()->cart->prices_include_tax && 0 >= WC()->cart->cart_contents_total) {
            return true;
        }
        return false;
    }

    public function getDiscountData($data, $code)
    {
        $wlpr_discount_method = self::$point->getDiscountMethod();
        $can_allow_discount = self::$point->getCouponApplyMethod();

        if($wlpr_discount_method == 'fee') {
            return $data;
        }elseif(isset(WC()->cart->applied_coupons) && is_array(WC()->cart->applied_coupons) && count(WC()->cart->applied_coupons) > 1 && (in_array($can_allow_discount,array('other')))){
            return $data;
        }
        $referral_helper = Loyalty::referral();
        if ((strtolower($code) == self::$woocommerce->get_discount_code()) || $referral_helper->checkReferCouponBeforeCouponApply($code)) {
            $data = array(
                'id' => 0,
                'type' => 'fixed_cart',
                'amount' => 0,
                'coupon_amount' => 0,
                'individual_use' => false,
                'product_ids' => array(),
                'exclude_product_ids' => array(),
                'usage_limit' => '',
                'usage_count' => '',
                'expiry_date' => '',
                'apply_before_tax' => 'yes',
                'free_shipping' => false,
                'product_categories' => array(),
                'exclude_product_categories' => array(),
                'exclude_sale_items' => false,
                'minimum_amount' => '',
                'maximum_amount' => '',
                'customer_email' => '',
            );
        }
        return $data;
    }

    public function getDiscountErrorMessage($message, $mdg_error, $coupon)
    {
        if(is_null($coupon)){
            return $message;
        }
        $wlpr_discount_method = self::$point->getDiscountMethod();
        $can_allow_discount = self::$point->getCouponApplyMethod();
        if($wlpr_discount_method == 'fee' || (in_array($can_allow_discount,array('other')))) {
            if((strtolower($coupon->get_code()) == self::$woocommerce->get_discount_code())){
                $message = sprintf(__('Sorry, it is not possible to apply coupon <b>"%s"</b> as you have another discount applied in cart.',WLPR_TEXT_DOMAIN), $this->changeCouponLabel($coupon));
            }
            return $message;
        }
        $referral_helper = Loyalty::referral();
        $referral_settings = get_option('wlpr_referral');
        $referral_discount_enable = (isset($referral_settings['wlpr_referral_discount']) && !empty($referral_settings['wlpr_referral_discount'])) ? $referral_settings['wlpr_referral_discount'] : 'no';
        if ($referral_discount_enable === 'no') {
            return $message;
        }
        if (!empty($coupon->get_code()) && $referral_helper->isValidReferCoupon($coupon->get_code())) {
            $message = esc_html(__('When user email address is provided in the checkout, this coupon will be applied automatically.', WLPR_TEXT_DOMAIN));
        }
        $code = $coupon->get_code();
        if (strstr(strtoupper($code), 'WLPR_POINTS_REDEMPTION')) {
            $label = esc_attr(__((isset($setting_option['wlpr_cart_point_name']) && !empty($setting_option['wlpr_cart_point_name'])) ? $setting_option['wlpr_cart_point_name'] : 'Points discount',WLPR_TEXT_DOMAIN));

            $message = sprintf( __( 'Sorry, it seems the coupon "%s" is invalid - it has now been removed from your order.', WLPR_TEXT_DOMAIN ), esc_html( $label ) );
        }
        return $message;
    }

    public function getDiscountAmount($discount, $discounting_amount, $cart_item, $single, $coupon)
    {
        $wlpr_discount_method = self::$point->getDiscountMethod();
        $can_allow_discount = self::$point->getCouponApplyMethod();
        if($wlpr_discount_method == 'fee') {
            return $discount;
        }elseif(count(WC()->cart->applied_coupons) > 1 && (in_array($can_allow_discount,array('other')))){
            return $discount;
        }

        $referral_helper = Loyalty::referral();
        $product_helper = Loyalty::product();
        $referral_settings = get_option('wlpr_referral');
        $referral_discount = (isset($referral_settings['wlpr_referral_coupon_percent']) && !empty($referral_settings['wlpr_referral_coupon_percent'])) ? $referral_settings['wlpr_referral_coupon_percent'] : 0;
        $referral_percentage_type = (isset($referral_settings['wlpr_referral_coupon_percent_type']) && !empty($referral_settings['wlpr_referral_coupon_percent_type'])) ? $referral_settings['wlpr_referral_coupon_percent_type'] : 'fixed';
        if ($referral_helper->checkReferCouponBeforeCouponApply($coupon->get_code())) {
            $bundle_array = array();
            $total_product = 0;
            foreach (WC()->cart->cart_contents as $item){

                if(isset($item['data']) && $item['data']->get_type() == 'bundle') {
                    $enable_earn_point = get_post_meta($item['data']->get_id(), '_wlpr_product_enable_earn_point', true);
                    if (!in_array($enable_earn_point, array('global', 'product', 'disable'))) {
                        $enable_earn_point = 'global';
                    }
                    if ($enable_earn_point == 'global') {
                        list($cate_points, $enable_earn_point) = $product_helper->getCategoryLevelEarnPoints($item['data'], WC()->order_factory);
                    }
                    $bundle_item_allowed = array();
                    foreach ($item['data']->get_bundled_data_items() as $bundled_data_item){
                        $bundle_meta = $bundled_data_item->get_meta_data();
                        $single_bundle_data = $bundled_data_item->get_data();
                        $product_bundle_id = 0;
                        if(isset($single_bundle_data['product_id']) && !empty($single_bundle_data['product_id'])){
                            $product_bundle_id = $single_bundle_data['product_id'];
                        }
                        $bundle_item_allowed[$product_bundle_id] = false;
                        if(isset($bundle_meta['priced_individually']) && $bundle_meta['priced_individually'] === 'yes'){
                            $bundle_item_allowed[$product_bundle_id] = true;
                        }


                    }
                    $bundle_array[$item['key']] = array(
                        'enabled' => ($enable_earn_point == 'disable') ? false: true,
                        'bundled_items' => $bundle_item_allowed
                    );
                }
                if(isset($item['bundled_by']) && !empty($item['bundled_by'])){
                    if(isset($bundle_array[$item['bundled_by']]) && !empty($bundle_array[$item['bundled_by']])){
                        $bundled_items = $bundle_array[$item['bundled_by']];
                        $current_product_id = (isset($item['product_id']) && !empty($item['product_id'])) ? $item['product_id']: 0;
                        $current_product_allow = false;
                        $current_bundle = array();
                        if(isset($bundled_items['bundled_items']) && !empty($bundled_items['bundled_items'])){
                            $current_bundle = $bundled_items['bundled_items'];
                        }
                        if(isset($current_bundle[$current_product_id]) && $current_bundle[$current_product_id]){
                            $current_product_allow = true;
                        }
                        if(!$bundled_items['enabled'] || !$current_product_allow){
                            continue;
                        }
                    }
                }
                if($referral_percentage_type == 'fixed'){
                    $total_product += 1;
                }else{
                    $total_product = 1;
                }
                //
            }



            if ($referral_percentage_type != 'fixed') {
                $referral_discount = $discounting_amount * ($referral_discount / 100);
            }
            if (version_compare(WC_VERSION, '3.2.0', '<')) {
                $referral_discount = $referral_discount / $cart_item['quantity'];
            }else{
                $referral_discount = $referral_discount / $total_product;
            }
            return round(min($referral_discount, $discounting_amount), wc_get_rounding_precision());
        }
        if (strtolower($coupon->get_code()) != self::$woocommerce->get_discount_code()) {
            return $discount;
        }
        $existing_discount_amounts = self::$woocommerce->get_discount_total_from_existing_coupons();
        $cart_item_qty = $cart_item['quantity'];
        $cart_item_data = $cart_item['data'];
        $sub_total_inc_tax = WC()->cart->subtotal - $existing_discount_amounts;
        if (wc_prices_include_tax()) {
            $discount_percent = (
                    wc_get_price_including_tax($cart_item_data) * $cart_item_qty - self::$woocommerce->get_cart_item_discount_total($cart_item)
                ) / $sub_total_inc_tax;
        } else {
            $sub_total_ex_tax = WC()->cart->subtotal_ex_tax - $existing_discount_amounts;
            $discount_percent = (
                    wc_get_price_excluding_tax($cart_item_data) * $cart_item_qty - self::$woocommerce->get_cart_item_discount_total($cart_item)
                ) / $sub_total_ex_tax;
        }
        $total_discount = self::$point->getDiscountForRedeemingPoints(true, $existing_discount_amounts);
        if ($total_discount <= 0) {
            WC()->cart->remove_coupon($coupon->get_code());
        }
        $total_with_discount_percent = (float)$total_discount * $discount_percent;
        if (version_compare(WC_VERSION, '3.2.0', '<')) {
            $total_with_discount_percent = $total_with_discount_percent / $cart_item['quantity'];
        }
        if (version_compare(WC_VERSION, '2.6.3', '>')) {
            return round(min($total_with_discount_percent, $discounting_amount), wc_get_rounding_precision());
        } else {
            return round(min($total_with_discount_percent, $discounting_amount), 6);
        }
    }

    public function getDiscountAppliedMessage($message, $message_code, $coupon)
    {
        $wlpr_discount_method = self::$point->getDiscountMethod();
        $can_allow_discount = self::$point->getCouponApplyMethod();
        if($can_allow_discount == 'loyal' && self::$point->isLoyalDiscountApplied()){
            return '';
        }
        if($wlpr_discount_method == 'fee') {
            return $message;
        }
        if (WC_Coupon::WC_COUPON_SUCCESS === $message_code && $coupon->get_code() === self::$woocommerce->get_discount_code()) {
            return __('Discount Applied Successfully', WLPR_TEXT_DOMAIN);
        } else {
            return $message;
        }
    }

    public function removeThirdPartyCoupon(){
        $can_allow_discount = self::$point->getCouponApplyMethod();
        if($can_allow_discount == 'loyal' &&  self::$point->isLoyalDiscountApplied()){
            global $woocommerce;
            $loyal_coupons = self::$woocommerce->get_discount_code();
            if(!is_array($loyal_coupons)){
                $loyal_coupons = array($loyal_coupons);
            }
            if(isset($woocommerce->cart) && !empty($woocommerce->cart) && isset($woocommerce->cart->applied_coupons) && !empty($woocommerce->cart->applied_coupons)){
                $removed_coupon = false;
                foreach ($woocommerce->cart->applied_coupons as $code){
                   if(!in_array($code, $loyal_coupons)){
                       $removed_coupon = true;
                       WC()->cart->remove_coupon($code);
                       if(function_exists('wc_add_notice')){
                           $msg = sprintf(__('Sorry, it is not possible to apply coupon <b>"%s"</b> as you already have a discount applied in cart.',WLPR_TEXT_DOMAIN), $code);
                           $msg = apply_filters('wlpr_notice_on_remove_coupon_while_having_a_discount', $msg, $code);
                           wc_add_notice( $msg, 'notice' );
                       }
                   }
                }
                if($removed_coupon){
                    WC()->cart->calculate_totals();
                }
            }

        }
    }

    public function logRedemptionPoints($order_id)
    {
        $logged_points = get_post_meta($order_id, '_wlpr_points_logged_redemption', true);
        if (!empty($logged_points)) {
            return;
        }
        $discount_code = self::$woocommerce->get_discount_code();
        $discount_method = self::$point->getDiscountMethod();
        $discount_amount = 0;
        $points_redeemed = 0;
        if($discount_method != 'fee'){
            $discount_amount = self::$woocommerce->get_discount_from_code($discount_code);
            $points_redeemed = self::$point->getPointForDiscount($discount_amount);
        }
        update_post_meta($order_id, '_wlpr_points_logged_redemption', array('points' => $points_redeemed, 'amount' => $discount_amount, 'discount_code' => $discount_code));
    }

    public function changeCouponLabel($label,$discount = '')
    {
        $referral_settings = get_option('wlpr_referral', '');
        $enable_referral = (isset($referral_settings['wlpr_enable_referral']) && !empty($referral_settings['wlpr_enable_referral'])) ? $referral_settings['wlpr_enable_referral'] : 'yes';
        $referral_data = '';
        if(isset($discount) && !empty($discount) && $enable_referral){
            $discount_code = $discount->get_code();
            $referral_data = Loyalty::referral()->isValidReferCoupon($discount_code);
        }

        if (strstr(strtoupper($label), 'WLPR_POINTS_REDEMPTION')) {
            $setting_option = get_option('wlpr_settings', '');
            $label = (isset($setting_option['wlpr_cart_point_name']) && !empty($setting_option['wlpr_cart_point_name']))
                ? $setting_option['wlpr_cart_point_name'] : 'Points discount';
            $label = esc_attr(__($label,WLPR_TEXT_DOMAIN));
        } elseif (!empty($referral_data)) {
            $label = (isset($referral_settings['wlpr_cart_referal_coupon_name']) && !empty($referral_settings['wlpr_cart_referal_coupon_name']))
                ? $referral_settings['wlpr_cart_referal_coupon_name'] : 'Referral discount';
            $label = esc_attr(__($label,WLPR_TEXT_DOMAIN));
        }
        return $label;
    }

    public function pointsLast()
    {
        $ordered_coupons = array();
        $points = array();
        foreach (WC()->cart->get_applied_coupons() as $code) {
            if (strstr($code, 'wlpr_points_redemption_')) {
                $points[] = $code;
            } else {
                $ordered_coupons[] = $code;
            }
        }
        WC()->cart->applied_coupons = array_merge($ordered_coupons, $points);
    }

    public function renderThankYouMessage($order_id)
    {
        $points = self::$point->getPointEarnedForOrderReceived($order_id);
        $order = self::$woocommerce->getOrder($order_id);
        $order_email = $order->get_billing_email();
        self::$woocommerce->set_discount_code('');
        self::$woocommerce->set_discount_amount(0);
        self::$woocommerce->set_refer_discount_code('');
        if (self::$point->checkExcludeUserRole($order_email)) {
            return;
        }
        $total_points = self::$point->getUsersPoints($order_email);
        $setting_option = get_option('wlpr_settings', '');
        $message = (isset($setting_option['wlpr_thank_you_message']) && !empty($setting_option['wlpr_thank_you_message'])) ? __($setting_option['wlpr_thank_you_message'],WLPR_TEXT_DOMAIN) : __('You have earned <strong>{wlpr_points}</strong> {wlpr_points_label} for this order. You have a total of <strong>{wlpr_total_points}</strong> {wlpr_total_points_label}.',WLPR_TEXT_DOMAIN);
        if (!$message || !$points) {
            return;
        }
        $message = str_replace('{wlpr_points}', number_format_i18n($points), $message);
        $message = str_replace('{wlpr_points_label}', self::$point->getPointLabel(), $message);
        $message = str_replace('{wlpr_total_points}', number_format_i18n($total_points), $message);
        $message = str_replace('{wlpr_total_points_label}', self::$point->getPointLabel(), $message);
        $message = Woocommerce::getCleanHtml($message);
        $message = '<span>' . $message . '</span>';
        echo apply_filters('wlpr_thank_you_message', $message, $points, $total_points);
    }

    public function discountRemoved($coupon_code)
    {
        $wlpr_discount_method = self::$point->getDiscountMethod();
        if($wlpr_discount_method != 'fee') {
            if (!strstr($coupon_code, 'wlpr_points_redemption_')) {
                return;
            }

            if (is_checkout()) {
                $this->displayRedeemPointsMessage();
            }
        }
    }

    public function handleCancelledRefundedOrder($order_id)
    {
        $order = self::$woocommerce->getOrder($order_id);
        $order_id = $order->get_id();
        $order_user_email = $order->get_billing_email();
        if (!$order_user_email) {
            return;
        }
        $points_earned = get_post_meta($order_id, '_wlpr_points_earned', true);
        if ($points_earned > 0) {
            self::$point->reducePoints($order_user_email, $points_earned, 'order-cancelled', null, $order_id);
            delete_post_meta($order_id, '_wlpr_points_earned');
            $order->add_order_note(sprintf(__('%1$d %2$s removed.', WLPR_TEXT_DOMAIN), $points_earned, self::$point->getPointLabel()));
        }
        $points_redeemed = get_post_meta($order_id, '_wlpr_points_redeemed', true);
        if ($points_redeemed > 0) {
            self::$point->addEarnPoint($order_user_email, $points_redeemed, 'order-cancelled', null, $order_id);
            delete_post_meta($order_id, '_wlpr_points_redeemed');
            $order->add_order_note(sprintf(__('%1$d %2$s credited back to customer.', WLPR_TEXT_DOMAIN), $points_redeemed, self::$point->getPointLabel()));
        }
    }

    public function handlePartiallyRefundedOrder($order_id, $refund_id)
    {
        $order = self::$woocommerce->getOrder($order_id);
        $order_user_email = $order->get_billing_email();
        if (!$order_user_email) {
            return;
        }
        $points_earned = get_post_meta($order_id, '_wlpr_points_earned', true);
        if ($points_earned > 0) {
            $refund = new WC_Order_Refund($refund_id);
            $points_refunded = self::$point->globalPoints($refund->get_amount());
            if ($points_earned < $points_refunded) {
                $points_refunded = $points_earned;
            }
            $points_refunded = self::$point->roundPoints($points_refunded);
            update_post_meta($order_id, '_wlpr_points_earned', ($points_earned - $points_refunded));
            self::$point->reducePoints($order_user_email, $points_refunded, 'order-refunded', null, $order_id);
            $order->add_order_note(sprintf(__('%1$d %2$s removed.', WLPR_TEXT_DOMAIN), $points_refunded, self::$point->getPointLabel()));
        }
    }
    function renderProductMessageStyle(){
        $point_setting = get_option('wlpr_settings');
        $show_product_message = (isset($point_setting['display_product_message_page']) && !empty($point_setting['display_product_message_page'])) ? $point_setting['display_product_message_page'] : 'all';
        $style = '';
        $display_product_display_position = (isset($point_setting['display_product_display_position']) && !empty($point_setting['display_product_display_position']) ? $point_setting['display_product_display_position'] : 'before_price');
        $message = (isset($point_setting['wlpr_single_product_message']) && !empty($point_setting['wlpr_single_product_message'])) ? __($point_setting['wlpr_single_product_message'],WLPR_TEXT_DOMAIN) : __('Purchase this product now and earn <strong>{wlpr_points}</strong> {wlpr_points_label}!',WLPR_TEXT_DOMAIN);
        if(in_array($show_product_message,array('list')) && (is_shop() || is_product_category())){
            if(!empty($message)){
                $style = '.wc-points-rewards-product-message{
    display: block;
}';
            }
        }elseif (in_array($show_product_message,array('single')) && is_product() ){
            if(!empty($message)){
                $style = '.wc-points-rewards-product-message{
    display: block;
}
.products .wc-points-rewards-product-message{
    display: none !important;
}
.product_list_widget .wc-points-rewards-product-message{
    display: none !important;
}';
            }
        }elseif(in_array($show_product_message,array('all'))) {
            if (!empty($message)) {
                $style = '.wc-points-rewards-product-message{
                    display: block;
                }';
            }
        }
        $style = apply_filters('wlpr_single_product_message_style', $style, $this);
        wp_register_style( 'wlpr-custom-style', false ); // phpcs:ignore
        wp_enqueue_style( 'wlpr-custom-style' );
        wp_add_inline_style("wlpr-custom-style",$style);
    }

    function renderProductMessageCartLink($cart_link,$product){
        if (self::$point->checkExcludeUserRole()) {
            return $cart_link;
        }
        if ( (isset($_REQUEST['app_name']) && isset($_REQUEST['scope']) && isset($_REQUEST['oauth_consumer_key']))
            || (isset($_REQUEST['consumer_key']) && isset($_REQUEST['consumer_secret']))) {
            return $cart_link;
        }
        $point_setting = get_option('wlpr_settings');
        $message = (isset($point_setting['wlpr_single_product_message']) && !empty($point_setting['wlpr_single_product_message'])) ? __($point_setting['wlpr_single_product_message'],WLPR_TEXT_DOMAIN) : __('Purchase this product now and earn <strong>{wlpr_points}</strong> {wlpr_points_label}!',WLPR_TEXT_DOMAIN);
        $points_earned = self::$product->getProductEarnPoint($product);
        $points_earned = self::$point->roundPoints($points_earned);
        if (!$message || !$points_earned) {
            $message = '';
        } else {
            if (class_exists('WC_Dynamic_Pricing')) {
                if (get_post_meta($product->get_id(), '_pricing_rules', true)) {
                    $message = $this->get_variation_product_message($points_earned);
                }
            }
            if (method_exists($product, 'get_available_variations')) {
                $variations = $product->get_available_variations();
                $points = $this->get_highest_points_variation($variations, $product->get_id());
                $message = '';
                if ($points) {
                    $message = $this->get_variation_product_message($points);
                }
            }
            $message = $this->change_message_variables($message, $product);
        }
        $show_product_message = (isset($point_setting['display_product_message_page']) && !empty($point_setting['display_product_message_page'])) ? $point_setting['display_product_message_page'] : 'all';
        $display_product_display_position = (isset($point_setting['display_product_display_position']) && !empty($point_setting['display_product_display_position']) ? $point_setting['display_product_display_position'] : 'before_price');
        $message = Woocommerce::getCleanHtml($message);
        if(in_array($show_product_message,array('list')) && (is_shop() || is_product_category())){
            if($display_product_display_position == 'before_add_to_cart'){
                $message = $message . $cart_link;
            }elseif ($display_product_display_position == 'after_add_to_cart'){
                $message = $cart_link. $message;
            }
        }elseif (in_array($show_product_message,array('single')) && is_product() ){
            if($display_product_display_position == 'before_add_to_cart'){
                $message = $message . $cart_link;
            }elseif ($display_product_display_position == 'after_add_to_cart'){
                $message = $cart_link. $message;
            }
        }elseif(in_array($show_product_message,array('hide'))){
            $message = $cart_link;
        }elseif(in_array($show_product_message,array('all'))){
            if($display_product_display_position == 'before_add_to_cart'){
                $message = $message . $cart_link;
            }elseif ($display_product_display_position == 'after_add_to_cart'){
                $message = $cart_link. $message;
            }
        }else{
            $message =  $cart_link;
        }
        return apply_filters('wlpr_single_product_message', $message, $this);
    }

    function renderProductMessage($price, $product, $awdr_request = false)
    {
        if (self::$point->checkExcludeUserRole()) {
            return $price;
        }
        if ( (isset($_REQUEST['app_name']) && isset($_REQUEST['scope']) && isset($_REQUEST['oauth_consumer_key']))
            || (isset($_REQUEST['consumer_key']) && isset($_REQUEST['consumer_secret']))) {
            return $price;
        }
        $low_stock = (bool)self::$input->post_get('low_in_stock');
        if((is_admin() && !$awdr_request ) || (isset($low_stock) && $low_stock == true)){
            return $price;
        }
        $point_setting = get_option('wlpr_settings');
        $message = (isset($point_setting['wlpr_single_product_message']) && !empty($point_setting['wlpr_single_product_message'])) ? __($point_setting['wlpr_single_product_message'],WLPR_TEXT_DOMAIN) : __('Purchase this product now and earn <strong>{wlpr_points}</strong> {wlpr_points_label}!',WLPR_TEXT_DOMAIN);

        $points_earned = self::$product->getProductEarnPoint($product);
        $points_earned = self::$point->roundPoints($points_earned);
        if (!$message || !$points_earned) {
            $message = '';
        } else {

            if (class_exists('WC_Dynamic_Pricing')) {
                if (get_post_meta($product->get_id(), '_pricing_rules', true)) {
                    $message = $this->get_variation_product_message($points_earned);
                }
            }
            if (method_exists($product, 'get_available_variations')) {
                $variations = $product->get_available_variations();
                $points = $this->get_highest_points_variation($variations, $product->get_id());
                $message = '';
                if ($points) {
                    $message = $this->get_variation_product_message($points);
                }
            }
            $message = $this->change_message_variables($message, $product);
        }
        $show_product_message = (isset($point_setting['display_product_message_page']) && !empty($point_setting['display_product_message_page'])) ? $point_setting['display_product_message_page'] : 'all';
        $display_product_display_position = (isset($point_setting['display_product_display_position']) && !empty($point_setting['display_product_display_position']) ? $point_setting['display_product_display_position'] : 'before_price');
        $message = Woocommerce::getCleanHtml($message);
        if(in_array($show_product_message,array('list')) && (is_shop() || is_product_category())){
            if($display_product_display_position == 'before_price'){
                $message = $message . $price;
            }elseif ($display_product_display_position == 'after_price'){
                $message = $price. $message;
            }
        }elseif (in_array($show_product_message,array('single')) && is_product() ){
            if($display_product_display_position == 'before_price'){
                $message = $message . $price;
            }elseif ($display_product_display_position == 'after_price'){
                $message = $price. $message;
            }
        }elseif(in_array($show_product_message,array('hide'))){
            $message = $price;
        }elseif(in_array($show_product_message,array('all'))){
            if($display_product_display_position == 'before_price'){
                $message = $message . $price;
            }elseif ($display_product_display_position == 'after_price'){
                $message = $price. $message;
            }
        }else{
            $message =  $price;
        }

        return apply_filters('wlpr_single_product_message', $message, $this);
    }

    function renderProductMessageCart(){
        if (self::$point->checkExcludeUserRole()) {
            return '';
        }
        if ( (isset($_REQUEST['app_name']) && isset($_REQUEST['scope']) && isset($_REQUEST['oauth_consumer_key']))
            || (isset($_REQUEST['consumer_key']) && isset($_REQUEST['consumer_secret']))) {
            return '';
        }
        global $product;
        $point_setting = get_option('wlpr_settings');
        $message = (isset($point_setting['wlpr_single_product_message']) && !empty($point_setting['wlpr_single_product_message'])) ? __($point_setting['wlpr_single_product_message'],WLPR_TEXT_DOMAIN) : __('Purchase this product now and earn <strong>{wlpr_points}</strong> {wlpr_points_label}!',WLPR_TEXT_DOMAIN);
        $points_earned = self::$product->getProductEarnPoint($product);
        $points_earned = self::$point->roundPoints($points_earned);
        if (!$message || !$points_earned) {
            $message = '';
        } else {
            if (class_exists('WC_Dynamic_Pricing')) {
                if (get_post_meta($product->get_id(), '_pricing_rules', true)) {
                    $message = $this->get_variation_product_message($points_earned);
                }
            }
            if (method_exists($product, 'get_available_variations')) {
                $variations = $product->get_available_variations();
                $points = $this->get_highest_points_variation($variations, $product->get_id());
                $message = '';
                if ($points) {
                    $message = $this->get_variation_product_message($points);
                }
            }
            $message = $this->change_message_variables($message, $product);
        }
        $show_product_message = (isset($point_setting['display_product_message_page']) && !empty($point_setting['display_product_message_page'])) ? $point_setting['display_product_message_page'] : 'all';
        $message = Woocommerce::getCleanHtml($message);
        if(in_array($show_product_message,array('hide','single')) && (is_shop() || is_product_category() || !is_product())){
            $message = '';
        }
        if(is_product() && in_array($show_product_message,array('hide','list'))){
            $message = '';
        }
        if(in_array($show_product_message,array('hide'))){
            $message = '';
        }
        echo apply_filters('wlpr_single_product_message', $message, $this);
    }

    public function get_variation_product_message($points)
    {
        $point_setting = get_option('wlpr_settings');
        $message = (isset($point_setting['wlpr_variable_product_message']) && !empty($point_setting['wlpr_variable_product_message'])) ? __($point_setting['wlpr_variable_product_message'],WLPR_TEXT_DOMAIN) : __('Earn up to <strong>{wlpr_points}</strong> {wlpr_points_label}.',WLPR_TEXT_DOMAIN);
        if (!empty($message)) {
            $message = str_replace('{wlpr_points}', number_format_i18n($points), $message);
            $message = str_replace('{wlpr_points_label}', self::$point->getPointLabel(), $message);
        }
        $message = '<span class="wc-points-rewards-product-message">' . $message . '</span>';
        $message = Woocommerce::getCleanHtml($message);
        return $message;
    }

    function change_message_variables($message, $product)
    {
        $points_earned = self::$product->getProductEarnPoint($product);
        $points_earned = self::$point->roundPoints($points_earned);
        if (method_exists($product, 'get_variation_price') && $product->get_variation_price('min') != $product->get_variation_price('max')) {
            return $message;
        }
        $message = str_replace('{wlpr_points}', number_format_i18n($points_earned), $message);
        $message = str_replace('{wlpr_points_label}', self::$point->getPointLabel(), $message);
        if (method_exists($product, 'get_variation_price')) {
            $message = '<span class="wc-points-rewards-product-message wc-points-rewards-product-variation-message">' . $message . '</span>';
        } else {
            $message = '<span class="wc-points-rewards-product-message">' . $message . '</span>';
        }
        $message = Woocommerce::getCleanHtml($message);
        return $message;
    }

    public function get_highest_points_variation($variations, $product_id)
    {
        $transient_name = $this->transient_highest_point_variation($product_id);
        $points = get_transient($transient_name);
        if (false === $points) {
            $highest = array('key' => 0, 'points' => 0);
            foreach ($variations as $key => $variation) {
                $points = self::$product->getProductEarnPoint($variation['variation_id']);
                $points = self::$point->roundPoints($points);
                if ($points > $highest['points']) {
                    $highest = array('key' => $key, 'points' => $points);
                }
            }
            $points = $highest['points'];
            set_transient($transient_name, $points, 50);
        }
        return $points;
    }

    public function transient_highest_point_variation($product_id)
    {
        return 'wlpr_highest_point_variation_' . $product_id;
    }

    public function variableProductSync($product, $children = array())
    {
        if (version_compare(WC_VERSION, '3.0.0', '<')) {
            $variation_id = $product;
        } else {
            $variation_id = $product->get_id();
            $children = $product->get_children();
        }
        $wc_max_points_earned = '';
        $wc_min_points_earned = '';
        $variable_points = array();
        $product_price = self::$product->getProductPrice($product);
        foreach ($children as $child) {
            $earned = '';
            $point_setting = json_decode(get_post_meta($child, '_wlpr_variable_product_points_earned', true), true);
            if (isset($point_setting['wlpr_earn_point']) && isset($point_setting['wlpr_point_earn_price']) &&
                $point_setting['wlpr_earn_point'] && $point_setting['wlpr_point_earn_price']) {
                $earned = $product_price * ($point_setting['wlpr_earn_point'] / $point_setting['wlpr_point_earn_price']);
            }
            if ($earned !== '') {
                $variable_points[] = $earned;
            }
        }
        if (count($variable_points) > 0) {
            $wc_max_points_earned = max($variable_points);
            $wc_min_points_earned = min($variable_points);
        }
        update_post_meta($variation_id, '_wlpr_max_points_earned', $wc_max_points_earned);
        update_post_meta($variation_id, '_wlpr_min_points_earned', $wc_min_points_earned);
    }

    public function renderVariationMessage($price_html, $product)
    {
        if (!is_product()) {
            return $price_html;
        }
        $point_setting = get_option('wlpr_settings');
        $message = (isset($point_setting['wlpr_single_product_message']) && !empty($point_setting['wlpr_single_product_message'])) ? __($point_setting['wlpr_single_product_message'],WLPR_TEXT_DOMAIN) : __('Purchase this product now and earn <strong>{wlpr_points}</strong> {wlpr_points_label}!',WLPR_TEXT_DOMAIN);
        $points_earned = self::$product->getProductEarnPoint($product);
        $points_earned = self::$point->roundPoints($points_earned);
        if (!$message || !$points_earned) {
            return $price_html;
        }
        $message = $this->change_message_variables($message, $product);
        $message = Woocommerce::getCleanHtml($message);
        $price_html =  $message. ' ' . $price_html;

        return $price_html;
    }

    public function deleteTransients($product_id)
    {
        delete_transient($this->transient_highest_point_variation($product_id));
    }

    public function createAccountAction($user_id)
    {
        $point_setting = get_option('wlpr_settings');
        $enable_signup_reward = (isset($point_setting['wlpr_enable_signup_reward']) && !empty($point_setting['wlpr_enable_signup_reward'])) ? $point_setting['wlpr_enable_signup_reward'] : 'yes';
        if($enable_signup_reward == 'yes'){
            $points = (isset($point_setting['wlpr_account_signup_points']) && (!empty($point_setting['wlpr_account_signup_points'])|| $point_setting['wlpr_account_signup_points'] == 0)) ? $point_setting['wlpr_account_signup_points'] : 50;
            if (!empty($points)) {
                $user_email = get_userdata($user_id)->user_email;
                if (!self::$point->checkSignUpPoint($user_email)) {
                    self::$point->addEarnPoint($user_email, $points, 'account-signup');
                }
            }
        }
    }

    public function checkIsOldUser($user_name,$user){
        $user_email = sanitize_email($user->user_email);
        if(!empty($user_email) && !self::$point->isValidEmailForRedeem($user_email)){
            global $wpdb;
            $order_id = $wpdb->get_var( $wpdb->prepare( "SELECT DISTINCT ID FROM $wpdb->posts as posts LEFT JOIN $wpdb->postmeta as meta ON posts.ID = meta.post_id WHERE meta.meta_value = %s AND meta.meta_key = %s AND posts.post_status in(%s,%s)", $user_email, '_billing_email',"wc-processing","wc-completed" ) );
            if ( ! empty( $order_id ) ) {
                $referralHelper = Loyalty::referral();
                $pointTable = new Points();
                $uniqueReferCode = $referralHelper->get_unique_refer_code();
                $_data = array(
                    'user_email' => $user_email,
                    'points' => 0,
                    'created_date' => date("Y-m-d h:i:s"),
                    'refer_code' => $uniqueReferCode
                );
                $pointTable->insertRow($_data);
            }
        }
    }

    public function productReviewAction($comment_id, $approved = 0)
    {
        if (!is_user_logged_in() || !$approved)
            return;

        $point_setting = get_option('wlpr_settings');
        $enable_review_reward = (isset($point_setting['wlpr_enable_review_reward']) && !empty($point_setting['wlpr_enable_review_reward'])) ? $point_setting['wlpr_enable_review_reward'] : 'yes';
        if($enable_review_reward == 'no'){
            return;
        }

        $comment = get_comment($comment_id);
        $post_type = get_post_type($comment->comment_post_ID);
        $points = 0;

        if ('product' === $post_type) {
            $points = (isset($point_setting['wlpr_write_review_points']) && (!empty($point_setting['wlpr_write_review_points'])||$point_setting['wlpr_write_review_points']==0)) ? $point_setting['wlpr_write_review_points'] : 50;
        }
        if (!empty($points) && isset($comment->comment_author_email) && !empty($comment->comment_author_email) && filter_var($comment->comment_author_email, FILTER_VALIDATE_EMAIL)) {
            $params = apply_filters('wlpr_point_review_post_comments_args', array('author_email' => $comment->comment_author_email, 'post_id' => $comment->comment_post_ID));
            $comments = get_comments($params);
            if (count($comments) <= 1 && apply_filters('wlpr_point_post_add_product_review_points', true, $comment_id)) {
                global $wpdb;
                $point_action_table = new PointAction();
                $where = $wpdb->prepare("user_email = %s AND action = %s AND product_id = %s",sanitize_email($comment->comment_author_email), 'product-review', (int)$comment->comment_post_ID);
                $point_review_action_data = $point_action_table->getWhere($where, '*', true);
                if(empty($point_review_action_data)){
                    self::$point->addEarnPoint($comment->comment_author_email, $points, 'product-review', array('product_id' => $comment->comment_post_ID));
                }
            }
        }
    }

    public function productReviewApproveAction($comment)
    {
        $post_type = get_post_type($comment->comment_post_ID);
        $point_setting = get_option('wlpr_settings');
        $enable_review_reward = (isset($point_setting['wlpr_enable_review_reward']) && !empty($point_setting['wlpr_enable_review_reward'])) ? $point_setting['wlpr_enable_review_reward'] : 'yes';
        if($enable_review_reward == 'yes'){
            if ('product' === $post_type) {
                $point_setting = get_option('wlpr_settings');
                $points = (isset($point_setting['wlpr_write_review_points']) && (!empty($point_setting['wlpr_write_review_points'])||$point_setting['wlpr_write_review_points']==0)) ? $point_setting['wlpr_write_review_points'] : 50;
            }
            if (!empty($points) && isset($comment->comment_author_email) && !empty($comment->comment_author_email) && filter_var($comment->comment_author_email, FILTER_VALIDATE_EMAIL)) {
                $params = apply_filters('wlpr_point_review_approve_comments_args', array('author_email' => $comment->comment_author_email, 'post_id' => $comment->comment_post_ID));
                $comments = get_comments($params);
                if (count($comments) <= 1 && apply_filters('wlpr_point_approve_add_product_review_points', true, $comment->comment_ID)) {
                    global $wpdb;
                    $point_action_table = new PointAction();
                    $where = $wpdb->prepare("user_email = %s AND action = %s AND product_id = %s",sanitize_email($comment->comment_author_email), 'product-review', (int)$comment->comment_post_ID);
                    $point_review_action_data = $point_action_table->getWhere($where, '*', true);
                    if(empty($point_review_action_data)){
                        self::$point->addEarnPoint($comment->comment_author_email, $points, 'product-review', array('product_id' => $comment->comment_post_ID));
                    }
                }
            }
        }
    }

    function removeSchedule()
    {
        $remove_schedule_date = get_option('wlpr_remove_schedule_day');
        if (empty($remove_schedule_date)) {
            update_option('wlpr_remove_schedule_day', date('Y-m-d H:i:s'), true);
        } elseif (!empty($remove_schedule_date)) {
            $current_datetime = new \DateTime('now');
            $last_schedule_time = new \DateTime($remove_schedule_date);
            $diff = date_diff($last_schedule_time, $current_datetime);
            if ($diff->y > 0 || $diff->m > 2) {
                self::$woocommerce->delete_schedule('wlpr_expire_points');
                update_option('wlpr_remove_schedule_day', date('Y-m-d H:i:s'), true);
            }
        }
    }

    function wlpr_expire_points_schedule()
    {
        $hook = 'wlpr_expire_points';
        $timestamp = wp_next_scheduled($hook);
        if (false === $timestamp) {
            $scheduled_time = strtotime('today midnight', current_time('timestamp'));
            wp_schedule_event($scheduled_time, 'daily', $hook);
        }
        $hook = 'wlpr_expire_email_points';
        $timestamp = wp_next_scheduled($hook);
        if (false === $timestamp) {
            $scheduled_time = strtotime('today', current_time('timestamp'));
            wp_schedule_event($scheduled_time, 'daily', $hook);
        }
        //every 6 hours
        $hook = 'wlpr_birth_day_points';
        $timestamp = wp_next_scheduled($hook);
        if(false === $timestamp){
            $scheduled_time = strtotime('+6 hours', current_time('timestamp'));
            wp_schedule_event($scheduled_time, 'hourly', $hook);
        }
    }

    public function wlpr_expire_points_remove_schedule()
    {
        $next_scheduled = wp_next_scheduled('wlpr_expire_points');
        wp_unschedule_event($next_scheduled, 'wlpr_expire_points');

        $next_scheduled = wp_next_scheduled('wlpr_expire_email_points');
        wp_unschedule_event($next_scheduled, 'wlpr_expire_email_points');

        $next_scheduled = wp_next_scheduled('wlpr_birth_day_points');
        wp_unschedule_event($next_scheduled, 'wlpr_birth_day_points');
    }

    public function expire_points()
    {
        global $wpdb;
        $is_already_migrated = get_option('wlpr_already_migration');
        if(!$is_already_migrated){
            return;
        }
        $point_action = new PointAction();
        $date_expire_before = date('Y-m-d H:i:s');
        $expiring_points = $point_action->get_expiring_points($date_expire_before);
        if (count($expiring_points) > 0) {
            foreach ($expiring_points as $expiring) {
                $point_action->updateRow(array('expire_status' => 'expired'), array('id' => $expiring->id));
                $point_table = new Points();
                $created_date = date("Y-m-d h:i:s");
                $where = $wpdb->prepare("user_email = %s", sanitize_email($expiring->user_email));
                $user_points = $point_table->getWhere($where, '*', true);
                if (isset($expiring->points) && !empty($expiring->points) && $expiring->user_email ) {
                    $log_expire_point = $user_points->points;
                    $user_points->points = $user_points->points - $expiring->points;
                    if($user_points->points <= 0){
                        $user_points->points = 0;
                    }else{
                        $log_expire_point = $expiring->points;
                    }
                    $update_data = array(
                        'points' => $user_points->points,
                        'created_date' => $created_date
                    );
                    $where = array('user_email' => $expiring->user_email);
                    $point_table->updateRow($update_data, $where);
                    $args = array(
                        'user_email' => $expiring->user_email,
                        'points' => -$log_expire_point,
                        'event_type' => 'expire',
                        'redeem_price' => self::$point->getRedeemPointAmount($log_expire_point),
                        'earn_price' => 0.0
                    );
                    $point_log = new PointLog();
                    if (isset($expiring->order_id) && !empty($expiring->order_id)) {
                        $args['order_id'] = $expiring->order_id;
                    }
                    $point_log->add_log_entry($args);
                }
            }
        }
    }

    public function add_endpoints()
    {
        global $wp_rewrite;
        $status = true;
        $status = apply_filters('wlpr_flush_rewrite_rules',$status);
        if($status){
            flush_rewrite_rules();
        }
        add_rewrite_endpoint('loyalty', EP_ROOT | EP_PAGES);
    }

    public function get_endpoint()
    {
        return $this->endpoint;
    }

    public function add_menu_items($menu_items)
    {
        $logout = $menu_items['customer-logout'];
        unset($menu_items['customer-logout']);
        $menu_items[$this->endpoint] = ucfirst(self::$point->getPointLabel());
        $menu_items['customer-logout'] = $logout;
        return $menu_items;
    }

    function add_myaccount_point_class($classes,$endpoint){
        if($this->endpoint == $endpoint){
            $classes[] = 'wlpr';
            $classes[] = 'wlpr-trophy';
        }
        return $classes;
    }

    function includes()
    {
        add_action('woocommerce_account_menu_items', array($this, 'add_menu_items'));
        $options = get_option('wlpr_settings');
        $my_account_label_icon_position = (isset($options['wlpr_my_account_label_icon_position']) && !empty($options['wlpr_my_account_label_icon_position']) ? $options['wlpr_my_account_label_icon_position'] : 'no');
        if($my_account_label_icon_position == 'yes'){
            add_filter('woocommerce_account_menu_item_classes',array($this, 'add_myaccount_point_class'),10,2);
        }
        add_action('woocommerce_account_loyalty_endpoint', array($this, 'woocommerce_wlpr_points_rewards_my_points'));
    }

    function woocommerce_wlpr_points_rewards_my_points($current_page)
    {
        global $wpdb;
        $user_email = get_user_by('id', get_current_user_id())->user_email;
        $point_table = new Points();
        $user_email = sanitize_email($user_email);
        $point_where = $wpdb->prepare("user_email = %s", array($user_email));
        $user_point = $point_table->getWhere($point_where, '*', true);
        $points_label = self::$point->getPointLabel();
        $per_page = apply_filters('wlpr_my_account_points_events', 5, $user_email);
        $point_action = new PointAction();
        $transaction_page_number = (int)self::$input->get('transaction_page_number', 1);
        $transaction_offset = $per_page * ($transaction_page_number - 1);
        $transaction_where = $wpdb->prepare('user_email = %s AND action != %s AND action != %s ORDER BY id DESC LIMIT %d OFFSET %d', array($user_email, 'private_note', 'expire_email', $per_page, $transaction_offset));
        $transaction = $point_action->getWhere($transaction_where, '*', false);
        $transaction_total_where = $wpdb->prepare('user_email = %s AND action != %s AND action != %s ORDER BY id DESC', array($user_email, 'private_note', 'expire_email'));
        $transaction_total_count = $point_action->getWhere($transaction_total_where, 'COUNT( DISTINCT id) as total_count', true);
        $log_params = array(
            'totalRows' => $transaction_total_count->total_count,
            'perPage' => $per_page,
            'currentPage' => $transaction_page_number,
            'queryStringSegment' => 'transaction_page_number'
        );
        $transaction_pagination = new Pagination($log_params);
        $referral_settings = get_option('wlpr_referral');
        $wlpr_enable_referral = (isset($referral_settings['wlpr_enable_referral']) && !empty($referral_settings['wlpr_enable_referral'])) ? $referral_settings['wlpr_enable_referral'] : 'yes';
        $facebook_app_id = (isset($referral_settings['wlpr_fb_app_id']) && !empty($referral_settings['wlpr_fb_app_id'])) ? $referral_settings['wlpr_fb_app_id'] : '';
        $before_referral_message = (isset($referral_settings['wlpr_before_referral_message']) && !empty($referral_settings['wlpr_before_referral_message'])) ? __($referral_settings['wlpr_before_referral_message'],WLPR_TEXT_DOMAIN) : __('Great news, You can earn point via placing order and referring your friends. <br><strong>Note:</strong> You can refer your friends after your first order.', WLPR_TEXT_DOMAIN);
        $before_referral_message = Woocommerce::getCleanHtml($before_referral_message);
        $share_content = (isset($referral_settings['wlpr_share_content']) && !empty($referral_settings['wlpr_share_content'])) ? __($referral_settings['wlpr_share_content'],WLPR_TEXT_DOMAIN) : __('{wlpr_referee_point} {wlpr_points_label} off your first purchase.',WLPR_TEXT_DOMAIN);
        $share_subject = (isset($referral_settings['wlpr_share_subject']) && !empty($referral_settings['wlpr_share_subject'])) ? __($referral_settings['wlpr_share_subject'],WLPR_TEXT_DOMAIN) : __('{wlpr_referee_point} {wlpr_points_label} off your first purchase.',WLPR_TEXT_DOMAIN);
        $share_content = str_replace('{wlpr_points_label}', $points_label, $share_content);
        $share_subject = str_replace('{wlpr_points_label}', $points_label, $share_subject);
        $wlpr_referring_person = ((isset($referral_settings['wlpr_referring_person']) && (!empty($referral_settings['wlpr_referring_person']) || $referral_settings['wlpr_referring_person'] == 0))) ? $referral_settings['wlpr_referring_person'] : 50;
        $referrer_message = '';
        if ($wlpr_referring_person > 0) {
            $referrer_message = (isset($referral_settings['wlpr_referrer_message']) && !empty($referral_settings['wlpr_referrer_message'])) ? __($referral_settings['wlpr_referrer_message'],WLPR_TEXT_DOMAIN) : '';
        }
        $referrer_message = str_replace('{wlpr_referrer_point}', $wlpr_referring_person, $referrer_message);
        $referrer_message = Woocommerce::getCleanHtml($referrer_message);
        $wlpr_referred_person = ((isset($referral_settings['wlpr_referred_person']) && (!empty($referral_settings['wlpr_referred_person']) || $referral_settings['wlpr_referred_person'] ==0))) ? $referral_settings['wlpr_referred_person'] : 50;
        $referee_message = '';
        if ($wlpr_referred_person > 0) {
            $referee_message = (isset($referral_settings['wlpr_referee_message']) && !empty($referral_settings['wlpr_referee_message'])) ? __($referral_settings['wlpr_referee_message'],WLPR_TEXT_DOMAIN) : '';
        }
        $referee_message = str_replace('{wlpr_referee_point}', $wlpr_referred_person, $referee_message);
        $referee_message = Woocommerce::getCleanHtml($referee_message);
        $share_content = str_replace('{wlpr_referee_point}', $wlpr_referred_person, $share_content);
        $share_subject = str_replace('{wlpr_referee_point}', $wlpr_referred_person, $share_subject);
        $referee_discount_message = '';
        $enable_refer_discount = (isset($referral_settings['wlpr_referral_discount']) && !empty($referral_settings['wlpr_referral_discount'])) ? $referral_settings['wlpr_referral_discount'] : 'no';
        $referral_coupon_amount = (isset($referral_settings['wlpr_referral_coupon_percent']) && !empty($referral_settings['wlpr_referral_coupon_percent'])) ? $referral_settings['wlpr_referral_coupon_percent'] : 0;
        $referral_coupon_type = (isset($referral_settings['wlpr_referral_coupon_percent_type']) && !empty($referral_settings['wlpr_referral_coupon_percent_type'])) ? $referral_settings['wlpr_referral_coupon_percent_type'] : 'fixed';
        if ($enable_refer_discount == 'yes' && $referral_coupon_amount > 0) {
            $referee_discount_message = (isset($referral_settings['wlpr_referee_discount_message']) && !empty($referral_settings['wlpr_referee_discount_message'])) ? __($referral_settings['wlpr_referee_discount_message'],WLPR_TEXT_DOMAIN) : '';
            if ($referral_coupon_type == 'fixed') {
                $referee_discount_message = str_replace('{wlpr_referee_discount}', get_woocommerce_currency_symbol() . $referral_coupon_amount, $referee_discount_message);
                $share_content = str_replace('{wlpr_referee_discount}', get_woocommerce_currency_symbol() . $referral_coupon_amount, $share_content);
            } else {
                $referee_discount_message = str_replace('{wlpr_referee_discount}', $referral_coupon_amount . '%', $referee_discount_message);
                $share_content = str_replace('{wlpr_referee_discount}', $referral_coupon_amount . '%', $share_content);
            }
        } else {
            $referee_discount_message = str_replace('{wlpr_referee_discount}', 0, $referee_discount_message);
            $share_content = str_replace('{wlpr_referee_discount}', 0, $share_content);
        }
        $referee_discount_message = Woocommerce::getCleanHtml($referee_discount_message);
        $url = '';
        if(isset($user_point->refer_code) && !empty($user_point->refer_code)){
            $url = site_url() . '?wlpr_ref=' . $user_point->refer_code;
        }
        $my_point_params = array(
            'user_point' => $user_point,
            'url' => $url,
            'points_label' => $points_label,
            'point_helper' => Loyalty::point(),
            'transaction' => $transaction,
            'transaction_pagination' => $transaction_pagination,
            'transaction_page_number' => $transaction_page_number,
            'before_referral_message' => $before_referral_message,
            'share_content' => $share_content,
            'referrer_message' => $referrer_message,
            'referee_message' => $referee_message,
            'referee_discount_message' => $referee_discount_message,
            'share_subject' => $share_subject,
            'facebook_app_id' => $facebook_app_id,
            'wlpr_enable_referral' => $wlpr_enable_referral,
            'enable_facebook_share' => (isset($referral_settings['wlpr_enable_facebook_share_point']) && !empty($referral_settings['wlpr_enable_facebook_share_point'])) ? $referral_settings['wlpr_enable_facebook_share_point']: 'yes',
            'enable_twitter_share' => (isset($referral_settings['wlpr_enable_twitter_share_point']) && !empty($referral_settings['wlpr_enable_twitter_share_point'])) ? $referral_settings['wlpr_enable_twitter_share_point']: 'yes',
            'enable_email_share' => (isset($referral_settings['wlpr_enable_email_share_point']) && !empty($referral_settings['wlpr_enable_email_share_point'])) ? $referral_settings['wlpr_enable_email_share_point']: 'yes',
            'enable_whatsapp_share' => (isset($referral_settings['wlpr_enable_whatsapp_share_point']) && !empty($referral_settings['wlpr_enable_whatsapp_share_point'])) ? $referral_settings['wlpr_enable_whatsapp_share_point']: 'yes'
        );
        if(isset($wlpr_enable_referral) && $wlpr_enable_referral == 'yes' && isset($user_point->refer_code) && !empty($user_point->refer_code)){
            $share_content .= ' ' . $url;
            $my_point_params['share_content'] = $share_content;
            $my_point_params['refer_code'] = $user_point->refer_code;
        }

        $my_point_params = apply_filters('wlpr_my_account_params',$my_point_params);
        wc_get_template(
            'my-points.php',
            $my_point_params,
            '',
            WLPR_PLUGIN_PATH . 'App/Views/Site/'
        );
    }

    function setReferCouponToSession()
    {
        if (self::$point->checkExcludeUserRole()) {
            return;
        }
        $referral_settings = get_option('wlpr_referral');
        $enable_referral = (isset($referral_settings['wlpr_enable_referral']) && !empty($referral_settings['wlpr_enable_referral'])) ? $referral_settings['wlpr_enable_referral'] : 'yes';
        $wlpr_ref = (string)self::$input->post_get('wlpr_ref','');
        if ($enable_referral == 'yes' && isset($wlpr_ref) && !empty($wlpr_ref)) {
            $referal_code = sanitize_text_field($wlpr_ref);
            self::$woocommerce->initWoocommerceSession();
            self::$woocommerce->set_refer_discount_code($referal_code);

        }
    }

    function addReferCouponToCheckout()
    {
        $referral_helper = Loyalty::referral();
        $refer_code = self::$woocommerce->get_refer_discount_code();
        $discount_method = self::$point->getDiscountMethod();
        if($discount_method == 'fee'){

        }elseif ($discount_method == 'coupon'){
            if (!empty($refer_code) && !empty(self::$woocommerce->getCart()) && !self::$woocommerce->hasDiscount($refer_code)) {
                if ($referral_helper->checkReferCouponBeforeCouponApply($refer_code)) {
                    self::$woocommerce->addDiscount($refer_code);
                }
            }
        }
    }

    function saveReferralToOrder($order_id, $order_data_store)
    {
        $referral_code = self::$woocommerce->get_refer_discount_code();
        if (!empty($referral_code)) {
            update_post_meta($order_id, '_wlpr_referral_code', $referral_code);
        }
    }

    function register_form()
    {
        if (self::$point->checkExcludeUserRole()) {
            return false;
        }
        $point_setting = get_option('wlpr_settings');
        $enable_signup_reward = (isset($point_setting['wlpr_enable_signup_reward']) && !empty($point_setting['wlpr_enable_signup_reward'])) ? $point_setting['wlpr_enable_signup_reward'] : 'yes';
        $signup_point = (isset($point_setting['wlpr_account_signup_points']) && (!empty($point_setting['wlpr_account_signup_points'])|| $point_setting['wlpr_account_signup_points'] == 0)) ? $point_setting['wlpr_account_signup_points'] : 50;
        if ($signup_point > 0 && $enable_signup_reward == 'yes') {
            $signup_message = (isset($point_setting['wlpr_account_signup_message']) && !empty($point_setting['wlpr_account_signup_message'])) ? __($point_setting['wlpr_account_signup_message'],WLPR_TEXT_DOMAIN) : __('Signup and earn <strong>{wlpr_signup_point}</strong> {wlpr_points_label}!',WLPR_TEXT_DOMAIN);
            $point_label = self::$point->getPointLabel();
            $signup_message = str_replace('{wlpr_signup_point}', $signup_point, $signup_message);
            $signup_message = str_replace('{wlpr_points_label}', $point_label, $signup_message);
            echo Woocommerce::getCleanHtml("<span>" . $signup_message . '</span>');
        }
    }

    function woo_signup_message($checkout)
    {
        $this->register_form();
    }

    function displayProductReviewMessage($commant_form)
    {
        if (self::$point->checkExcludeUserRole()) {
            return $commant_form;
        }
        $point_setting = get_option('wlpr_settings');
        $enable_review_reward = (isset($point_setting['wlpr_enable_review_reward']) && !empty($point_setting['wlpr_enable_review_reward'])) ? $point_setting['wlpr_enable_review_reward'] : 'yes';
        if($enable_review_reward == 'no'){
            return $commant_form;
        }
        $review_point = (isset($point_setting['wlpr_write_review_points']) && (!empty($point_setting['wlpr_write_review_points'])||$point_setting['wlpr_write_review_points']==0)) ? $point_setting['wlpr_write_review_points'] : 50;
        $review_message = '';
        if ($review_point > 0) {
            $review_message = (isset($point_setting['wlpr_write_review_message']) && !empty($point_setting['wlpr_write_review_message'])) ? __($point_setting['wlpr_write_review_message'],WLPR_TEXT_DOMAIN) : __('Review and earn <strong>{wlpr_review_points}</strong> {wlpr_points_label}!',WLPR_TEXT_DOMAIN);
            $point_label = self::$point->getPointLabel();
            $review_message = str_replace('{wlpr_review_points}', $review_point, $review_message);
            $review_message = str_replace('{wlpr_points_label}', $point_label, $review_message);
        }
        if (isset($commant_form['comment_notes_after']) && !empty($review_message)) {
            $commant_form['comment_notes_after'] = $commant_form['comment_notes_after'] . '<br/>' . Woocommerce::getCleanHtml($review_message);
        }
        return $commant_form;
    }

    function process_short_code($attr, $content)
    {
        global $wpdb;
        if (isset($attr['display']) && !empty($attr['display'])) {
            $short_codes = explode(',', $attr['display']);
            $email = wp_get_current_user()->user_email;
            if (empty($email)) {
                return $content;
            }
            $point_setting = get_option('wlpr_settings');
            $email = sanitize_email($email);
            foreach ($short_codes as $short_code) {
                $short_code = strip_tags($short_code);
                if ($short_code == 'customer_points_balance') {
                    $total_points = self::$point->getUsersPoints($email);
                    if (empty($content)) {
                        $content .= $total_points;
                    } else {
                        $content .= ' ' . $total_points;
                    }
                } elseif ($short_code == 'customer_points_balance_with_label') {
                    $total_points = self::$point->getUsersPoints($email);
                    if (empty($content)) {
                        $content .= sprintf(esc_html__('Customer points %s',WLPR_TEXT_DOMAIN),$total_points);//esc_html(__(sprintf('Customer points %s', $total_points), WLPR_TEXT_DOMAIN));
                    } else {
                        $content .= ' ' . sprintf(esc_html__('Customer points %s',WLPR_TEXT_DOMAIN),$total_points);//esc_html(__(sprintf('Customer points %s', $total_points), WLPR_TEXT_DOMAIN));
                    }
                } elseif (in_array($short_code, array('referral_url', 'referral_code'))) {
                    $point_table = new Points();
                    $where = $wpdb->prepare("user_email = %s", array($email));
                    $user_point_data = $point_table->getWhere($where, '*', true);
                    if (!empty($user_point_data)) {
                        if (empty($content)) {
                            if ($short_code == 'referral_code') {
                                $content .= $user_point_data->refer_code;
                            } elseif ($short_code == 'referral_url') {
                                $content .= site_url() . '?wlpr_ref=' . $user_point_data->refer_code;
                            }
                        } else {
                            if ($short_code == 'referral_code') {
                                $content .= ' ' . $user_point_data->refer_code;
                            } elseif ($short_code == 'referral_url') {
                                $content .= ' ' . site_url() . '?wlpr_ref=' . $user_point_data->refer_code;
                            }
                        }
                    }
                } elseif ($short_code == 'review_points') {
                    $review_point = (isset($point_setting['wlpr_write_review_points']) && (!empty($point_setting['wlpr_write_review_points'])||$point_setting['wlpr_write_review_points']==0)) ? $point_setting['wlpr_write_review_points'] : 50;
                    $enable_review_reward = (isset($point_setting['wlpr_enable_review_reward']) && !empty($point_setting['wlpr_enable_review_reward'])) ? $point_setting['wlpr_enable_review_reward'] : 'yes';
                    if($enable_review_reward == 'yes'){
                        if (empty($content)) {
                            $content .= $review_point;
                        } elseif ($content) {
                            $content .= ' ' . $review_point;
                        }
                    }
                } elseif ($short_code == 'review_points_with_label') {
                    $review_point = (isset($point_setting['wlpr_write_review_points']) && (!empty($point_setting['wlpr_write_review_points'])||$point_setting['wlpr_write_review_points']==0)) ? $point_setting['wlpr_write_review_points'] : 50;
                    $enable_review_reward = (isset($point_setting['wlpr_enable_review_reward']) && !empty($point_setting['wlpr_enable_review_reward'])) ? $point_setting['wlpr_enable_review_reward'] : 'yes';
                    if($enable_review_reward == 'yes'){
                        if (empty($content)) {
                            $content .= sprintf(esc_html__('Review points %s',WLPR_TEXT_DOMAIN),$review_point);
                        } elseif ($content) {
                            $content .= ' ' . sprintf(esc_html__('Review points %s',WLPR_TEXT_DOMAIN),$review_point);
                        }
                    }
                } elseif ($short_code == 'signup_points') {
                    $signup_point = (isset($point_setting['wlpr_account_signup_points']) && (!empty($point_setting['wlpr_account_signup_points'])|| $point_setting['wlpr_account_signup_points'] == 0)) ? $point_setting['wlpr_account_signup_points'] : 50;
                    $enable_signup_reward = (isset($point_setting['wlpr_enable_signup_reward']) && !empty($point_setting['wlpr_enable_signup_reward'])) ? $point_setting['wlpr_enable_signup_reward'] : 'yes';
                    if($enable_signup_reward == 'yes'){
                        if (empty($content)) {
                            $content .= $signup_point;
                        } elseif ($content) {
                            $content .= ' ' . $signup_point;
                        }
                    }
                } elseif ($short_code == 'signup_points_with_label') {
                    $signup_point = (isset($point_setting['wlpr_account_signup_points']) && (!empty($point_setting['wlpr_account_signup_points'])|| $point_setting['wlpr_account_signup_points'] == 0)) ? $point_setting['wlpr_account_signup_points'] : 50;
                    $enable_signup_reward = (isset($point_setting['wlpr_enable_signup_reward']) && !empty($point_setting['wlpr_enable_signup_reward'])) ? $point_setting['wlpr_enable_signup_reward'] : 'yes';
                    if($enable_signup_reward == 'yes'){
                        if (empty($content)) {
                            $content .= sprintf(esc_html__('Signup points %s',WLPR_TEXT_DOMAIN),$signup_point);
                        } elseif ($content) {
                            $content .= ' ' . sprintf(esc_html__('Signup points %s',WLPR_TEXT_DOMAIN),$signup_point);
                        }
                    }

                } elseif ($short_code == 'point_label') {
                    $point_label = self::$point->getPointLabel();
                    if (empty($content)) {
                        $content .= $point_label;
                    } elseif ($content) {
                        $content .= ' ' . $point_label;
                    }
                } elseif ($short_code == 'point_amount') {
                    $total_points = self::$point->getUsersPoints($email);
                    $point_amount = self::$point->getRedeemPointAmount($total_points);
                    if (empty($content)) {
                        $content .= $point_amount;
                    } elseif ($content) {
                        $content .= ' ' . $point_amount;
                    }
                }
            }
        }
        return $content;
    }

    function addEmailClass($emails)
    {
        if (!isset($emails['WlprEarnEmail']) && file_exists(WLPR_PLUGIN_PATH . 'App/Includes/WlprEarnEmail.php')) {
            include_once(WLPR_PLUGIN_PATH . '/App/Includes/WlprEarnEmail.php');
            $emails['WlprEarnEmail'] = new \WlprEarnEmail();
        }
        if (!isset($emails['WlprRefereeEmail']) && file_exists(WLPR_PLUGIN_PATH . 'App/Includes/WlprRefereeEmail.php')) {
            include_once(WLPR_PLUGIN_PATH . '/App/Includes/WlprRefereeEmail.php');
            $emails['WlprRefereeEmail'] = new \WlprRefereeEmail();
        }
        if (!isset($emails['WlprReferralEmail']) && file_exists(WLPR_PLUGIN_PATH . 'App/Includes/WlprReferralEmail.php')) {
            include_once(WLPR_PLUGIN_PATH . '/App/Includes/WlprReferralEmail.php');
            $emails['WlprReferralEmail'] = new \WlprReferralEmail();
        }

        if (!isset($emails['WlprPointExpireEmail']) && file_exists(WLPR_PLUGIN_PATH . 'App/Includes/WlprPointExpireEmail.php')) {
            include_once(WLPR_PLUGIN_PATH . '/App/Includes/WlprPointExpireEmail.php');
            $emails['WlprPointExpireEmail'] = new \WlprPointExpireEmail();
        }

        if (!isset($emails['WlprOnBirthDayGiftEmail']) && file_exists(WLPR_PLUGIN_PATH . 'App/Includes/WlprOnBirthDayGiftEmail.php')) {
            include_once(WLPR_PLUGIN_PATH . '/App/Includes/WlprOnBirthDayGiftEmail.php');
            $emails['WlprOnBirthDayGiftEmail'] = new \WlprOnBirthDayGiftEmail();
        }
        return $emails;
    }

    function sendExpirePointEmail(){
        \WC_Emails::instance();
        do_action('wlpr_email_expire_point_event');
    }

    function changeLauncherTemplate(){

        $template_key = (string)self::$input->post_get('template_key', 'wlpr_full');

        if(!empty($template_key)){
            update_option('wlpr_active_template',$template_key);
        }
        $message = __('Launcher activated successfully',WLPR_TEXT_DOMAIN);
        wp_send_json_success($message);
    }

    function footer_content(){
        $options = get_option('wlpr_settings', '');
        $enable_launcher = (isset($options['wlpr_enable_launcher']) && !empty($options['wlpr_enable_launcher'])) ? $options['wlpr_enable_launcher'] : 'yes';
        if (!is_admin() && !isset($_REQUEST['wlpr-launcher-preview']) && $enable_launcher == 'yes' && !isset($_REQUEST['customize_theme'])) {
            $suffix = '.min';
            if(defined('SCRIPT_DEBUG')){
                $suffix  = SCRIPT_DEBUG ? '' : '.min';
            }
            wp_register_script(WLPR_PLUGIN_SLUG . '-launcher', WLPR_PLUGIN_URL . 'Assets/Site/Js/wlpr_launcher'.$suffix.'.js', array(), WLPR_PLUGIN_VERSION);
            wp_enqueue_script(WLPR_PLUGIN_SLUG . '-launcher');

            wp_register_style(WLPR_PLUGIN_SLUG . '-font-wlpr', WLPR_PLUGIN_URL . 'Assets/Site/Css/wlpr-front'.$suffix.'.css', array(), WLPR_PLUGIN_VERSION);
            wp_enqueue_style(WLPR_PLUGIN_SLUG . '-font-wlpr');
            $default_launcher_icon_path = WLPR_PLUGIN_URL.'Assets/Images/launcher_icon.png';
            $launcher_image = (isset($options['wlpr_launcher_icon']) && !empty($options['wlpr_launcher_icon'])) ? $options['wlpr_launcher_icon'] : $default_launcher_icon_path;
            $launcher_text = (isset($options['wlpr_launcher_text']) && !empty($options['wlpr_launcher_text'])) ? __($options['wlpr_launcher_text'],WLPR_TEXT_DOMAIN) : __('My Rewards',WLPR_TEXT_DOMAIN);
            $launcher_position = (isset($options['wlpr_launcher_icon_position']) && !empty($options['wlpr_launcher_icon_position'])) ? $options['wlpr_launcher_icon_position'] : 'left';
            $referral_settings = get_option('wlpr_referral');
            $facebook_app_id = (isset($referral_settings['wlpr_fb_app_id']) && !empty($referral_settings['wlpr_fb_app_id'])) ? $referral_settings['wlpr_fb_app_id'] : '';
            $wlpr_launcher_icon_background_color = (isset($options['wlpr_launcher_icon_background_color']) && !empty($options['wlpr_launcher_icon_background_color'])) ? $options['wlpr_launcher_icon_background_color'] : '#353d9f';
            $wlpr_launcher_icon_text_color = (isset($options['wlpr_launcher_icon_text_color']) && !empty($options['wlpr_launcher_icon_text_color'])) ? $options['wlpr_launcher_icon_text_color'] : '#f0f0f0';
            $wlpr_launcher_display_device = (isset($options['wlpr_launcher_display_device']) && !empty($options['wlpr_launcher_display_device'])) ? $options['wlpr_launcher_display_device'] : 'all';
            wc_get_template(
                'front_launcher.php',
                array(
                    'preview_content' => \Wlpr_Preview::front_end_view(),
                    'launcher_image' => $launcher_image,
                    'launcher_text' => $launcher_text,
                    'launcher_position' => $launcher_position,
                    'launcher_icon_background_color' => $wlpr_launcher_icon_background_color,
                    'launcher_icon_text_color' => $wlpr_launcher_icon_text_color,
                    'launcher_display_device' => $wlpr_launcher_display_device,
                    'facebook_app_id' => $facebook_app_id
                ),
                '',
                WLPR_PLUGIN_PATH . 'App/Views/Site/'
            );
        }
    }

    function getDiscountFeeAmount($cart){
        $wlpr_discount_method = self::$point->getDiscountMethod();
        if($wlpr_discount_method == 'fee') {
            $referral_helper = Loyalty::referral();
            $refer_code = self::$woocommerce->get_refer_discount_code();
            if (!empty($refer_code) && $referral_helper->checkReferCouponBeforeCouponApply($refer_code)) {
                if (wc_prices_include_tax()) {
                    $sub_total = WC()->cart->subtotal;
                } else {
                    $sub_total = WC()->cart->subtotal_ex_tax;
                }
                $referral_settings = get_option('wlpr_referral');
                $referral_discount = (isset($referral_settings['wlpr_referral_coupon_percent']) && !empty($referral_settings['wlpr_referral_coupon_percent'])) ? $referral_settings['wlpr_referral_coupon_percent'] : 0;
                $referral_percentage_type = (isset($referral_settings['wlpr_referral_coupon_percent_type']) && !empty($referral_settings['wlpr_referral_coupon_percent_type'])) ? $referral_settings['wlpr_referral_coupon_percent_type'] : 'fixed';
                if ($referral_percentage_type != 'fixed') {
                    $referral_discount = $sub_total * ($referral_discount / 100);
                }
                if($refer_code && $referral_discount){
                    WC()->cart->fees_api()->add_fee(
                        array(
                            'id' => $refer_code,
                            'name'      => esc_attr(__((isset($referral_settings['wlpr_cart_referal_coupon_name']) &&
                                !empty($referral_settings['wlpr_cart_referal_coupon_name'])) ? $referral_settings['wlpr_cart_referal_coupon_name'] : 'Referral discount',WLPR_TEXT_DOMAIN)),
                            'amount'    => (float) -$referral_discount,
                            'taxable'   => false,
                            'tax_class' => '',
                            'fee_code' => $refer_code
                        )
                    );
                }
            }

            $setting_option = get_option('wlpr_settings', '');
            $partial_redemption = (isset($setting_option['wlpr_partial_redemption_enabled']) && !empty($setting_option['wlpr_partial_redemption_enabled'])) ? $setting_option['wlpr_partial_redemption_enabled'] : 'no';
            if($partial_redemption == 'yes'){
                $discount_amount = self::$point->getDiscountForRedeemingPoints(true, null, false);
            }else{
                $discount_amount = self::$point->getDiscountForRedeemingPoints(false, null, false);
            }

            $discount_code = self::$woocommerce->get_discount_code();
            if ($discount_code && $discount_amount){
                WC()->cart->fees_api()->add_fee(
                    array(
                        'id' => $discount_code,
                        'name'      => esc_attr(__((isset($referral_settings['wlpr_cart_referal_coupon_name']) &&
                            !empty($referral_settings['wlpr_cart_referal_coupon_name'])) ? $referral_settings['wlpr_cart_referal_coupon_name'] : 'Referral discount',WLPR_TEXT_DOMAIN)),
                        'amount'    => (float) -$discount_amount,
                        'taxable'   => false,
                        'tax_class' => '',
                        'fee_code' => $discount_code
                    )
                );
            }
        }
    }

    function getDiscountFeeTaxes($taxes,$fee,$cart){
        $wlpr_discount_method = self::$point->getDiscountMethod();
        if($wlpr_discount_method == 'fee') {
            $discount_code = self::$woocommerce->get_discount_code();
            if($discount_code == $fee->object->id){
                return array();
            }
            $refer_code = self::$woocommerce->get_refer_discount_code();
            if($refer_code == $fee->object->id){
                return array();
            }
            return $taxes;
        }
        return $taxes;
    }

    function displayDiscountFee($cart_totals_fee_html, $fee){
        $wlpr_discount_method = self::$point->getDiscountMethod();
        if($wlpr_discount_method == 'fee') {
            $discount_code = self::$woocommerce->get_discount_code();
            $refer_code = self::$woocommerce->get_refer_discount_code();
            if(in_array($fee->id,array($discount_code,$refer_code))){
                $cart_totals_fee_html = $cart_totals_fee_html.'<a onclick="wlpr.removeFee(\''.$fee->id.'\')" class="woocommerce-remove-fee" data-fee="'.$fee->id.'">['.__('Remove',WLPR_TEXT_DOMAIN).']</a>';
            }
            return $cart_totals_fee_html;
        }
        return $cart_totals_fee_html;
    }

    function ajaxRemoveFee(){
        $wlpr_nonce = (string)self::$input->post_get('security','');
        if(Woocommerce::verify_nonce($wlpr_nonce,'wlpr-coupon-none')){
            self::$woocommerce->set_discount_code('');
            self::$woocommerce->set_discount_amount(0);
        }
    }

    function item_save_process($item,$item_data){
        if(get_class($item) == 'WC_Order_Item_Fee'){
            $discount_code = self::$woocommerce->get_discount_code();
            if(isset($item->legacy_fee_key) && !empty($discount_code) && !empty($item->legacy_fee_key) && $item->legacy_fee_key == $discount_code){
                $id          = $item->get_id();
                update_metadata( 'order_item', $id, 'fee_code', $discount_code );
            }
        }

    }

    function update_order_review($post_data){
        parse_str($post_data, $post);
        $user_email = isset( $post['billing_email'] ) ? wc_clean( wp_unslash( $post['billing_email'] ) ) : '';
        if(!empty($user_email)){
            if(self::$point->isLoyalDiscountApplied() ){
                $ex_discount_code = self::$woocommerce->get_discount_code();
                $user_id = get_current_user_id();
                $user_details = get_userdata($user_id);
                $current_email = '';
                if (isset($user_details->data->user_email) && $user_details->data->user_email != '') {
                   $current_email = $user_details->data->user_email;
                }
                if(!self::$point->isValidEmailForRedeem($user_email) || $current_email != $user_email){
                    self::$woocommerce->set_discount_code('');
                    $list_coupons = WC()->cart->get_applied_coupons();
                    foreach ($list_coupons as $key=>$coupon){
                        if($coupon == $ex_discount_code){
                            unset($list_coupons[$key]);
                        }
                    }
                    WC()->cart->set_applied_coupons($list_coupons);
                }
            }
            $referral_helper = Loyalty::referral();
            $referral_code = $referral_helper->check_referral_code($user_email);
            $referral_code = sanitize_text_field($referral_code);
            self::$woocommerce->set_refer_discount_code($referral_code);
        }
    }

    function update_discount_code($order,$data_store){
        $discount_code = self::$woocommerce->get_discount_code();
        if(!empty($discount_code)){
            update_post_meta($order->get_id(), '_wlpr_points_order_discount_code', $discount_code);
        }
    }

    function saveBirthDate(){
        /**
         * case 1: already user but no birth date
         * case 2: new user
         * case 3: Already user, empty birthdate
         */
        global $wpdb;
        $birth_date = (string)self::$input->post_get('birth_date', '');
        $validate_data =  Validation::validateBirthday($_REQUEST);
        if(is_array($validate_data)){
            wp_send_json_error();
            exit;
        }
        $user_email = get_user_by('id', get_current_user_id())->user_email;
        $point_table = new Points();
        $user_email = sanitize_email($user_email);
        $point_where = $wpdb->prepare("user_email = %s", array($user_email));
        $user_point = $point_table->getWhere($point_where, '*', true);
        if(empty($user_point)){
            $increase_point  = true;
        }elseif (empty($user_point->birth_date) || is_null($user_point->birth_date)){
            $increase_point  = true;
        }
        $settings = get_option('wlpr_settings');
        $enable_birth_date_point = (isset($settings['wlpr_enable_birth_date_point']) && !empty($settings['wlpr_enable_birth_date_point'])) ? $settings['wlpr_enable_birth_date_point']: 'yes';
        if($increase_point && $enable_birth_date_point === 'yes'){
            $birth_date_point = (isset($settings['wlpr_birth_date_point']) && !empty($settings['wlpr_birth_date_point'])) ? $settings['wlpr_birth_date_point']: 0;
            if(!empty($birth_date_point)){
                self::$point->addEarnPoint($user_email, $birth_date_point, 'birth_date', null, null);
            }
        }
        if(!empty($birth_date)){
            if(empty($user_point)){
                $point_table = new Points();
                $point_where = $wpdb->prepare("user_email = %s", array($user_email));
                $user_point = $point_table->getWhere($point_where, '*', true);
            }
            if(!empty($user_point)){
                $update_data = array(
                    'birth_date' => $birth_date);
                $where = array('user_email' => $user_email);
                $point_table->updateRow($update_data, $where);
            }
        }
        wp_send_json_success();
    }

    function onBirthDayPoints(){
        global $wpdb;
        $settings = get_option('wlpr_settings');
        $enable_birth_date_point = (isset($settings['wlpr_enable_birth_date_point']) && !empty($settings['wlpr_enable_birth_date_point'])) ? $settings['wlpr_enable_birth_date_point']: 'yes';
        $wlpr_on_birth_date_point = (isset($settings['wlpr_on_birth_date_point']) && !empty($settings['wlpr_on_birth_date_point'])) ? $settings['wlpr_on_birth_date_point']: 50;
        if($enable_birth_date_point == 'yes' ){
            $point_table = $wpdb->prefix.'wlpr_points';
            $point_action = $wpdb->prefix.'wlpr_user_point_actions';
            $query = $wpdb->prepare("SELECT point_tbl.*,YEAR (point_action_tbl.created_date) as last_birth FROM {$point_table} as point_tbl
LEFT JOIN {$point_action} as point_action_tbl ON point_action_tbl.user_email = point_tbl.user_email AND point_action_tbl.action = %s 
 WHERE MONTH(point_tbl.birth_date) = %s AND DAY (point_tbl.birth_date) = %s GROUP BY point_tbl.user_email",'on_birth_date',date('m'),date('d'));
            $birth_users = $wpdb->get_results($query);
            foreach ($birth_users as $birth_user){
                if(empty($birth_user->last_birth) || date('Y') > $birth_user->last_birth){
                    self::$point->addEarnPoint($birth_user->user_email,$wlpr_on_birth_date_point, 'on_birth_date', null, null);
                }
            }
        }
    }

    function facebookShareReward(){
        $referral_settings = get_option('wlpr_referral');
        $wlpr_facebook_share_point = (isset($referral_settings['wlpr_facebook_share_point']) && !empty($referral_settings['wlpr_facebook_share_point'])) ? $referral_settings['wlpr_facebook_share_point']: 0;
        $enable_facebook_share_point = (isset($referral_settings['wlpr_enable_facebook_share_point']) && !empty($referral_settings['wlpr_enable_facebook_share_point'])) ? $referral_settings['wlpr_enable_facebook_share_point']: 'yes';
        if($wlpr_facebook_share_point > 0 && $enable_facebook_share_point === 'yes'){
            Loyalty::social()->socialShareReward($wlpr_facebook_share_point,'facebook_share');
        }
        wp_send_json_success();
    }

    function twitterShareReward(){
        $referral_settings = get_option('wlpr_referral');
        $wlpr_twitter_share_point = (isset($referral_settings['wlpr_twitter_share_point']) && !empty($referral_settings['wlpr_twitter_share_point'])) ? $referral_settings['wlpr_twitter_share_point']: 0;
        $enable_twitter_share_point = (isset($referral_settings['wlpr_enable_twitter_share_point']) && !empty($referral_settings['wlpr_enable_twitter_share_point'])) ? $referral_settings['wlpr_enable_twitter_share_point']: 'yes';
        if($wlpr_twitter_share_point > 0 && $enable_twitter_share_point === 'yes'){
            Loyalty::social()->socialShareReward($wlpr_twitter_share_point,'twitter_share');
        }
        wp_send_json_success();
    }

    function emailShareReward(){
        $referral_settings = get_option('wlpr_referral');
        $wlpr_email_share_point = (isset($referral_settings['wlpr_email_share_point']) && !empty($referral_settings['wlpr_email_share_point'])) ? $referral_settings['wlpr_email_share_point']: 0;
        $enable_email_share_point = (isset($referral_settings['wlpr_enable_email_share_point']) && !empty($referral_settings['wlpr_enable_email_share_point'])) ? $referral_settings['wlpr_enable_email_share_point']: 'yes';
        if($wlpr_email_share_point > 0 && $enable_email_share_point === 'yes'){
            Loyalty::social()->socialShareReward($wlpr_email_share_point,'email_share');
        }
        wp_send_json_success();
    }

    function whatsAppShareReward(){
        $referral_settings = get_option('wlpr_referral');
        $wlpr_whatsapp_share_point = (isset($referral_settings['wlpr_whatsapp_share_point']) && !empty($referral_settings['wlpr_whatsapp_share_point'])) ? $referral_settings['wlpr_whatsapp_share_point']: 0;
        $enable_whatsapp_share_point = (isset($referral_settings['wlpr_enable_whatsapp_share_point']) && !empty($referral_settings['wlpr_enable_whatsapp_share_point'])) ? $referral_settings['wlpr_enable_whatsapp_share_point']: 'yes';
        if($wlpr_whatsapp_share_point > 0 && $enable_whatsapp_share_point === 'yes'){
            Loyalty::social()->socialShareReward($wlpr_whatsapp_share_point,'whatsapp_share');
        }
        wp_send_json_success();
    }
}