<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */

namespace Wlpr\App\Controllers;

use Wlpr\App\Helpers\Input;
use Wlpr\App\Helpers\Loyalty;
use Wlpr\App\Helpers\Template;

class Base
{
    protected static $input, $point, $product, $checkout, $template, $woocommerce;

    /**
     * Base constructor.
     * init all required helper
     * @since 1.0.0
     */
    function __construct()
    {
        self::$input = empty(self::$input) ? new Input() : self::$input;
        self::$point = empty(self::$point) ? Loyalty::point() : self::$point;
        self::$product = empty(self::$product) ? Loyalty::product() : self::$product;
        self::$checkout = empty(self::$checkout) ? Loyalty::checkout() : self::$checkout;
        self::$template = empty(self::$template) ? new Template() : self::$template;
        self::$woocommerce = empty(self::$woocommerce) ? Loyalty::woocommerce() : self::$woocommerce;
        //$this->initCompatibles();
    }

    /**
     * Init all the required compatibles
     * @since 1.0.0
     */
    function initCompatibles()
    {
    }

    /**
     * Create all required tables
     * @since 1.0.0
     */
    function createRequiredTables()
    {
    }

    /**
     * Update point, when order status change
     * @param $order_id
     * @param $from_status
     * @param $to_status
     * @param $order_obj
     * @since 1.0.0
     */
    function updatePoints($order_id,$from_status,$to_status,$order_obj)
    {
        $can_add_point = true;
        $can_add_point = apply_filters('wlpr_can_point_increase_decrease', $can_add_point, $order_id,$from_status,$to_status);
        $wlpr_discount_method = self::$point->getDiscountMethod();
        if($wlpr_discount_method != 'fee' && $can_add_point) {
            $order = self::$woocommerce->getOrder($order_id);
            self::$point->deductRedeemedPoints($order_id, $order);
            $options = get_option('wlpr_settings', '');
            $point_earning_status = (isset($options['wlpr_point_earning_status']) && !empty($options['wlpr_point_earning_status']) ? $options['wlpr_point_earning_status'] : array('processing','completed'));
            if (in_array($order->get_status(),$point_earning_status)) {
                self::$point->addPointEarned($order_id, $order);
            }
        }
    }
}