<?php
/**
 * @author      Flycart (Alagesan)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html
 * @link        https://www.flycart.org
 * */
use Wlpr\App\Models\Points;

class LoyaltyPoints {
    protected $namespace = 'flycart-loyalty-points/v1';

    protected $rest_base = 'points';
    public function register_routes() {
        register_rest_route(
            $this->namespace,
            '/' . $this->rest_base.'/add',
            array(
                'methods' => 'POST',
                'callback' => array( $this, 'add_points' ),
                'permission_callback' => '__return_true',
                'args' => array(
                    'user_email' => array(
                        'required' => true,
                        'validate_callback' => function($param, $request, $key) {
                            $email_status = true;
                            if(filter_var($param, FILTER_VALIDATE_EMAIL)){
                                $email_status = false;
                            }
                            return (!preg_match(
                                "^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,6})$^", $param))
                                ? FALSE : TRUE;
                        }
                    ),
                    'points' => array(
                        'required' => true,
                        'validate_callback' => function($param, $request, $key) {
                            $status = true;
                            if(!is_numeric($param)){
                                $status = false;
                            }
                            if($param < 0){
                                $status = false;
                            }
                            return $status;
                        }
                    )
                )
            )
        );

        register_rest_route(
            $this->namespace,
            '/' . $this->rest_base.'/reduce',
            array(
                'methods' => 'POST',
                'callback' => array( $this, 'reduce_points' ),
                'permission_callback' => '__return_true',
                'args' => array(
                    'user_email' => array(
                        'required' => true,
                        'validate_callback' => function($param, $request, $key) {
                            return (!preg_match(
                                "^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,6})$^", $param))
                                ? FALSE : TRUE;
                        }
                    ),
                    'points' => array(
                        'default' => 0,
                        'required' => true,
                        'validate_callback' => function($param, $request, $key) {
                            $status = true;
                            if(!is_numeric($param)){
                                $status = false;
                            }
                            if($param < 0){
                                $status = false;
                            }

                            return $status;
                        }
                    ),
                )
            )
        );
    }

    /**
     * @param $request - \WP_REST_Request
     * @return WP_REST_Response
     */
    public function add_points( $request ) {
        global $wpdb;
        $user_email = $request->get_param('user_email');
        $points = $request->get_param('points');
        $points = $this->roundPoints($points);
        //1. New user add point... so need to create user
        //2. Old user add point... so need to update point
        $pointTable = new Points();
        $email = sanitize_email($user_email);
        $point_helper = \Wlpr\App\Helpers\Loyalty::point();
        $data = true;
        try{
            $point_helper->addEarnPoint($email, $points, 'rest-api');
        }catch (Exception $e){
            $data = false;
        }
        if($data){
            $where = $wpdb->prepare("user_email = %s", $email);
            $data = $pointTable->getWhere($where, '*', true);
        }

        return new WP_REST_Response( $data, 200 );
    }

    /**
     * @param $request
     * @return WP_REST_Response
     */
    public function reduce_points( $request ) {
        global $wpdb;
        $user_email = $request->get_param('user_email');
        $points = $request->get_param('points');
        $points = $this->roundPoints($points);
        //1. New user add point... so need to create user
        //2. Old user add point... so need to update point
        $pointTable = new Points();
        $email = sanitize_email($user_email);
        $point_helper = \Wlpr\App\Helpers\Loyalty::point();
        $data = true;
        try{
            $point_helper->reducePoints($email, $points, 'rest-api');
        }catch (Exception $e){
            $data = false;
        }
        if($data){
            $where = $wpdb->prepare("user_email = %s", $email);
            $data = $pointTable->getWhere($where, '*', true);
        }

        return new WP_REST_Response( $data, 200 );
    }

    public function roundPoints($points)
    {
        $settingOption = get_option('wlpr_settings', '');
        $roundingOption = (isset($settingOption['wlpr_point_rounding_type']) && !empty($settingOption['wlpr_point_rounding_type'])) ? $settingOption['wlpr_point_rounding_type'] : 'round';
        switch ($roundingOption) {
            case 'ceil':
                $pointEarned = ceil($points);
                break;
            case 'floor':
                $pointEarned = floor($points);
                break;
            default:
                $pointEarned = round($points);
                break;
        }
        return $pointEarned;
    }
}