<?php

/**
 * Short codes.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'GTW_Shortcodes' ) ) {

	/**
	 * Class.
	 */
	class GTW_Shortcodes {

		/**
		 * Class Initialization.
		 * */
		public static function init() {
			$shortcodes = apply_filters( 'gtw_load_shortcodes' , array(
				'gtw_order_gift_wrapper' ,
				'gtw_gtw_order_gift_wrapper_remove_notice' ,
				'gtw_order_gift_wrapper_non_applicable_products_notice' ,
					) ) ;

			foreach ( $shortcodes as $shortcode_name ) {
				// Add a shortcode.
				add_shortcode( $shortcode_name , array( __CLASS__ , 'process_shortcode' ) ) ;
			}
		}

		/**
		 * Process the shortcode.
		 * 
		 * @return mixed
		 * */
		public static function process_shortcode( $atts, $content, $tag ) {
			$shortcode_name = str_replace( 'gtw_' , '' , $tag ) ;
			$function       = 'shortcode_' . $shortcode_name ;

			switch ( $shortcode_name ) {
				case 'order_gift_wrapper':
				case 'gtw_order_gift_wrapper_remove_notice':
				case 'order_gift_wrapper_non_applicable_products_notice':
					ob_start() ;
					self::$function( $atts , $content ) ; // output for shortcode.
					$content = ob_get_contents() ;
					ob_end_clean() ;
					break ;

				default:
					ob_start() ;
					do_action( "gtw_shortcode_{$shortcode_name}_content" ) ;
					$content = ob_get_contents() ;
					ob_end_clean() ;
					break ;
			}

			return $content ;
		}

		/**
		 * Display the content of the order gift wrapper.
		 * 
		 * @return void
		 * */
		public static function shortcode_order_gift_wrapper( $atts, $content ) {

			GTW_Frontend::render_popup_order_gift_wrapper( 'shortcode' ) ;
		}

		/**
		 * Display the content of the order gift wrapper remove notice.
		 * 
		 * @return void
		 * */
		public static function shortcode_gtw_order_gift_wrapper_remove_notice( $atts, $content ) {

			GTW_Frontend::add_remove_order_gift_wrapper_notice() ;
		}

		/**
		 * Display the content of the order gift wrapper exclude products notice.
		 * 
		 * @return void
		 * */
		public static function shortcode_order_gift_wrapper_non_applicable_products_notice( $atts, $content ) {

			GTW_Frontend::order_gift_wrapper_exclude_products_notice() ;
		}

	}

	GTW_Shortcodes::init() ;
}
