<?php

/**
 * WooCommerce Multi Currency Compatibility.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'GTW_WooCommerce_Multi_Currency_Compatibility' ) ) {

	/**
	 * Class GTW_WPML_Multi_Currency_Compatibility.
	 */
	class GTW_WooCommerce_Multi_Currency_Compatibility extends GTW_Compatibility {

		/**
		 * Class Constructor.
		 */
		public function __construct() {
			$this->id = 'woocommerce_multi_currency' ;

			parent::__construct() ;
		}

		/**
		 * Is plugin enabled?.
		 * 
		 *  @return bool
		 * */
		public function is_plugin_enabled() {
			return class_exists( 'WOOMC\App' ) ;
		}

		/**
		 * Action
		 */
		public function actions() {

			// Convert the price.
			add_filter( 'gtw_convert_price' , array( $this , 'convert_price' ) , 10 , 2 ) ;
			// Convert the cart gift wrapper price.
			add_filter( 'gtw_gift_wrapper_product_price' , array( $this , 'convert_cart_gift_wrapper_price' ) , 10 , 2 ) ;
			// Stop the cart product price conversion.
			add_filter( 'woocommerce_multicurrency_pre_product_get_price' , array( $this , 'stop_cart_product_price_conversion' ) , 10 , 4 ) ;
		}

		/**
		 * Convert the cart gift wrapper price.
		 * 
		 * @return string
		 */
		public function convert_cart_gift_wrapper_price( $price, $session ) {
			return $this->convert_price( $price , false ) ;
		}

		/**
		 * Stop the cart product price conversion.
		 * 
		 * @return string/bool
		 */
		public function stop_cart_product_price_conversion( $pre_value, $value, $product, $price_type ) {
			if ( ! is_object( WOOMC\App::instance() ) ) {
				return $pre_value ;
			}

			// Return if the current product is not a gift wrapper.
			if ( ! isset( $product->gtw_orginal_wrapper_price ) ) {
				return $pre_value ;
			}

			return $value ;
		}

		/**
		 * Convert the price.
		 * 
		 * @return string
		 */
		public function convert_price( $price, $currency ) {
			if ( ! is_object( WOOMC\App::instance() ) ) {
				return $price ;
			}

			$detector   = new WOOMC\Currency\Detector() ;
			$controller = new WOOMC\Price\Controller( WOOMC\App::instance()->getPriceCalculator() , $detector ) ;
			if ( ! is_object( $controller ) ) {
				return $price ;
			}

			return $controller->convert( $price ) ;
		}

	}

}
