<?php
/**
 * Shortcodes information.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
/*
 * Hook: gtw_before_shortcode_contents.
 */
do_action( 'gtw_before_shortcode_contents' ) ;
?>
<table class="form-table gtw_shortcodes_info widefat striped">
	<thead>
		<tr>
			<th><?php esc_html_e( 'Shortcode' , 'gift-wrapper-for-woocommerce' ) ; ?></th>
			<th><?php esc_html_e( 'Parameter Support' , 'gift-wrapper-for-woocommerce' ) ; ?></th>
			<th><?php esc_html_e( 'Description' , 'gift-wrapper-for-woocommerce' ) ; ?></th>
		</tr>
	</thead>
	<tbody>
		<?php
		if ( gtw_check_is_array( $shortcodes_info ) ) :
			foreach ( $shortcodes_info as $shortcode => $details ) :
				?>
				<tr>
					<td><?php echo esc_html( $shortcode ) ; ?></td>
					<td><?php echo esc_html( $details[ 'supported_parameters' ] ) ; ?></td>
					<td><?php echo esc_html( $details[ 'usage' ] ) ; ?></td>
				</tr>
				<?php
			endforeach ;
		endif ;
		?>
	</tbody>
</table>

<?php
/*
 * Hook: gtw_after_shortcodes_content.
 */
do_action( 'gtw_after_shortcodes_content' ) ;

