<?php

/**
 * Shortcodes Tab
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( class_exists( 'GTW_Shortcodes_Tab' ) ) {
	return new GTW_Shortcodes_Tab() ;
}

/**
 * GTW_Shortcodes_Tab.
 */
class GTW_Shortcodes_Tab extends GTW_Settings_Page {

	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->id                = 'shortcodes' ;
		$this->show_reset_button = false ;
		$this->label             = esc_html__( 'Shortcodes' , 'gift-wrapper-for-woocommerce' ) ;

		// Display the shortcode information.
		add_action( 'woocommerce_admin_field_gtw_shortcodes_information' , array( $this , 'shortcodes_information' ) ) ;

		parent::__construct() ;
	}

	/**
	 * Get the settings for the shortcodes section array.
	 * 
	 * @return array
	 * */
	protected function shortcodes_section_array() {

		$section_fields = array() ;

		// Shortcodes section start.
		$section_fields[] = array(
			'type'  => 'title' ,
			'title' => __( 'Shortcodes' , 'gift-cards-pro-for-woocommerce' ) ,
			'id'    => 'gtw_shortcodes_options' ,
				) ;
		$section_fields[] = array(
			'type' => 'gtw_shortcodes_information' ,
				) ;
		$section_fields[] = array(
			'type' => 'sectionend' ,
			'id'   => 'gtw_shortcodes_options' ,
				) ;
		// Shortcodes section end.

		return $section_fields ;
	}

	/**
	 * Display the shortcode information.
	 * 
	 * @retrun void
	 * */
	public function shortcodes_information() {

		$shortcodes_info = array(
			'[gtw_order_gift_wrapper]'                                => array(
				'supported_parameters' => 'No' ,
				'usage'                => __( 'Display entire order gift wrapper' , 'gift-cards-pro-for-woocommerce' )
			) ,
			'[gtw_order_gift_wrapper_remove_notice]'                  => array(
				'supported_parameters' => 'No' ,
				'usage'                => __( 'Display remove order gift wrapper notice' , 'gift-cards-pro-for-woocommerce' )
			) ,
			'[gtw_order_gift_wrapper_non_applicable_products_notice]' => array(
				'supported_parameters' => 'No' ,
				'usage'                => __( 'Display order gift wrapper non-applicable products notice' , 'gift-cards-pro-for-woocommerce' )
			)
				) ;

		include_once( GTW_ABSPATH . 'inc/admin/menu/views/html-shortcodes-info.php' ) ;
	}

}

return new GTW_Shortcodes_Tab() ;
