<?php
/**
 * Plugin Name:       Discount on total bulk quantity for NBDesigner Advanced
 * Plugin URI:        https://cmsmart.net
 * Description:       Apply discount price for total bulk quantity
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.1
 * Author:            Hoang
 * Author URI:        https://cmsmart.net
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       discount-on-total-bulk-for-nbdesigner-advanced
 * Domain Path:       /languages
 */

add_action('wp_enqueue_scripts','nbod_discount_bulk_nbdesigner_js',31);
function nbod_discount_bulk_nbdesigner_js(){
    wp_localize_script('nbdesigner','nbod_discount_bulk',true); 
}
add_action('admin_enqueue_scripts','nbod_admin_discount_bulk_nbdesigner_js',31);
function nbod_admin_discount_bulk_nbdesigner_js(){
    wp_localize_script('admin_nbdesigner','nbod_discount_bulk',true);  
}

add_action('nbd_js_config','nbod_discount_bulk_frontend_js');
function nbod_discount_bulk_frontend_js(){
    echo 'var nbod_discount_bulk = true;';
}

add_filter('nbdesigner_printing_options_settings','include_discount_options');
function include_discount_options($array){
    $discount_arr = array(
        'title'         => esc_html__( 'Apply discount price for total bulk quantity', 'web-to-print-online-designer'),
        'description'   => esc_html__( 'Required setting "Bulk variation" for option appearance.', 'web-to-print-online-designer'),
        'id'            => 'nbdesigner_discount_bulk',
        'default'       => 'no',
        'type'          => 'radio',
        'options'       => array(
            'yes'   => esc_html__('Yes', 'web-to-print-online-designer'),
            'no'    => esc_html__('No', 'web-to-print-online-designer')
        )  
    );
    array_push($array['general'],$discount_arr);
    return $array;
}

add_filter('nbod_option_total_bulk','build_option_total_bulk',10,6);
function build_option_total_bulk($options_field,$options,$f_key,$tab,$key,$f){
    if (nbdesigner_get_option( 'nbdesigner_discount_bulk') == yes) {
        if ($options['display_type'] == 3 && $key == 'depend_qty'){
            $options_field = NBD_ADMIN_PRINTING_OPTIONS::build_config_general_bulk_depend_qty($f);
        }
    }
    return $options_field;
}

add_filter('nbod_recalculate_total_bulk','recalculate_total_bulk',10,5);
function recalculate_total_bulk($option_price,$options,$product,$post_data,$quantity){
    if (nbdesigner_get_option( 'nbdesigner_discount_bulk') == yes) {
        $option_fields  = unserialize( $options['fields'] );
        $nbd_field      = isset( $post_data['nbd-field'] ) ? $post_data['nbd-field'] : array();
        $original_price = (float)$product->get_price('edit');
        if($option_fields['display_type'] == 3){
            $total_bulk = 0;
            foreach ($post_data['nbb-qty-fields'] as $k => $qty) {
                $total_bulk += $qty;
            }
            $option_price   = NBD_FRONTEND_PRINTING_OPTIONS::option_processing_recal( $options, $original_price, $nbd_field, $quantity, null, $product ,$total_bulk);
        }
        return $option_price;
    } else {
        return $option_price;
    }
}

add_filter('nbod_recalculate_total_bulk2','recalculate_total_bulk2',10,6);
function recalculate_total_bulk2($option_price,$fields,$options,$product,$cart,$quantity){
    if (nbdesigner_get_option( 'nbdesigner_discount_bulk') == yes) {
        if( nbd_is_base64_string( $options['fields'] ) ){
            $options['fields'] = base64_decode( $options['fields'] );
        }
        $option_fields  = unserialize( $options['fields'] );
        $option_fields  = NBD_FRONTEND_PRINTING_OPTIONS::recursive_stripslashes( $option_fields );
        $original_price = (float)$product->get_price( 'edit' );
        if($option_fields['display_type'] == 3){
            $total_bulk = 0;
            foreach ( $cart->cart_contents as $cart_item_key => $cart_item ) {
                $total_bulk += $cart_item['quantity'];
            }
            $option_price   = NBD_FRONTEND_PRINTING_OPTIONS::option_processing_recal( $options, $original_price, $fields, $quantity, $cart_item_key, $product ,$total_bulk);
        }
        return $option_price;
    } else {
        return $option_price;
    }
}

add_action('nbod_add_field_bulk_min_qty','add_field_bulk_min_qty');
function add_field_bulk_min_qty(){
    ?>
    <div class="nbd-field-info">
        <div class="nbd-field-info-1">
            <div><label><b><?php _e('Min quantity', 'web-to-print-online-designer'); ?></b></label></div>
        </div>
        <div class="nbd-field-info-2">
            <div>
                <input ng-model="options.bulk_min_qty" name="options[bulk_min_qty]"/>
            </div>
        </div>
    </div>
    <?php
}

add_filter('nbod_apply_min_bulk_qty','apply_min_bulk_qty',10,2);
function apply_min_bulk_qty($html,$options){
    $min_qty = $options['bulk_min_qty'] != '' ? $options['bulk_min_qty'] : 1;
    ob_start();
    ?>
    <!--<td><input class="nbb-qty-fields" name="nbb-qty-fields[]" type="number" min="<?php echo $min_qty; ?>" step="1" value="<?php echo $min_qty; ?>" style="width: 4em" pattern="[0-9]*" onchange="nbOption.updateBulkPrice()"/></td>-->
    <td><input class="nbb-qty-fields" name="nbb-qty-fields[]" type="number" min="<?php echo $min_qty; ?>" step="1" value="" style="width: 4em" pattern="[0-9]*" onchange="nbOption.updateBulkPrice()"/></td>
    <?php
    $html = ob_get_clean();
    return $html;
}
//add_action('nbd_enable_table_price_for_bulk','show_table_price_for_bulk',10,7);
function show_table_price_for_bulk($options,$display_type,$has_delivery,$num_visible_field,$request,$nbd_qv_type,$style_class){
    if( nbdesigner_get_option('nbdesigner_hide_table_pricing', 'no') == 'no' && $options['display_type'] == 3 && !$has_delivery && $num_visible_field > 0 ): ?>
            <div ng-if="valid_form && price_table.length > 1" class="nbo-table-pricing-wrap <?php echo $style_class; ?>" <?php if( isset($_REQUEST['wc-api']) && $_REQUEST['wc-api'] == 'NBO_Quick_View' && $nbd_qv_type == '2') echo 'nbd-perfect-scroll'; ?>>
                <p class="nbo-table-pricing-title" ng-init="showNboTablePricing = true">
                    <b><?php _e('Table pricing', 'web-to-print-online-designer'); ?></b>
                    <?php if( $display_type == 3 ): ?>
                    <span class="nbo-minus nbo-toggle" ng-show="showNboTablePricing" ng-click="showNboTablePricing = !showNboTablePricing"> 
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.0" width="34" height="34" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                            <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none">
                                <path d="M1897 2623 c-345 -346 -630 -638 -633 -651 -14 -54 44 -113 98 -97 13 4 287 271 610 593 l588 587 593 -593 c542 -542 595 -592 625 -592 44 0 82 38 82 82 0 30 -52 85 -633 665 -593 594 -634 633 -667 633 -32 0 -73 -39 -663 -627z"/>
                            </g>
                        </svg> 
                    </span>
                    <span class="nbo-plus nbo-toggle" ng-show="!showNboTablePricing" ng-click="showNboTablePricing = !showNboTablePricing">
                        <svg xmlns="http://www.w3.org/2000/svg" version="1.0" width="34" height="34" viewBox="0 0 512.000000 512.000000" preserveAspectRatio="xMidYMid meet">
                            <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none">
                                <path d="M1303 3238 c-27 -13 -47 -60 -39 -90 3 -13 288 -305 633 -650 589 -589 631 -628 663 -628 32 0 74 39 662 627 375 374 629 636 633 651 13 52 -30 102 -88 102 -15 0 -193 -171 -614 -592 l-593 -593 -593 593 c-621 621 -606 608 -664 580z"/>
                            </g>
                        </svg>
                    </span>
                    <?php endif; ?>
                </p>
                <table class="nbo-table-pricing" ng-show="!showNboTablePricing">
                    <?php if( nbdesigner_get_option( 'nbdesigner_table_pricing_type', '1' ) == '1' ): ?>
                    <thead>
                        <tr>
                            <th><?php _e('From', 'web-to-print-online-designer'); ?></th>
                            <th><?php _e('Up to', 'web-to-print-online-designer'); ?></th>
                            <th><?php _e('Price / 1 item', 'web-to-print-online-designer'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr ng-repeat="pt in price_table" ng-class="pt.in_range ? 'nbo-bold' : ''">
                            <td>{{pt.from}}</td>
                            <td>{{pt.up != '**' ? pt.up : '<?php _e('or more', 'web-to-print-online-designer'); ?>'}}</td>
                            <td ng-bind-html="pt.final_price | to_trusted"></td>
                        </tr>
                    </tbody>
                    <?php else: ?>
                    <thead>
                        <tr>
                            <th><?php _e('Amount', 'web-to-print-online-designer'); ?></th>
                            <th><?php _e('Unit price', 'web-to-print-online-designer'); ?></th>
                            <th><?php _e('Total price', 'web-to-print-online-designer'); ?></th>
                            <th><?php _e('Saving', 'web-to-print-online-designer'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr ng-repeat="pt in price_table">
                            <td>{{pt.qty}}</td>
                            <td ng-bind-html="pt.final_price | to_trusted"></td>
                            <td ng-if="!pt.cart_item_fee.enable" ng-bind-html="pt.total_cart_price | to_trusted"></td>
                            <td ng-if="pt.cart_item_fee.enable"><span ng-bind-html="pt._total_cart_price | to_trusted"></span>(+<span ng-bind-html="pt.cart_item_fee.value | to_trusted"></span>)</td>
                            <td ng-class="pt.klass">{{pt.saving}}</td>
                        </tr>
                    </tbody>
                    <tfoot ng-if="price_table_cart_fee">
                        <tr><td colspan="4"><small><?php _e('(+x) x: Cart item fee', 'web-to-print-online-designer'); ?></small></td></tr>
                    </tfoot>
                    <?php endif; ?>
                </table>
            </div>
            <?php endif;
}
add_filter( 'woocommerce_get_price_html', 'change_product_price_display_plus', 10, 2 );
function change_product_price_display_plus($price, $product){
     
    //$price = '<span class="'. $class .'">'. __('Good mornig', 'web-to-print-online-designer') .'</span> ' . $price;
     $price = $price.'<ul class ="size-custom"> 											
    <li>
        <img src="https://test1.cmsmart.net/www.mtmp.com.my/wp-content/uploads/2022/04/6/guida-taglie.svg" >  
        <a  href="#">Guida taglie </a>
    </li>												
    <li>
        <img src="https://test1.cmsmart.net/www.mtmp.com.my/wp-content/uploads/2022/04/6/descrizione.svg"> 
        <a href="#">Info prodotto </a>
    </li>	
</ul>' ;
    return $price;
}