<?php

/**
 * Plugin Name: Free Shipping (Customized)
 * Description: Free shipping hide flat rate & show local pickup.
 * Version: 1.1.0
 * License: GPL-3.0+
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */
if (!defined('WPINC')) {
    die;
}

/*
 * Check if WooCommerce is active
 */
if (in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) {

    add_action('woocommerce_shipping_init', 'iora_order_total_free_shipping_method');

    function iora_order_total_free_shipping_method() {
        if (!class_exists('WC_iORA_Shipping_Method')) {

            class WC_iORA_Shipping_Method extends WC_Shipping_Method {

                public function __construct($instance_id = 0) {
                    $this->id = 'iora_order_total_free_shipping';
                    $this->instance_id = absint($instance_id);
                    $this->method_title = __('Free Shipping (Customized)');
                    $this->method_description = __('Free shipping hide flat rate & show local pickup.');
                    $this->supports = array(
                        'shipping-zones',
                        'instance-settings',
                        'instance-settings-modal'
                    );
                    // make it always enabled
                    $this->title = __('Free Shipping (Customized)');
                    $this->enabled = 'yes';
                    $this->init();
                }

                function init() {
                    // Load the settings API
                    $this->init_form_fields();
                    $this->init_settings();
                    // Save settings in admin if you have any defined
                    add_action('woocommerce_update_options_shipping_' . $this->id, array(
                        $this,
                        'process_admin_options'
                    ));
                }

                // Fields for the settings page
                function init_form_fields() {
                    // Fields for the modal form from the Zones window
                    $this->instance_form_fields = array(
                        'title' => array(
                            'title' => __('Title'),
                            'type' => 'text',
                            'description' => __('Shipping title to be displayed on site'),
                            'default' => __('Free Shipping Over $0')
                        ),
                        'order_total' => array(
                            'title' => __('Order Total'),
                            'type' => 'number',
                            'description' => __('Minimum order total (Total - Discount - Coupon Discount) for free shipping'),
                            'default' => 0
                        )
                    );
                }

                public function calculate_shipping($package = array()) {
                    $intance_settings = $this->instance_settings;
                    // Register the rate
                    $this->add_rate(array(
                        'id' => $this->id,
                        'label' => $intance_settings['title'],
                        'cost' => 0,
                        'package' => $package,
                        'taxes' => false
                    ));
                }

            }

        }
        //add your shipping method to WooCommers list of Shipping methods
        add_filter('woocommerce_shipping_methods', 'add_iora_order_total_free_shipping_method');

        function add_iora_order_total_free_shipping_method($methods) {
            $methods['iora_order_total_free_shipping'] = 'WC_iORA_Shipping_Method';
            return $methods;
        }

        function get_discount_total() {
            $discount_total = 0;
            foreach (WC()->cart->get_coupon_discount_totals() as $coupon_id => $discount) {
                $coupon = new WC_Coupon($coupon_id);
                if ($coupon->discount_type != 'store_credit') {
                    $discount_total += $discount;
                }
            }
            return $discount_total;
        }

        function get_fees_total() {
            $fees_total = 0;
            foreach (WC()->cart->get_fees() as $fee) {
                $fees_total += $fee->total;
            }
            return $fees_total;
        }

        function action_woocommerce_cart_totals_before_shipping() {
            $packages = WC()->shipping->get_packages();
            $subtotal = (float) WC()->cart->get_displayed_subtotal();
            $provide_free_shipping = false;
            $free_shipping_method_list = array();
            $flat_rate_method_list = array();
            $set_shipping_methods = array();
            $chosen_shipping_method = WC()->session->get('chosen_shipping_methods');

            foreach ($packages as $i => $package) {
                $all_shipping_methods = $package['rates'];
                $set_shipping_methods = $package['rates'];
                foreach ($all_shipping_methods as $shipping_method_key => $shipping_method) {
                    if ($shipping_method->method_id == 'iora_order_total_free_shipping') {
                        $free_shipping_method_list[] = $shipping_method_key;
                    } elseif ($shipping_method->method_id == 'local_pickup' || $shipping_method->method_id == 'local_pickup_plus'){
                        // do nothing
                    } else {
                        $flat_rate_method_list[] = $shipping_method_key;
                    }

                    if ($shipping_method->method_id == 'iora_order_total_free_shipping') {
                        $free_shipping_method_list[] = $shipping_method_key;
                        // Get order_total setting to decide free shipping
                        $option_name = 'woocommerce_iora_order_total_free_shipping_' . $shipping_method->instance_id . '_settings';
                        $iora_order_total_free_shipping_settings = get_option($option_name);

                        if (isset($iora_order_total_free_shipping_settings['order_total'])) {
                            $iora_order_total_setting = (float) $iora_order_total_free_shipping_settings['order_total'];
                            // Calculate subtotal without discount
                            $fees_total = get_fees_total();
                            $discount_total = get_discount_total();
                            $subtotal_after_fees = $subtotal + $fees_total - $discount_total;

                            // If subtotal more than order_total setting, provide free shipping
                            if ($subtotal_after_fees >= $iora_order_total_setting) {
                                $provide_free_shipping = true;
                            }
                        }
                    }
                }
                if ($provide_free_shipping) {
                    // If provide free shipping, remove flat rate method
                    foreach ($flat_rate_method_list as $method_key) {
                        unset($set_shipping_methods[$method_key]);
                    }
                } else {
                    // If not provide free shipping, remove free shipping method
                    foreach ($free_shipping_method_list as $method_key) {
                        unset($set_shipping_methods[$method_key]);
                    }
                }
                WC()->shipping->packages[$i]['rates'] = $set_shipping_methods;
                // If selected flat rate shipping method no longer available
                // Select first shipping method 
                // Re-calculate cart total
                if (!isset(WC()->shipping->packages[$i]['rates'][$chosen_shipping_method[0]])) {
                    $new_chosen_shipping_method = array_key_first($set_shipping_methods);
                    WC()->session->set('chosen_shipping_methods', array($new_chosen_shipping_method));
                    // Calculate new cart total
                    $totals = WC()->cart->get_totals();
                    $new_shipping_cost = WC()->shipping->packages[$i]['rates'][$new_chosen_shipping_method]->cost;
                    $new_total = $totals['total'] - $totals['shipping_total'] + $new_shipping_cost;
                    $totals['shipping_total'] = $new_shipping_cost;
                    $totals['total'] = $new_total;
                    WC()->cart->set_totals($totals);
                }
            }
        }

        add_action('woocommerce_cart_totals_before_shipping', 'action_woocommerce_cart_totals_before_shipping', 10, 0);
        add_action('woocommerce_review_order_before_shipping', 'action_woocommerce_cart_totals_before_shipping', 10, 0);
    }

}