<?php
/*
 * Plugin Name: Atome Payment Gateway
 * Plugin URI: https://gateway.apaylater.com
 * Description: Atome enables users to own the things you love now and pay later. The bill will be split into three equal instalments automatically. No hidden fees, 0% interest.
 * Author: Atome
 * Author URI: https://www.atome.sg
 * Version: 2.5.11
 * License: GNU Public License
 */

add_action('plugins_loaded', 'atome_init_gateway_class');

function atome_init_gateway_class()
{
    if (!defined('WOO_ATOME_PLUGIN_PATH')) {
        define('WOO_ATOME_PLUGIN_PATH', plugin_dir_path(__FILE__));
    }

    if (!defined('WOO_ATOME_PLUGIN_URL')) {
        define('WOO_ATOME_PLUGIN_URL', plugin_dir_url(__FILE__));
    }

    if (!class_exists('WC_Payment_Gateway')) {
        return;
    }

    require_once WOO_ATOME_PLUGIN_PATH . 'includes/class-wc-atome-gateway.php';

    $atome_gateway = WC_Atome_Gateway::get_instance();


    add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'atome_plugin_action_links');
    function atome_plugin_action_links($links)
    {
        $settings_link = '<a href="' . admin_url('admin.php?page=wc-settings&tab=checkout&section=atome') . '">' . __('Settings') . '</a>';
        array_unshift($links, $settings_link);
        return $links;
    }

    //check update
    add_filter('site_transient_update_plugins', 'push_update');
    function push_update($transient)
    {
        if (empty($transient->checked)) {
            return $transient;
        }

        if (false == $remote = get_transient('upgrade_atome')) {
            // info.json is the file with the actual plugin information on your server
            $remote = wp_remote_get(
                WC_Atome_Gateway::BASE_URL . '/woocommerce/info.json',
                array(
                    'timeout' => 10,
                    'headers' => array(
                        'Accept' => 'application/json'
                    )
                )
            );

            if (!is_wp_error($remote) && isset($remote['response']['code']) && $remote['response']['code'] == 200 && !empty($remote['body'])) {
                set_transient('upgrade_atome', $remote, 300); // 5 mins cache
            }
        }

        if (!is_wp_error($remote) && isset($remote['response']['code']) && $remote['response']['code'] == 200 && !empty($remote['body'])) {
            $remote = json_decode($remote['body']);
            if ($remote && version_compare(WC_Atome_Gateway::VERSION, $remote->version, '<')) {
                $res = new stdClass();
                $res->slug = 'atome';
                $res->plugin = 'aaclub_wc_plugin/index.php'; // it could be just YOUR_PLUGIN_SLUG.php if your plugin doesn't have its own directory
                $res->new_version = $remote->version;
                $res->package = $remote->download_url;
                $transient->response[$res->plugin] = $res;
                //$transient->checked[$res->plugin] = $remote->version;
            }
        }
        return $transient;
    }

    // show update info
    add_filter('plugins_api', 'plugin_info', 20, 3);
    function plugin_info($res, $action, $args)
    {
        if ('plugin_information' !== $action) {
            return false;
        }

        $plugin_slug = 'atome';

        if ($plugin_slug !== $args->slug) {
            return false;
        }

        if (false == $remote = get_transient('update_' . $plugin_slug)) {
            $remote = wp_remote_get(
                WC_Atome_Gateway::BASE_URL . '/woocommerce/info.json',
                array(
                    'timeout' => 10,
                    'headers' => array(
                        'Accept' => 'application/json'
                    )
                )
            );

            if (!is_wp_error($remote) && isset($remote['response']['code']) && $remote['response']['code'] == 200 && !empty($remote['body'])) {
                set_transient('update_' . $plugin_slug, $remote, 43200); // 12 hours cache
            }
        }

        if (!is_wp_error($remote) && isset($remote['response']['code']) && $remote['response']['code'] == 200 && !empty($remote['body'])) {
            $remote = json_decode($remote['body']);
            $res = new stdClass();

            $res->name = 'Atome Payment Gateway';
            $res->slug = $plugin_slug;
            $res->version = $remote->version;
            $res->requires = $remote->requires;
            $res->author = '<a href="https://www.atome.sg">Atome</a>';
            $res->download_link = $remote->download_url;
            $res->trunk = $remote->download_url;
            $res->requires_php = '5.3';
            $res->last_updated = $remote->last_updated;
            $res->sections = array(
                'description' =>  "<ul><li>Atome enables users to own the things you love now and pay later. </li><li>The bill will be split into three equal instalments automatically. </li><li>No hidden fees, 0% interest.</li></ul>",
                'changelog' => $remote->sections->changelog
            );
            $res->banners = array(
                'low' => WC_Atome_Gateway::BASE_URL . '/plugins/wc/assets/images/woocommerce-banner.png',
                'high' => WC_Atome_Gateway::BASE_URL . '/plugins/wc/assets/images/woocommerce-banner.png'
            );
            return $res;
        }
        return false;
    }

    // delete cache
    add_action('upgrader_process_complete', 'after_update', 10, 2);
    function after_update($upgrader_object, $options)
    {
        if ($options['action'] == 'update' && $options['type'] === 'plugin') {
            delete_transient('upgrade_atome');
        }
    }

    // add payment gateway
    add_filter('woocommerce_payment_gateways', 'atome_add_gateway_class');
    function atome_add_gateway_class($gateways)
    {
        $gateways[] = 'WC_Atome_Gateway';
        return $gateways;
    }

    //add intro page
    add_action('wp_head', 'atome_render_hook');
    function atome_render_hook()
    {
        $gateways = WC_Atome_Gateway::get_instance();
        $country = $gateways->get_option('country');
        $language = $gateways->get_option('language');

        $options = array(
            'country'                  => $country,
            'language'                 => $language,
            'api_environment'          => $gateways->get_option('api_environment'),
            'price_divider'            => $gateways->get_option('price_divider'),
            'price_divider_created_by' => $gateways->get_option('price_divider_created_by'),
            'price_divider_applied_on' => $gateways->get_option('price_divider_applied_on'),
            'price_divider_position'   => $gateways->get_option('price_divider_position'),
            'sku_permission'           => $gateways->get_option('sku_permission'),
            'order_created_stage'      => $gateways->get_option('order_created_stage'),
            'max_spend'                => $gateways->get_option('max_spend'),
            'debug_mode'               => $gateways->get_option('debug_mode'),
            'version'                  => WC_Atome_Gateway::VERSION,
        );

        echo '<script type="text/javascript">window.atomePaymentPluginPriceDividerOptions = '.json_encode($options).'</script>';

        if ($country && $language) {
            $info = 'country=' . $country . '&lang=' . $language;
            echo '<script id="atome-intro-js" src="' . WC_Atome_Gateway::BASE_URL . '/plugins/intro/index.js?' . $info . '"></script>';
        } else {
            echo '<script src="' . WC_Atome_Gateway::BASE_URL . '/plugins/intro/index.js"></script>';
        }

        echo '<script src="'. WC_Atome_Gateway::BASE_URL . '/plugins/wc/price-divider.js"></script>';

        if(preg_match('/otobodycare.com/', get_option('siteurl'))) {
            echo '<style type="text/css"> .wc_payment_methods .payment_method_atome label {padding-left: 125px;} .payment_box.payment_method_atome {margin-top: -37px}</style>';
        }
    }

    add_action('wp_enqueue_scripts', 'add_frontend_scripts', 10, 0);
    function add_frontend_scripts() {
        wp_enqueue_style('woo-atome-main-style', WOO_ATOME_PLUGIN_URL . 'css/main.css', array(), WC_Atome_Gateway::VERSION);
    }

    // price divider
    if ($atome_gateway->get_option('price_divider') === 'yes' && $atome_gateway->get_option('price_divider_created_by') === 'plugin') {
        require_once WOO_ATOME_PLUGIN_PATH . '/includes/class-price-divider.php';
    }

    //fix connection error in bad network
    add_filter('http_request_timeout', 'timeout_extend');
    function timeout_extend()
    {
        return 20;
    }

    add_filter('wp_mail', 'atome_mail_handler');
    function atome_mail_handler($mail_info)
    {
        if(isset($mail_info['message'])){
            $mail_info['message'] = str_ireplace('{{atome.site.logo}}', '<td><img style="display: block; width: 100%; max-width: 100px; margin: 0 auto;" src="'.get_site_icon_url().'" alt="'.get_bloginfo( 'name' ).'" /></td>', $mail_info['message']);

            if(stripos($mail_info['message'], '{{atome.admin.phone}}') !== FALSE){
                $admin_args = array(
                    'role'   => 'administrator',
                    'fields' => array( 'id' ),
                );

                $admin_phone = '';
                $admin_usr   = get_users( $admin_args );
                foreach ($admin_usr as $user) {
                    $admin_phone      = get_user_meta( $user->id, 'billing_phone', true );
                    if(!empty($admin_phone)){
                        break;
                    }
                }

                $mail_info['message'] = str_ireplace('{{atome.admin.phone}}', $admin_phone, $mail_info['message']);
            }

        }

        return $mail_info;
    }

    if (WC_Atome_Gateway::get_instance()->check_display_atome_order_number()) {
        add_filter('manage_edit-shop_order_columns', 'add_atome_shop_order_column', 20 );
        add_action('manage_shop_order_posts_custom_column', 'add_atome_orders_list_column_content', 20, 2 );
    }


    function add_atome_shop_order_column($columns)
    {
        $reordered_columns = array();

        // Inserting columns to a specific location
        foreach( $columns as $key => $column){
            $reordered_columns[$key] = $column;
            if( $key ==  'order_number' ){
                // Inserting after "Status" column
                $reordered_columns['atome_order_number'] = __( 'Atome Order Number','atome');
            }
        }
        return $reordered_columns;
    }


    function add_atome_orders_list_column_content( $column, $post_id )
    {
        if ('atome_order_number' ==  $column) {
            if (get_post_meta($post_id, '_payment_method', true) == 'atome') {
                echo $post_id;
            }
        }
    }
}
