<?php

class WC_Atome_Price_Divider {

  protected $atome_gateway;

  protected $price_divider_temlate;

  protected $price_divider_position;

  public function __construct()
  {
    $this->atome_gateway = WC_Atome_Gateway::get_instance();
    $this->price_divider_temlate = $this->get_price_divider_temlate();
    $this->price_divider_position = $this->atome_gateway->get_option('price_divider_position');

    add_filter('woocommerce_get_price_html', array($this, 'atome_filter_woocommerce_get_price_html'), 1000, 2);

    if ('above_add_to_cart' === $this->price_divider_position) {
      add_action('woocommerce_before_add_to_cart_button', array($this, 'add_price_divider_before_add_to_cart_button'));
    } else if ('below_add_to_cart' === $this->price_divider_position) {
      add_action('woocommerce_after_add_to_cart_button', array($this, 'add_price_divider_after_add_to_cart_button'));
    }
  }

  public function add_price_divider_after_add_to_cart_button()
  {
    echo $this->get_price_divider_html();
  }

  public function add_price_divider_before_add_to_cart_button()
  {
    echo $this->get_price_divider_html();
  }

  public function get_price_divider_html($product = null)
  {
    if (empty($product)) {
      global $product;
    }
    $price_to_display = $this->atome_gateway->get_price_to_display($product);

    if (!$this->can_show_price_divder($price_to_display)) {
      $this->atome_gateway->log('[get_price_divider_html]: can_show_price_divder => false');
      return '';
    }

    $display_data = [
      'formatted_installment_price' => wc_price($this->atome_gateway->format_price_for_price_divider($price_to_display / 3)),
      'atome_pd_logo_url'           => $this->atome_gateway->get_price_divider_logo_url(),
      'class_div_wrpper'            => is_product() && doing_action('woocommerce_single_product_summary') ?  $this->price_divider_position : 'below_price_on_list',
    ];

    $price_divider_html = preg_replace_callback('/{{(\w+?)}}/', function ($matches) use ($display_data) {
      return isset($display_data[$matches[1]]) ? $display_data[$matches[1]] : '';
    }, $this->price_divider_temlate);

    return str_replace(PHP_EOL, '', $price_divider_html);
  }

  public function get_price_divider_temlate()
  {
    $language = $this->atome_gateway->get_option('language');
    $price_divider_template = $this->atome_gateway->get_messages('price_divider');

    if (empty($price_divider_template) || ('zh' == $language && !preg_match('/traditional-chinese/', $price_divider_template))) {
      $default_pd_files = [
        'en' => 'English',
        'zh' => 'Chinese_HongKong',
      ];
      $language_file = isset($default_pd_files[$language]) ? $default_pd_files[$language] : 'English';
      $path = WOO_ATOME_PLUGIN_PATH . '/i18n/languages/' . $language_file . '.php';

      if (!file_exists($path)) {
        $path = WOO_ATOME_PLUGIN_PATH . '/i18n/languages/English.php';
      }

      $language_contents = require $path;

      $price_divider_template = isset($language_contents['price_divider']) ? $language_contents['price_divider'] : '';
    }

    return $price_divider_template;
  }

  public function can_show_price_divder($price_to_display)
  {
    if (is_admin()) {
      $this->atome_gateway->log('[can_show_price_divder]: is_admin => true');
      return false;
    }

    $max_spend = $this->atome_gateway->get_option('max_spend');
    if (!empty($max_spend) && $price_to_display > $max_spend) {
      $this->atome_gateway->log('[can_show_price_divder]: price_to_display > max_spend = '. $max_spend);
      return false;
    }

    if (preg_match('/designcollection.dk|designmyspace.com/', get_option('siteurl')) && $price_to_display > 3000) {
      $this->atome_gateway->log('[can_show_price_divder]: price_to_display > 3000');
      return false;
    }

    if ($price_to_display < 1) {
      $this->atome_gateway->log('[can_show_price_divder]: price_to_display < 1');
      return false;
    }

    $price_divider_applied_on = $this->atome_gateway->get_option('price_divider_applied_on');
    if ($price_divider_applied_on === 'product' && (!is_product() || !doing_action('woocommerce_single_product_summary'))) {
      $this->atome_gateway->log('[can_show_price_divder]: price_divider_applied_on == product && not doing woocommerce_single_product_summary');
      return false;
    }

    if (!$this->atome_gateway->check_currency()) {
      $this->atome_gateway->log('[can_show_price_divder]: check_currency => false');
      return false;
    }

    return true;
  }

  public function atome_filter_woocommerce_get_price_html($price, $product)
  {
    // $atome_gateway = WC_Atome_Gateway::get_instance();
    // $atome_gateway->log('[price_divider_info]: price before atome handling is => ' . $price);
  
    // if ($atome_gateway->get_option('debug_mode') == 'yes') {
    //   global $wp_filter;
    //   if (isset($wp_filter['woocommerce_get_price_html'])) {
    //     foreach ($wp_filter['woocommerce_get_price_html']->callbacks as $priority => $callbacks) {
    //       foreach ($callbacks as $idx => $callback_details) {
    //         if (is_array($callback_details['function']) && is_object($callback_details['function'][0])) {
    //           $callback_details['function'][0] = get_class($callback_details['function'][0]);
    //         }
    //         $atome_gateway->log('[price_divider_info]: woocommerce_get_price_html\'s filter => [' . $priority . '][' . $idx . ']' . json_encode($callback_details));
    //       }
    //     }
    //   }
    // }
    
    if (is_product() && doing_action('woocommerce_single_product_summary') && 'below_product_price' !== $this->price_divider_position) {
      return $price;
    }

    $price_to_display = $this->atome_gateway->get_price_to_display($product);
    if (!$this->can_show_price_divder($price_to_display))
    {
      $this->atome_gateway->log('[price_divider_info]:Prece divider was not added.');
      return $price;
    }
  
    $this->atome_gateway->log('[price_divider_info]:Prece divider was added successfully.');

    return $price . $this->get_price_divider_html($product);
  }
}

$atome_price_divider = new WC_Atome_Price_Divider();
