# Homepage Slideshow

Each slide (image or video) from the Slideshow is a separate Slideshow Post. You can add new slides from the [Slideshow](edit.php?post_type=slider) section.

**[Add a New Slideshow Post](edit.php?post_type=slider)**

**[View more details in Documentation](https://www.wpzoom.com/documentation/inspiro/inspiro-homepage-slideshow/)**


# Portfolio Module


### Create Portfolio Posts
Before creating a page which will show all your Portfolio posts, you have to publish a few Portfolio posts in the [Portfolio](edit.php?post_type=portfolio_item) section.

**[Add a New Portfolio Post](edit.php?post_type=portfolio_item)**

---

### Create the Portfolio Page
Portfolio Posts can be displayed on a new or an existing page.

1. Create a new page or edit an existing one
2. Change the **Page Template** to one of the 5 available Portfolio templates.
3. Publish your page.

You can see more details and differences between each template in the [documentation](https://www.wpzoom.com/documentation/inspiro/inspiro-setting-up-the-portfolio-gallery-page/).

**[Add a New Page](post-new.php?post_type=page)**


# Homepage Setup

By default WordPress, and possible your website shows your latest blog posts on homepage. You can easily change that from **[Reading Settings](options-reading.php)**, by setting a static page as front page.

---

### Different ways to configure the Homepage:

When creating a new page which you will assign as your Front Page in the **Settings > Reading**, you have 2 Page Templates available:

[![widgets](https://www.wpzoom.com/wp-content/uploads/2018/09/inspiro-page-template-home.png)](https://www.wpzoom.com/wp-content/uploads/2018/09/inspiro-page-template-home.png)


1. **Homepage (Widgetized)** - when using this Page Template for your front page, it will displays widgets which you can add in the **Homepage** widgetized area on the [Widgets page](widgets.php). You can also manage the widgets from the [Customizer](customizer.php).

[![widgets](https://www.wpzoom.com/wp-content/uploads/2018/09/inspiro-home-widgets.png)](https://www.wpzoom.com/wp-content/uploads/2018/09/inspiro-home-widgets.png)


2. **Homepage (Page Builder)** - if you set this page template to your front page, then you can easily build the layout you want using the **[Beaver Builder](https://www.wpbeaverbuilder.com/wpzoom/?fla=463)** _(also available for free)_ or a different page builder. You can also preload a pre-defined layout from the demo of your theme from the **Templates** section in the builder:

[![template](https://www.wpzoom.com/wp-content/uploads/2018/09/beaver-load-template.png)](https://www.wpzoom.com/wp-content/uploads/2018/09/beaver-load-template.png)



**[Add a New Page](post-new.php?post_type=page)**


# Blog Page

If you set a static page as your front page, you can easily show your latest blog posts on a new or existing page.

### How to Create a Blog Page

1. If you don't have a Blog page yet, please create one from **Pages > Add New**
2. From **Settings > Reading** page, select your **Blog** as the **Posts Page**.

You can find more instructions [in this tutorial](https://www.wpzoom.com/docs/how-to-create-a-blog-page-in-business-themes/).

# Quick Tips

## How to Upload my Logo?

You can upload your custom logo image in the **Customizer > Site Identity**.

---

## How to Add Social Icons in the Menu?

You have to install our free plugin called [Social Icons Widget by WPZOOM](https://wordpress.org/plugins/social-icons-widget-by-wpzoom/), and when you will activate it, a new widget will be available on the Widgets page.
Find the **Social Icons by WPZOOM** widget and add it in the widget area called **Header Social Icons**.

![social](https://www.wpzoom.com/wp-content/uploads/2017/08/Screen-Shot-2017-08-21-at-15.21.27.png)

---

## How to enable the eCommerce (Shop) functionality?

Our theme fully supports the most popular eCommerce plugin for WordPress - [WooCommerce](https://wordpress.org/plugins/woocommerce/). You will have to install and activate it in order to enable the Shop page.

---

### How to Create a Contact Form?

You can create a Contact Form easily by using the free plugin [WPForms](https://wordpress.org/plugins/wpforms-lite/). If you need to create advanced forms or need more features, check out [WPForms Premium](http://wpzoom.com/go/wpforms).


# Documentation

For full theme Documentation please visit our website:
* **[Inspiro Documentation](https://www.wpzoom.com/documentation/inspiro/)**
* **[Knowledge Base](https://www.wpzoom.com/docs/)**


# Need Support?

Need one-to-one assistance with your theme? Get in touch with our Support team and we'd love the opportunity to help you.

**[Open a New Support Ticket](https://www.wpzoom.com/support/tickets/create/)**
