<?php if (!defined('ABSPATH')) exit; 
    $product_id         = isset( $_GET['product_id'] ) ? absint( $_GET['product_id'] ) : 0;
    $nbes_settings      = get_post_meta( $product_id, '_nbes_settings', true );
    $preview3d_settings = get_post_meta( $product_id, '_nb3d_preview_settings', true );
    $enable_3d_preview  = false;
    $is_mobile          = wp_is_mobile() ? 1 : 0;
    if( $nbes_settings ){
        $_nbes_settings = unserialize( $nbes_settings );
        if( isset( $_nbes_settings['td_preview'] ) && $_nbes_settings['td_preview'] == 1 && $_nbes_settings['td_folder_name'] != '' && $_nbes_settings['td_custom_mesh_name'] != '' ){
            $enable_3d_preview  = true;
        }
    }
    if( !$enable_3d_preview ){
        esc_html_e('Please enable 3D preview and fill 3D folder name and custom mesh name!', 'web-to-print-online-designer');
        die();
    }
    $model_url          = NBDESIGNER_DATA_URL . '/3d-models/' . $_nbes_settings['td_folder_name'] . '/' . $_nbes_settings['td_folder_name'] . '.gltf';
    $environment_exists = file_exists( NBDESIGNER_DATA_DIR . '/3d-models/' . $_nbes_settings['td_folder_name'] . '/environment.hdr' ) ? true : false;
    $environment_url    = NBDESIGNER_DATA_URL . '/3d-models/' . $_nbes_settings['td_folder_name'] . '/environment.hdr';
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=yes">
        <title>3D - Preview</title>
        <style>
            html, body {
                height: 100%;
                margin: 0;
                border-bottom-left-radius: 4px;
                border-bottom-right-radius: 4px;
                overflow: hidden;
            }
            #c {
                width: 100%;
                height: 100%;
                display: block;
            }
            #c:focus {
                outline: none;
            }
            .close-button.close-bottom {
                display: none;
            }
            <?php if( isset( $_GET['mode'] ) && $_GET['mode'] == 'setup' ): ?>
            .preview-3d-wrap-loading {
                position: fixed;
                background: #fff;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                display: flex;
                justify-content: center;
                align-items: center;
                z-index: 2;
                border-bottom-left-radius: 4px;
                border-bottom-right-radius: 4px;
            }
            .preview-3d-wrap-loading.hiddden {
                z-index: -1;
                opacity: 0;
            }
            .preview-3d-wrap-loading .loader{
                position: relative;
                width: 40px;
                height: 40px;
            }
            .circular .path {
                stroke-dasharray: 1,200;
                stroke-dashoffset: 0;
                -webkit-animation: dash 1.5s ease-in-out infinite,color 6s ease-in-out infinite;
                animation: dash 1.5s ease-in-out infinite,color 6s ease-in-out infinite;
                stroke-linecap: round;
            }
            .circular {
                -webkit-animation: rotate 2s linear infinite;
                animation: rotate 2s linear infinite;
                height: 100%;
                -webkit-transform-origin: center center;
                transform-origin: center center;
                width: 100%;
                position: absolute;
                top: 0;
                bottom: 0;
                left: 0;
                right: 0;
                margin: auto;
            }
            @-webkit-keyframes rotate {
                to {
                    -webkit-transform: rotate(1turn);
                    transform: rotate(1turn)
                }
            }
            @keyframes rotate {
                to {
                    -webkit-transform: rotate(1turn);
                    transform: rotate(1turn)
                }
            }
            @-webkit-keyframes dash {
                0% {
                    stroke-dasharray: 1,200;
                    stroke-dashoffset: 0
                }
                50% {
                    stroke-dasharray: 89,200;
                    stroke-dashoffset: -35px
                }
                to {
                    stroke-dasharray: 89,200;
                    stroke-dashoffset: -124px
                }
            }
            @keyframes dash {
                0% {
                    stroke-dasharray: 1,200;
                    stroke-dashoffset: 0
                }
                50% {
                    stroke-dasharray: 89,200;
                    stroke-dashoffset: -35px
                }
                to {
                    stroke-dasharray: 89,200;
                    stroke-dashoffset: -124px
                }
            }
            @-webkit-keyframes color {
                0%,to {
                    stroke: #d62d20
                }
                40% {
                    stroke: #0057e7
                }
                66% {
                    stroke: #008744
                }
                80%,90% {
                    stroke: #ffa700
                }
            }
            @keyframes color {
                0%,to {
                    stroke: #d62d20
                }
                40% {
                    stroke: #0057e7
                }
                66% {
                    stroke: #008744
                }
                80%,90% {
                    stroke: #ffa700
                }
            }
            <?php endif; ?>
        </style>
    </head>
    <body>
        <canvas id="c" tabindex="1" ></canvas>
        <?php if( isset( $_GET['mode'] ) && $_GET['mode'] == 'setup' ): ?>
        <div class="preview-3d-wrap-loading">
            <div class="loader">
                <svg class="circular" viewBox="25 25 50 50">
                    <circle class="path" cx="50" cy="50" r="20" fill="none" stroke-width="2" stroke-miterlimit="10"/>
                </svg>
            </div>
        </div>
        <?php endif; ?>
        <script type="module">
            const is_mobile = <?php echo $is_mobile; ?>;
            <?php if( isset( $_GET['mode'] ) && $_GET['mode'] == 'setup' ): ?>
            import NBD3DPreview from '<?php echo NBDESIGNER_PLUGIN_URL .'assets/js/3d/'; ?>setup-preview.js';
            <?php else: ?>
            import NBD3DPreview from '<?php echo NBDESIGNER_PLUGIN_URL .'assets/js/3d/'; ?>preview.js';
            <?php endif; ?>
            <?php 
                if( $preview3d_settings ): 
                    $settings = base64_decode( $preview3d_settings );
            ?>
                const defaultsttings = JSON.parse('<?php echo $settings; ?>');
            <?php else: ?>
                const defaultsttings = {
                    autoRotate: false,
                    autoRotateSpeed: -10,
                    backgroudColor: '#ffffff',
                    backgroundImage: false,
                    ambientLightColor: '#cccccc',
                    ambientIntensity: 1,
                    spotLightsColor: '#ffffff',
                    spotLightsIntensity: 0.3,
                    spotLightsAngle: 0.50,
                    spotLightsPenumbra: 0.75
                }
            <?php endif; ?>
            <?php if( !$environment_exists ): ?>
                defaultsttings.backgroundImage = false;
            <?php endif; ?>
            const settings = {
                ...defaultsttings,
                meshName: '<?php echo $_nbes_settings['td_custom_mesh_name']; ?>',
                mode: '<?php echo isset( $_GET['mode'] ) ? $_GET['mode'] : ''; ?>',
                environment_url: '<?php echo $environment_url; ?>'
            };

            const mouseEventHandler = makeSendPropertiesHandler([
                'ctrlKey',
                'metaKey',
                'shiftKey',
                'button',
                'clientX',
                'clientY',
                'pageX',
                'pageY',
                'pointerType'
            ]);
            const wheelEventHandlerImpl = makeSendPropertiesHandler([
                'deltaX',
                'deltaY',
            ]);
            const keydownEventHandler = makeSendPropertiesHandler([
                'ctrlKey',
                'metaKey',
                'shiftKey',
                'keyCode',
            ]);

            function wheelEventHandler(event, sendFn) {
                event.preventDefault();
                wheelEventHandlerImpl(event, sendFn);
            }

            function preventDefaultHandler(event) {
                event.preventDefault();
            }

            function copyProperties(src, properties, dst) {
                for (const name of properties) {
                    dst[name] = src[name];
                }
            }

            function makeSendPropertiesHandler(properties) {
                return function sendProperties(event, sendFn) {
                    const data = {type: event.type};

                    copyProperties(event, properties, data);
                    sendFn(data);
                };
            }

            function touchEventHandler(event, sendFn) {
                const touches = [];
                const data = {type: event.type, touches};
                for (let i = 0; i < event.touches.length; ++i) {
                    const touch = event.touches[i];
                    touches.push({
                        pageX: touch.pageX,
                        pageY: touch.pageY,
                    });
                }
                sendFn(data);
            }

            const orbitKeys = {
                '37': true,  // left
                '38': true,  // up
                '39': true,  // right
                '40': true,  // down
            };
            function filteredKeydownEventHandler(event, sendFn) {
                const {keyCode} = event;
                if (orbitKeys[keyCode]) {
                    event.preventDefault();
                    keydownEventHandler(event, sendFn);
                }
            }

            let nextProxyId = 0;
            class ElementProxy {
                constructor(element, worker, eventHandlers) {
                    this.id = nextProxyId++;
                    this.worker = worker;
                    const sendEvent = (data) => {
                        this.worker.postMessage({
                            type: 'event',
                            id: this.id,
                            data,
                        });
                    };

                    worker.postMessage({
                        type: 'makeProxy',
                        id: this.id,
                    });
                    sendSize();
                    for (const [eventName, handler] of Object.entries(eventHandlers)) {
                        element.addEventListener(eventName, function(event) {
                            handler(event, sendEvent);
                        });
                    }

                    function sendSize() {
                        const rect = element.getBoundingClientRect();
                        sendEvent({
                            type: 'size',
                            left: rect.left,
                            top: rect.top,
                            width: element.clientWidth,
                            height: element.clientHeight,
                        });
                    }

                    window.addEventListener('resize', sendSize);
                }
            }

            let worker;

            let preview, offscreencanvas = false;
            function _postMessage( msg ){
                window.parent.postMessage( msg, window.location.origin );
                <?php if( isset( $_GET['mode'] ) && $_GET['mode'] == 'setup' ): ?>
                if( msg == 'loaded_3d_model' ){
                    let classString = document.querySelector('.preview-3d-wrap-loading').className;
                    let newClass = classString.concat(" hiddden");
                    document.querySelector('.preview-3d-wrap-loading').className = newClass;
                }
                <?php endif; ?>
            }
            function receiveMessage( event ){
                if( event.origin == window.location.origin ){
                    if( event.data[0] && event.data[0] == 'update_design' ){
                        if( offscreencanvas ){
                            worker.postMessage({
                                type: 'updateDesign',
                                designs: event.data[1]
                            })
                        }else{
                            preview.updateDesign(event.data[1], 'on_main');
                        }
                    }
                    if( event.data[0] && event.data[0] == 'take_screenshot' ){
                        if( offscreencanvas ){
                            worker.postMessage({
                                type: 'takeScreenshot'
                            })
                        }else{
                            preview.takeScreenshot('on_main');
                        }
                    }
                }
            }

            function startWorker(canvas) {
                canvas.focus();
                const offscreen = canvas.transferControlToOffscreen();
                worker = new Worker('<?php echo NBDESIGNER_PLUGIN_URL .'assets/js/3d/'; ?>worker.js', {type: 'module'});

                const eventHandlers = {
                    contextmenu: preventDefaultHandler,
                    mousedown: mouseEventHandler,
                    mousemove: mouseEventHandler,
                    mouseup: mouseEventHandler,
                    pointerdown: mouseEventHandler,
                    pointermove: mouseEventHandler,
                    pointerup: mouseEventHandler,
                    touchstart: touchEventHandler,
                    touchmove: touchEventHandler,
                    touchend: touchEventHandler,
                    wheel: wheelEventHandler,
                    keydown: filteredKeydownEventHandler,
                };
                const proxy = new ElementProxy(canvas, worker, eventHandlers);
                worker.postMessage({
                    type: 'start',
                    canvas: offscreen,
                    canvasId: proxy.id,
                    model: '<?php echo $model_url; ?>',
                    settings: settings
                }, [offscreen]);

                worker.onmessage = function(e) {
                    if(e.data == 'loaded_3d_model'){
                        _postMessage( "loaded_3d_model" );
                    }else{
                        if( typeof e.data == 'object' && e.data.type == 'taked_screenshot' ){
                            _postMessage( e.data );
                        }
                    }
                }
            }

            function saveOptions( settings ){
                const _settings = JSON.stringify( settings, (key,value) => {
                    if( ["meshName", "meshNames", "mode", "environment_url"].indexOf( key ) > -1 ){
                        return undefined;
                    }
                    return value;
                });

                const ajax_url = "<?php echo admin_url('admin-ajax.php'); ?>",
                nonce = "<?php echo wp_create_nonce('save-design'); ?>",
                product_id = "<?php echo $product_id; ?>";

                const formData = new FormData();
                formData.append('action', 'nbdesigner_save_3d_preview_settings');
                formData.append('nonce', nonce);
                formData.append('product_id', product_id);
                formData.append('settings', _settings);
                const xmlhttp = new XMLHttpRequest();
                xmlhttp.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {
                        const response = xmlhttp.responseText,
                        data = JSON.parse( response );
                        if( data.flag == 1 ){
                            alert( '<?php esc_html_e('Save options successfully!', 'web-to-print-online-designer'); ?>' );
                        }else{
                            alert( '<?php esc_html_e('Oops! Try again later', 'web-to-print-online-designer'); ?>' );
                        }
                    }
                };
                xmlhttp.open("POST", ajax_url, true);
                xmlhttp.send( formData );
            }

            function startMainPage(canvas) {
                preview = new NBD3DPreview();
                preview.init({canvas, inputElement: canvas, model: '<?php echo $model_url; ?>', settings: settings, callback: _postMessage, takeScreenshotCallback: _postMessage, saveOptions});
            }

            function main() {
                const canvas = document.querySelector('#c');
                if (canvas.transferControlToOffscreen && settings.mode == '' && !is_mobile ) {
                    offscreencanvas = true;
                    startWorker(canvas);
                } else {
                    startMainPage(canvas);
                    window.addEventListener('resize', function(){
                        if ( !preview.renderRequested ) {
                            preview.renderRequested = true;
                            requestAnimationFrame(() => preview.render());
                        }
                    });
                }
            }

            main();

            window.addEventListener("message", receiveMessage, false);
        </script>
    </body>
</html>