
# Card Payment Details

Reflects the current status of a card payment. Contains only non-confidential information.

## Structure

`CardPaymentDetails`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `status` | `?string` | Optional | The card payment's current state. The state can be AUTHORIZED, CAPTURED, VOIDED, or<br>FAILED.<br>**Constraints**: *Maximum Length*: `50` | getStatus(): ?string | setStatus(?string status): void |
| `card` | [`?Card`](../../doc/models/card.md) | Optional | Represents the payment details of a card to be used for payments. These<br>details are determined by the payment token generated by Web Payments SDK. | getCard(): ?Card | setCard(?Card card): void |
| `entryMethod` | `?string` | Optional | The method used to enter the card's details for the payment. The method can be<br>`KEYED`, `SWIPED`, `EMV`, `ON_FILE`, or `CONTACTLESS`.<br>**Constraints**: *Maximum Length*: `50` | getEntryMethod(): ?string | setEntryMethod(?string entryMethod): void |
| `cvvStatus` | `?string` | Optional | The status code returned from the Card Verification Value (CVV) check. The code can be<br>`CVV_ACCEPTED`, `CVV_REJECTED`, or `CVV_NOT_CHECKED`.<br>**Constraints**: *Maximum Length*: `50` | getCvvStatus(): ?string | setCvvStatus(?string cvvStatus): void |
| `avsStatus` | `?string` | Optional | The status code returned from the Address Verification System (AVS) check. The code can be<br>`AVS_ACCEPTED`, `AVS_REJECTED`, or `AVS_NOT_CHECKED`.<br>**Constraints**: *Maximum Length*: `50` | getAvsStatus(): ?string | setAvsStatus(?string avsStatus): void |
| `authResultCode` | `?string` | Optional | The status code returned by the card issuer that describes the payment's<br>authorization status.<br>**Constraints**: *Maximum Length*: `10` | getAuthResultCode(): ?string | setAuthResultCode(?string authResultCode): void |
| `applicationIdentifier` | `?string` | Optional | For EMV payments, the application ID identifies the EMV application used for the payment.<br>**Constraints**: *Maximum Length*: `32` | getApplicationIdentifier(): ?string | setApplicationIdentifier(?string applicationIdentifier): void |
| `applicationName` | `?string` | Optional | For EMV payments, the human-readable name of the EMV application used for the payment.<br>**Constraints**: *Maximum Length*: `16` | getApplicationName(): ?string | setApplicationName(?string applicationName): void |
| `applicationCryptogram` | `?string` | Optional | For EMV payments, the cryptogram generated for the payment.<br>**Constraints**: *Maximum Length*: `16` | getApplicationCryptogram(): ?string | setApplicationCryptogram(?string applicationCryptogram): void |
| `verificationMethod` | `?string` | Optional | For EMV payments, the method used to verify the cardholder's identity. The method can be<br>`PIN`, `SIGNATURE`, `PIN_AND_SIGNATURE`, `ON_DEVICE`, or `NONE`.<br>**Constraints**: *Maximum Length*: `50` | getVerificationMethod(): ?string | setVerificationMethod(?string verificationMethod): void |
| `verificationResults` | `?string` | Optional | For EMV payments, the results of the cardholder verification. The result can be<br>`SUCCESS`, `FAILURE`, or `UNKNOWN`.<br>**Constraints**: *Maximum Length*: `50` | getVerificationResults(): ?string | setVerificationResults(?string verificationResults): void |
| `statementDescription` | `?string` | Optional | The statement description sent to the card networks.<br><br>Note: The actual statement description varies and is likely to be truncated and appended with<br>additional information on a per issuer basis.<br>**Constraints**: *Maximum Length*: `50` | getStatementDescription(): ?string | setStatementDescription(?string statementDescription): void |
| `deviceDetails` | [`?DeviceDetails`](../../doc/models/device-details.md) | Optional | Details about the device that took the payment. | getDeviceDetails(): ?DeviceDetails | setDeviceDetails(?DeviceDetails deviceDetails): void |
| `cardPaymentTimeline` | [`?CardPaymentTimeline`](../../doc/models/card-payment-timeline.md) | Optional | The timeline for card payments. | getCardPaymentTimeline(): ?CardPaymentTimeline | setCardPaymentTimeline(?CardPaymentTimeline cardPaymentTimeline): void |
| `refundRequiresCardPresence` | `?bool` | Optional | Whether the card must be physically present for the payment to<br>be refunded.  If set to `true`, the card must be present. | getRefundRequiresCardPresence(): ?bool | setRefundRequiresCardPresence(?bool refundRequiresCardPresence): void |
| `errors` | [`?(Error[])`](../../doc/models/error.md) | Optional | Information about errors encountered during the request. | getErrors(): ?array | setErrors(?array errors): void |

## Example (as JSON)

```json
{
  "status": null,
  "card": null,
  "entry_method": null,
  "cvv_status": null,
  "avs_status": null,
  "auth_result_code": null,
  "application_identifier": null,
  "application_name": null,
  "application_cryptogram": null,
  "verification_method": null,
  "verification_results": null,
  "statement_description": null,
  "device_details": null,
  "card_payment_timeline": null,
  "refund_requires_card_presence": null,
  "errors": null
}
```

