<?php
/**
 * @package WBP User Groups
 * @version 1.0
 */
/*
Plugin Name: WBP User Groups
Plugin URI: https://www.helpfulinsightsolution.com/custom-plugin-development
Description: Plugin to enhance custom user groups functionality
Author: Helpful Insight Pvt. Ltd.
Version: 1.0
Author URI: https://helpfulinsightsolution.com
*/

// Don't load directly.
if ( ! function_exists( 'is_admin' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit();
}


// ini_set('display_errors','On');
// ini_set('error_reporting', E_ALL );
register_activation_hook( __FILE__, 'wbp_create_db' );
// register_deactivation_hook( __FILE__, 'wbp_deactivation'  );

function wbp_create_db() {
	global $wpdb;
	$charset_collate = $wpdb->get_charset_collate();
	$table_name = $wpdb->prefix . 'wbp_group_users';

	$sql = "CREATE TABLE $table_name (
		id int(11) NOT NULL AUTO_INCREMENT,
		group_name varchar(255) NOT NULL,
		logo int(11) NULL,
		grpdomain varchar(255) NULL,
		grpcode varchar(255) NULL,
		primary_menu int(11) NULL,
		secondary_menu int(11) NULL,
        handheld_menu int(11) NULL,
		visible_categories varchar(255) NULL,
		visible_products varchar(255) NULL,
		group_users text NULL,
		created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
		UNIQUE KEY id (id)
	) $charset_collate;";

	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $sql );
}

function wbp_deactivation(){
	global $wpdb;
	$table_name = $wpdb->prefix . 'wbp_group_users';
	$wpdb->query( "DROP TABLE IF EXISTS $table_name" );
}

function wbp_enqueue_script() {   
    wp_enqueue_style('wbp-css', plugin_dir_url( __FILE__ ).'assets/css/main.css');
    wp_register_script("wbp-script", plugin_dir_url( __FILE__ ).'assets/js/wbp-script.js', array('jquery'));
    wp_localize_script('wbp-script', 'hlsAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
    wp_enqueue_script( 'jquery' );
    wp_enqueue_script( 'wbp-script' );
}
add_action('wp_enqueue_scripts', 'wbp_enqueue_script');

add_action('admin_enqueue_scripts', 'my_admin_scripts');

function my_admin_scripts() {
    if (isset($_GET['page']) && $_GET['page'] == 'wbp_user_groups') {
        wp_enqueue_media();
    }
}

/**
 * Register a custom menu page.
 */
function wbp_register_my_custom_menu_page(){
    add_menu_page( 
        'User Groups',
        'User Groups',
        'manage_options',
        'wbp_user_groups',
        'wbp_user_groups',
        '',
        6
    );
    add_submenu_page(
        'wbp_user_groups',
        'Groups Setting',
        'Groups Setting',
        'manage_options',
        'wbp_user_groups_setting',
        'wbp_user_groups_setting'
    );
}
add_action( 'admin_menu', 'wbp_register_my_custom_menu_page' );

function wbp_user_groups(){
    require_once(dirname( __FILE__ ) . '/pages/wbp-user-groups-list.php');
}

function wbp_user_groups_setting(){
    require_once(dirname( __FILE__ ) . '/pages/wbp-user-groups-setting.php');
}

function get_all_groups(){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_results("SELECT * FROM $table_name");
    return $group_data;
}

function get_sgl_group($group_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_row("SELECT * FROM $table_name WHERE id = $group_id");
    return $group_data;
}

function get_group_users($group_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT group_users FROM $table_name WHERE id = $group_id");
    $group_users = explode(",", $group_data);
    return count($group_users);
}

function get_all_group_domain(){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $groupd_data = $wpdb->get_results("SELECT grpdomain,id FROM $table_name WHERE `grpdomain` IS NOT NULL");
    $grpDomainArr = array();
    foreach($groupd_data as $d_data){
        $grpDomainArr[$d_data->id] = $d_data->grpdomain;
    }
    return $grpDomainArr;
}

function get_group_by_domain($domain){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $groupd_id = $wpdb->get_var("SELECT id FROM $table_name WHERE `grpdomain` LIKE '%$domain%'");
    return $groupd_id;
}

function get_group_by_code($code){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $groupd_id = $wpdb->get_var("SELECT id FROM $table_name WHERE `grpcode` = '$code'");
    return $groupd_id;
}

function get_group_users_data($group_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT group_users FROM $table_name WHERE id = $group_id");
    return $group_users = explode(",", $group_data);
}

function get_user_groups($user_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT id FROM $table_name WHERE find_in_set($user_id,group_users)");
    return $group_data;
}

function is_user_group_exists($user_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_row("SELECT * FROM $table_name WHERE find_in_set($user_id,group_users)");
    if($group_data){
        return true;
    }
    return false;
}

function get_user_groups_cats($user_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT visible_categories FROM $table_name WHERE find_in_set($user_id,group_users)");
    return $group_data;
}

function get_group_cats($group_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT visible_categories FROM $table_name WHERE id = '$group_id'");
    return $group_data;
}

function get_user_groups_products($user_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT visible_products FROM $table_name WHERE find_in_set($user_id,group_users)");
    return $group_data;
}

function get_group_products($group_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT visible_products FROM $table_name WHERE id = '$group_id'");
    return $group_data;
}

function get_user_groups_cats_array($user_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT visible_categories FROM $table_name WHERE find_in_set($user_id,group_users)");
    $group_cat_arrs = explode(',',$group_data);
    $get_user_groups_cats_array = array();
    if($group_cat_arrs){
        foreach($group_cat_arrs as $group_cat_arr){
            $term = get_term( $group_cat_arr, 'product_cat' );
            $slug = $term->slug;
            $get_user_groups_cats_array[$group_cat_arr] = $slug;
        }
    }
    return $get_user_groups_cats_array;
}

function get_group_cats_array($groupid){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_var("SELECT visible_categories FROM $table_name WHERE id = '$groupid'");
    $group_cat_arrs = explode(',',$group_data);
    $get_user_groups_cats_array = array();
    if($group_cat_arrs){
        foreach($group_cat_arrs as $group_cat_arr){
            $term = get_term( $group_cat_arr, 'product_cat' );
            $slug = $term->slug;
            $get_user_groups_cats_array[$group_cat_arr] = $slug;
        }
    }
    return $get_user_groups_cats_array;
}

function get_all_groups_cats(){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_results("SELECT visible_categories FROM $table_name");
    $get_user_groups_visible_categories = array();
    $slug = '';
    if($group_data){
        foreach($group_data as $group_datas){
            $visible_categories = explode(',',$group_datas->visible_categories);
            foreach($visible_categories as $visible_category){
                $term = get_term( $visible_category, 'product_cat' );
                $slug = $term->slug;
                $get_user_groups_visible_categories[$visible_category] = $slug;
            }
        }
    }
    return $get_user_groups_visible_categories;
}

function get_all_groups_products(){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_results("SELECT visible_products FROM $table_name");
    $get_user_groups_visible_products = array();
    $slug = '';
    if($group_data){
        foreach($group_data as $group_datas){
            $visible_products = explode(',',$group_datas->visible_products);
            foreach($visible_products as $visible_product){
                $get_user_groups_visible_products[] = $visible_product;
            }
        }
    }
    return $get_user_groups_visible_products;
}

function get_user_group_menus($user_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_row("SELECT primary_menu,secondary_menu,handheld_menu,logo FROM $table_name WHERE find_in_set($user_id,group_users)");
    return $group_data;
}

function get_group_menus($group_id){
    global $wpdb;
    $table_name = $wpdb->prefix . 'wbp_group_users';
    $group_data = $wpdb->get_row("SELECT primary_menu,secondary_menu,handheld_menu,logo FROM $table_name WHERE id = '$group_id'");
    return $group_data;
}

add_action( 'template_redirect', 'wbp_redirect_hiding_product_detail' );
function wbp_redirect_hiding_product_detail() {
    $redirect_url = get_permalink( get_option('woocommerce_shop_page_id') );
    $u_redirect_url = get_option('landingPageAfterLoginUrl');
    if($u_redirect_url == ''){
        $u_redirect_url = site_url();
    }
    // echo get_current_user_id();
    // echo get_the_ID();
    // exit();

    /*if(is_product() && (!is_user_logged_in() || is_user_group_exists(get_current_user_id()) === false) ){
        wc_add_notice(__("Sorry, but you are not allowed yet to see this product."), 'notice' );
        wp_redirect($redirect_url);
        exit();
    }*/

    if ( (is_product() && is_user_logged_in() && is_user_group_exists(get_current_user_id())) || (is_product() && isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode']))) {
        
        $user_cats = (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode'])) ? explode(',',get_group_cats(get_group_by_code($_SESSION['portalCode']))) : explode(',',get_user_groups_cats(get_current_user_id()));

        $user_products = (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode'])) ? explode(',',get_group_products(get_group_by_code($_SESSION['portalCode']))) : explode(',',get_user_groups_products(get_current_user_id()));

        // print_r($user_products);die();
        if(has_term( $user_cats, 'product_cat' ) === false || ($user_products && !in_array(get_the_ID(), $user_products))){
            wc_add_notice(__("Sorry, but you are not allowed yet to see this product."), 'notice' );
            wp_redirect($u_redirect_url);
            exit();
        }
        /*else{
            wc_add_notice(__("Sorry, you are not logged in."), 'notice' );
            $redirect_url = get_permalink( get_option('woocommerce_myaccount_page_id') );
            wp_redirect($redirect_url);
            exit(); // Always exit
        }*/
    }elseif(is_product()){
        $get_user_groups_visible_products = get_all_groups_products();
        if(in_array(get_the_ID(), $get_user_groups_visible_products)){
            wc_add_notice(__("Sorry, but you are not allowed yet to see this product."), 'notice' );
            wp_redirect($u_redirect_url);
            exit();
        }
    }
}

function search_users(){
    extract($_POST);
    global $wpdb;
    $table_name = $wpdb->prefix.'users';
    $found_users = $wpdb->get_results("SELECT ID,user_email FROM $table_name WHERE user_email LIKE '%$str%'");
    
    $html = '<div class="clear-search fa fa-times-circle"></div><ul>';
    $i = 0;
    if($found_users){
        $html .= '<li value="all" class="all_select">-- Select All --</li>';
        foreach($found_users as $found_user){
            if(is_user_group_exists($found_user->ID) === false){
                $i++;
                $html .= '<li class="ser_li" value="'.$found_user->ID.'">'.$found_user->user_email.'</li>';
            }
        }
    }
    if($i == 0){
        $html = '<div class="clear-search fa fa-times-circle"></div><ul><li value="">No result found.</li>';
    }
    $html .= '</ul>';

    wp_send_json(array('htm' => $html));
    wp_die();
}
add_action('wp_ajax_search_users', 'search_users');

function set_user_group_menu(){
    set_theme_mod('custom_logo', 53856);
    $user_id = apply_filters( 'determine_current_user', false );
    wp_set_current_user( $user_id );
    $user_id = get_current_user_id();
    $group_menus = (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode'])) ? get_group_menus(get_group_by_code($_SESSION['portalCode'])) : get_user_group_menus($user_id);
    //print_r($group_menus);
    $locations = get_theme_mod( 'nav_menu_locations' );
    if(is_user_logged_in() || (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode']))){
        if(!empty($locations) && !empty($group_menus)) {
            $locations['primary'] = $group_menus->primary_menu;
            $locations['secondary'] = $group_menus->secondary_menu;
            $locations['handheld'] = $group_menus->handheld_menu;
            set_theme_mod('nav_menu_locations', $locations);
            //print_r($locations);
        }
        if(!empty($group_menus) && !empty($group_menus->logo)){
            set_theme_mod('custom_logo', $group_menus->logo);
        }
    }else{
        $locations['primary'] = get_option('primary_menu_position');
        $locations['secondary'] = get_option('secondary_menu_position');
        $locations['handheld'] = get_option('handheld_menu_position');
        set_theme_mod('nav_menu_locations', $locations);
    }
}
add_action('init', 'set_user_group_menu');

add_filter( 'get_terms', 'ts_get_subcategory_terms', 10, 3 );
function ts_get_subcategory_terms( $terms, $taxonomies, $args ) {
    $new_terms = array();
    if((is_user_logged_in() && is_user_group_exists(get_current_user_id()) === true) || (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode']))){
        
        //echo 'Hello1';
        $group_cats = (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode'])) ? get_group_cats_array(get_group_by_code($_SESSION['portalCode'])) : get_user_groups_cats_array(get_current_user_id());
        if ( in_array( 'product_cat', $taxonomies ) && ! is_admin() && is_shop() ) {
            foreach( $terms as $key => $term ) {
                if ( in_array( $term->slug, $group_cats ) ) {
                    $new_terms[] = $term;
                }
            }
            $terms = $new_terms;
        }
    }else{
        //echo 'Hello2';
        $group_cats = get_all_groups_cats();
        //print_r($group_cats);
        if ( in_array( 'product_cat', $taxonomies ) && ! is_admin() && is_shop() ) {
            foreach( $terms as $key => $term ) {
                if ( !in_array( $term->slug, $group_cats ) ) {
                    $new_terms[] = $term;
                }
            }
            $terms = $new_terms;
        }
    }
    return $terms;
}

function user_after_logout_redir(){
    $u_redirect_url = get_option('landingPageAfterLogoutUrl');
    if($u_redirect_url){
        wp_redirect( $u_redirect_url );
        exit();
    }else{
        wp_redirect( site_url() );
        exit();
    }
}
add_action('wp_logout','user_after_logout_redir');

function my_login_redirect($user_login, $user) {
    global $wpdb;
    $user_id = $user->ID;
    $u_redirect_url = get_option('landingPageAfterLoginUrl');
    if(is_user_group_exists($user_id) === false){
        wp_redirect( site_url('shop'));
        exit();
    }elseif($u_redirect_url){
        wp_redirect( $u_redirect_url );
        exit();
    }else{
        wp_redirect( site_url() );
        exit();
    }
}
add_action('wp_login', 'my_login_redirect', 10, 2);

function hide_portal_homepage() {
    if((!is_user_logged_in() && is_page('portal-home')) && !isset($_SESSION['portalCode'])) {
        wp_redirect( site_url('my-account'));
        exit();
    }
    if((is_user_logged_in() && is_page('portal-home') && is_user_group_exists(get_current_user_id()) === false) || (isset($_SESSION['portalCode']) && empty(get_group_by_code($_SESSION['portalCode'])))){
        wp_redirect( site_url('shop'));
        exit();
    }
}
add_action( 'template_redirect', 'hide_portal_homepage');

function add_usergroup_to_body_class( $classes ) {
    if((is_user_logged_in() && is_user_group_exists(get_current_user_id()) === true) || (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode']))) {
    	$group_id        = (isset($_SESSION['portalCode'])) ? get_group_by_code($_SESSION['portalCode']) : get_user_groups(get_current_user_id());
        $groups_data = get_sgl_group($group_id);
		$group_name_text       = "portal-" . $groups_data->group_name;
        $classes[] = "eden-portals " . sanitize_title_with_dashes($group_name_text);
    }
    return $classes;
}
add_filter( 'body_class', 'add_usergroup_to_body_class' );

add_filter( 'get_custom_logo', 'wbp_logo_link' );
function wbp_logo_link() {
    $u_homepageUrl = site_url();
    $custom_logo_id = get_theme_mod( 'custom_logo' );
    if((is_user_logged_in() && is_user_group_exists(get_current_user_id()) === true) || (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode']))){
        $u_homepageUrl = get_option('homepageUrl');
    }
    $html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home" itemprop="url">%2$s</a>',
        esc_url( $u_homepageUrl ),
        wp_get_attachment_image( $custom_logo_id, 'full', false, array(
            'class'    => get_current_user_id(),
        ) )
    );
    return $html;
}

function change_home_menu(){
    $u_homepageUrl = site_url();
    if((is_user_logged_in() && is_user_group_exists(get_current_user_id()) === true) || (isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode']))){
        $u_homepageUrl = get_option('homepageUrl');
        $u_postcards_portalUrl = "https://waybetterpostcard.com/product-category/portal-postcards/";
        $u_brochures_portalUrl = "https://waybetterpostcard.com/product-category/portal-brochures/";
        
        echo '<script>jQuery(document).ready(function($){
                $("li.menu-item-home a").attr("href", "'.$u_homepageUrl.'");
                $("li.menu-item-53613 a").attr("href", "'.$u_postcards_portalUrl.'");
                $("li.menu-item-53614 a").attr("href", "'.$u_brochures_portalUrl.'");
                if(jQuery(".woocommerce-breadcrumb a:first-child").html() == "Home"){
                    jQuery(".woocommerce-breadcrumb a:first-child").attr("href", "'.$u_homepageUrl.'");
                }
            });</script>';
     }
}
add_action('wp_head','change_home_menu');

function get_selected_products(){
    extract($_POST);
    global $wpdb;
    $response = array('status' => 'success');
    $args = array();
    $html = '';
    if($selected_categories){
        foreach($selected_categories as $selected_category){
            $categoryDetails = get_term_by( 'ID', $selected_category, 'product_cat');
            $args = array(
                'post_type'             => 'product',
                'post_status'           => 'publish',
                'posts_per_page'        => -1,
                'tax_query'             => array(
                    array(
                        'taxonomy'      => 'product_cat',
                        'terms'         => $categoryDetails->slug,
                        'field'         => 'slug',
                        'operator' => 'IN'
                    )
                )
            );
            $get_products = new WP_Query($args);
            $html .= '<optgroup label="'.$categoryDetails->name.' ('.$get_products->found_posts.')">';
            if($get_products->have_posts()){
                while($get_products->have_posts()){
                    $get_products->the_post();
                    $product_cat_name = array();
                    $terms = get_the_terms( get_the_ID(), 'product_cat' );
                    foreach ($terms as $term) {
                        if($term->parent){
                            $product_cat_name[] = $term->name;
                        }
                    }
                    $sub_cats = '';
                    if($product_cat_name){
                        $sub_cats = ' ('.implode(' > ',$product_cat_name).')';
                    }
                    $html .= '<option value="'.get_the_ID().'" '.(in_array(get_the_ID(),$selected_products) ? 'selected' : '' ).'>'.get_the_title().$sub_cats.'</option>';
                }
                wp_reset_postdata();
                wp_reset_query();
            }
            $html .= '</optgroup>';
        }
        $response = array('status' => 'success', 'options' => $html);
        wp_send_json($response);
        wp_die();
    }
    $response['options'] = '<option disabled>Please select category</option>';
    wp_send_json($response);
    wp_die();
}
add_action('wp_ajax_get_selected_products', 'get_selected_products');

add_filter( 'woocommerce_product_is_visible', 'wpf_product_visible_by_user_role', PHP_INT_MAX, 2 );
if ( ! function_exists( 'wpf_product_visible_by_user_role' ) ) {
    /**
     * Hides product from shop and search results by user role.
     */
    function wpf_product_visible_by_user_role( $visible, $product_id ) {
        if ( is_user_logged_in() && is_user_group_exists(get_current_user_id()) ) {
            $user_product_list = get_user_groups_products(get_current_user_id());
            $user_products = explode(',',$user_product_list);
            if(!empty($user_product_list) && !in_array($product_id, $user_products)){
                return false;
            }
        }else if(isset($_SESSION['portalCode']) && get_group_by_code($_SESSION['portalCode'])){
            $user_product_list = get_group_products(get_group_by_code($_SESSION['portalCode']));
            $user_products = explode(',',$user_product_list);
            if(!empty($user_product_list) && !in_array($product_id, $user_products)){
                return false;
            }
        }else {
            $get_user_groups_visible_products = get_all_groups_products();
            if(in_array($product_id, $get_user_groups_visible_products)){
                return false;
            }
        }
        return $visible;
    }
}

add_filter( 'page_template', 'portal_new_user_registration_temp' );
function portal_new_user_registration_temp( $page_template ){
    $portal_new_user_registration_id = get_option("portal_new_user_registration");
    if ( is_page( $portal_new_user_registration_id ) ) {
        $page_template = dirname( __FILE__ ) . '/pages/portal_new_user_registration_tpl.php';
    }
    return $page_template;
}

function add_user_register(){
    global $wpdb;
    $response = array();
    $password = wp_generate_password( 12, true, true );
    $formarray = $_POST;
    $a = explode('@', $formarray['yemail']);
    $rusername = $a[0];
    if(email_exists($formarray['yemail'])){
        $response = array('status'=>'failed', 'message'=>'Email already exists');
        wp_send_json($response);
        wp_die();
    }
    if(username_exists($a[0])){
        $rusername = $a[0].'-'.username_exists($a[0]);
    }
    
    $userdata = array(
        'user_login' =>  $rusername,
        'user_pass'  =>  $password,
        'user_email' =>  $formarray['yemail'],
        'first_name'   =>  $formarray['fname'],
        'last_name'  =>  $formarray['lname'],
    );   
    $user_id = wp_insert_user( $userdata ) ;

    if( !empty( $user_id ) ) {

        // You will need also to add this billing meta data
        update_user_meta( $user_id, 'billing_first_name', $formarray['fname'] );
        update_user_meta( $user_id, 'billing_last_name', $formarray['lname'] );
        update_user_meta( $user_id, 'billing_company', $formarray['ycompany'] );
        update_user_meta( $user_id, 'billing_address_1', $formarray['billing_address_1'] );
        update_user_meta( $user_id, 'billing_address_2', $formarray['billing_address_2'] );
        update_user_meta( $user_id, 'billing_city', $formarray['billing_city'] );
	    update_user_meta( $user_id, 'billing_state', $formarray['billing_state'] );
        update_user_meta( $user_id, 'billing_postcode', $formarray['billing_postcode'] );
        update_user_meta( $user_id, 'billing_phone', $formarray['billing_phone'] );
        update_user_meta( $user_id, 'billing_country', 'US' );

        // optionally shipping meta data, that could be different

        update_user_meta( $user_id, 'shipping_first_name', $formarray['fname'] );
        update_user_meta( $user_id, 'shipping_last_name', $formarray['lname'] );
        update_user_meta( $user_id, 'shipping_company', $formarray['ycompany'] );
        update_user_meta( $user_id, 'shipping_address_1', $formarray['shipping_address_1'] );
        update_user_meta( $user_id, 'shipping_address_2', $formarray['shipping_address_2'] );
        update_user_meta( $user_id, 'shipping_city', $formarray['shipping_city'] );
	    update_user_meta( $user_id, 'shipping_state', $formarray['shipping_state'] );
        update_user_meta( $user_id, 'shipping_postcode', $formarray['shipping_postcode'] );
        update_user_meta( $user_id, 'shipping_phone', $formarray['shipping_phone'] );
        update_user_meta( $user_id, 'shipping_country', 'US' );

        if(is_user_group_exists(get_current_user_id())){
            $currentGrpID = get_user_groups(get_current_user_id());
            $currentGrpData = get_group_users_data($currentGrpID);
            $currentGrpData[] = $user_id;
            $table_name = $wpdb->prefix . 'wbp_group_users';

            $wpdb->update($table_name, array('group_users' => implode(',', $currentGrpData)),array('id'=>$currentGrpID));
        }

        $response = array('status'=>'success');

    } else {
        $response = array('status'=>'failed');
    }  
    wp_send_json($response);
    wp_die();
}
add_action('wp_ajax_add_user_register', 'add_user_register'); 

add_action( 'user_register', 'wbp_registration_save', 10, 2 );
function wbp_registration_save($user_id, $user_data){
    // get_group_by_domain($domain);
    // get_all_group_domain();
    global $wpdb;
    $domain = explode("@", $user_data['user_email']);
    $domain1 = explode(".", $domain[1]);
    $do_grp = get_group_by_domain($domain1[0]);
    
    if($do_grp){
        $currentGrpData = get_group_users_data($do_grp);
        $currentGrpData[] = $user_id;
        $table_name = $wpdb->prefix . 'wbp_group_users';

        $wpdb->update($table_name, array('group_users' => implode(',', $currentGrpData)),array('id'=>$do_grp));
    }
}

function get_all_portal_products(){
    global $wpdb;
    $portalTbl = $wpdb->prefix . 'wbp_group_users';
    $portal_data = $wpdb->get_results("SELECT visible_products FROM $portalTbl");
    $get_user_portal_visible_products = array();
    if($portal_data){
        foreach($portal_data as $portalData){
            $visible_products = explode(',',$portalData->visible_products);
            foreach($visible_products as $visible_product){
                $get_user_portal_visible_products[] = $visible_product;
            }
        }
    }
    return explode(",", $get_user_portal_visible_products);
}