<?php
    if(isset($_POST['update_group_setting'])){
        extract($_POST);
        update_option('homepageUrl', $homepageUrl);
        update_option('landingPageAfterLoginUrl', $landingPageAfterLoginUrl);
        update_option('landingPageAfterLogoutUrl', $landingPageAfterLogoutUrl);
        update_option('primary_menu_position', $primary_menu_position);
        update_option('secondary_menu_position', $secondary_menu_position);
        update_option('handheld_menu_position', $handheld_menu_position);
        update_option('portal_new_user_registration', $portal_new_user_registration);
    }
?>
<div class="wrap">
    <h1 class="wp-heading-inline">User Groups Setting <a href="admin.php?page=wbp_user_groups" class="page-title-action">User Groups</a></h1>
    <form name="updateusergroupsetting" method="post" autocomplete="off">
        <table class="form-table" role="presentation">
            <tbody>
                <tr>
                    <th scope="row"><label for="homepageUrl">Homepage URL for groups</label></th>
                    <td><input name="homepageUrl" type="url" id="homepageUrl" value="<?=get_option('homepageUrl')?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="landingPageAfterLoginUrl">Landing page after login</label></th>
                    <td><input name="landingPageAfterLoginUrl" type="url" id="landingPageAfterLoginUrl" value="<?=get_option('landingPageAfterLoginUrl')?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="landingPageAfterLogoutUrl">Landing page after logout</label></th>
                    <td><input name="landingPageAfterLogoutUrl" type="url" id="landingPageAfterLogoutUrl" value="<?=get_option('landingPageAfterLogoutUrl')?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th scope="row"><label for="primary_menu_position">Primary Menu Position</label></th>
                    <td>
                        <select name="primary_menu_position" id="primary_menu_position" class="regular-text">
                        <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                            <?php
                                $all_menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
                                if($all_menus){
                                    foreach($all_menus as $all_menu){
                                        ?>
                                            <option value="<?=$all_menu->term_id?>" <?=( get_option('primary_menu_position') == $all_menu->term_id ) ? 'selected' : '' ;?>><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                        <?php
                                    }
                                }
                            ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="secondary_menu_position">Secondary Menu Position</label></th>
                    <td>
                        <select name="secondary_menu_position" id="secondary_menu_position" class="regular-text">
                            <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                            <?php
                                if($all_menus){
                                    foreach($all_menus as $all_menu){
                                        ?>
                                            <option value="<?=$all_menu->term_id?>" <?=( get_option('secondary_menu_position') == $all_menu->term_id ) ? 'selected' : '' ;?>><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                        <?php
                                    }
                                }
                            ?>
                        </select>
                    </td>
                </tr>
               <tr>
                    <th scope="row"><label for="handheld_menu_position">Handheld Menu Position</label></th>
                    <td>
                        <select name="handheld_menu_position" id="handheld_menu_position" class="regular-text">
                            <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                            <?php
                                if($all_menus){
                                    foreach($all_menus as $all_menu){
                                        ?>
                                            <option value="<?=$all_menu->term_id?>" <?=( get_option('handheld_menu_position') == $all_menu->term_id ) ? 'selected' : '' ;?>><?php echo esc_attr( __( $all_menu->name ) ); ?></option> 
                                        <?php
                                    }
                                }
                            ?>
                        </select>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="portal_new_user_registration">Portal New User Registration Page</label></th>
                    <td>
                        <select name="portal_new_user_registration" id="portal_new_user_registration" class="regular-text">
                            <option value=""><?php echo esc_attr( __( '--Select--' ) ); ?></option> 
                            <?php
                                $all_pages = get_pages();
                                if($all_pages){
                                    foreach($all_pages as $all_page){
                                        ?>
                                            <option value="<?=$all_page->ID?>" <?=( get_option('portal_new_user_registration') == $all_page->ID ) ? 'selected' : '' ;?>><?php echo esc_attr( __( $all_page->post_title ) ); ?></option> 
                                        <?php
                                    }
                                }
                            ?>
                        </select>
                    </td>
                </tr>
            </tbody>
        </table>
        <p class="submit"><input type="submit" name="update_group_setting" id="submit" class="button button-primary" value="Save Changes"></p>
    </form>
</div>